/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONAwareEx;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStreamAwareEx;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.reader.JsonWriter;

public class JSONArray
extends ArrayList<Object>
implements JSONAwareEx,
JSONStreamAwareEx,
List<Object> {
    private static final long serialVersionUID = 9106884089231309568L;

    public static String toJSONString(List<? extends Object> list) {
        return JSONArray.toJSONString(list, JSONValue.COMPRESSION);
    }

    public static String toJSONString(List<? extends Object> list, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONArray.writeJSONString(list, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static void writeJSONString(Iterable<? extends Object> iterable, Appendable appendable, JSONStyle jSONStyle) throws IOException {
        if (iterable == null) {
            appendable.append("null");
            return;
        }
        JsonWriter.JSONIterableWriter.writeJSONString(iterable, appendable, jSONStyle);
    }

    public static void writeJSONString(List<? extends Object> list, Appendable appendable) throws IOException {
        JSONArray.writeJSONString(list, appendable, JSONValue.COMPRESSION);
    }

    public JSONArray appendElement(Object object) {
        this.add(object);
        return this;
    }

    public void merge(Object object) {
        JSONObject.merge(this, object);
    }

    @Override
    public String toJSONString() {
        return JSONArray.toJSONString(this, JSONValue.COMPRESSION);
    }

    @Override
    public String toJSONString(JSONStyle jSONStyle) {
        return JSONArray.toJSONString(this, jSONStyle);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public String toString(JSONStyle jSONStyle) {
        return this.toJSONString(jSONStyle);
    }

    @Override
    public void writeJSONString(Appendable appendable) throws IOException {
        JSONArray.writeJSONString(this, appendable, JSONValue.COMPRESSION);
    }

    @Override
    public void writeJSONString(Appendable appendable, JSONStyle jSONStyle) throws IOException {
        JSONArray.writeJSONString(this, appendable, jSONStyle);
    }
}

