/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.security.Key;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;

public class SingleKeyJWSKeySelector<C extends SecurityContext>
implements JWSKeySelector<C> {
    private final List<Key> singletonKeyList;
    private final JWSAlgorithm expectedJWSAlg;

    public SingleKeyJWSKeySelector(JWSAlgorithm jWSAlgorithm, Key key) {
        if (jWSAlgorithm == null) {
            throw new IllegalArgumentException("The expected JWS algorithm cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        this.singletonKeyList = Collections.singletonList(key);
        this.expectedJWSAlg = jWSAlgorithm;
    }

    @Override
    public List<? extends Key> selectJWSKeys(JWSHeader jWSHeader, C c2) {
        if (!this.expectedJWSAlg.equals(jWSHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        return this.singletonKeyList;
    }
}

