/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public enum KeyOperation {
    SIGN("sign"),
    VERIFY("verify"),
    ENCRYPT("encrypt"),
    DECRYPT("decrypt"),
    WRAP_KEY("wrapKey"),
    UNWRAP_KEY("unwrapKey"),
    DERIVE_KEY("deriveKey"),
    DERIVE_BITS("deriveBits");

    private final String identifier;

    private KeyOperation(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The key operation identifier must not be null");
        }
        this.identifier = string2;
    }

    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier();
    }

    public static Set<KeyOperation> parse(List<String> list) throws ParseException {
        if (list == null) {
            return null;
        }
        LinkedHashSet<KeyOperation> linkedHashSet = new LinkedHashSet<KeyOperation>();
        for (String string : list) {
            if (string == null) continue;
            KeyOperation keyOperation = null;
            for (KeyOperation keyOperation2 : KeyOperation.values()) {
                if (!string.equals(keyOperation2.identifier())) continue;
                keyOperation = keyOperation2;
                break;
            }
            if (keyOperation != null) {
                linkedHashSet.add(keyOperation);
                continue;
            }
            throw new ParseException("Invalid JWK operation: " + string, 0);
        }
        return linkedHashSet;
    }
}

