/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories;

import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyTypeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.AESDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.DirectDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDHDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.PasswordBasedDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSADecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JWEJCAContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEDecrypterFactory;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWEDecrypterFactory
implements JWEDecrypterFactory {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final JWEJCAContext jcaContext = new JWEJCAContext();

    @Override
    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return SUPPORTED_ENCRYPTION_METHODS;
    }

    @Override
    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWEDecrypter createJWEDecrypter(JWEHeader jWEHeader, Key key) throws JOSEException {
        BaseJWEProvider baseJWEProvider;
        if (RSADecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && RSADecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof PrivateKey) || !(key instanceof RSAKey)) {
                throw new KeyTypeException(PrivateKey.class, RSAKey.class);
            }
            PrivateKey privateKey = (PrivateKey)key;
            baseJWEProvider = new RSADecrypter(privateKey);
        } else if (ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof PrivateKey) || !(key instanceof ECKey)) {
                throw new KeyTypeException(PrivateKey.class, ECKey.class);
            }
            PrivateKey privateKey = (PrivateKey)key;
            Curve curve = Curve.forECParameterSpec(((ECKey)((Object)key)).getParams());
            baseJWEProvider = new ECDHDecrypter(privateKey, null, curve);
        } else if (DirectDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey secretKey = (SecretKey)key;
            DirectDecrypter directDecrypter = new DirectDecrypter(secretKey);
            if (!directDecrypter.supportedEncryptionMethods().contains(jWEHeader.getEncryptionMethod())) {
                throw new KeyLengthException(jWEHeader.getEncryptionMethod().cekBitLength(), jWEHeader.getEncryptionMethod());
            }
            baseJWEProvider = directDecrypter;
        } else if (AESDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && AESDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey secretKey = (SecretKey)key;
            AESDecrypter aESDecrypter = new AESDecrypter(secretKey);
            if (!aESDecrypter.supportedJWEAlgorithms().contains(jWEHeader.getAlgorithm())) {
                throw new KeyLengthException(jWEHeader.getAlgorithm());
            }
            baseJWEProvider = aESDecrypter;
        } else if (PasswordBasedDecrypter.SUPPORTED_ALGORITHMS.contains(jWEHeader.getAlgorithm()) && PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(jWEHeader.getEncryptionMethod())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            byte[] byArray = key.getEncoded();
            baseJWEProvider = new PasswordBasedDecrypter(byArray);
        } else {
            throw new JOSEException("Unsupported JWE algorithm or encryption method");
        }
        ((JWEJCAContext)baseJWEProvider.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JWEJCAContext)baseJWEProvider.getJCAContext()).setProvider(this.jcaContext.getProvider());
        ((JWEJCAContext)baseJWEProvider.getJCAContext()).setKeyEncryptionProvider(this.jcaContext.getKeyEncryptionProvider());
        ((JWEJCAContext)baseJWEProvider.getJCAContext()).setMACProvider(this.jcaContext.getMACProvider());
        ((JWEJCAContext)baseJWEProvider.getJCAContext()).setContentEncryptionProvider(this.jcaContext.getContentEncryptionProvider());
        return baseJWEProvider;
    }

    static {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(RSADecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(ECDHDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(DirectDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(AESDecrypter.SUPPORTED_ALGORITHMS);
        linkedHashSet.addAll(PasswordBasedDecrypter.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        linkedHashSet2.addAll(RSADecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(DirectDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(AESDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        linkedHashSet2.addAll(PasswordBasedDecrypter.SUPPORTED_ENCRYPTION_METHODS);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(linkedHashSet2);
    }
}

