/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDSA;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDSAProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ECChecks;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDSAVerifier
extends ECDSAProvider
implements CriticalHeaderParamsAware,
JWSVerifier {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final ECPublicKey publicKey;

    public ECDSAVerifier(ECPublicKey eCPublicKey) throws JOSEException {
        this(eCPublicKey, null);
    }

    public ECDSAVerifier(ECKey eCKey) throws JOSEException {
        this(eCKey.toECPublicKey());
    }

    public ECDSAVerifier(ECPublicKey eCPublicKey, Set<String> set) throws JOSEException {
        super(ECDSA.resolveAlgorithm(eCPublicKey));
        this.publicKey = eCPublicKey;
        if (!ECChecks.isPointOnCurve(eCPublicKey, Curve.forJWSAlgorithm(this.supportedECDSAAlgorithm()).iterator().next().toECParameterSpec())) {
            throw new JOSEException("Curve / public key parameters mismatch");
        }
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public boolean verify(JWSHeader jWSHeader, byte[] byArray, Base64URL base64URL) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(jWSAlgorithm)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, this.supportedJWSAlgorithms()));
        }
        if (!this.critPolicy.headerPasses(jWSHeader)) {
            return false;
        }
        byte[] byArray3 = base64URL.decode();
        try {
            ECDSA.ensureLegalSignature(byArray3, jWSAlgorithm);
        }
        catch (JOSEException jOSEException) {
            return false;
        }
        try {
            byArray2 = ECDSA.transcodeSignatureToDER(byArray3);
        }
        catch (JOSEException jOSEException) {
            return false;
        }
        Signature signature = ECDSA.getSignerAndVerifier(jWSAlgorithm, this.getJCAContext().getProvider());
        try {
            signature.initVerify(this.publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid EC public key: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

