/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDHEncrypter
extends ECDHCryptoProvider
implements JWEEncrypter {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final ECPublicKey publicKey;
    private final SecretKey contentEncryptionKey;

    public ECDHEncrypter(ECPublicKey eCPublicKey) throws JOSEException {
        this(eCPublicKey, null);
    }

    public ECDHEncrypter(ECKey eCKey) throws JOSEException {
        super(eCKey.getCurve());
        this.publicKey = eCKey.toECPublicKey();
        this.contentEncryptionKey = null;
    }

    public ECDHEncrypter(ECPublicKey eCPublicKey, SecretKey secretKey) throws JOSEException {
        super(Curve.forECParameterSpec(eCPublicKey.getParams()));
        this.publicKey = eCPublicKey;
        if (secretKey != null) {
            if (secretKey.getAlgorithm() == null || !secretKey.getAlgorithm().equals("AES")) {
                throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES");
            }
            this.contentEncryptionKey = secretKey;
        } else {
            this.contentEncryptionKey = null;
        }
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        KeyPair keyPair = this.generateEphemeralKeyPair(this.publicKey.getParams());
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey eCPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).ephemeralPublicKey(new ECKey.Builder(this.getCurve(), eCPublicKey).build()).build();
        SecretKey secretKey = ECDH.deriveSharedSecret(this.publicKey, eCPrivateKey, this.getJCAContext().getKeyEncryptionProvider());
        return this.encryptWithZ(jWEHeader2, secretKey, byArray, this.contentEncryptionKey);
    }

    private KeyPair generateEphemeralKeyPair(ECParameterSpec eCParameterSpec) throws JOSEException {
        Provider provider = this.getJCAContext().getKeyEncryptionProvider();
        try {
            KeyPairGenerator keyPairGenerator = provider != null ? KeyPairGenerator.getInstance("EC", provider) : KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(eCParameterSpec);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            throw new JOSEException("Couldn't generate ephemeral EC key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    static {
        LinkedHashSet<Curve> linkedHashSet = new LinkedHashSet<Curve>();
        linkedHashSet.add(Curve.P_256);
        linkedHashSet.add(Curve.P_384);
        linkedHashSet.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(linkedHashSet);
    }
}

