/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.utils.ECChecks;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

public class ECDHDecrypter
extends ECDHCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    public static final Set<Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final PrivateKey privateKey;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public ECDHDecrypter(ECPrivateKey eCPrivateKey) throws JOSEException {
        this(eCPrivateKey, null);
    }

    public ECDHDecrypter(ECKey eCKey) throws JOSEException {
        super(eCKey.getCurve());
        if (!eCKey.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = eCKey.toECPrivateKey();
    }

    public ECDHDecrypter(ECPrivateKey eCPrivateKey, Set<String> set) throws JOSEException {
        this(eCPrivateKey, set, Curve.forECParameterSpec(eCPrivateKey.getParams()));
    }

    public ECDHDecrypter(PrivateKey privateKey, Set<String> set, Curve curve) throws JOSEException {
        super(curve);
        this.critPolicy.setDeferredCriticalHeaderParams(set);
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        Key key;
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        ECKey eCKey = (ECKey)jWEHeader.getEphemeralPublicKey();
        if (eCKey == null) {
            throw new JOSEException("Missing ephemeral public EC key \"epk\" JWE header parameter");
        }
        ECPublicKey eCPublicKey = eCKey.toECPublicKey();
        if (this.getPrivateKey() instanceof ECPrivateKey ? !ECChecks.isPointOnCurve(eCPublicKey, key = (ECPrivateKey)this.getPrivateKey()) : !ECChecks.isPointOnCurve(eCPublicKey, this.getCurve().toECParameterSpec())) {
            throw new JOSEException("Invalid ephemeral public EC key: Point(s) not on the expected curve");
        }
        key = ECDH.deriveSharedSecret(eCPublicKey, this.privateKey, this.getJCAContext().getKeyEncryptionProvider());
        return this.decryptWithZ(jWEHeader, (SecretKey)key, base64URL, base64URL2, base64URL3, base64URL4);
    }

    static {
        LinkedHashSet<Curve> linkedHashSet = new LinkedHashSet<Curve>();
        linkedHashSet.add(Curve.P_256);
        linkedHashSet.add(Curve.P_384);
        linkedHashSet.add(Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(linkedHashSet);
    }
}

