/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractMsalAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCode;

class DeviceCodeAuthorizationGrant
extends AbstractMsalAuthorizationGrant {
    private static final String GRANT_TYPE = "device_code";
    private final DeviceCode deviceCode;
    private final String scopes;
    private String correlationId;

    DeviceCodeAuthorizationGrant(DeviceCode deviceCode, String string, ClaimsRequest claimsRequest) {
        this.deviceCode = deviceCode;
        this.correlationId = deviceCode.correlationId();
        this.scopes = string;
        this.claims = claimsRequest;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("scope", Collections.singletonList("openid profile offline_access " + this.scopes));
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE));
        linkedHashMap.put(GRANT_TYPE, Collections.singletonList(this.deviceCode.deviceCode()));
        linkedHashMap.put("client_info", Collections.singletonList("1"));
        if (this.claims != null) {
            linkedHashMap.put("claims", Collections.singletonList(this.claims.formatAsJSONString()));
        }
        return linkedHashMap;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }
}

