/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.LogicalType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        byte[] byArray = jsonParser.getBinaryValue();
        return ByteBuffer.wrap(byArray);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, ByteBuffer byteBuffer) throws IOException {
        ByteBufferBackedOutputStream byteBufferBackedOutputStream = new ByteBufferBackedOutputStream(byteBuffer);
        jsonParser.readBinaryValue(deserializationContext.getBase64Variant(), byteBufferBackedOutputStream);
        byteBufferBackedOutputStream.close();
        return byteBuffer;
    }
}

