/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import macromedia.jdbc.slbase.BaseCallableStatement;
import macromedia.jdbc.slbase.BaseCallableStatementPoolable;
import macromedia.jdbc.slbase.BasePreparedStatement;
import macromedia.jdbc.slbase.BasePreparedStatementPoolable;

public final class BaseStatementPool {
    private final int TYPE_PREPARED_STATEMENT = 1;
    private final int TYPE_CALLABLE_STATEMENT = 2;
    BasePoolListNode head;
    BasePoolListNode tail;
    int maxPoolSize;
    int poolSize = 0;

    BaseStatementPool(int n2) {
        this.maxPoolSize = n2;
    }

    PreparedStatement makePreparedStatementPoolable(BasePreparedStatement basePreparedStatement) {
        BasePreparedStatementPoolable basePreparedStatementPoolable;
        basePreparedStatement.poolWrapper = basePreparedStatementPoolable = new BasePreparedStatementPoolable(basePreparedStatement, this);
        return basePreparedStatementPoolable;
    }

    CallableStatement makeCallableStatementPoolable(BaseCallableStatement baseCallableStatement) {
        BaseCallableStatementPoolable baseCallableStatementPoolable = new BaseCallableStatementPoolable(baseCallableStatement, this);
        baseCallableStatement.poolWrapper = baseCallableStatementPoolable;
        return baseCallableStatementPoolable;
    }

    void putPreparedStatement(BasePreparedStatement basePreparedStatement) {
        try {
            basePreparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            try {
                basePreparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        this.putStatement(1, basePreparedStatement);
    }

    void putCallableStatement(BaseCallableStatement baseCallableStatement) {
        try {
            baseCallableStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            try {
                baseCallableStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        this.putStatement(2, baseCallableStatement);
    }

    private void putStatement(int n2, BasePreparedStatement basePreparedStatement) {
        try {
            basePreparedStatement.clearBatchInternal();
            basePreparedStatement.closeCurrentResults(3, false);
            basePreparedStatement.implStatement.reset();
        }
        catch (SQLException sQLException) {
            try {
                basePreparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        BasePoolListNode basePoolListNode = this.head;
        this.head = new BasePoolListNode();
        this.head.statement = basePreparedStatement;
        this.head.statementType = n2;
        this.head.statementType = n2 == 2 ? 2 : 1;
        this.head.previous = basePoolListNode;
        this.head.next = null;
        basePreparedStatement.poolWrapper = null;
        if (basePoolListNode != null) {
            basePoolListNode.next = this.head;
        }
        if (this.tail == null) {
            this.tail = this.head;
        }
        ++this.poolSize;
        if (this.poolSize > this.maxPoolSize) {
            try {
                this.tail.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.tail = this.tail.next;
            this.tail.previous = null;
            --this.poolSize;
        }
    }

    PreparedStatement getPreparedStatement(String string, int n2, int n3) {
        return (PreparedStatement)this.getStatement(1, string, n2, n3);
    }

    CallableStatement getCallableStatement(String string, int n2, int n3) {
        return (CallableStatement)this.getStatement(2, string, n2, n3);
    }

    private Statement getStatement(int n2, String string, int n3, int n4) {
        BasePoolListNode basePoolListNode = this.head;
        while (basePoolListNode != null) {
            if (basePoolListNode.statementType == n2 && basePoolListNode.statement.implStatement.sql.getOriginal().equals(string) && basePoolListNode.statement.requestedResultSetType == n3 && basePoolListNode.statement.requestedResultSetConcurrency == n4) {
                if (basePoolListNode.previous != null) {
                    basePoolListNode.previous.next = basePoolListNode.next;
                }
                if (basePoolListNode.next != null) {
                    basePoolListNode.next.previous = basePoolListNode.previous;
                }
                if (basePoolListNode == this.head) {
                    this.head = this.head.previous;
                }
                if (basePoolListNode == this.tail) {
                    this.tail = this.tail.next;
                    if (this.tail == null) {
                        this.tail = this.head;
                    }
                }
                --this.poolSize;
                if (n2 == 2) {
                    return this.makeCallableStatementPoolable((BaseCallableStatement)basePoolListNode.statement);
                }
                return this.makePreparedStatementPoolable(basePoolListNode.statement);
            }
            basePoolListNode = basePoolListNode.previous;
        }
        return null;
    }

    void empty() {
        while (this.head != null) {
            try {
                this.head.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.head = this.head.next;
        }
    }

    class BasePoolListNode {
        BasePreparedStatement statement;
        int statementType;
        int resultSetType;
        int resultSetConcurrency;
        BasePoolListNode previous;
        BasePoolListNode next;

        BasePoolListNode() {
        }
    }
}

