/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcdb2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import macromedia.db2util.ddq;
import macromedia.resource.jdbc.JCAConnectionFactory;
import macromedia.resource.jdbcdb2.spi.JCAConnectionRequestInfo;
import macromedia.resource.jdbcdb2.spi.JCADefaultConnectionManager;
import macromedia.resource.jdbcdb2.spi.JCAExceptions;
import macromedia.resource.jdbcdb2.spi.JCALogger;
import macromedia.resource.jdbcdb2.spi.JCAManagedConnectionFactoryCommon;
import macromedia.resource.jdbcdb2.spi.JCAUtil;

public class JCAConnectionFactoryCommon
extends JCAConnectionFactory {
    private static String footprint = "$Revision: #1 $";
    private JCAManagedConnectionFactoryCommon managedConnectionFactory;
    private ConnectionManager connectionManager;
    protected transient JCALogger logger;
    private transient JCAExceptions exceptions;
    private transient Reference reference;

    public JCAConnectionFactoryCommon() {
    }

    public JCAConnectionFactoryCommon(ConnectionManager connectionManager, JCAManagedConnectionFactoryCommon jCAManagedConnectionFactoryCommon, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        this.init(connectionManager, jCAManagedConnectionFactoryCommon, jCALogger, jCAExceptions);
    }

    public void init(ConnectionManager connectionManager, JCAManagedConnectionFactoryCommon jCAManagedConnectionFactoryCommon, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        ddq.a("managedConnectionFactory must not be null", jCAManagedConnectionFactoryCommon != null);
        ddq.a("connectionManager must not be null", connectionManager != null);
        ddq.a("exceptions must not be null", jCAExceptions != null);
        this.managedConnectionFactory = jCAManagedConnectionFactoryCommon;
        this.connectionManager = connectionManager;
        this.logger = jCALogger;
        this.exceptions = jCAExceptions;
    }

    public Connection getConnection() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getConnection()");
        }
        this.validate();
        try {
            Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, null);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ConnectionFactory.getConnection", connection);
            }
            return connection;
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getConnection(String username, String password)");
            this.logger.println("username = " + string);
            this.logger.println("password = ********");
        }
        this.validate();
        JCAConnectionRequestInfo jCAConnectionRequestInfo = new JCAConnectionRequestInfo(string, string2);
        try {
            Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)jCAConnectionRequestInfo);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ConnectionFactory.getConnection", connection);
            }
            return connection;
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        PrintWriter printWriter = this.logger.getLogWriter();
        if (printWriter != null) {
            this.logger.printEnter("ConnectionFactory.getLogWriter()");
        }
        this.validate();
        if (printWriter != null) {
            this.logger.printExit("ConnectionFactory.getLogWriter", printWriter);
        }
        return printWriter;
    }

    public int getLoginTimeout() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getLoginTimeout()");
        }
        this.validate();
        int n2 = this.managedConnectionFactory.getLoginTimeout();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.getLoginTimeout", String.valueOf(n2));
        }
        return n2;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        if (this.logger != null) {
            if (this.logger.getLogWriter() != null) {
                this.logger.printEnter("ConnectionFactory.setLogWriter(PrintWriter logWriter)");
                this.logger.println("logWriter = " + printWriter);
            }
            this.logger.cleanup();
        }
        this.validate();
        this.logger = new JCALogger(printWriter);
        try {
            this.managedConnectionFactory.setLogWriter(printWriter);
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
        DriverManager.setLogWriter(printWriter);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setLogWriter");
        }
    }

    public void setLoginTimeout(int n2) throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.setLoginTimeout(int seconds)");
            this.logger.println("seconds = " + n2);
        }
        this.validate();
        this.managedConnectionFactory.setLoginTimeout(new Integer(n2));
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setLoginTimeout");
        }
    }

    public void setReference(Reference reference) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.setReference(Reference reference)");
            this.logger.println("reference = " + reference);
        }
        this.reference = reference;
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setReference");
        }
    }

    public Reference getReference() throws NamingException {
        Reference reference = null;
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getReference()");
        }
        reference = this.reference != null ? this.reference : this.createReference();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.getReference", reference);
        }
        return reference;
    }

    private final void validate() throws SQLException {
        if (this.connectionManager == null || this.managedConnectionFactory == null) {
            ResourceException resourceException = this.exceptions.getException(4310, 2);
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    private final Reference createReference() {
        return JCAUtil.createConnectionFactoryReference(this.managedConnectionFactory);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.logger = new JCALogger(this.managedConnectionFactory.getLogWriter());
        }
        catch (ResourceException resourceException) {
            this.logger = new JCALogger();
        }
        this.exceptions = this.managedConnectionFactory.getExceptions();
        if (this.connectionManager instanceof JCADefaultConnectionManager) {
            ((JCADefaultConnectionManager)this.connectionManager).setExceptions(this.exceptions);
        }
        this.reference = null;
    }
}

