/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.signers;

import macromedia.db2util.externals.org.bouncycastle.crypto.AsymmetricBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoException;
import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.Signer;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher engine;
    private final Digest digest;
    private boolean forSigning;

    public GenericSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this.engine = asymmetricBlockCipher;
        this.digest = digest;
    }

    public void init(boolean bl, dda dda10) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = dda10 instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)dda10).getParameters() : (AsymmetricKeyParameter)dda10;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.engine.init(bl, dda10);
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return this.engine.processBlock(byArray, 0, byArray.length);
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            byte[] byArray3 = this.engine.processBlock(byArray, 0, byArray.length);
            if (byArray3.length < byArray2.length) {
                byte[] byArray4 = new byte[byArray2.length];
                System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
                byArray3 = byArray4;
            }
            return Arrays.constantTimeAreEqual(byArray3, byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void reset() {
        this.digest.reset();
    }
}

