/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.macs;

import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.db2util.externals.org.bouncycastle.crypto.Mac;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.modes.KGCMBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.AEADParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithIV;

public class KGMac
implements Mac {
    private final KGCMBlockCipher cipher;
    private final int macSizeBits;

    public KGMac(KGCMBlockCipher kGCMBlockCipher) {
        this.cipher = kGCMBlockCipher;
        this.macSizeBits = kGCMBlockCipher.getUnderlyingCipher().getBlockSize() << 3;
    }

    public KGMac(KGCMBlockCipher kGCMBlockCipher, int n2) {
        this.cipher = kGCMBlockCipher;
        this.macSizeBits = n2;
    }

    public void init(dda dda10) throws IllegalArgumentException {
        if (!(dda10 instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("KGMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)dda10;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.cipher.init(true, new AEADParameters(keyParameter, this.macSizeBits, byArray));
    }

    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-KGMAC";
    }

    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    public void update(byte by) throws IllegalStateException {
        this.cipher.processAADByte(by);
    }

    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(byArray, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

