/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.AsymmetricBlockCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.engines.RSACoreEngine;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.RSAKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import macromedia.db2util.externals.org.bouncycastle.util.BigIntegers;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean bl, dda dda10) {
        this.core.init(bl, dda10);
        if (dda10 instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda10;
            this.key = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            this.key = (RSAKeyParameters)dda10;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] byArray, int n2, int n3) {
        BigInteger bigInteger;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger bigInteger2 = this.core.convertInput(byArray, n2, n3);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger bigInteger3 = rSAPrivateCrtKeyParameters.getPublicExponent();
            if (bigInteger3 != null) {
                BigInteger bigInteger4;
                BigInteger bigInteger5 = rSAPrivateCrtKeyParameters.getModulus();
                BigInteger bigInteger6 = BigIntegers.createRandomInRange(ONE, bigInteger5.subtract(ONE), this.random);
                BigInteger bigInteger7 = bigInteger6.modPow(bigInteger3, bigInteger5).multiply(bigInteger2).mod(bigInteger5);
                BigInteger bigInteger8 = this.core.processBlock(bigInteger7);
                bigInteger = bigInteger8.multiply(bigInteger4 = bigInteger6.modInverse(bigInteger5)).mod(bigInteger5);
                if (!bigInteger2.equals(bigInteger.modPow(bigInteger3, bigInteger5))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                bigInteger = this.core.processBlock(bigInteger2);
            }
        } else {
            bigInteger = this.core.processBlock(bigInteger2);
        }
        return this.core.convertOutput(bigInteger);
    }
}

