/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.crypto.engines;

import macromedia.db2util.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.db2util.externals.org.bouncycastle.crypto.StreamCipher;
import macromedia.db2util.externals.org.bouncycastle.crypto.dda;
import macromedia.db2util.externals.org.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private static final int STATE_LENGTH = 256;
    private byte[] engineState = null;
    private int x = 0;
    private int y = 0;
    private byte[] workingKey = null;

    public void init(boolean bl, dda dda10) {
        if (dda10 instanceof KeyParameter) {
            this.workingKey = ((KeyParameter)dda10).getKey();
            RC4Engine rC4Engine = this;
            rC4Engine.setKey(rC4Engine.workingKey);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to RC4 init - " + dda10.getClass().getName());
    }

    public String getAlgorithmName() {
        return "RC4";
    }

    public byte returnByte(byte by) {
        this.x = this.x + 1 & 0xFF;
        this.y = this.engineState[this.x] + this.y & 0xFF;
        byte by2 = this.engineState[this.x];
        this.engineState[this.x] = this.engineState[this.y];
        this.engineState[this.y] = by2;
        return (byte)(by ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n4 + n3 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.engineState[this.x] + this.y & 0xFF;
            byte by = this.engineState[this.x];
            this.engineState[this.x] = this.engineState[this.y];
            this.engineState[this.y] = by;
            byArray2[i2 + n4] = (byte)(byArray[i2 + n2] ^ this.engineState[this.engineState[this.x] + this.engineState[this.y] & 0xFF]);
        }
        return n3;
    }

    public void reset() {
        RC4Engine rC4Engine = this;
        rC4Engine.setKey(rC4Engine.workingKey);
    }

    private final void setKey(byte[] byArray) {
        this.workingKey = byArray;
        this.x = 0;
        this.y = 0;
        if (this.engineState == null) {
            this.engineState = new byte[256];
        }
        int n2 = 0;
        while (n2 < 256) {
            int n3 = n2++;
            this.engineState[n3] = (byte)n3;
        }
        n2 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n4 = (byArray[n2] & 0xFF) + this.engineState[i2] + n4 & 0xFF;
            byte by = this.engineState[i2];
            this.engineState[i2] = this.engineState[n4];
            this.engineState[n4] = by;
            n2 = (n2 + 1) % byArray.length;
        }
    }
}

