/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util.externals.org.bouncycastle.asn1.ess;

import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.ess.ESSCertIDv2;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Object {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static SigningCertificateV2 getInstance(Object object) {
        if (object == null || object instanceof SigningCertificateV2) {
            return (SigningCertificateV2)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)object);
        }
        return null;
    }

    private SigningCertificateV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.certs = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.policies = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2 eSSCertIDv2) {
        this.certs = new DERSequence(eSSCertIDv2);
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 < eSSCertIDv2Array.length; ++i2) {
            aSN1EncodableVector.add(eSSCertIDv2Array[i2]);
        }
        this.certs = new DERSequence(aSN1EncodableVector);
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        int n2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (n2 = 0; n2 < eSSCertIDv2Array.length; ++n2) {
            aSN1EncodableVector.add(eSSCertIDv2Array[n2]);
        }
        this.certs = new DERSequence(aSN1EncodableVector);
        if (policyInformationArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n2 = 0; n2 < policyInformationArray.length; ++n2) {
                aSN1EncodableVector.add(policyInformationArray[n2]);
            }
            this.policies = new DERSequence(aSN1EncodableVector);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[this.certs.size()];
        for (int i2 = 0; i2 != this.certs.size(); ++i2) {
            eSSCertIDv2Array[i2] = ESSCertIDv2.getInstance(this.certs.getObjectAt(i2));
        }
        return eSSCertIDv2Array;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.policies.size()];
        for (int i2 = 0; i2 != this.policies.size(); ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance(this.policies.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certs);
        if (this.policies != null) {
            aSN1EncodableVector.add(this.policies);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

