/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import macromedia.db2util.DDPBEKey;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1InputStream;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.db2util.externals.org.bouncycastle.asn1.ASN1Set;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERBMPString;
import macromedia.db2util.externals.org.bouncycastle.asn1.DERNull;
import macromedia.db2util.externals.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import macromedia.db2util.externals.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.CertBag;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.ContentInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.EncryptedData;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.MacData;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.Pfx;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.pkcs.SafeBag;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.DigestInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.Extension;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import macromedia.db2util.externals.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import macromedia.db2util.externals.org.bouncycastle.crypto.Digest;
import macromedia.db2util.externals.org.bouncycastle.crypto.util.DigestFactory;
import macromedia.db2util.externals.org.bouncycastle.jcajce.PKCS12Key;
import macromedia.db2util.externals.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import macromedia.db2util.externals.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import macromedia.db2util.externals.org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import macromedia.db2util.externals.org.bouncycastle.jce.interfaces.BCKeyStore;
import macromedia.db2util.externals.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import macromedia.db2util.externals.org.bouncycastle.jce.provider.BouncyCastleProvider;
import macromedia.db2util.externals.org.bouncycastle.util.Arrays;
import macromedia.db2util.externals.org.bouncycastle.util.Integers;
import macromedia.db2util.externals.org.bouncycastle.util.Properties;
import macromedia.db2util.externals.org.bouncycastle.util.Strings;
import macromedia.db2util.externals.org.bouncycastle.util.encoders.Hex;

public class DDPKCS12KeyStoreProvider
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    static final String PKCS12_MAX_IT_COUNT_PROPERTY = "macromedia.db2util.externals.org.bouncycastle.pkcs12.max_it_count";
    private static final int MIN_ITERATIONS = 1024;
    private static final b keySizeProvider = new b();
    private static Method initMethod;
    private static Method doFinalMethod;
    private static Method updateMethod;
    private c keys = new c();
    private Hashtable<String, String> localIds = new Hashtable();
    private c certs = new c();
    private Hashtable<a, Certificate> chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    protected ASN1ObjectIdentifier keyAlgorithm;
    protected ASN1ObjectIdentifier certAlgorithm;
    private AlgorithmIdentifier macAlgorithm = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    private int itCount = 1024;

    public DDPKCS12KeyStoreProvider() {
        this(null, PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC);
    }

    public DDPKCS12KeyStoreProvider(Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.keyAlgorithm = aSN1ObjectIdentifier;
        this.certAlgorithm = aSN1ObjectIdentifier2;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private final SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            return new SubjectKeyIdentifier(DDPKCS12KeyStoreProvider.getDigest(subjectPublicKeyInfo));
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Digest digest = DigestFactory.createSHA1();
        byte[] byArray = new byte[digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.a();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.a();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certs.b(string) != null || this.keys.b(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.a(string);
        Certificate certificate = (Certificate)this.certs.a(string);
        if (certificate != null) {
            this.chainCerts.remove(new a(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new a(certificate.getPublicKey()));
            }
        }
    }

    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("alias cannot be null");
        }
        Certificate certificate = (Certificate)this.certs.b(string);
        if (certificate == null) {
            String string2 = this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        String string;
        Certificate certificate2;
        Enumeration enumeration = this.certs.b();
        Enumeration enumeration2 = this.certs.a();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        enumeration = this.keyCerts.elements();
        enumeration2 = this.keyCerts.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ASN1InputStream(byArray);
                        object2 = ((ASN1OctetString)((ASN1InputStream)object3).readObject()).getOctets();
                        object3 = new ASN1InputStream((byte[])object2);
                        object = AuthorityKeyIdentifier.getInstance(((ASN1InputStream)object3).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = this.chainCerts.get(new a(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.chainCerts.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!((Object)principal).equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (vector.contains(certificate)) {
                    certificate = null;
                    continue;
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                certificateArray[i2] = (Certificate)vector.elementAt(i2);
            }
            return certificateArray;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        if (string == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.keys.b(string) == null && this.certs.b(string) == null) {
            return null;
        }
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.b(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.certs.b(string) != null && this.keys.b(string) == null;
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keys.b(string) != null;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.keys.b(string) != null) {
            throw new KeyStoreException("There is a key entry with the name " + string + ".");
        }
        this.certs.a(string, certificate);
        this.chainCerts.put(new a(certificate.getPublicKey()), certificate);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.b(string) != null) {
            this.engineDeleteEntry(string);
        }
        this.keys.a(string, key);
        if (certificateArray != null) {
            this.certs.a(string, certificateArray[0]);
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                this.chainCerts.put(new a(certificateArray[i2].getPublicKey()), certificateArray[i2]);
            }
        }
    }

    public int engineSize() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.a();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.a();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        try {
            if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), this.validateIterationCount(pKCS12PBEParams.getIterations()));
                Cipher cipher = Cipher.getInstance(aSN1ObjectIdentifier.getId());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl);
                cipher.init(4, (Key)pKCS12Key, pBEParameterSpec);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                Cipher cipher = this.createCipher(4, cArray, algorithmIdentifier);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + aSN1ObjectIdentifier);
    }

    protected byte[] cryptData(boolean bl, AlgorithmIdentifier algorithmIdentifier, char[] cArray, boolean bl2, byte[] byArray) throws IOException {
        int n2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        int n3 = n2 = bl ? 1 : 2;
        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
            try {
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                SecretKey secretKey = this.getPBEKey(cArray);
                Cipher cipher = Cipher.getInstance(aSN1ObjectIdentifier.getId());
                cipher.init(n2, (Key)secretKey, pBEParameterSpec);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
            try {
                Cipher cipher = this.createCipher(n2, cArray, algorithmIdentifier);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
    }

    private final SecretKey getPBEKey(char[] cArray) throws IOException {
        DDPBEKey dDPBEKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            dDPBEKey = new DDPBEKey(pBEKeySpec, "PBE");
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return dDPBEKey;
    }

    private final Cipher createCipher(int n2, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
        SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.a(algorithmIdentifier2))) : secretKeyFactory.generateSecret(new PBKDF2KeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.a(algorithmIdentifier2), pBKDF2Params.getPrf()));
        Cipher cipher = Cipher.getInstance(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
        ASN1Encodable aSN1Encodable = pBES2Parameters.getEncryptionScheme().getParameters();
        if (aSN1Encodable instanceof ASN1OctetString) {
            cipher.init(n2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Encodable).getOctets()));
        } else {
            GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Encodable);
            cipher.init(n2, (Key)secretKey, new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
        }
        return cipher;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ASN1Object aSN1Object;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        ASN1Object aSN1Object2;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n2 = bufferedInputStream.read();
        if (n2 != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        Pfx pfx = Pfx.getInstance(aSN1Sequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<ASN1Object> vector = new Vector<ASN1Object>();
        boolean bl = false;
        boolean bl2 = false;
        if (pfx.getMacData() != null) {
            aSN1Object2 = pfx.getMacData();
            object9 = ((MacData)aSN1Object2).getMac();
            this.macAlgorithm = ((DigestInfo)object9).getAlgorithmId();
            byte[] byArray = ((MacData)aSN1Object2).getSalt();
            this.itCount = this.validateIterationCount(((MacData)aSN1Object2).getIterationCount());
            object8 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                DDPKCS12KeyStoreProvider dDPKCS12KeyStoreProvider = this;
                object7 = dDPKCS12KeyStoreProvider.calculatePbeMac(dDPKCS12KeyStoreProvider.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, false, (byte[])object8);
                object6 = ((DigestInfo)object9).getDigest();
                if (!Arrays.constantTimeAreEqual(object7, (byte[])object6)) {
                    if (cArray.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    DDPKCS12KeyStoreProvider dDPKCS12KeyStoreProvider2 = this;
                    object7 = dDPKCS12KeyStoreProvider2.calculatePbeMac(dDPKCS12KeyStoreProvider2.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, true, (byte[])object8);
                    if (!Arrays.constantTimeAreEqual(object7, (byte[])object6)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new c();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
            aSN1Object2 = AuthenticatedSafe.getInstance(aSN1InputStream.readObject());
            object9 = ((AuthenticatedSafe)aSN1Object2).getContentInfo();
            for (int i2 = 0; i2 != ((ContentInfo[])object9).length; ++i2) {
                ASN1Encodable aSN1Encodable;
                ASN1Primitive aSN1Primitive;
                ASN1Primitive aSN1Primitive2;
                Object object10;
                Object object11;
                if (object9[i2].getContentType().equals(PKCSObjectIdentifiers.data)) {
                    object8 = new ASN1InputStream(((ASN1OctetString)((ContentInfo)object9[i2]).getContent()).getOctets());
                    object7 = (ASN1Sequence)((ASN1InputStream)object8).readObject();
                    for (int i3 = 0; i3 != object7.size(); ++i3) {
                        SafeBag safeBag = SafeBag.getInstance(object7.getObjectAt(i3));
                        if (safeBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                            aSN1Object = EncryptedPrivateKeyInfo.getInstance(safeBag.getBagValue());
                            object5 = this.unwrapKey(((EncryptedPrivateKeyInfo)aSN1Object).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)aSN1Object).getEncryptedData(), cArray, bl2);
                            object4 = (PKCS12BagAttributeCarrier)object5;
                            object3 = null;
                            object2 = null;
                            if (safeBag.getBagAttributes() != null) {
                                object = safeBag.getBagAttributes().getObjects();
                                while (object.hasMoreElements()) {
                                    object11 = (ASN1Sequence)object.nextElement();
                                    object10 = (ASN1ObjectIdentifier)((ASN1Sequence)object11).getObjectAt(0);
                                    aSN1Primitive2 = (ASN1Set)((ASN1Sequence)object11).getObjectAt(1);
                                    aSN1Primitive = null;
                                    if (((ASN1Set)aSN1Primitive2).size() > 0) {
                                        aSN1Primitive = (ASN1Primitive)((ASN1Set)aSN1Primitive2).getObjectAt(0);
                                        aSN1Encodable = object4.getBagAttribute((ASN1ObjectIdentifier)object10);
                                        if (aSN1Encodable != null) {
                                            if (!aSN1Encodable.toASN1Primitive().equals(aSN1Primitive)) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                        } else {
                                            object4.setBagAttribute((ASN1ObjectIdentifier)object10, aSN1Primitive);
                                        }
                                    }
                                    if (((ASN1Primitive)object10).equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                        object3 = ((DERBMPString)aSN1Primitive).getString();
                                        this.keys.a((String)object3, object5);
                                        continue;
                                    }
                                    if (!((ASN1Primitive)object10).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                                    object2 = (ASN1OctetString)aSN1Primitive;
                                }
                            }
                            if (object2 != null) {
                                object = new String(Hex.encode(((ASN1OctetString)object2).getOctets()));
                                if (object3 == null) {
                                    this.keys.a((String)object, object5);
                                    continue;
                                }
                                this.localIds.put((String)object3, (String)object);
                                continue;
                            }
                            bl = true;
                            this.keys.a("unmarked", object5);
                            continue;
                        }
                        if (!safeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) continue;
                        vector.addElement(safeBag);
                    }
                    continue;
                }
                if (!((ContentInfo)object9[i2]).getContentType().equals(PKCSObjectIdentifiers.encryptedData)) continue;
                object8 = EncryptedData.getInstance(((ContentInfo)object9[i2]).getContent());
                object7 = this.cryptData(false, ((EncryptedData)object8).getEncryptionAlgorithm(), cArray, bl2, ((EncryptedData)object8).getContent().getOctets());
                object6 = (ASN1Sequence)ASN1Primitive.fromByteArray(object7);
                for (int i4 = 0; i4 != ((ASN1Sequence)object6).size(); ++i4) {
                    ASN1Encodable aSN1Encodable2;
                    aSN1Object = SafeBag.getInstance(((ASN1Sequence)object6).getObjectAt(i4));
                    if (((SafeBag)aSN1Object).getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                        vector.addElement(aSN1Object);
                        continue;
                    }
                    if (((SafeBag)aSN1Object).getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                        object5 = EncryptedPrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                        object4 = this.unwrapKey(((EncryptedPrivateKeyInfo)object5).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object5).getEncryptedData(), cArray, bl2);
                        object3 = (PKCS12BagAttributeCarrier)object4;
                        object2 = null;
                        object = null;
                        object11 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                        while (object11.hasMoreElements()) {
                            object10 = (ASN1Sequence)object11.nextElement();
                            aSN1Primitive2 = (ASN1ObjectIdentifier)((ASN1Sequence)object10).getObjectAt(0);
                            aSN1Primitive = (ASN1Set)((ASN1Sequence)object10).getObjectAt(1);
                            aSN1Encodable = null;
                            if (((ASN1Set)aSN1Primitive).size() > 0) {
                                aSN1Encodable = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                                aSN1Encodable2 = object3.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2);
                                if (aSN1Encodable2 != null) {
                                    if (!aSN1Encodable2.toASN1Primitive().equals(aSN1Encodable)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                } else {
                                    object3.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2, aSN1Encodable);
                                }
                            }
                            if (aSN1Primitive2.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                                object2 = ((DERBMPString)aSN1Encodable).getString();
                                this.keys.a((String)object2, object4);
                                continue;
                            }
                            if (!aSN1Primitive2.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                            object = (ASN1OctetString)aSN1Encodable;
                        }
                        object10 = new String(Hex.encode(((ASN1OctetString)object).getOctets()));
                        if (object2 == null) {
                            this.keys.a((String)object10, object4);
                            continue;
                        }
                        this.localIds.put((String)object2, (String)object10);
                        continue;
                    }
                    if (!((SafeBag)aSN1Object).getBagId().equals(PKCSObjectIdentifiers.keyBag)) continue;
                    object5 = PrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                    object4 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)object5);
                    object3 = (PKCS12BagAttributeCarrier)object4;
                    object2 = null;
                    object = null;
                    object11 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                    while (object11.hasMoreElements()) {
                        object10 = ASN1Sequence.getInstance(object11.nextElement());
                        aSN1Primitive2 = ASN1ObjectIdentifier.getInstance(((ASN1Sequence)object10).getObjectAt(0));
                        aSN1Primitive = ASN1Set.getInstance(((ASN1Sequence)object10).getObjectAt(1));
                        aSN1Encodable = null;
                        if (((ASN1Set)aSN1Primitive).size() <= 0) continue;
                        aSN1Encodable = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                        aSN1Encodable2 = object3.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2);
                        if (aSN1Encodable2 != null) {
                            if (!aSN1Encodable2.toASN1Primitive().equals(aSN1Encodable)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object3.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2, aSN1Encodable);
                        }
                        if (aSN1Primitive2.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                            object2 = ((DERBMPString)aSN1Encodable).getString();
                            this.keys.a((String)object2, object4);
                            continue;
                        }
                        if (!aSN1Primitive2.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object = (ASN1OctetString)aSN1Encodable;
                    }
                    object10 = new String(Hex.encode(((ASN1OctetString)object).getOctets()));
                    if (object2 == null) {
                        this.keys.a((String)object10, object4);
                        continue;
                    }
                    this.localIds.put((String)object2, (String)object10);
                }
            }
        }
        this.certs = new c();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i5 = 0; i5 != vector.size(); ++i5) {
            Object object12;
            object9 = (SafeBag)vector.elementAt(i5);
            CertBag certBag = CertBag.getInstance(((SafeBag)object9).getBagValue());
            if (!certBag.getCertId().equals(PKCSObjectIdentifiers.x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + certBag.getCertId());
            }
            try {
                object7 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object8 = this.certFact.generateCertificate((InputStream)object7);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object7 = null;
            object6 = null;
            if (((SafeBag)object9).getBagAttributes() != null) {
                object12 = ((SafeBag)object9).getBagAttributes().getObjects();
                while (object12.hasMoreElements()) {
                    aSN1Object = ASN1Sequence.getInstance(object12.nextElement());
                    object5 = ASN1ObjectIdentifier.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(0));
                    object4 = ASN1Set.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(1));
                    if (((ASN1Set)object4).size() <= 0) continue;
                    object3 = (ASN1Primitive)((ASN1Set)object4).getObjectAt(0);
                    object2 = null;
                    if (object8 instanceof PKCS12BagAttributeCarrier) {
                        object2 = (PKCS12BagAttributeCarrier)object8;
                        object = object2.getBagAttribute((ASN1ObjectIdentifier)object5);
                        if (object != null) {
                            if (!object.toASN1Primitive().equals(object3)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object2.setBagAttribute((ASN1ObjectIdentifier)object5, (ASN1Encodable)object3);
                        }
                    }
                    if (((ASN1Primitive)object5).equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) {
                        object6 = ((DERBMPString)object3).getString();
                        continue;
                    }
                    if (!((ASN1Primitive)object5).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                    object7 = (ASN1OctetString)object3;
                }
            }
            this.chainCerts.put(new a(((Certificate)object8).getPublicKey()), (Certificate)object8);
            if (bl) {
                if (!this.keyCerts.isEmpty()) continue;
                object12 = new String(Hex.encode(this.createSubjectKeyId(((Certificate)object8).getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(object12, object8);
                this.keys.a((String)object12, this.keys.a("unmarked"));
                continue;
            }
            if (object7 != null) {
                object12 = new String(Hex.encode(object7.getOctets()));
                this.keyCerts.put(object12, object8);
            }
            if (object6 != null) {
                this.certs.a((String)object6, object8);
                continue;
            }
            this.certs.a(Integer.toString(i5), object8);
        }
    }

    private final int validateIterationCount(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        if (n2 < 0) {
            throw new IllegalStateException("negative iteration count found");
        }
        BigInteger bigInteger2 = Properties.asBigInteger(PKCS12_MAX_IT_COUNT_PROPERTY);
        if (bigInteger2 != null && bigInteger2.intValue() < n2) {
            throw new IllegalStateException("iteration count " + n2 + " greater than " + bigInteger2.intValue());
        }
        return n2;
    }

    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private final Set getUsedCertificateSet() {
        Object object;
        String string;
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.keys.a();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            for (int i2 = 0; i2 != ((Certificate[])object).length; ++i2) {
                hashSet.add(object[i2]);
            }
        }
        enumeration = this.certs.a();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            hashSet.add(object);
        }
        return hashSet;
    }

    private final byte[] calculatePbeMac(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n2, char[] cArray, boolean bl, byte[] byArray2) throws Exception {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        BaseMac baseMac = (BaseMac)bouncyCastleProvider.getService("Mac", aSN1ObjectIdentifier.getId()).newInstance(null);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        DDPKCS12KeyStoreProvider.baseMacinit().invoke((Object)baseMac, new PKCS12Key(cArray, bl), pBEParameterSpec);
        DDPKCS12KeyStoreProvider.baseMacUpdate().invoke((Object)baseMac, byArray2, 0, byArray2.length);
        return (byte[])DDPKCS12KeyStoreProvider.baseMacDoFinal().invoke((Object)baseMac, new Object[0]);
    }

    private static Method baseMacUpdate() throws NoSuchMethodException {
        if (updateMethod == null) {
            updateMethod = BaseMac.class.getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE);
            updateMethod.setAccessible(true);
        }
        return updateMethod;
    }

    private static Method baseMacDoFinal() throws NoSuchMethodException {
        if (doFinalMethod == null) {
            doFinalMethod = BaseMac.class.getDeclaredMethod("engineDoFinal", new Class[0]);
            doFinalMethod.setAccessible(true);
        }
        return doFinalMethod;
    }

    private static Method baseMacinit() throws NoSuchMethodException {
        if (initMethod == null) {
            initMethod = BaseMac.class.getDeclaredMethod("engineInit", Key.class, AlgorithmParameterSpec.class);
            initMethod.setAccessible(true);
        }
        return initMethod;
    }

    private static class b {
        private final Map a;

        b() {
            HashMap<ASN1ObjectIdentifier, Integer> hashMap = new HashMap<ASN1ObjectIdentifier, Integer>();
            hashMap.put(new ASN1ObjectIdentifier("1.2.840.113533.7.66.10"), Integers.valueOf(128));
            hashMap.put(PKCSObjectIdentifiers.des_EDE3_CBC, Integers.valueOf(192));
            hashMap.put(NISTObjectIdentifiers.id_aes128_CBC, Integers.valueOf(128));
            hashMap.put(NISTObjectIdentifiers.id_aes192_CBC, Integers.valueOf(192));
            hashMap.put(NISTObjectIdentifiers.id_aes256_CBC, Integers.valueOf(256));
            hashMap.put(NTTObjectIdentifiers.id_camellia128_cbc, Integers.valueOf(128));
            hashMap.put(NTTObjectIdentifiers.id_camellia192_cbc, Integers.valueOf(192));
            hashMap.put(NTTObjectIdentifiers.id_camellia256_cbc, Integers.valueOf(256));
            hashMap.put(CryptoProObjectIdentifiers.gostR28147_gcfb, Integers.valueOf(256));
            this.a = Collections.unmodifiableMap(hashMap);
        }

        public int a(AlgorithmIdentifier algorithmIdentifier) {
            Integer n2 = (Integer)this.a.get(algorithmIdentifier.getAlgorithm());
            if (n2 != null) {
                return n2;
            }
            return -1;
        }
    }

    private static class c {
        private Hashtable a = new Hashtable();
        private Hashtable b = new Hashtable();

        private c() {
        }

        public void a(String string, Object object) {
            String string2 = string == null ? null : Strings.toLowerCase(string);
            String string3 = (String)this.b.get(string2);
            if (string3 != null) {
                this.a.remove(string3);
            }
            this.b.put(string2, string);
            this.a.put(string, object);
        }

        public Enumeration a() {
            return this.a.keys();
        }

        public Object a(String string) {
            String string2 = (String)this.b.remove(string == null ? null : Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.a.remove(string2);
        }

        public Object b(String string) {
            String string2 = (String)this.b.get(string == null ? null : Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.a.get(string2);
        }

        public Enumeration b() {
            return this.a.elements();
        }
    }

    private class a {
        byte[] a;

        a(PublicKey publicKey) {
            this.a = DDPKCS12KeyStoreProvider.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        a(byte[] byArray) {
            this.a = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.a);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a a2 = (a)object;
            return Arrays.areEqual(this.a, a2.a);
        }
    }
}

