/*
 * Decompiled with CFR 0.152.
 */
package macromedia.db2util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.KeyRep;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

final class DDPBEKey
implements SecretKey {
    static final long serialVersionUID = -2234768909660948176L;
    private byte[] key;
    private String type;

    DDPBEKey(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        this.key = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            this.key[i2] = (byte)(cArray[i2] & 0x7F);
        }
        Arrays.fill(cArray, ' ');
        this.type = string;
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getAlgorithm() {
        return this.type;
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.type)) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private final Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

