/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.utils;

import coldfusion.cloud.aws.dynamodb.utils.DynamoDBApisName;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;

public class PMTUtilsForDynamoDB {
    private static final Log logger = LogFactory.getLog(PMTUtilsForDynamoDB.class);

    public static <T extends DynamoDbException> TagAttributeList catchErrorMetrics(T e, TagAttributeList tagAttributeList) {
        if (e == null || tagAttributeList == null || !Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics()) {
            return tagAttributeList;
        }
        String[] errorType = ((Object)e).getClass().getName().split("\\.");
        return tagAttributeList.addTagAttribute("StatusText", (Object)e.getMessage()).addTagAttribute("ERRORTYPE", (Object)errorType[errorType.length - 1]).addTagAttribute("status_code", (Object)"Failure").addTagAttribute("ClockSkewException", (Object)e.isClockSkewException()).addTagAttribute("ThrottlingException", (Object)e.isThrottlingException());
    }

    private static void updateSuccessHttpResponse(Map customizedResponseStruct, TagAttributeList tempAttributeList) {
        if (customizedResponseStruct == null) {
            return;
        }
        tempAttributeList.addTagAttribute("StatusText", (Object)((Map)customizedResponseStruct.get("HttpResponse")).get("StatusText").toString()).addTagAttribute("status_code", (Object)"Success");
    }

    public static TagAttributeList startDynamoDBMonitoring(DynamoDBApisName name, TagAttributeList tagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionStart((String)name.name(), null, (boolean)true);
            TagAttributeList temp = TagAttributeList.getInstance((TagAttributeList)tagAttributeList);
            return temp;
        }
        return null;
    }

    public static void endDynamoDBMonitoring(DynamoDBApisName name, TagAttributeList tempAttributeList, Map paramMap, Map customizedResponseStruct) {
        if (tempAttributeList == null) {
            return;
        }
        if (customizedResponseStruct != null) {
            PMTUtilsForDynamoDB.updateTagAttributeList(name, tempAttributeList, paramMap, customizedResponseStruct);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)name.name(), null, (List)TagAttributeList.getInstance((TagAttributeList)tempAttributeList).getTagAttributes(), (boolean)true);
    }

    private static void updateTagAttributeList(DynamoDBApisName name, TagAttributeList tempAttributeList, Map paramMap, Map customizedResponseStruct) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics()) {
                return;
            }
            switch (name) {
                case createTable: 
                case deleteTable: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("tableArn", ((Map)customizedResponseStruct.get("tableDescription")).get("tableArn"));
                    tempAttributeList.addTagAttribute("TableStatus", ((Map)customizedResponseStruct.get("tableDescription")).get("TableStatus"));
                    break;
                }
                case createGlobalTable: 
                case updateGlobalTable: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("GlobalTableName"));
                    tempAttributeList.addTagAttribute("tableArn", ((Map)customizedResponseStruct.get("GlobalTableDescription")).get("GlobalTableArn"));
                    tempAttributeList.addTagAttribute("TableStatus", ((Map)customizedResponseStruct.get("GlobalTableDescription")).get("GlobalTableStatus"));
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case createBackup: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("tableArn", ((Map)customizedResponseStruct.get("BackupDetails")).get("BackupArn"));
                    break;
                }
                case putItem: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ExpectedCount", (Object)((Map)paramMap.get("Item")).size());
                    tempAttributeList.addTagAttribute("ActualCount", (Object)((Map)customizedResponseStruct.get("attributes")).size());
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case updateItem: 
                case deleteItem: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ExpectedCount", (Object)((Struct)paramMap.get("Key")).size());
                    tempAttributeList.addTagAttribute("ActualCount", (Object)((Map)customizedResponseStruct.get("attributes")).size());
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case getItem: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ExpectedCount", (Object)String.valueOf(((Struct)paramMap.get("Key")).size()));
                    tempAttributeList.addTagAttribute("ActualCount", (Object)String.valueOf(((Map)customizedResponseStruct.get("Item")).size()));
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case batchGetItem: {
                    tempAttributeList.addTagAttribute("ActualCount", (Object)((Map)customizedResponseStruct.get("Responses")).size());
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case transactGetItems: {
                    tempAttributeList.addTagAttribute("TableName", ((Struct)((Struct)((ArrayList)paramMap.get("TransactItems")).get(0)).get((Object)"Get")).get((Object)"TableName"));
                    tempAttributeList.addTagAttribute("ActualCount", (Object)((ArrayList)customizedResponseStruct.get("responses")).size());
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case transactWriteItems: 
                case batchWriteItem: {
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case deleteBackup: 
                case describeLimits: 
                case listGlobalTables: 
                case listBackups: 
                case listTagsOfResource: 
                case tagResource: 
                case untagResource: 
                case describeEndpoints: {
                    break;
                }
                case query: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ActualCount", customizedResponseStruct.get("count"));
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case scan: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ActualCount", customizedResponseStruct.get("count"));
                    tempAttributeList.addTagAttribute("ExpectedCount", customizedResponseStruct.get("scannedCount"));
                    tempAttributeList.addTagAttribute("OperationType", (Object)"read");
                    break;
                }
                case updateTimeToLive: 
                case describeTable: 
                case describeTimeToLive: 
                case updateContinuousBackups: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    break;
                }
                case updateTable: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("TableName"));
                    tempAttributeList.addTagAttribute("ReadCapacityUnits", ((Map)paramMap.get("ProvisionedThroughput")).get("ReadCapacityUnits"));
                    tempAttributeList.addTagAttribute("WriteCapacityUnits", ((Map)paramMap.get("ProvisionedThroughput")).get("WriteCapacityUnits"));
                    tempAttributeList.addTagAttribute("TableStatus", ((Map)customizedResponseStruct.get("tableDescription")).get("TableStatus"));
                    tempAttributeList.addTagAttribute("OperationType", (Object)"write");
                    break;
                }
                case describeGlobalTable: {
                    tempAttributeList.addTagAttribute("TableName", paramMap.get("GlobalTableName"));
                    break;
                }
                case describeBackup: {
                    tempAttributeList.addTagAttribute("BackupArn", paramMap.get("BackupArn"));
                    break;
                }
                case describeGlobalTableSettings: {
                    tempAttributeList.addTagAttribute("GlobalTableName", paramMap.get("GlobalTableName"));
                    break;
                }
                case listTables: {
                    tempAttributeList.addTagAttribute("Count", (Object)((ArrayList)customizedResponseStruct.get("TableNames")).size());
                    break;
                }
                case restoreTableToPointInTime: {
                    tempAttributeList.addTagAttribute("SourceTableName", paramMap.get("SourceTableName"));
                    tempAttributeList.addTagAttribute("TargetTableName", paramMap.get("TargetTableName"));
                    break;
                }
                case restoreTableFromBackup: {
                    tempAttributeList.addTagAttribute("TargetTableName", paramMap.get("TargetTableName"));
                }
            }
            PMTUtilsForDynamoDB.updateSuccessHttpResponse(customizedResponseStruct, tempAttributeList);
        }
        catch (Exception e) {
            logger.info((Object)RB.getString(PMTUtilsForDynamoDB.class, (String)"Util.PmtMonitoringError"));
        }
    }
}

