/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.SAMLServiceImpl;
import coldfusion.saml.SamlBindings;
import coldfusion.saml.SpConfiguration;
import coldfusion.saml.util.Utils;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.KeystoreUtils;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.RandomStringUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SamlHelper {
    private static final String SAML_FOLDER_PREFIX = ServiceFactory.getSamlService().getRootDir() + File.separator + "lib" + File.separator + "saml" + File.separator;
    private static final String KEYSTORE_FILE_SUFFIX = ".p12";
    private static final String SP_ENTITYID = "ENTITYID";
    private static final String SP_ACSURL = "ACSURL";
    private static final String SP_ACSBINDING = "ACSBINDING";
    private static final String SP_SLOURL = "SLOURL";
    private static final String SP_SLOBINDING = "SLOBINDING";
    private static final String SP_SIGNREQUESTS = "SIGNREQUESTS";
    private static final String SP_WANTASSERTIONSSIGNED = "WANTASSERTIONSSIGNED";
    private static final String SP_LOGOUTRESPONSESIGNED = "LOGOUTRESPONSESIGNED";
    private static final String SP_SIGNKEYSTOREPATH = "SIGNKEYSTOREPATH";
    private static final String SP_SIGNKEYSTOREPASSWORD = "SIGNKEYSTOREPASSWORD";
    private static final String SP_SIGNKEYSTOREALIAS = "SIGNKEYSTOREALIAS";
    private static final String SP_STATESTORE = "REQUESTSTORE";
    private static final String SP_STRICT = "STRICT";
    private static final String SP_SIGNMETADATA = "SIGNMETADATA";
    private static final String SP_FILEPATH = "FILEPATH";
    private static final String SP_PREFIX = "CFGenerated_";
    private static final String BINDING_REDIRECT = "REDIRECT";

    public static Map generateSpStruct(Map inputStruct) {
        HashMap<String, Object> outputStruct = new HashMap<String, Object>();
        SpConfiguration config = (SpConfiguration)SamlHelper.generateDefaultSpMetadata(true, inputStruct, false).get("sp");
        if (config != null) {
            outputStruct.put(SP_ENTITYID, config.getEntityId());
            outputStruct.put(SP_ACSURL, config.getAcsUrl());
            outputStruct.put(SP_ACSBINDING, config.getAcsBinding());
            outputStruct.put(SP_SLOURL, config.getSloUrl());
            outputStruct.put(SP_SLOBINDING, config.getSloBinding());
            outputStruct.put(SP_SIGNMETADATA, config.isSignMetadata());
            outputStruct.put(SP_SIGNREQUESTS, config.isSignRequests());
            outputStruct.put(SP_WANTASSERTIONSSIGNED, config.isWantAssertionsSigned());
            outputStruct.put(SP_SIGNKEYSTOREPATH, config.getSignKeystorePath());
            outputStruct.put(SP_SIGNKEYSTOREPASSWORD, ServiceFactory.getSamlService().decryptPassword(config.getSignKeystorePassword()));
            outputStruct.put(SP_STATESTORE, config.getStateStore());
            return outputStruct;
        }
        return null;
    }

    public static Map generateDefaultSpMetadata(boolean addConfigToMap, Map inputStruct) {
        return SamlHelper.generateDefaultSpMetadata(addConfigToMap, inputStruct, true);
    }

    public static Map generateDefaultSpMetadata(boolean addConfigToMap, Map inputStruct, boolean resetUrls) {
        boolean hasInput;
        String randomName = SP_PREFIX + RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        SpConfiguration config = new SpConfiguration();
        config.setGenerated(addConfigToMap);
        boolean bl = hasInput = inputStruct != null;
        if (!hasInput || inputStruct.get(SP_ENTITYID) == null) {
            config.setEntityId("http://coldfusion.adobe.com/" + randomName);
        } else {
            config.setEntityId((String)inputStruct.get(SP_ENTITYID));
        }
        if (!hasInput || inputStruct.get(SP_ACSURL) == null) {
            config.setAcsUrl("http://localhost:8500/" + randomName + ".cfm");
        } else {
            config.setAcsUrl((String)inputStruct.get(SP_ACSURL));
        }
        if (resetUrls) {
            config.setAcsUrl(null);
        }
        if (!hasInput || inputStruct.get(SP_ACSBINDING) == null) {
            config.setAcsBinding(BINDING_REDIRECT);
        } else {
            config.setAcsBinding((String)inputStruct.get(SP_ACSBINDING));
        }
        if (!hasInput || inputStruct.get(SP_SLOURL) == null) {
            config.setSloUrl("http://localhost:8500/" + randomName + ".cfm");
        } else {
            config.setSloUrl((String)inputStruct.get(SP_SLOURL));
        }
        if (resetUrls) {
            config.setSloUrl(null);
        }
        if (!hasInput || inputStruct.get(SP_SLOBINDING) == null) {
            config.setSloBinding(BINDING_REDIRECT);
        } else {
            config.setSloBinding((String)inputStruct.get(SP_SLOBINDING));
        }
        if (!hasInput || inputStruct.get(SP_SIGNREQUESTS) == null) {
            config.setSignRequests(true);
        } else {
            config.setSignRequests(Boolean.valueOf((String)inputStruct.get(SP_SIGNREQUESTS)));
        }
        if (!hasInput || inputStruct.get(SP_WANTASSERTIONSSIGNED) == null) {
            config.setWantAssertionsSigned(true);
        } else {
            config.setWantAssertionsSigned(Boolean.valueOf((String)inputStruct.get(SP_WANTASSERTIONSSIGNED)));
        }
        if (!hasInput || inputStruct.get(SP_LOGOUTRESPONSESIGNED) == null) {
            config.setLogoutResponseSigned(true);
        } else {
            config.setLogoutResponseSigned(Boolean.valueOf((String)inputStruct.get(SP_LOGOUTRESPONSESIGNED)));
        }
        if (!hasInput || inputStruct.get(SP_SIGNMETADATA) == null) {
            config.setSignMetadata(false);
        } else {
            config.setSignMetadata(Boolean.valueOf((String)inputStruct.get(SP_SIGNMETADATA)));
        }
        if (!hasInput || inputStruct.get(SP_STATESTORE) == null) {
            config.setStateStore("");
        } else {
            config.setStateStore((String)inputStruct.get(SP_STATESTORE));
        }
        Map keystore = KeystoreUtils.generateSAMLSPMetadataKeyPair();
        if (keystore == null) {
            throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"GenerateKeyStoreError"));
        }
        String keystorePath = SamlHelper.writeKeystoreToFile(keystore);
        config.setSignKeystorePath(keystorePath);
        config.setSignKeystorePassword((String)keystore.get("keystorepassword"));
        config.setSignKeystoreAlias((String)keystore.get("keystorealias"));
        if (hasInput) {
            List<String> errors = SamlHelper.validateSpSettings(config);
            if (!errors.isEmpty()) {
                throw new SAMLServiceImpl.SpException(errors);
            }
            if (inputStruct.containsKey(SP_FILEPATH)) {
                SamlHelper.exportSpMetadata(config, (String)inputStruct.get(SP_FILEPATH));
            }
        }
        if (addConfigToMap) {
            ServiceFactory.getSamlService().addSpMetadata(randomName, (Object)config);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", randomName);
        m.put("sp", config);
        return m;
    }

    private static String writeKeystoreToFile(Map keystoreMap) {
        KeyStore keystore = (KeyStore)keystoreMap.get("keystore");
        String name = (String)keystoreMap.get("keystorename");
        String password = (String)keystoreMap.get("keystorepassword");
        FileOutputStream fos = null;
        if (keystore != null) {
            String filepath = SAML_FOLDER_PREFIX + name + KEYSTORE_FILE_SUFFIX;
            File file = new File(filepath);
            try {
                file.createNewFile();
            }
            catch (IOException e1) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"CreateFileError", (Object)filepath));
            }
            try {
                fos = new FileOutputStream(file);
                KeystoreUtils.writeKeystoreToFile((KeyStore)keystore, (OutputStream)fos, (char[])password.toCharArray());
            }
            catch (FileNotFoundException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"CreateFileError", (Object)filepath));
            }
            catch (KeyStoreException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"KeystoreToFileError"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"NoSuchAlgorithmException"));
            }
            catch (CertificateException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"CertificateException"));
            }
            catch (IOException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"KeystoreToFileError"));
            }
            finally {
                if (fos != null) {
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return filepath;
        }
        return null;
    }

    public static void exportSpMetadata(SpConfiguration config, String filepath) {
        Saml2Settings settings = SpConfiguration.spConfigToSamlSettings(config);
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)new File(filepath), (String)settings.getSPMetadata());
        }
        catch (IOException | CertificateEncodingException e) {
            throw new SAMLServiceImpl.SpMetadataException(RB.getString(SamlHelper.class, (String)"SPMetadataExportError"));
        }
    }

    public static List<String> validateIdpSettings(IdpConfiguration config) {
        List errors = null;
        if (!Utils.isEmpty(config.getMetadataUrl())) {
            try {
                Saml2Settings idpSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseRemoteXML((URL)new URL(config.getMetadataUrl()))).build();
                errors = idpSettings.checkIdPSettings();
            }
            catch (MalformedURLException e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataMalformedURL", (Object)config.getMetadataUrl()));
            }
            catch (Exception e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataURLFetchException", (Object)config.getMetadataUrl()));
            }
        } else if (!Utils.isEmpty(config.getMetadataFilePath()) || !Utils.isEmpty(config.getMetadataRaw())) {
            Document xmlDocument = null;
            try {
                xmlDocument = config.getMetadataRaw() != null ? Util.parseXML((InputSource)new InputSource(new StringReader(config.getMetadataRaw()))) : Util.parseXML((InputSource)new InputSource(new StringReader(FileUtils.readFile((String)config.getMetadataFilePath(), null))));
                Saml2Settings idpSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseXML((Document)xmlDocument)).build();
                errors = idpSettings.checkIdPSettings();
            }
            catch (ParserConfigurationException e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParserConfigError"));
            }
            catch (Exception e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParsingError"));
            }
        } else {
            String errorMsg;
            errors = new ArrayList();
            if (Utils.isEmpty(config.getEntityId())) {
                errorMsg = "idp_entityId_not_found";
                errors.add((String)errorMsg);
            }
            if (Utils.isEmpty(config.getSsoUrl())) {
                errorMsg = "idp_sso_url_invalid";
                errors.add((String)errorMsg);
            }
        }
        return errors;
    }

    public static List<String> validateSpSettings(SpConfiguration config) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.getEntityId() == null) {
            errors.add("entity_id");
        }
        if (config.getAcsUrl() == null) {
            errors.add("acs_url");
        } else {
            try {
                new URL(config.getAcsUrl());
            }
            catch (MalformedURLException e) {
                throw new SAMLServiceImpl.SpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"AcsUrlMalformed", (Object)config.getAcsUrl()));
            }
        }
        return errors;
    }

    public static IdpConfiguration createIdpConfigFromStruct(Map struct) {
        IdpConfiguration configuration = new IdpConfiguration();
        if (struct.containsKey("URL")) {
            configuration.setMetadataUrl((String)struct.get("URL"));
        } else if (struct.containsKey("FILE")) {
            configuration.setMetadataFilePath((String)struct.get("FILE"));
        } else if (struct.containsKey("RAWXML")) {
            configuration.setMetadataRaw((String)struct.get("RAWXML"));
        } else {
            if (struct.containsKey(SP_ENTITYID)) {
                configuration.setEntityId((String)struct.get(SP_ENTITYID));
            }
            if (struct.containsKey("SSOURL")) {
                configuration.setSsoUrl((String)struct.get("SSOURL"));
            }
            if (struct.containsKey("SSOBINDING")) {
                configuration.setSsoBinding((String)struct.get("SSOBINDING"));
            }
            if (struct.containsKey(SP_SLOURL)) {
                configuration.setSloUrl((String)struct.get(SP_SLOURL));
            }
            if (struct.containsKey(SP_SLOBINDING)) {
                configuration.setSloBinding((String)struct.get(SP_SLOBINDING));
            }
            if (struct.containsKey("LOGOUTRESPONSEURL")) {
                configuration.setLogoutResponseUrl((String)struct.get("LOGOUTRESPONSEURL"));
            }
            if (struct.containsKey(SP_SIGNREQUESTS)) {
                configuration.setSignRequests(Cast._boolean((CFBoolean)((CFBoolean)struct.get(SP_SIGNREQUESTS))));
            }
            if (struct.containsKey("ENCRYPTREQUESTS")) {
                configuration.setEncryptRequests(Cast._boolean((CFBoolean)((CFBoolean)struct.get("ENCRYPTREQUESTS"))));
            }
            if (struct.containsKey("SIGNCERTIFICATE")) {
                configuration.setSignCertificate((String)struct.get("SIGNCERTIFICATE"));
            }
            if (struct.containsKey("ENCRYPTCERTIFICATE")) {
                configuration.setEncryptCertificate((String)struct.get("ENCRYPTCERTIFICATE"));
            }
        }
        return configuration;
    }

    public static SpConfiguration createSpConfigFromStruct(Map struct) {
        SpConfiguration configuration = new SpConfiguration();
        if (struct.containsKey(SP_ENTITYID)) {
            configuration.setEntityId((String)struct.get(SP_ENTITYID));
        }
        if (struct.containsKey(SP_ACSURL)) {
            configuration.setAcsUrl((String)struct.get(SP_ACSURL));
        }
        if (struct.containsKey(SP_ACSBINDING)) {
            configuration.setAcsBinding((String)struct.get(SP_ACSBINDING));
        }
        if (struct.containsKey(SP_SLOURL)) {
            configuration.setSloUrl((String)struct.get(SP_SLOURL));
        }
        if (struct.containsKey(SP_SLOBINDING)) {
            configuration.setSloBinding((String)struct.get(SP_SLOBINDING));
        }
        if (struct.containsKey(SP_SIGNREQUESTS)) {
            configuration.setSignRequests(Cast._boolean(struct.get(SP_SIGNREQUESTS)));
        }
        if (struct.containsKey(SP_WANTASSERTIONSSIGNED)) {
            configuration.setWantAssertionsSigned(Cast._boolean(struct.get(SP_WANTASSERTIONSSIGNED)));
        }
        if (struct.containsKey(SP_LOGOUTRESPONSESIGNED)) {
            configuration.setLogoutResponseSigned(Cast._boolean(struct.get(SP_LOGOUTRESPONSESIGNED)));
        }
        if (struct.containsKey(SP_SIGNKEYSTOREPATH)) {
            configuration.setSignKeystorePath((String)struct.get(SP_SIGNKEYSTOREPATH));
        }
        if (struct.containsKey(SP_SIGNKEYSTOREPASSWORD)) {
            configuration.setSignKeystorePassword((String)struct.get(SP_SIGNKEYSTOREPASSWORD));
        }
        if (struct.containsKey(SP_SIGNKEYSTOREALIAS)) {
            configuration.setSignKeystoreAlias((String)struct.get(SP_SIGNKEYSTOREALIAS));
        }
        if (struct.containsKey(SP_STATESTORE)) {
            configuration.setStateStore((String)struct.get(SP_STATESTORE));
        }
        if (struct.containsKey(SP_STRICT)) {
            configuration.setStrict(Cast._boolean(struct.get(SP_STRICT)));
        }
        return configuration;
    }

    public static Map getStructFromAppScope(String providerType, String providerName) {
        ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
        if (appScope == null) {
            return null;
        }
        Map samlSettings = null;
        Map securitySettings = (Map)appScope.getApplicationSettingsMap().get("SECURITY");
        if (securitySettings != null) {
            switch (providerType) {
                case "IDP": {
                    samlSettings = (Map)securitySettings.get("SAMLSETTINGS");
                    if (samlSettings == null) break;
                    return SamlHelper.getProviderStruct((List)samlSettings.get("IDP"), providerName);
                }
                case "SP": {
                    samlSettings = (Map)securitySettings.get("SAMLSETTINGS");
                    if (samlSettings == null) break;
                    return SamlHelper.getProviderStruct((List)samlSettings.get("SP"), providerName);
                }
            }
        } else if (appScope.getApplicationPath().toLowerCase().endsWith(".cfm")) {
            samlSettings = (Map)appScope.getApplicationSettingsMap().get("SAMLSETTINGS");
            switch (providerType) {
                case "IDP": {
                    if (samlSettings == null) break;
                    return SamlHelper.getProviderStruct((List)samlSettings.get("IDP"), providerName);
                }
                case "SP": {
                    if (samlSettings == null) break;
                    return SamlHelper.getProviderStruct((List)samlSettings.get("SP"), providerName);
                }
            }
        }
        return null;
    }

    private static Map getProviderStruct(List providerList, String providerName) {
        Map map = null;
        if (providerList != null) {
            for (Object o : providerList) {
                String lProviderName;
                map = (Map)o;
                if (map == null || (lProviderName = (String)map.get("NAME")) == null || lProviderName.trim().length() != providerName.trim().length() || lProviderName.indexOf(providerName) != 0) continue;
                return map;
            }
        }
        return null;
    }

    public static Saml2Settings getSamlSettings(IdpConfiguration idpConfiguration, SpConfiguration spConfiguration) {
        LinkedHashMap<String, Object> settingsMap = new LinkedHashMap<String, Object>();
        Saml2Settings tempSettings = null;
        if (!Utils.isEmpty(idpConfiguration.getMetadataUrl())) {
            try {
                tempSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseRemoteXML((URL)new URL(idpConfiguration.getMetadataUrl()))).build();
            }
            catch (MalformedURLException e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataMalformedURL", (Object)idpConfiguration.getMetadataUrl()));
            }
            catch (Exception e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataURLFetchException", (Object)idpConfiguration.getMetadataUrl()));
            }
        } else if (!Utils.isEmpty(idpConfiguration.getMetadataFilePath()) || !Utils.isEmpty(idpConfiguration.getMetadataRaw())) {
            Object xmlDocument = null;
            try {
                xmlDocument = idpConfiguration.getMetadataRaw() != null ? Util.parseXML((InputSource)new InputSource(new StringReader(idpConfiguration.getMetadataRaw()))) : Util.parseXML((InputSource)new InputSource(new StringReader(FileUtils.readFile((String)idpConfiguration.getMetadataFilePath(), null))));
                tempSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseXML((Document)xmlDocument)).build();
            }
            catch (ParserConfigurationException e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParserConfigError"));
            }
            catch (Exception e) {
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"ParsingError"));
            }
        } else {
            if (!Utils.isEmpty(idpConfiguration.getEntityId())) {
                settingsMap.put("onelogin.saml2.idp.entityid", idpConfiguration.getEntityId());
            }
            if (!Utils.isEmpty(idpConfiguration.getSsoUrl())) {
                settingsMap.put("onelogin.saml2.idp.single_sign_on_service.url", idpConfiguration.getSsoUrl());
            }
            if (!Utils.isEmpty(idpConfiguration.getSsoBinding())) {
                switch (idpConfiguration.getSsoBinding().toUpperCase()) {
                    case "REDIRECT": {
                        settingsMap.put("onelogin.saml2.idp.single_sign_on_service.binding", SamlBindings.REDIRECT.toString());
                        break;
                    }
                    case "POST": {
                        settingsMap.put("onelogin.saml2.idp.single_sign_on_service.binding", SamlBindings.POST.toString());
                        break;
                    }
                    default: {
                        settingsMap.put("onelogin.saml2.idp.single_sign_on_service.binding", SamlBindings.REDIRECT.toString());
                        break;
                    }
                }
            } else {
                settingsMap.put("onelogin.saml2.idp.single_sign_on_service.binding", SamlBindings.REDIRECT.toString());
            }
            if (!Utils.isEmpty(idpConfiguration.getSloUrl())) {
                settingsMap.put("onelogin.saml2.idp.single_logout_service.url", idpConfiguration.getSloUrl());
            }
            if (!Utils.isEmpty(idpConfiguration.getSloBinding())) {
                switch (idpConfiguration.getSloBinding().toUpperCase()) {
                    case "REDIRECT": {
                        settingsMap.put("onelogin.saml2.idp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
                        break;
                    }
                    case "POST": {
                        settingsMap.put("onelogin.saml2.idp.single_logout_service.binding", SamlBindings.POST.toString());
                        break;
                    }
                    default: {
                        settingsMap.put("onelogin.saml2.idp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
                        break;
                    }
                }
            } else {
                settingsMap.put("onelogin.saml2.idp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
            }
            if (!Utils.isEmpty(idpConfiguration.getLogoutResponseUrl())) {
                settingsMap.put("onelogin.saml2.idp.single_logout_service.response.url", idpConfiguration.getLogoutResponseUrl());
            }
            settingsMap.put("onelogin.saml2.security.want_messages_signed", idpConfiguration.isSignRequests());
            if (idpConfiguration.isEncryptRequests() && idpConfiguration.isSignRequests()) {
                if (!Utils.isEmpty(idpConfiguration.getEncryptCertificate())) {
                    settingsMap.put("onelogin.saml2.idp.x509cert", SamlHelper.stringToCert(idpConfiguration.getEncryptCertificate()));
                }
                if (!Utils.isEmpty(idpConfiguration.getSignCertificate())) {
                    settingsMap.put("onelogin.saml2.idp.x509certMulti.0", SamlHelper.stringToCert(idpConfiguration.getSignCertificate()));
                }
            } else if (idpConfiguration.isEncryptRequests()) {
                if (!Utils.isEmpty(idpConfiguration.getEncryptCertificate())) {
                    settingsMap.put("onelogin.saml2.idp.x509cert", SamlHelper.stringToCert(idpConfiguration.getEncryptCertificate()));
                }
            } else if (idpConfiguration.isSignRequests() && !Utils.isEmpty(idpConfiguration.getSignCertificate())) {
                settingsMap.put("onelogin.saml2.idp.x509cert", SamlHelper.stringToCert(idpConfiguration.getSignCertificate()));
            }
        }
        if (tempSettings != null) {
            settingsMap.put("onelogin.saml2.idp.entityid", tempSettings.getIdpEntityId());
            settingsMap.put("onelogin.saml2.idp.single_sign_on_service.url", tempSettings.getIdpSingleSignOnServiceUrl());
            settingsMap.put("onelogin.saml2.idp.single_sign_on_service.binding", tempSettings.getIdpSingleSignOnServiceBinding());
            settingsMap.put("onelogin.saml2.idp.single_logout_service.url", tempSettings.getIdpSingleLogoutServiceUrl());
            settingsMap.put("onelogin.saml2.idp.single_logout_service.binding", tempSettings.getIdpSingleLogoutServiceBinding());
            settingsMap.put("onelogin.saml2.idp.single_logout_service.response.url", tempSettings.getIdpSingleLogoutServiceResponseUrl());
            settingsMap.put("onelogin.saml2.idp.x509cert", tempSettings.getIdpx509cert());
            Object certificates = tempSettings.getIdpx509certMulti();
            for (int i = 0; i < certificates.size(); ++i) {
                settingsMap.put("onelogin.saml2.idp.x509certMulti." + i, certificates.get(i));
            }
        }
        settingsMap.put("onelogin.saml2.strict", spConfiguration.isStrict());
        if (!Utils.isEmpty(spConfiguration.getEntityId())) {
            settingsMap.put("onelogin.saml2.sp.entityid", spConfiguration.getEntityId());
        }
        if (!Utils.isEmpty(spConfiguration.getAcsUrl())) {
            settingsMap.put("onelogin.saml2.sp.assertion_consumer_service.url", spConfiguration.getAcsUrl());
        }
        if (!Utils.isEmpty(spConfiguration.getAcsBinding())) {
            switch (spConfiguration.getAcsBinding().toUpperCase()) {
                case "REDIRECT": {
                    settingsMap.put("onelogin.saml2.sp.assertion_consumer_service.binding", SamlBindings.REDIRECT.toString());
                    break;
                }
                case "POST": {
                    settingsMap.put("onelogin.saml2.sp.assertion_consumer_service.binding", SamlBindings.POST.toString());
                    break;
                }
                default: {
                    settingsMap.put("onelogin.saml2.sp.assertion_consumer_service.binding", SamlBindings.REDIRECT.toString());
                    break;
                }
            }
        } else {
            settingsMap.put("onelogin.saml2.sp.assertion_consumer_service.binding", SamlBindings.REDIRECT.toString());
        }
        if (!Utils.isEmpty(spConfiguration.getSloUrl())) {
            settingsMap.put("onelogin.saml2.sp.single_logout_service.url", spConfiguration.getSloUrl());
        }
        if (!Utils.isEmpty(spConfiguration.getSloBinding())) {
            switch (spConfiguration.getSloBinding().toUpperCase()) {
                case "REDIRECT": {
                    settingsMap.put("onelogin.saml2.sp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
                    break;
                }
                case "POST": {
                    settingsMap.put("onelogin.saml2.sp.single_logout_service.binding", SamlBindings.POST.toString());
                    break;
                }
                default: {
                    settingsMap.put("onelogin.saml2.sp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
                    break;
                }
            }
        } else {
            settingsMap.put("onelogin.saml2.sp.single_logout_service.binding", SamlBindings.REDIRECT.toString());
        }
        if (spConfiguration.isSignRequests()) {
            settingsMap.put("onelogin.saml2.security.authnrequest_signed", spConfiguration.isSignRequests());
            settingsMap.put("onelogin.saml2.security.logoutrequest_signed", spConfiguration.isSignRequests());
        }
        if (spConfiguration.isWantAssertionsSigned()) {
            settingsMap.put("onelogin.saml2.security.want_assertions_signed", spConfiguration.isWantAssertionsSigned());
        }
        if (spConfiguration.isLogoutResponseSigned()) {
            settingsMap.put("onelogin.saml2.security.logoutresponse_signed", spConfiguration.isLogoutResponseSigned());
        }
        if (spConfiguration.isSignMetadata()) {
            settingsMap.put("onelogin.saml2.security.sign_metadata", spConfiguration.isSignMetadata());
        }
        if (!Utils.isEmpty(spConfiguration.getSignKeystorePath())) {
            if (spConfiguration.getSignKeystorePath().trim().length() == 0 || !new File(spConfiguration.getSignKeystorePath()).exists()) {
                throw new SpConfiguration.KeystoreException(RB.getString(SpConfiguration.class, (String)"KeystoreNotFound", (Object)spConfiguration.getSignKeystorePath()));
            }
            KeystoreUtils.addBCProvider();
            KeyStore keystore = KeystoreUtils.getKeyStore((String)spConfiguration.getSignKeystorePath(), (String)spConfiguration.getSignKeystorePassword());
            KeystoreUtils.removeBCProvider();
            String alias = null;
            if (spConfiguration.getSignKeystoreAlias() == null || spConfiguration.getSignKeystoreAlias().trim().length() == 0) {
                try {
                    alias = KeystoreUtils.getKeyAlias((KeyStore)keystore);
                }
                catch (KeyStoreException e) {
                    throw new SpConfiguration.KeystoreException(RB.getString(SpConfiguration.class, (String)"AliasNotFound"));
                }
            } else {
                alias = spConfiguration.getSignKeystoreAlias();
            }
            Certificate[] chain = null;
            try {
                chain = keystore.getCertificateChain(alias);
            }
            catch (KeyStoreException e1) {
                throw new SpConfiguration.KeystoreException(RB.getString(SpConfiguration.class, (String)"CertificateError"));
            }
            if (chain == null || chain.length == 0) {
                throw new SpConfiguration.KeystoreException(RB.getString(SpConfiguration.class, (String)"NoCertificate"));
            }
            try {
                PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, spConfiguration.getSignKeystorePassword().toCharArray());
                settingsMap.put("onelogin.saml2.sp.privatekey", privateKey);
                settingsMap.put("onelogin.saml2.sp.x509cert", (X509Certificate)chain[0]);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new SpConfiguration.KeystoreException(RB.getString(SpConfiguration.class, (String)"KeyRetrieveError"));
            }
        }
        settingsMap.put("onelogin.saml2.unique_id_prefix", "COLDFUSION");
        return new SettingsBuilder().fromValues(settingsMap).build();
    }

    private static X509Certificate stringToCert(String cert) {
        byte[] decoded = Base64Encoder.decode((String)cert);
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
        }
        catch (CertificateException e) {
            throw new KeystoreUtils.CertificateException(RB.getString(SamlHelper.class, (String)"CertificateException"));
        }
    }

    public static boolean isSamlLogoutRequest() {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        return httpRequest.getParameter("SAMLRequest") != null;
    }

    public static boolean isSamlLogoutResponse() {
        HttpRequest httpRequest = ServletUtils.makeHttpRequest((HttpServletRequest)FusionContext.getCurrent().getRequest());
        return httpRequest.getParameter("SAMLResponse") != null;
    }

    public static Struct toSpStruct(SpConfiguration config) {
        Struct spStruct = new Struct();
        if (!Utils.isEmpty(config.getEntityId())) {
            spStruct.put((Object)SP_ENTITYID, (Object)config.getEntityId());
        }
        if (!Utils.isEmpty(config.getAcsUrl())) {
            spStruct.put((Object)SP_ACSURL, (Object)config.getAcsUrl());
        }
        if (!Utils.isEmpty(config.getAcsBinding())) {
            spStruct.put((Object)SP_ACSBINDING, (Object)config.getAcsBinding());
        }
        if (!Utils.isEmpty(config.getSloUrl())) {
            spStruct.put((Object)SP_SLOURL, (Object)config.getSloUrl());
        }
        if (!Utils.isEmpty(config.getSloBinding())) {
            spStruct.put((Object)SP_SLOBINDING, (Object)config.getSloBinding());
        }
        spStruct.put((Object)SP_SIGNREQUESTS, (Object)config.isSignRequests());
        spStruct.put((Object)SP_WANTASSERTIONSSIGNED, (Object)config.isWantAssertionsSigned());
        spStruct.put((Object)SP_LOGOUTRESPONSESIGNED, (Object)config.isLogoutResponseSigned());
        if (!Utils.isEmpty(config.getSignKeystorePath())) {
            spStruct.put((Object)SP_SIGNKEYSTOREPATH, (Object)config.getSignKeystorePath());
        }
        if (!Utils.isEmpty(config.getSignKeystorePassword())) {
            spStruct.put((Object)SP_SIGNKEYSTOREPASSWORD, (Object)config.getSignKeystorePassword());
        }
        if (!Utils.isEmpty(config.getSignKeystoreAlias())) {
            spStruct.put((Object)SP_SIGNKEYSTOREALIAS, (Object)config.getSignKeystoreAlias());
        }
        return spStruct;
    }

    public static Struct toIdpStruct(IdpConfiguration config) {
        Struct idpStruct = new Struct();
        if (!Utils.isEmpty(config.getMetadataUrl())) {
            idpStruct.put((Object)"URL", (Object)config.getMetadataUrl());
        } else if (!Utils.isEmpty(config.getMetadataRaw())) {
            idpStruct.put((Object)"RAWXML", (Object)config.getMetadataRaw());
        } else if (!Utils.isEmpty(config.getMetadataFilePath())) {
            idpStruct.put((Object)"FILE", (Object)config.getMetadataFilePath());
        } else {
            if (!Utils.isEmpty(config.getEntityId())) {
                idpStruct.put((Object)SP_ENTITYID, (Object)config.getEntityId());
            }
            if (!Utils.isEmpty(config.getSsoUrl())) {
                idpStruct.put((Object)"SSOURL", (Object)config.getSsoUrl());
            }
            if (!Utils.isEmpty(config.getSsoBinding())) {
                idpStruct.put((Object)"SSOBINDING", (Object)config.getSsoBinding());
            }
            if (!Utils.isEmpty(config.getSloUrl())) {
                idpStruct.put((Object)SP_SLOURL, (Object)config.getSloUrl());
            }
            if (!Utils.isEmpty(config.getSloBinding())) {
                idpStruct.put((Object)SP_SLOBINDING, (Object)config.getSloBinding());
            }
            if (!Utils.isEmpty(config.getLogoutResponseUrl())) {
                idpStruct.put((Object)"LOGOUTRESPONSEURL", (Object)config.getLogoutResponseUrl());
            }
            idpStruct.put((Object)SP_SIGNREQUESTS, (Object)config.isSignRequests());
            idpStruct.put((Object)"ENCRYPTREQUESTS", (Object)config.isEncryptRequests());
            if (!Utils.isEmpty(config.getSignCertificate())) {
                idpStruct.put((Object)"SIGNCERTIFICATE", (Object)config.getSignCertificate());
            }
            if (!Utils.isEmpty(config.getEncryptCertificate())) {
                idpStruct.put((Object)"ENCRYPTCERTIFICATE", (Object)config.getEncryptCertificate());
            }
        }
        return idpStruct;
    }

    public static void mergeSp(SpConfiguration oldConfig, SpConfiguration newConfig) {
        if (Utils.isEmpty(newConfig.getEntityId())) {
            newConfig.setEntityId(oldConfig.getEntityId());
        }
        if (Utils.isEmpty(newConfig.getDescription())) {
            newConfig.setDescription(oldConfig.getDescription());
        }
        if (Utils.isEmpty(newConfig.getAcsUrl())) {
            newConfig.setAcsUrl(oldConfig.getAcsUrl());
        }
        if (Utils.isEmpty(newConfig.getAcsBinding())) {
            newConfig.setAcsBinding(oldConfig.getAcsBinding());
        }
        if (Utils.isEmpty(newConfig.getSloUrl())) {
            newConfig.setSloUrl(oldConfig.getSloUrl());
        }
        if (Utils.isEmpty(newConfig.getSloBinding())) {
            newConfig.setSloBinding(oldConfig.getSloBinding());
        }
        if (Utils.isEmpty(newConfig.getSignKeystorePath())) {
            newConfig.setSignKeystorePath(oldConfig.getSignKeystorePath());
        }
        if (Utils.isEmpty(newConfig.getSignKeystorePassword())) {
            newConfig.setSignKeystorePassword(oldConfig.getSignKeystorePassword());
        }
        if (Utils.isEmpty(newConfig.getSignKeystoreAlias())) {
            newConfig.setSignKeystoreAlias(oldConfig.getSignKeystoreAlias());
        }
        if (oldConfig.isGenerated()) {
            newConfig.setGenerated(oldConfig.isGenerated());
        }
    }
}

