/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.filter.FusionContext;
import coldfusion.scheduling.CronTabEntry;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CronUtil {
    public static String getTriggername(String task2) {
        return "trigger_" + task2.toUpperCase();
    }

    public static String getFullGroupName(String group, String mode) {
        String appName = "";
        appName = "application".equalsIgnoreCase(mode) ? CronUtil.getApplicationName() : ("server".equalsIgnoreCase(mode) ? CronUtil.getServerName() : mode);
        String groupname = CronUtil.stringNullCheck(group) ? "DEFAULT" : group;
        return (appName + CronUtil.getTasknameDelimiter() + groupname).toUpperCase();
    }

    public static String getServerName() {
        return "serverscheduletask";
    }

    public static String getJobname(String task2) {
        return "job_" + task2.toUpperCase();
    }

    public static Date getMergedTime(Date adate, Date atime) {
        Date mergedDateTime;
        if (atime == null) {
            return adate;
        }
        try {
            Calendar ndate = Calendar.getInstance();
            Calendar dcal = Calendar.getInstance();
            dcal.setTime(adate);
            Calendar tcal = Calendar.getInstance();
            tcal.setTime(atime);
            ndate.set(2, dcal.get(2));
            ndate.set(5, dcal.get(5));
            ndate.set(1, dcal.get(1));
            ndate.set(10, tcal.get(10));
            ndate.set(12, tcal.get(12));
            ndate.set(13, tcal.get(13));
            ndate.set(14, tcal.get(14));
            ndate.set(9, tcal.get(9));
            mergedDateTime = ndate.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new CronTabEntry.SchedulingStartDateTimeException(adate, atime);
        }
        return mergedDateTime;
    }

    public static String getOverwriteFilename(String filename) {
        if (CronUtil.stringNullCheck(filename)) {
            throw new IllegalArgumentException("Filename can not be empty");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-dd-M-HH-mm-ss");
        String append = "_" + format.format(new Date()).toString();
        String[] splits = filename.split("\\.");
        int len = splits.length;
        String fname = "";
        for (int x = 0; x < len - 1; ++x) {
            fname = fname + splits[x] + ".";
        }
        if (fname.length() > 0) {
            fname = fname.substring(0, fname.length() - 1);
        }
        fname = fname + append;
        fname = len > 1 ? fname + "." + splits[len - 1] : filename + fname;
        return fname;
    }

    public static boolean stringNullCheck(String string) {
        return null == string || 0 == string.length();
    }

    public static String getApplicationName() {
        String appname = "";
        try {
            appname = FusionContext.getCurrent().getApplicationName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return appname;
    }

    public static String getTasknameDelimiter() {
        return "#$%^";
    }
}

