/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.scheduling.CronTabEntry;
import coldfusion.scheduling.PriorityComparator;
import coldfusion.scheduling.RunnableFactory;
import coldfusion.scheduling.ThreadPool;
import coldfusion.scheduling.ThreadPoolService;
import coldfusion.scheduling.task;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;

public class Scheduler
extends ThreadPoolService
implements RunnableFactory,
Runnable,
SchedulerService {
    private PriorityQueue _tasks;
    private final Object lock = new Object();
    private ThreadPool threadPool;
    private ArrayList shutDownObjects;

    public void stop() throws ServiceException {
        this.destroy();
    }

    public void restart() throws ServiceException {
        this.stop();
        this.start();
    }

    public void cancel(Runnable task2) {
        this._cancel(task2);
    }

    public void start() throws ServiceException {
        try {
            this.initTaskQueue();
            Runtime.getRuntime().addShutdownHook(new Thread(this));
            this.threadPool = new ThreadPool("scheduler", this);
            this.threadPool.setMaxThreads(this.getMaxHandlerThreads());
            this.threadPool.setActiveThreads(this.getActiveHandlerThreads());
            this.threadPool.setMinThreads(this.getMinHandlerThreads());
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private void initTaskQueue() {
        this.shutDownObjects = new ArrayList();
        this._tasks = new PriorityQueue(new PriorityComparator());
    }

    public void destroy() throws ServiceException {
        try {
            this.threadPool.shutdown();
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private void insert(Runnable r, long when) {
        this._tasks.add(new task(r, when));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable createRunnable() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            Runnable r = null;
            while (r == null) {
                task t;
                long now = System.currentTimeMillis();
                while (true) {
                    if (this._tasks.isEmpty()) {
                        this.lock.wait();
                    } else {
                        t = (task)this._tasks.peek();
                        long timeout = t.getWhen() - now;
                        if (timeout <= 0L) break;
                        this.lock.wait(timeout);
                    }
                    now = System.currentTimeMillis();
                }
                t = (task)this._tasks.poll();
                r = t.getRunnable();
            }
            return r;
        }
    }

    @Override
    public Runnable swapRunnable(Runnable r) throws InterruptedException {
        return null;
    }

    public void destroyRunnable(Runnable r) {
        if (r instanceof CronTabEntry) {
            CronTabEntry entry = (CronTabEntry)r;
            entry.log("Interrupt task " + entry.getTask() + " scheduled at " + entry.getStartDate() + " " + entry.getStartTime() + " " + entry.getEndDate() + " " + entry.getEndTime());
        }
    }

    @Override
    public void destroyRunnable(Runnable r, int reason) {
        this.destroyRunnable(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable r, long when) {
        Object object = this.lock;
        synchronized (object) {
            this.insert(r, when);
            this.lock.notify();
        }
    }

    public void scheduleFromNow(Runnable r, long when) {
        this.schedule(r, System.currentTimeMillis() + when);
    }

    public void scheduleForShutDown(Runnable object) {
        this.shutDownObjects.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _cancel(Runnable r) {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this._tasks.iterator();
            while (it.hasNext()) {
                task t = (task)it.next();
                if (!t.getRunnable().equals(r)) continue;
                it.remove();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump() {
        long now = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            for (task t : this._tasks) {
                if (t.getWhen() - now >= 0L) continue;
                System.out.println("Hold on! This one needs to run: " + t.getWhen() + " (due " + (t.getWhen() - now) + "ms from now) " + t.getRunnable().getClass().getName());
            }
        }
    }

    @Override
    public void run() {
        Iterator iter = this.shutDownObjects.iterator();
        while (iter.hasNext()) {
            ((Runnable)iter.next()).run();
        }
    }
}

