/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.Executor;
import coldfusion.cloud.VendorCredential;
import coldfusion.cloud.azure.AzureCredential;
import coldfusion.cloud.azure.ServiceBusKeyBasedCredential;
import coldfusion.cloud.azure.ServiceBusTokenBasedCredential;
import coldfusion.cloud.azure.servicebus.ServiceBusAPIException;
import coldfusion.cloud.azure.servicebus.ServiceBusClient;
import coldfusion.cloud.azure.servicebus.ServiceBusConfig;
import coldfusion.cloud.azure.servicebus.ServiceBusQueue;
import coldfusion.cloud.azure.servicebus.ServiceBusQueueImpl;
import coldfusion.cloud.azure.servicebus.ServiceBusSubscription;
import coldfusion.cloud.azure.servicebus.ServiceBusSubscriptionImpl;
import coldfusion.cloud.azure.servicebus.ServiceBusTopic;
import coldfusion.cloud.azure.servicebus.ServiceBusTopicImpl;
import coldfusion.cloud.azure.servicebus.metadata.SBChangeMessageStateMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBChangeMessageStateProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBGenerateTokenMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBGenerateTokenProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBMessageHandler;
import coldfusion.cloud.azure.servicebus.metadata.SBMessageHandlerMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBMessageHandlerProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBPeekMessageMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBPeekMessageProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBQueueMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBReceiveDeferredMessageMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBReceiveDeferredMessageProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBReceiveMessageMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBReceiveMessageProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBScheduleMessageMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBSendMessageMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBSubscriptionMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBSubscriptionProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBSubscriptionRuleMetadata;
import coldfusion.cloud.azure.servicebus.metadata.SBSubscriptionRuleProperties;
import coldfusion.cloud.azure.servicebus.metadata.SBTopicMetadata;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.microsoft.azure.servicebus.ClientFactory;
import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageReceiver;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.servicebus.MessageHandlerOptions;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.SubscriptionClient;
import com.microsoft.azure.servicebus.management.AccessRights;
import com.microsoft.azure.servicebus.management.AuthorizationRule;
import com.microsoft.azure.servicebus.management.EntityNameHelper;
import com.microsoft.azure.servicebus.management.ManagementClient;
import com.microsoft.azure.servicebus.management.QueueDescription;
import com.microsoft.azure.servicebus.management.QueueRuntimeInfo;
import com.microsoft.azure.servicebus.management.SharedAccessAuthorizationRule;
import com.microsoft.azure.servicebus.management.SubscriptionDescription;
import com.microsoft.azure.servicebus.management.SubscriptionRuntimeInfo;
import com.microsoft.azure.servicebus.management.TopicDescription;
import com.microsoft.azure.servicebus.management.TopicRuntimeInfo;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.rules.CorrelationFilter;
import com.microsoft.azure.servicebus.rules.FalseFilter;
import com.microsoft.azure.servicebus.rules.Filter;
import com.microsoft.azure.servicebus.rules.RuleAction;
import com.microsoft.azure.servicebus.rules.RuleDescription;
import com.microsoft.azure.servicebus.rules.SqlFilter;
import com.microsoft.azure.servicebus.rules.SqlRuleAction;
import com.microsoft.azure.servicebus.rules.TrueFilter;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SharedAccessSignatureTokenProvider;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.jsp.PageContext;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class ServiceBusClientImpl
implements ServiceBusClient,
NamedInvokable {
    private Logger logger = CFLogs.SERVER_LOG;
    String connectionString;
    ClientSettings clientSettings;
    ManagementClient managementClient;
    ConnectionStringBuilder builder;
    Map<String, IMessageSender> entityToSender;
    Map<String, IMessageReceiver> entityToPeekLockModeReceiver;
    Map<String, IMessageReceiver> entityToReceiveDeleteReceiver;
    Map<String, SubscriptionClient> subscriptionToPLModeClient;
    Map<String, SubscriptionClient> subscriptionToRDModeClient;
    Map<String, QueueClient> queueClientToPLModeReceiver;
    Map<String, QueueClient> queueClientToRDModeReceiver;
    private TagAttributeList tagAttributeList;
    private static InvokeNamedMethodInvocationMap<ServiceBusClientImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ServiceBusClientImpl(VendorCredential credential, ServiceBusConfig config) {
        if (credential instanceof AzureCredential) {
            this.connectionString = ((AzureCredential)credential).getConnectionString();
            this.builder = new ConnectionStringBuilder(this.connectionString);
        } else if (credential instanceof ServiceBusTokenBasedCredential) {
            ServiceBusTokenBasedCredential cred = (ServiceBusTokenBasedCredential)credential;
            this.builder = new ConnectionStringBuilder(URI.create(cred.getEndpoint()), cred.getEntityPath(), cred.getToken());
        } else if (credential instanceof ServiceBusKeyBasedCredential) {
            ServiceBusKeyBasedCredential cred = (ServiceBusKeyBasedCredential)credential;
            this.builder = new ConnectionStringBuilder(URI.create(cred.getEndpoint()), cred.getEntityPath(), cred.getSasKeyName(), cred.getSasKey());
        }
        if (config.getOperationTimeout() != null) {
            this.builder.setOperationTimeout(config.getOperationTimeout());
        }
        if (config.getRetryPolicy() != null) {
            this.builder.setRetryPolicy(config.getRetryPolicy());
        }
        this.managementClient = new ManagementClient(this.builder);
        this.entityToSender = new ConcurrentHashMap<String, IMessageSender>();
        this.entityToPeekLockModeReceiver = new ConcurrentHashMap<String, IMessageReceiver>();
        this.subscriptionToPLModeClient = new ConcurrentHashMap<String, SubscriptionClient>();
        this.subscriptionToRDModeClient = new ConcurrentHashMap<String, SubscriptionClient>();
        this.queueClientToPLModeReceiver = new ConcurrentHashMap<String, QueueClient>();
        this.queueClientToRDModeReceiver = new ConcurrentHashMap<String, QueueClient>();
        this.entityToReceiveDeleteReceiver = new ConcurrentHashMap<String, IMessageReceiver>();
        this.tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.SERVICE_BUS.name());
    }

    @Override
    public ServiceBusQueue createQueue(String queuePath) throws ServiceBusAPIException {
        ServiceBusQueueImpl serviceBusQueue;
        String methodName = "createQueue";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            QueueDescription description = this.managementClient.createQueue(queuePath);
            serviceBusQueue = new ServiceBusQueueImpl(this, description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CreateQueueError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"createQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : queue with path " + queuePath + " created."));
        return serviceBusQueue;
    }

    @Override
    public ServiceBusQueue createQueue(String queuePath, Map queueDescription) throws ServiceBusAPIException {
        ServiceBusQueueImpl serviceBusQueue;
        String methodName = "createQueue";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            QueueDescription description = new QueueDescription(queuePath);
            ValidatorFiller.INSTANCE.fillObject((Object)description, queueDescription, SBQueueMetadata.getInstance().getConsumerMap());
            QueueDescription response = this.managementClient.createQueue(description);
            serviceBusQueue = new ServiceBusQueueImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CreateQueueError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"createQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : queue with path " + queuePath + " created."));
        return serviceBusQueue;
    }

    @Override
    public ServiceBusQueue getQueue(String queuePath) throws ServiceBusAPIException {
        ServiceBusQueueImpl serviceBusQueue;
        String methodName = "getQueue";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            QueueDescription description = this.managementClient.getQueue(queuePath);
            serviceBusQueue = new ServiceBusQueueImpl(this, description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetQueueError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : queue with path " + queuePath + " created."));
        return serviceBusQueue;
    }

    @Override
    public ServiceBusQueue updateQueue(String queuePath, Map queueDescription) throws ServiceBusAPIException {
        ServiceBusQueueImpl serviceBusQueue;
        String methodName = "updateQueue";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            QueueDescription description = this.managementClient.getQueue(queuePath);
            ValidatorFiller.INSTANCE.fillObject((Object)description, queueDescription, SBQueueMetadata.getInstance().getConsumerMap());
            QueueDescription response = this.managementClient.updateQueue(description);
            serviceBusQueue = new ServiceBusQueueImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"UpdateQueueError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"updateQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : queue with path " + queuePath + " updated."));
        return serviceBusQueue;
    }

    @Override
    public ServiceBusSubscription updateSubscription(String topicPath, String subscriptionName, Map subscriptionDescription) throws ServiceBusAPIException {
        ServiceBusSubscriptionImpl subscription = null;
        String methodName = "updateSubscription";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            SBSubscriptionProperties properties = new SBSubscriptionProperties(this.managementClient.getSubscription(topicPath, subscriptionName));
            subscriptionDescription.put("subscriptionName", subscriptionName);
            ValidatorFiller.INSTANCE.fillObject((Object)properties, subscriptionDescription, SBSubscriptionMetadata.getInstance().getConsumerMap());
            SubscriptionDescription description = this.managementClient.updateSubscription(properties.getDescription());
            subscription = new ServiceBusSubscriptionImpl(this, properties.getSubscriptionName(), properties.getTopicPath(), description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"UpdateSubscriptionError", (Object)subscriptionName), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"updateSubscription", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : subscription with name " + subscriptionName + " updated."));
        return subscription;
    }

    @Override
    public Struct deleteQueue(String queuePath) throws ServiceBusAPIException {
        String methodName = "deleteQueue";
        RequestMonitorEventProcessor.onFunctionStart((String)methodName, (boolean)true);
        String statusCode = "Success";
        try {
            this.managementClient.deleteQueue(queuePath);
            this.entityToPeekLockModeReceiver.remove(queuePath);
            this.entityToReceiveDeleteReceiver.remove(queuePath);
            this.entityToSender.remove(queuePath);
            Struct res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            this.logger.debug((Object)("ServiceBus : queue with path " + queuePath + " deleted."));
            Struct struct = res;
            return struct;
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeleteQueueError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deleteQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
    }

    @Override
    public Struct sendMessageToQueue(String queuePath, Map message) throws ServiceBusAPIException {
        return this.sendMessage(queuePath, message, "queue");
    }

    @Override
    public Struct sendMessageToTopic(String topicPath, Map message) throws ServiceBusAPIException {
        return this.sendMessage(topicPath, message, "topic");
    }

    @Override
    public Struct sendMessage(String entityPath, Map message, String entityType) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"sendMessage", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageSender sender = this.getMessageSender(entityPath);
            Message msg = new Message();
            ValidatorFiller.INSTANCE.fillObject((Object)msg, message, SBSendMessageMetadata.getInstance().getConsumerMap());
            sender.send((IMessage)msg);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SendMessageError", (Object)entityPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"sendMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : message sent to " + entityPath + " successfully."));
        return res;
    }

    @Override
    public Struct sendMessageBatchToQueue(String queuePath, List<Map> messages) throws ServiceBusAPIException {
        return this.sendMessageBatch(queuePath, messages, "queue");
    }

    @Override
    public Struct sendMessageBatchToTopic(String topicPath, List<Map> messages) throws ServiceBusAPIException {
        return this.sendMessageBatch(topicPath, messages, "topic");
    }

    @Override
    public Struct sendMessageBatch(String entityPath, List<Map> messages, String entityType) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"sendMessageBatch", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageSender sender = this.getMessageSender(entityPath);
            ArrayList messageList = new ArrayList();
            messages.forEach(entry -> {
                Message message = new Message();
                ValidatorFiller.INSTANCE.fillObject((Object)message, entry, SBSendMessageMetadata.getInstance().getConsumerMap());
                messageList.add(message);
            });
            sender.sendBatch(messageList);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SendMessageBatchError", (Object)entityPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"sendMessageBatch", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : batch message sent to " + entityPath + " successfully."));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessageSender getMessageSender(String queuePath) throws InterruptedException, ExecutionException, ServiceBusException {
        if (this.entityToSender.get(queuePath) == null) {
            Map<String, IMessageSender> map = this.entityToSender;
            synchronized (map) {
                if (this.entityToSender.get(queuePath) == null) {
                    MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder((ConnectionStringBuilder)this.builder);
                    IMessageSender sender = ClientFactory.createMessageSenderFromEntityPath((MessagingFactory)factory, (String)queuePath);
                    this.entityToSender.put(queuePath, sender);
                }
            }
        }
        IMessageSender sender = this.entityToSender.get(queuePath);
        return sender;
    }

    @Override
    public Struct scheduleMessageToQueue(String queuePath, Map message) throws ServiceBusAPIException {
        return this.scheduleMessage(queuePath, message, "queue");
    }

    @Override
    public Struct scheduleMessageToTopic(String topicPath, Map message) throws ServiceBusAPIException {
        return this.scheduleMessage(topicPath, message, "topic");
    }

    @Override
    public Struct scheduleMessage(String entityPath, Map message, String entityType) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"scheduleMessage", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageSender sender = this.getMessageSender(entityPath);
            Message msg = new Message();
            ValidatorFiller.INSTANCE.fillObject((Object)msg, message, SBScheduleMessageMetadata.getInstance().getConsumerMap());
            long sequenceNumber = sender.scheduleMessage((IMessage)msg, msg.getScheduledEnqueueTimeUtc());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            res.put((Object)"sequenceNumber", (Object)sequenceNumber);
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ScheduleMessageError", (Object)entityPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"scheduleMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : scheduleMessage operation for " + entityPath + " successful."));
        return res;
    }

    @Override
    public Struct cancelScheduledQueueMessage(String queuePath, long sequenceNumber) throws ServiceBusAPIException {
        return this.cancelScheduledMessage(queuePath, sequenceNumber, "queue");
    }

    @Override
    public Struct cancelScheduledTopicMessage(String topicPath, long sequenceNumber) throws ServiceBusAPIException {
        return this.cancelScheduledMessage(topicPath, sequenceNumber, "topic");
    }

    @Override
    public Struct cancelScheduledMessage(String entityPath, long sequenceNumber, String entityType) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"cancelScheduledMessage", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageSender sender = this.getMessageSender(entityPath);
            sender.cancelScheduledMessage(sequenceNumber);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CancelScheduleMessageError", (Object)entityPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"cancelScheduledMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : cancelScheduleMessage operation for " + entityPath + " successful."));
        return res;
    }

    @Override
    public Struct abandonMessage(String queuePath, Map message) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"abandonMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            receiver.abandon(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"AbandonMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"abandonMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : abandonMessage operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct deferMessage(String queuePath, Map message) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deferMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            receiver.defer(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeferMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deferMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : deferMessage operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct deadLetterMessage(String queuePath, Map message) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deadLetterMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            receiver.deadLetter(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeadLetterMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deadLetterMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : deadLetterMessage operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct completeMessage(String queuePath, Map message) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"completeMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            try {
                IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
                receiver.complete(properties.getLockToken());
            }
            catch (UnsupportedOperationException ex) {
                QueueClient client = this.getQueueClient(queuePath, null);
                client.complete(properties.getLockToken());
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CompleteMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"completeMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : completeMessage operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct receiveMessage(String queuePath, Map receiveMessageOptions) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"receiveMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBReceiveMessageProperties properties = new SBReceiveMessageProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, receiveMessageOptions, SBReceiveMessageMetadata.getInstance().getConsumerMap());
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, properties.getReceiveMode());
            Collection<Object> receivedMessages = new ArrayList<IMessage>();
            ArrayList structMessages = new ArrayList();
            if (properties.getMaxMessageCount() > 0) {
                receivedMessages = properties.getServerWaitTime() > 0 ? receiver.receiveBatch(properties.getMaxMessageCount(), Duration.ofSeconds(properties.getServerWaitTime())) : receiver.receiveBatch(properties.getMaxMessageCount());
            } else if (properties.getServerWaitTime() > 0) {
                receivedMessages.add(receiver.receive(Duration.ofSeconds(properties.getServerWaitTime())));
            } else {
                receivedMessages.add(receiver.receive());
            }
            res = this.messagesListToStructResponse(receivedMessages, structMessages);
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ReceiveMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"receiveMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : receiveMessage operation successful for " + queuePath + "."));
        return res;
    }

    private Struct messagesListToStructResponse(Collection receivedMessages, Collection structMessages) {
        if (receivedMessages != null) {
            receivedMessages.forEach(message -> structMessages.add(CloudDeserializationUtil.INSTANCE.beanToStruct(message)));
        }
        Struct response = new Struct();
        response.put((Object)"status_code", (Object)200);
        response.put((Object)"messages", (Object)structMessages);
        return response;
    }

    @Override
    public Struct receiveDeferredMessage(String queuePath, Map receiveDeferredMessageOptions) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"receiveDeferredMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBReceiveDeferredMessageProperties properties = new SBReceiveDeferredMessageProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, receiveDeferredMessageOptions, SBReceiveDeferredMessageMetadata.getInstance().getConsumerMap());
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            ArrayList<IMessage> receivedMessages = new ArrayList<IMessage>();
            ArrayList structMessages = new ArrayList();
            if (properties.getSequenceNumberList() == null) {
                receivedMessages.add(receiver.receiveDeferredMessage(properties.getSequenceNumber()));
            } else {
                receivedMessages.addAll(receiver.receiveDeferredMessageBatch(properties.getSequenceNumberList()));
            }
            res = this.messagesListToStructResponse(receivedMessages, structMessages);
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ReceiveDeferredMessageError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"receiveDeferredMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : receiveDeferredMessage operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct renewLockToken(String queuePath, String lockToken) throws ServiceBusAPIException {
        Struct response;
        RequestMonitorEventProcessor.onFunctionStart((String)"renewLockToken", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            Instant instant = receiver.renewMessageLock(UUID.fromString(lockToken));
            response = new Struct();
            response.put((Object)"status_code", (Object)200);
            response.put((Object)"newLockTime", (Object)FieldTypecastUtil.INSTANCE.getDateProperty((Object)instant));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"RenewLockTokenError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"renewLockToken", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : renewLockToken operation successful for " + queuePath + "."));
        return response;
    }

    @Override
    public Struct setPrefetchCount(String queuePath, int prefetchCount) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setPrefetchCount", (boolean)true);
        String statusCode = "Success";
        try {
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            if (receiver != null) {
                receiver.setPrefetchCount(prefetchCount);
            }
            if ((receiver = this.getMessageReceiver(queuePath, "RECEIVEANDDELETE")) != null) {
                receiver.setPrefetchCount(prefetchCount);
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SetPrefetchCountError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"setPrefetchCount", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : setPrefetchCount operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public Struct getPrefetchCount(String queuePath) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getPrefetchCount", (boolean)true);
        String statusCode = "Success";
        try {
            int prefetchCount = 0;
            IMessageReceiver receiver = this.getMessageReceiver(queuePath, null);
            if (receiver != null) {
                prefetchCount = receiver.getPrefetchCount();
            } else {
                receiver = this.getMessageReceiver(queuePath, "RECEIVEANDDELETE");
                if (receiver != null) {
                    prefetchCount = receiver.getPrefetchCount();
                }
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            res.put((Object)"prefetchCount", (Object)prefetchCount);
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetPrefetchCountError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getPrefetchCount", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getPrefetchCount operation successful for " + queuePath + "."));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessageReceiver getMessageReceiver(String queuePath, String receiveMode) throws InterruptedException, ServiceBusException, ExecutionException {
        IMessageReceiver receiver = null;
        if (receiveMode == null || "PEEKLOCK".equals(receiveMode)) {
            if (this.entityToPeekLockModeReceiver.get(queuePath) == null) {
                Map<String, IMessageReceiver> map = this.entityToPeekLockModeReceiver;
                synchronized (map) {
                    if (this.entityToPeekLockModeReceiver.get(queuePath) == null) {
                        MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder((ConnectionStringBuilder)this.builder);
                        IMessageReceiver messageReceiver = ClientFactory.createMessageReceiverFromEntityPath((MessagingFactory)factory, (String)queuePath, (ReceiveMode)ReceiveMode.PEEKLOCK);
                        this.entityToPeekLockModeReceiver.put(queuePath, messageReceiver);
                    }
                }
            }
            receiver = this.entityToPeekLockModeReceiver.get(queuePath);
        } else {
            if (this.entityToReceiveDeleteReceiver.get(queuePath) == null) {
                Map<String, IMessageReceiver> map = this.entityToReceiveDeleteReceiver;
                synchronized (map) {
                    if (this.entityToReceiveDeleteReceiver.get(queuePath) == null) {
                        MessagingFactory factory = MessagingFactory.createFromConnectionStringBuilder((ConnectionStringBuilder)this.builder);
                        IMessageReceiver messageReceiver = ClientFactory.createMessageReceiverFromEntityPath((MessagingFactory)factory, (String)queuePath, (ReceiveMode)ReceiveMode.RECEIVEANDDELETE);
                        this.entityToReceiveDeleteReceiver.put(queuePath, messageReceiver);
                    }
                }
            }
            receiver = this.entityToReceiveDeleteReceiver.get(queuePath);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueClient getQueueClient(String queuePath, String receiveMode) throws InterruptedException, ServiceBusException, ExecutionException {
        QueueClient client = null;
        ConnectionStringBuilder csBuilder = new ConnectionStringBuilder(this.builder.toString(), queuePath);
        if (receiveMode == null || "PEEKLOCK".equals(receiveMode)) {
            if (this.queueClientToPLModeReceiver.get(queuePath) == null) {
                Map<String, QueueClient> map = this.queueClientToPLModeReceiver;
                synchronized (map) {
                    if (this.queueClientToPLModeReceiver.get(queuePath) == null) {
                        client = new QueueClient(csBuilder, ReceiveMode.PEEKLOCK);
                        this.queueClientToPLModeReceiver.put(queuePath, client);
                    }
                }
            }
            client = this.queueClientToPLModeReceiver.get(queuePath);
        } else {
            if (this.queueClientToRDModeReceiver.get(queuePath) == null) {
                Map<String, QueueClient> map = this.queueClientToRDModeReceiver;
                synchronized (map) {
                    if (this.queueClientToRDModeReceiver.get(queuePath) == null) {
                        client = new QueueClient(csBuilder, ReceiveMode.RECEIVEANDDELETE);
                        this.queueClientToPLModeReceiver.put(queuePath, client);
                    }
                }
            }
            client = this.queueClientToRDModeReceiver.get(queuePath);
        }
        return client;
    }

    @Override
    public Struct listQueues() throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listQueues", (boolean)true);
        String statusCode = "Success";
        try {
            ArrayList queueList = new ArrayList();
            this.managementClient.getQueues().forEach(queue -> queueList.add(new ServiceBusQueueImpl(this, (QueueDescription)queue)));
            res = new Struct();
            res.put((Object)"queueList", queueList);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ListQueuesError"), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"listQueues", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : listQueues operation successful.");
        return res;
    }

    @Override
    public Struct listTopics() throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listTopics", (boolean)true);
        String statusCode = "Success";
        try {
            ArrayList topicList = new ArrayList();
            this.managementClient.getTopics().forEach(topic -> topicList.add(new ServiceBusTopicImpl(this, (TopicDescription)topic)));
            res = new Struct();
            res.put((Object)"topicList", topicList);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ListTopicsError"), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"listTopics", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : listTopics operation successful.");
        return res;
    }

    @Override
    public Struct listSubscriptions(String topicPath) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"listSubscriptions", (boolean)true);
        String statusCode = "Success";
        try {
            ArrayList subscriptions = new ArrayList();
            this.managementClient.getSubscriptions(topicPath).forEach(sub -> subscriptions.add(new ServiceBusSubscriptionImpl(this, sub.getSubscriptionName(), topicPath, (SubscriptionDescription)sub)));
            res = new Struct();
            res.put((Object)"subscriptionsList", subscriptions);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"ListSubsciptionsError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"listSubscriptions", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : listSubscriptions operation successful.");
        return res;
    }

    @Override
    public ServiceBusSubscription getSubscription(String topicPath, String subscriptionName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscription", (boolean)true);
        String statusCode = "Success";
        ServiceBusSubscriptionImpl res = null;
        try {
            SubscriptionDescription description = this.managementClient.getSubscription(topicPath, subscriptionName);
            res = new ServiceBusSubscriptionImpl(this, subscriptionName, topicPath, description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionError", (Object)topicPath, (Object)subscriptionName), ex);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscription", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        return res;
    }

    @Override
    public Struct getSubscriptionRuntimeInfo(String topicPath, String subscriptionName) throws ServiceBusAPIException {
        Struct res;
        if (topicPath == null || topicPath.length() == 0) {
            throw new IllegalArgumentException(RB.getString(ServiceBusClientImpl.class, (String)"NameStringLengthError", (Object)"topicPath", (Object)260));
        }
        if (subscriptionName == null || subscriptionName.length() == 0) {
            throw new IllegalArgumentException(RB.getString(ServiceBusClientImpl.class, (String)"NameStringLengthError", (Object)"subscriptionName", (Object)50));
        }
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionRuntimeInfo", (boolean)true);
        String statusCode = "Success";
        try {
            SubscriptionRuntimeInfo subscriptionRuntimeInfo = this.managementClient.getSubscriptionRuntimeInfo(topicPath, subscriptionName);
            res = CloudDeserializationUtil.INSTANCE.beanToStruct((Object)subscriptionRuntimeInfo);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionRuntimeInfoError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscriptionRuntimeInfo", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getSubscriptionRuntimeInfo operation successful for " + topicPath + "."));
        return res;
    }

    @Override
    public String getDeadletterQueuePath(String entityName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getDeadLetterQueue", (boolean)true);
        String result = EntityNameHelper.formatDeadLetterPath((String)entityName);
        RequestMonitorEventProcessor.onFunctionEnd((String)"getDeadLetterQueue", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).getTagAttributes(), (boolean)true);
        return result;
    }

    @Override
    public Struct peekMessageFromQueue(String queuePath, Map peekMessageOptions) throws ServiceBusAPIException {
        return this.peekMessage(queuePath, peekMessageOptions, "queue");
    }

    @Override
    public Struct peekMessageFromSubscription(String topicPath, String subscriptionName, Map peekMessageOptions) throws ServiceBusAPIException {
        return this.peekMessage(EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName), peekMessageOptions, "subscription");
    }

    @Override
    public Struct peekMessage(String entityPath, Map peekMessageOptions, String entityType) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"peekMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBPeekMessageProperties properties = new SBPeekMessageProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, peekMessageOptions, SBPeekMessageMetadata.getInstance().getConsumerMap());
            IMessageReceiver browser = this.getMessageReceiver(entityPath, null);
            ArrayList<IMessage> receivedMessages = new ArrayList<IMessage>();
            ArrayList structMessages = new ArrayList();
            if (properties.getMessageCount() != -1) {
                if (properties.getFromSequenceNumber() != -1L) {
                    receivedMessages.addAll(browser.peekBatch(properties.getFromSequenceNumber(), properties.getMessageCount()));
                } else {
                    receivedMessages.addAll(browser.peekBatch(properties.getMessageCount()));
                }
            } else if (properties.getFromSequenceNumber() != -1L) {
                receivedMessages.add(browser.peek(properties.getFromSequenceNumber()));
            } else {
                receivedMessages.add(browser.peek());
            }
            res = this.messagesListToStructResponse(receivedMessages, structMessages);
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"PeekMessageError", (Object)entityPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"peekMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : peekMessage operation successful for " + entityPath + "."));
        return res;
    }

    @Override
    public Struct getQueueRuntimeInfo(String queuePath) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getQueueRuntimeInfo", (boolean)true);
        String statusCode = "Success";
        try {
            QueueRuntimeInfo queueRuntimeInfo = this.managementClient.getQueueRuntimeInfo(queuePath);
            res = CloudDeserializationUtil.INSTANCE.beanToStruct((Object)queueRuntimeInfo);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetQueueRuntimeInfoError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getQueueRuntimeInfo", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getQueueRuntimeInfo operation successful for " + queuePath + "."));
        return res;
    }

    @Override
    public ServiceBusTopic createTopic(String topicPath) throws ServiceBusAPIException {
        ServiceBusTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createTopic", (boolean)true);
        String statusCode = "Success";
        try {
            TopicDescription response = this.managementClient.createTopic(topicPath);
            res = new ServiceBusTopicImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CreateTopicError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"createTopic", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : topic created " + topicPath + "."));
        return res;
    }

    @Override
    public ServiceBusTopic getTopic(String topicPath) throws ServiceBusAPIException {
        ServiceBusTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getTopic", (boolean)true);
        String statusCode = "Success";
        try {
            TopicDescription response = this.managementClient.getTopic(topicPath);
            res = new ServiceBusTopicImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetTopicError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getTopic", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getTopic operation successful for " + topicPath + "."));
        return res;
    }

    @Override
    public ServiceBusTopic createTopic(String topicPath, Map topicDescription) throws ServiceBusAPIException {
        ServiceBusTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"createTopic", (boolean)true);
        String statusCode = "Success";
        try {
            TopicDescription description = new TopicDescription(topicPath);
            ValidatorFiller.INSTANCE.fillObject((Object)description, topicDescription, SBTopicMetadata.getInstance().getConsumerMap());
            TopicDescription response = this.managementClient.createTopic(description);
            res = new ServiceBusTopicImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CreateTopicError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"createTopic", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : topic created with specified properties " + topicPath + "."));
        return res;
    }

    @Override
    public ServiceBusTopic updateTopic(String topicPath, Map topicDescription) throws ServiceBusAPIException {
        ServiceBusTopicImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"updateTopic", (boolean)true);
        String statusCode = "Success";
        try {
            TopicDescription description = this.managementClient.getTopic(topicPath);
            ValidatorFiller.INSTANCE.fillObject((Object)description, topicDescription, SBTopicMetadata.getInstance().getConsumerMap());
            TopicDescription response = this.managementClient.updateTopic(description);
            res = new ServiceBusTopicImpl(this, response);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"UpdateTopicError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"updateTopic", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : topic updated with speicified properties " + topicPath + "."));
        return res;
    }

    @Override
    public Struct deleteTopic(String topicPath) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteTopic", (boolean)true);
        String statusCode = "Success";
        try {
            this.managementClient.deleteTopic(topicPath);
            this.entityToSender.remove(topicPath);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeleteTopicError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deleteTopic", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : topic deleted " + topicPath + "."));
        return res;
    }

    @Override
    public Struct getTopicRuntimeInfo(String topicPath) throws ServiceBusAPIException {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getTopicRuntimeInfo", (boolean)true);
        String statusCode = "Success";
        try {
            TopicRuntimeInfo topicRuntimeInfo = this.managementClient.getTopicRuntimeInfo(topicPath);
            res = CloudDeserializationUtil.INSTANCE.beanToStruct((Object)topicRuntimeInfo);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetTopicRuntimeInfoError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getTopicRuntimeInfo", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getTopicRuntimeInfo operation successful for " + topicPath + "."));
        return res;
    }

    @Override
    public ServiceBusSubscription subscribe(String topicPath, Object subscription) throws ServiceBusAPIException {
        if (subscription instanceof String) {
            return this.subscribe(topicPath, Cast._String((Object)subscription), null, null);
        }
        if (subscription instanceof Map) {
            return this.subscribe(topicPath, Cast._Map((Object)subscription), null);
        }
        throw new IllegalArgumentException(RB.getString(ServiceBusClientImpl.class, (String)"SubscribeIllegalArgError"));
    }

    public ServiceBusSubscription subscribe(String topicPath, Map subscription, Object dummyParam) throws ServiceBusAPIException {
        ServiceBusSubscriptionImpl res;
        RequestMonitorEventProcessor.onFunctionStart((String)"subscribe", (boolean)true);
        String statusCode = "Success";
        SBSubscriptionProperties properties = new SBSubscriptionProperties();
        properties.setTopicPath(topicPath);
        ValidatorFiller.INSTANCE.fillObject((Object)properties, subscription, SBSubscriptionMetadata.getInstance().getConsumerMap());
        try {
            SubscriptionDescription description = this.managementClient.createSubscription(properties.getDescription());
            res = new ServiceBusSubscriptionImpl(this, properties.getSubscriptionName(), properties.getTopicPath(), description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SubscribeError"), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"subscribe", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : subscription created.");
        return res;
    }

    public ServiceBusSubscription subscribe(String topicPath, String subscriptionName, Object dummyParam, Object dummyParam2) throws ServiceBusAPIException {
        ServiceBusSubscriptionImpl res;
        if (topicPath == null || topicPath.length() == 0) {
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"NullValueNotAllowedException", (Object)"topicpath"), new NullPointerException());
        }
        if (subscriptionName == null || subscriptionName.length() == 0) {
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"NullValueNotAllowedException", (Object)"subscriptionname"), new NullPointerException());
        }
        RequestMonitorEventProcessor.onFunctionStart((String)"subscribe", (boolean)true);
        String statusCode = "Success";
        try {
            SubscriptionDescription description = this.managementClient.createSubscription(topicPath, subscriptionName);
            res = new ServiceBusSubscriptionImpl(this, subscriptionName, topicPath, description);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SubscribeError"), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"subscribe", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : subscription created.");
        return res;
    }

    @Override
    public Struct unsubscribe(String topicPath, String subscriptionName) throws ServiceBusAPIException {
        RequestMonitorEventProcessor.onFunctionStart((String)"unsubscribe", (boolean)true);
        String statusCode = "Success";
        try {
            this.managementClient.deleteSubscription(topicPath, subscriptionName);
            this.subscriptionToPLModeClient.remove(EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName));
            Struct res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            this.logger.debug((Object)"ServiceBus : subscription removed.");
            Struct struct = res;
            return struct;
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"UnsubscribeError", (Object)topicPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"unsubscribe", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionClient getSubscriptionClient(String susbcriptionId, String receiveMode) throws InterruptedException, ServiceBusException {
        SubscriptionClient subscriber = null;
        ConnectionStringBuilder subsrciptionConStrBuilder = new ConnectionStringBuilder(this.builder.toString(), susbcriptionId);
        if (receiveMode == null || "PEEKLOCK".equals(receiveMode)) {
            if (this.subscriptionToPLModeClient.get(susbcriptionId) == null) {
                Map<String, SubscriptionClient> map = this.subscriptionToPLModeClient;
                synchronized (map) {
                    if (this.subscriptionToPLModeClient.get(susbcriptionId) == null) {
                        SubscriptionClient messageSubscriber = new SubscriptionClient(subsrciptionConStrBuilder, ReceiveMode.PEEKLOCK);
                        this.subscriptionToPLModeClient.put(susbcriptionId, messageSubscriber);
                    }
                }
            }
            subscriber = this.subscriptionToPLModeClient.get(susbcriptionId);
        } else {
            if (this.subscriptionToRDModeClient.get(susbcriptionId) == null) {
                Map<String, SubscriptionClient> map = this.subscriptionToRDModeClient;
                synchronized (map) {
                    if (this.subscriptionToRDModeClient.get(susbcriptionId) == null) {
                        SubscriptionClient messageSubscriber = new SubscriptionClient(subsrciptionConStrBuilder, ReceiveMode.RECEIVEANDDELETE);
                        this.subscriptionToRDModeClient.put(susbcriptionId, messageSubscriber);
                    }
                }
            }
            subscriber = this.subscriptionToRDModeClient.get(susbcriptionId);
        }
        return subscriber;
    }

    @Override
    public Struct abandonSubscriptionMessage(String formattedSubscriptionPath, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"abandonSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.abandon(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"AbandonSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"abandonSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : abandonMessage operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct abandonSubscriptionMessage(String topicPath, String subscriptionName, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"abandonSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        String formattedSubscriptionPath = null;
        try {
            formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.abandon(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"AbandonSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"abandonSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : abandonMessage operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct deadLetterSubscriptionMessage(String formattedSubscriptionPath, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deadLetterSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.deadLetter(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeadLetterSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deadLetterSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : deadLetter operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct deadLetterSubscriptionMessage(String topicPath, String subscriptionName, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"deadLetterSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        String formattedSubscriptionPath = null;
        try {
            formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.deadLetter(properties.getLockToken(), properties.getPropertiesToModify());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"DeadLetterSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"deadLetterSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).addTagAttribute("topic", (Object)topicPath).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : deadLetter operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct completeSubscriptionMessage(String formattedSubscriptionPath, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"completeSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        try {
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.complete(properties.getLockToken());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CompleteSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"completeSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : completeMessage operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct completeSubscriptionMessage(String topicPath, String subscriptionName, Map message) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"completeSubscriptionMessage", (boolean)true);
        String statusCode = "Success";
        String formattedSubscriptionPath = null;
        try {
            formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
            SBChangeMessageStateProperties properties = new SBChangeMessageStateProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, message, SBChangeMessageStateMetadata.getInstance().getConsumerMap());
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.complete(properties.getLockToken());
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"CompleteSubscriptionMessageError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"completeSubscriptionMessage", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : completeMessage operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct setSubscriptionPrefetchCount(String formattedSubscriptionPath, int prefetchCount) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"setSubscriptionPrefetchCount", (boolean)true);
        String statusCode = "Success";
        try {
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            if (subscriptionClient != null) {
                subscriptionClient.setPrefetchCount(prefetchCount);
            }
            if ((subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, "RECEIVEANDDELETE")) != null) {
                subscriptionClient.setPrefetchCount(prefetchCount);
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"SetSubscriptionPrefetchCountError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"setSubscriptionPrefetchCount", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : setSubscriptionPrefetchCount operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct getSubscriptionPrefetchCount(String formattedSubscriptionPath) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionPrefetchCount", (boolean)true);
        String statusCode = "Success";
        try {
            int prefetchCount = 0;
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            if (subscriptionClient != null) {
                prefetchCount = subscriptionClient.getPrefetchCount();
            }
            if ((subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, "RECEIVEANDDELETE")) != null) {
                prefetchCount = subscriptionClient.getPrefetchCount();
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            res.put((Object)"prefetchCount", (Object)prefetchCount);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionPrefetchCountError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscriptionPrefetchCount", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getSubscriptionPrefetchCount operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct getSubscriptionPrefetchCount(String topicPath, String subscriptionName) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionPrefetchCount", (boolean)true);
        String statusCode = "Success";
        String formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
        try {
            int prefetchCount = 0;
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            if (subscriptionClient != null) {
                prefetchCount = subscriptionClient.getPrefetchCount();
            }
            if ((subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, "RECEIVEANDDELETE")) != null) {
                prefetchCount = subscriptionClient.getPrefetchCount();
            }
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            res.put((Object)"prefetchCount", (Object)prefetchCount);
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionPrefetchCountError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscriptionPrefetchCount", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getSubscriptionPrefetchCount operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct getSubscriptionRules(String formattedSubscriptionPath) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionRules", (boolean)true);
        String statusCode = "Success";
        try {
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            Collection rules = subscriptionClient.getRules();
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            if (rules != null) {
                ArrayList structRules = new ArrayList();
                rules.forEach(rule -> structRules.add(CloudDeserializationUtil.INSTANCE.beanToStruct(rule)));
                res.put((Object)"rules", structRules);
            }
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionRulesError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscriptionRules", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getSubscriptionRules operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct getSubscriptionRules(String topicPath, String subscriptionName) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"getSubscriptionRules", (boolean)true);
        String formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
        String statusCode = "Success";
        try {
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            Collection rules = subscriptionClient.getRules();
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
            if (rules != null) {
                ArrayList structRules = new ArrayList();
                rules.forEach(rule -> structRules.add(CloudDeserializationUtil.INSTANCE.beanToStruct(rule)));
                res.put((Object)"rules", structRules);
            }
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GetSubscriptionRulesError", (Object)formattedSubscriptionPath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getSubscriptionRules", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : getSubscriptionRules operation successful for " + formattedSubscriptionPath + "."));
        return res;
    }

    @Override
    public Struct addSubscriptionRule(String topicPath, String subscriptionName, Map rule) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"addSubscriptionRule", (boolean)true);
        String statusCode = "Success";
        try {
            String formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            RuleDescription ruleDescription = new RuleDescription();
            SBSubscriptionRuleProperties properties = new SBSubscriptionRuleProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, rule, SBSubscriptionRuleMetadata.getInstance().getConsumerMap());
            ruleDescription.setName(properties.getName());
            switch (properties.getType()) {
                case "true": {
                    ruleDescription.setFilter((Filter)new TrueFilter());
                    break;
                }
                case "false": {
                    ruleDescription.setFilter((Filter)new FalseFilter());
                    break;
                }
                case "sql": {
                    ruleDescription.setFilter((Filter)new SqlFilter(properties.getSqlFilterCondition()));
                    ruleDescription.setAction((RuleAction)new SqlRuleAction(properties.getSqlFilterAction()));
                    break;
                }
                case "correlation": {
                    CorrelationFilter filter = new CorrelationFilter();
                    filter.setLabel(properties.getLabel());
                    filter.setProperties(properties.getMessageProperties());
                    filter.setReplyTo(properties.getReplyTo());
                    filter.setTo(properties.getTo());
                    filter.setCorrelationId(properties.getCorrelationId());
                    filter.setMessageId(properties.getMessageId());
                    ruleDescription.setFilter((Filter)filter);
                }
            }
            subscriptionClient.addRule(ruleDescription);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"AddSubscriptionRuleError", (Object)subscriptionName), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"addSubscriptionRule", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : addSubscriptionRule operation successful for " + subscriptionName + "."));
        return res;
    }

    @Override
    public Struct removeSubscriptionRule(String topicPath, String subscriptionName, String ruleName) {
        Struct res;
        RequestMonitorEventProcessor.onFunctionStart((String)"removeSubscriptionRule", (boolean)true);
        String statusCode = "Success";
        try {
            String formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, null);
            subscriptionClient.removeRule(ruleName);
            res = new Struct();
            res.put((Object)"status_code", (Object)Integer.toString(200));
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"RemoveSubscriptionRuleError", (Object)subscriptionName), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"removeSubscriptionRule", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : removeSubscriptionRule operation successful for " + subscriptionName + "."));
        return res;
    }

    @Override
    public void registerMessageHandler(String topicPath, String subscriptionName, Map messageHandler) throws ServiceBusAPIException {
        RequestMonitorEventProcessor.onFunctionStart((String)"registerMessageHandler", (boolean)true);
        String statusCode = "Success";
        SBMessageHandlerProperties properties = new SBMessageHandlerProperties();
        ValidatorFiller.INSTANCE.fillObject((Object)properties, messageHandler, SBMessageHandlerMetadata.getInstance().getConsumerMap());
        String formattedSubscriptionPath = EntityNameHelper.formatSubscriptionPath((String)topicPath, (String)subscriptionName);
        try {
            SubscriptionClient subscriptionClient = this.getSubscriptionClient(formattedSubscriptionPath, properties.getReceiveMode());
            SBMessageHandler msgHandler = new SBMessageHandler(properties.getOnSuccess(), properties.getOnError(), FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, new ServiceBusSubscriptionImpl(this, subscriptionName, topicPath), RequestMonitorData.getCurrent());
            subscriptionClient.registerMessageHandler(msgHandler.getJavaMessageHandler(), new MessageHandlerOptions(properties.getMaxConcurrentCalls(), properties.isAutoComplete(), properties.getMaxAutoRenewDuration()), Executor.getInstance());
        }
        catch (ServiceBusException | InterruptedException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"RegisterMessageHandlerError", (Object)subscriptionName), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"registerMessageHandler", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("topic", (Object)topicPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : registerMessageHandler operation successful for " + subscriptionName + "."));
    }

    @Override
    public void registerMessageHandler(String queuePath, Map messageHandler) throws ServiceBusAPIException {
        RequestMonitorEventProcessor.onFunctionStart((String)"registerMessageHandler", (boolean)true);
        String statusCode = "Success";
        SBMessageHandlerProperties properties = new SBMessageHandlerProperties();
        ValidatorFiller.INSTANCE.fillObject((Object)properties, messageHandler, SBMessageHandlerMetadata.getInstance().getConsumerMap());
        try {
            QueueClient client = this.getQueueClient(queuePath, properties.getReceiveMode());
            SBMessageHandler msgHandler = new SBMessageHandler(properties.getOnSuccess(), properties.getOnError(), FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, new ServiceBusQueueImpl(this, this.managementClient.getQueue(queuePath)), RequestMonitorData.getCurrent());
            client.registerMessageHandler(msgHandler.getJavaMessageHandler(), new MessageHandlerOptions(properties.getMaxConcurrentCalls(), properties.isAutoComplete(), properties.getMaxAutoRenewDuration()), Executor.getInstance());
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"RegisterMessageHandlerError", (Object)queuePath), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"registerMessageHandler", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("queue", (Object)queuePath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)("ServiceBus : registerMessageHandler operation successful for " + queuePath + "."));
    }

    @Override
    public String generateSasToken(String entityPath, String entityType, Map sasRule) throws ServiceBusAPIException {
        RequestMonitorEventProcessor.onFunctionStart((String)"generateSasToken", (boolean)true);
        String statusCode = "Success";
        String token = null;
        try {
            SBGenerateTokenProperties properties = new SBGenerateTokenProperties();
            ValidatorFiller.INSTANCE.fillObject((Object)properties, sasRule, SBGenerateTokenMetadata.getInstance().getConsumerMap());
            SharedAccessAuthorizationRule rule = this.createSasRule(entityPath, entityType, properties.getAuthorizationRule());
            SharedAccessSignatureTokenProvider sasTokenProvider = new SharedAccessSignatureTokenProvider(rule.getKeyName(), rule.getPrimaryKey(), properties.getExpiryInSeconds().intValue());
            String tokenAudience = URI.create(properties.getEndpoint()).resolve(entityPath).toString();
            token = ((SecurityToken)sasTokenProvider.getSecurityTokenAsync(tokenAudience).get()).getTokenValue();
        }
        catch (ServiceBusException | InterruptedException | ExecutionException ex) {
            statusCode = "Failure";
            throw new ServiceBusAPIException(RB.getString(ServiceBusClientImpl.class, (String)"GenerateTokenError"), ex);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"generateSasToken", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute(entityType, (Object)entityPath).addTagAttribute("status_code", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
        this.logger.debug((Object)"ServiceBus : generateToken operation successful.");
        return token;
    }

    private SharedAccessAuthorizationRule createSasRule(String entityPath, String entityType, AuthorizationRule rule) throws InterruptedException, ServiceBusException {
        switch (entityType.toLowerCase()) {
            case "topic": {
                TopicDescription topicDescription = this.managementClient.getTopic(entityPath);
                topicDescription.setAuthorizationRules(Arrays.asList(rule));
                TopicDescription updatedTopicDescription = this.managementClient.updateTopic(topicDescription);
                return (SharedAccessAuthorizationRule)updatedTopicDescription.getAuthorizationRules().get(0);
            }
            case "queue": {
                QueueDescription queueDescription = this.managementClient.getQueue(entityPath);
                SharedAccessAuthorizationRule aRule = new SharedAccessAuthorizationRule("ruleWith", Arrays.asList(AccessRights.Manage, AccessRights.Listen, AccessRights.Send));
                queueDescription.setAuthorizationRules(Arrays.asList(aRule));
                QueueDescription updatedQueueDescription = this.managementClient.updateQueue(queueDescription);
                return (SharedAccessAuthorizationRule)updatedQueueDescription.getAuthorizationRules().get(0);
            }
        }
        return null;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"createQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath"}, args);
                    return obj.createQueue(Cast._String((Object)argColl.get((Object)"queuePath")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "queueDescription"}, args);
                    return obj.createQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"queueDescription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath"}, args);
                    return obj.getQueue(Cast._String((Object)argColl.get((Object)"queuePath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "queueDescription"}, args);
                    return obj.updateQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"queueDescription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "subscriptionDescription"}, args);
                    return obj.updateSubscription(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"subscriptionDescription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath"}, args);
                    return obj.deleteQueue(Cast._String((Object)argColl.get((Object)"queuePath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageToQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.sendMessageToQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageToQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageToTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "message"}, args);
                    return obj.sendMessageToTopic(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageToTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "message", "entityType"}, args);
                    return obj.sendMessage(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._Map((Object)argColl.get((Object)"message")), Cast._String((Object)argColl.get((Object)"entityType")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatchToQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "messages"}, args);
                    return obj.sendMessageBatchToQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatchToQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatchToTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "messages"}, args);
                    return obj.sendMessageBatchToTopic(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._List((Object)argColl.get((Object)"messages")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatchToTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sendMessageBatch", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "messages", "entityType"}, args);
                    return obj.sendMessageBatch(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._List((Object)argColl.get((Object)"messages")), Cast._String((Object)argColl.get((Object)"entityType")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sendMessageBatch", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"scheduleMessageToQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.scheduleMessageToQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("scheduleMessageToQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"scheduleMessageToTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "message"}, args);
                    return obj.scheduleMessageToTopic(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("scheduleMessageToTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"scheduleMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "message", "entityType"}, args);
                    return obj.scheduleMessage(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._Map((Object)argColl.get((Object)"message")), Cast._String((Object)argColl.get((Object)"entityType")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("scheduleMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cancelScheduledQueueMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "sequenceNumber"}, args);
                    return obj.cancelScheduledQueueMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._long((Object)argColl.get((Object)"sequenceNumber"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cancelScheduledQueueMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cancelScheduledTopicMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "sequenceNumber"}, args);
                    return obj.cancelScheduledTopicMessage(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._long((Object)argColl.get((Object)"sequenceNumber"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cancelScheduledTopicMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cancelScheduledMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "sequenceNumber", "entityType"}, args);
                    return obj.cancelScheduledMessage(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._long((Object)argColl.get((Object)"sequenceNumber"), (boolean)false), Cast._String((Object)argColl.get((Object)"entityType")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cancelScheduledMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"abandonMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.abandonMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("abandonMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deferMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.deferMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deferMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deadLetterMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.deadLetterMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deadLetterMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"completeMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "message"}, args);
                    return obj.completeMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("completeMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "receiveMessageOptions"}, args);
                    return obj.receiveMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"receiveMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"receiveDeferredMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "receiveDeferredMessageOptions"}, args);
                    return obj.receiveDeferredMessage(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"receiveDeferredMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("receiveDeferredMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"renewLockToken", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "lockToken"}, args);
                    return obj.renewLockToken(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._String((Object)argColl.get((Object)"lockToken")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("renewLockToken", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "prefetchCount"}, args);
                    return obj.setPrefetchCount(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._int((Object)argColl.get((Object)"prefetchCount"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath"}, args);
                    return obj.getPrefetchCount(Cast._String((Object)argColl.get((Object)"queuePath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listQueues", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listQueues();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listQueues", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listTopics", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listTopics();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listTopics", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listSubscriptions", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath"}, args);
                    return obj.listSubscriptions(Cast._String((Object)argColl.get((Object)"topicPath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listSubscriptions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName"}, args);
                    return obj.getSubscription(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionRuntimeInfo", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName"}, args);
                    return obj.getSubscriptionRuntimeInfo(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionRuntimeInfo", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getDeadletterQueuePath", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityName"}, args);
                    return obj.getDeadletterQueuePath(Cast._String((Object)argColl.get((Object)"entityName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDeadletterQueuePath", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"peekMessageFromQueue", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "peekMessageOptions"}, args);
                    return obj.peekMessageFromQueue(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"peekMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("peekMessageFromQueue", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"peekMessageFromSubscription", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "peekMessageOptions"}, args);
                    return obj.peekMessageFromSubscription(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"peekMessageOptions")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("peekMessageFromSubscription", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"peekMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "peekMessageOptions", "entityType"}, args);
                    return obj.peekMessage(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._Map((Object)argColl.get((Object)"peekMessageOptions")), Cast._String((Object)argColl.get((Object)"entityType")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("peekMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getQueueRuntimeInfo", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath"}, args);
                    return obj.getQueueRuntimeInfo(Cast._String((Object)argColl.get((Object)"queuePath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getQueueRuntimeInfo", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath"}, args);
                    return obj.createTopic(Cast._String((Object)argColl.get((Object)"topicPath")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "topicDescription"}, args);
                    return obj.createTopic(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._Map((Object)argColl.get((Object)"topicDescription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath"}, args);
                    return obj.getTopic(Cast._String((Object)argColl.get((Object)"topicPath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"updateTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "topicDescription"}, args);
                    return obj.updateTopic(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._Map((Object)argColl.get((Object)"topicDescription")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("updateTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteTopic", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath"}, args);
                    return obj.deleteTopic(Cast._String((Object)argColl.get((Object)"topicPath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteTopic", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTopicRuntimeInfo", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath"}, args);
                    return obj.getTopicRuntimeInfo(Cast._String((Object)argColl.get((Object)"topicPath")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTopicRuntimeInfo", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"subscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscription"}, args);
                    return obj.subscribe(Cast._String((Object)argColl.get((Object)"topicPath")), argColl.get((Object)"subscription"));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscription", "dummyParam"}, args);
                    return obj.subscribe(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._Map((Object)argColl.get((Object)"subscription")), argColl.get((Object)"dummyParam"));
                }
                case 4: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "dummyParam", "dummyParam2"}, args);
                    return obj.subscribe(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), argColl.get((Object)"dummyParam"), argColl.get((Object)"dummyParam2"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("subscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"unsubscribe", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName"}, args);
                    return obj.unsubscribe(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("unsubscribe", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"abandonSubscriptionMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath", "message"}, args);
                    return obj.abandonSubscriptionMessage(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "message"}, args);
                    return obj.abandonSubscriptionMessage(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("abandonSubscriptionMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deadLetterSubscriptionMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath", "message"}, args);
                    return obj.deadLetterSubscriptionMessage(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "message"}, args);
                    return obj.deadLetterSubscriptionMessage(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deadLetterSubscriptionMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"completeSubscriptionMessage", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath", "message"}, args);
                    return obj.completeSubscriptionMessage(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")), Cast._Map((Object)argColl.get((Object)"message")));
                }
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "message"}, args);
                    return obj.completeSubscriptionMessage(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"message")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("completeSubscriptionMessage", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setSubscriptionPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath", "prefetchCount"}, args);
                    return obj.setSubscriptionPrefetchCount(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")), Cast._int((Object)argColl.get((Object)"prefetchCount"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setSubscriptionPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionPrefetchCount", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath"}, args);
                    return obj.getSubscriptionPrefetchCount(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName"}, args);
                    return obj.getSubscriptionPrefetchCount(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionPrefetchCount", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSubscriptionRules", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"formattedSubscriptionPath"}, args);
                    return obj.getSubscriptionRules(Cast._String((Object)argColl.get((Object)"formattedSubscriptionPath")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName"}, args);
                    return obj.getSubscriptionRules(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSubscriptionRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addSubscriptionRule", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "rule"}, args);
                    return obj.addSubscriptionRule(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"rule")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addSubscriptionRule", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"removeSubscriptionRule", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "ruleName"}, args);
                    return obj.removeSubscriptionRule(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._String((Object)argColl.get((Object)"ruleName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("removeSubscriptionRule", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"registerMessageHandler", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"topicPath", "subscriptionName", "messageHandler"}, args);
                    obj.registerMessageHandler(Cast._String((Object)argColl.get((Object)"topicPath")), Cast._String((Object)argColl.get((Object)"subscriptionName")), Cast._Map((Object)argColl.get((Object)"messageHandler")));
                    return null;
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"queuePath", "messageHandler"}, args);
                    obj.registerMessageHandler(Cast._String((Object)argColl.get((Object)"queuePath")), Cast._Map((Object)argColl.get((Object)"messageHandler")));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("registerMessageHandler", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateSasToken", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 3: {
                    argColl = new ArgumentCollection((Object[])new String[]{"entityPath", "entityType", "sasRule"}, args);
                    return obj.generateSasToken(Cast._String((Object)argColl.get((Object)"entityPath")), Cast._String((Object)argColl.get((Object)"entityType")), Cast._Map((Object)argColl.get((Object)"sasRule")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateSasToken", obj);
        });
    }
}

