/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util.trackers;

import com.icesoft.util.trackers.AbstractTracker;
import com.icesoft.util.trackers.DefaultViewportStatus;
import com.icesoft.util.trackers.HTML4ViewportStatus;
import com.icesoft.util.trackers.PaintNap;
import com.icesoft.util.trackers.RenderDoneTrackerListener;
import com.icesoft.util.trackers.ViewportStatus;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class RenderDoneTracker
extends AbstractTracker {
    private String viewportId;
    private boolean sleepForPaint;
    private long startTime;
    protected Hashtable vps;

    public RenderDoneTracker(String viewportId) {
        this(viewportId, true);
    }

    public RenderDoneTracker(String viewportId, boolean sleepForPaint) {
        this.viewportId = viewportId;
        this.vps = new Hashtable();
        this.sleepForPaint = sleepForPaint;
    }

    private synchronized void reset() {
        this.startTime = 0L;
        this.vps.clear();
    }

    public void forceReset(int resolutionType, String msg) {
        this.reset();
        if (this.sleepForPaint) {
            PaintNap nap = new PaintNap(this, resolutionType, msg);
            Thread monitorThread = new Thread((Runnable)nap, "Paint nap");
            monitorThread.start();
        } else {
            this.notifyListeners(resolutionType, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        RenderDoneTracker renderDoneTracker = this;
        synchronized (renderDoneTracker) {
            Viewport v = (Viewport)e.getSource();
            String location = v.getLocation();
            String vid = v.getId();
            String name = e.getPropertyName();
            String val = "";
            if (e.getNewValue() instanceof String) {
                val = (String)e.getNewValue();
            }
            ViewportStatus status = (ViewportStatus)this.vps.get(vid);
            if (name.equals("contentLoading")) {
                if (val.equals("begin")) {
                    if (this.viewportId.equals(vid)) {
                        this.reset();
                        this.startTime = System.currentTimeMillis();
                    }
                    if (v.getPilot() != null) {
                        status = this.createViewportStatus(v);
                        this.vps.put(vid, status);
                    }
                }
                if (val.equals("error") && this.viewportId.equals(vid)) {
                    ContentLoader cl = (ContentLoader)e.getOldValue();
                    String errString = "ERROR encountered loading " + location + ": ";
                    errString = cl != null ? errString + cl.getException().toString() : errString + "Unknown error.";
                    this.forceReset(1, errString);
                    return;
                }
            }
            if (name.equals("pilotLoading") && val.equals("end") && this.vps.containsKey(vid)) {
                status = this.createViewportStatus(v);
                this.vps.put(vid, status);
            }
            if (status != null) {
                status.processEvent(e);
                if (this.allViewportsDone()) {
                    long endTime = System.currentTimeMillis();
                    String msg = "Load and render of " + location + " complete in " + (endTime - this.startTime) + " ms.";
                    this.forceReset(0, msg);
                }
            }
        }
    }

    private ViewportStatus createViewportStatus(Viewport v) {
        ViewportStatus status = v.getPilot() instanceof ThePilot ? new HTML4ViewportStatus() : new DefaultViewportStatus();
        return status;
    }

    private boolean allViewportsDone() {
        boolean allDone = true;
        if (this.vps.size() > 0) {
            Enumeration items = this.vps.elements();
            while (items.hasMoreElements()) {
                ViewportStatus item = (ViewportStatus)items.nextElement();
                if (item.isDone()) continue;
                allDone = false;
                break;
            }
        } else {
            allDone = false;
        }
        return allDone;
    }

    protected void paintNapDone() {
    }

    @Override
    public synchronized void notifyListeners(int resolutionType, String msg) {
        Enumeration crowd = this.trackerListeners.elements();
        while (crowd.hasMoreElements()) {
            RenderDoneTrackerListener listener = (RenderDoneTrackerListener)crowd.nextElement();
            listener.renderingDone(this.viewportId, resolutionType, msg);
        }
    }
}

