/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.PDFgErrorHandler;
import coldfusion.document.webkit.PDFgServiceManager;
import coldfusion.document.webkit.PDFgServiceManagerHelper;
import coldfusion.document.webkit.PDFgServiceManagerSetupException;
import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class HttpPDFRequestHandler {
    private static final String SERVICE_MANAGER_REGISTER = "SERVICE_MANAGER_REGISTER";
    private static final String SERVICE_MANAGER_UNREGISTER = "SERVICE_MANAGER_UNREGISTER";
    private static final String SERVICE_MANAGER_CONFIG_ERROR = "SERVICE_MANAGER_CONFIG_ERROR";
    private static final String CONVERSION_SUCCESS = "CONVERSION_SUCCESS";
    private static final String ACTION = "action";
    private static final String SERVERID = "serverid";
    private static final String AUTHTOKEN = "authtoken";
    private static final String REGISTER = "register";
    private static final String UNREGISTER = "unregister";
    private static final String CONVERT = "convert";
    private static final String CONVERSION_REQUEST = "conversionrequest";
    public static final String VERIFY = "verify";

    public static ByteArrayOutputStream requestPDFGeneration(PDFgServiceManager serviceManager, String conversionRequest) {
        if (serviceManager == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        String url = serviceManager.getURL();
        if (url == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        ByteArrayOutputStream byteOut = null;
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair(ACTION, CONVERT));
        nameValuePairs.add(new BasicNameValuePair(SERVERID, PDFgServiceManagerHelper.serverId));
        nameValuePairs.add(new BasicNameValuePair(AUTHTOKEN, serviceManager.getAuthToken()));
        nameValuePairs.add(new BasicNameValuePair(CONVERSION_REQUEST, conversionRequest));
        InputStream in = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                String errorMessage = statusLine.getReasonPhrase();
                PDFgErrorHandler.handleConversionError(statusCode, errorMessage, url, serviceManager);
            } else {
                CFLogs.SERVER_LOG.debug((Object)RB.getString(HttpPDFRequestHandler.class, (String)CONVERSION_SUCCESS));
                HttpEntity resEntity = response.getEntity();
                Header contentTypeHeader = resEntity.getContentType();
                String contentType = null;
                if (contentTypeHeader != null) {
                    contentType = contentTypeHeader.getValue();
                }
                if (contentType != null && contentType.equalsIgnoreCase("application/pdf") && (in = resEntity.getContent()) != null) {
                    byteOut = new ByteArrayOutputStream();
                    int bytesInBuf = 0;
                    byte[] buf = new byte[5120];
                    while ((bytesInBuf = in.read(buf)) != -1) {
                        byteOut.write(buf, 0, bytesInBuf);
                    }
                }
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            throw new PDFgErrorHandler.ServiceManagerRetryException(e.getMessage(), url);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            }
        }
        return byteOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] registerPDFgServiceManager(PDFgServiceManager serviceManager) {
        byte[] encryptedSessionId = null;
        if (serviceManager == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        String url = serviceManager.getURL();
        if (url == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
        post.setConfig(requestConfig);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair(ACTION, REGISTER));
        nameValuePairs.add(new BasicNameValuePair(SERVERID, PDFgServiceManagerHelper.serverId));
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                String reasonPhrase = statusLine.getReasonPhrase();
                PDFgErrorHandler.handleRegisterError(statusCode, reasonPhrase, url);
            } else {
                CFLogs.SERVER_LOG.info((Object)RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_REGISTER, (Object)url));
                HttpEntity resEntity = response.getEntity();
                in = resEntity.getContent();
                if (in != null) {
                    byteOut = new ByteArrayOutputStream();
                    int bytesInBuf = 0;
                    byte[] buf = new byte[16];
                    while ((bytesInBuf = in.read(buf)) != -1) {
                        byteOut.write(buf, 0, bytesInBuf);
                    }
                    encryptedSessionId = byteOut.toByteArray();
                }
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (byteOut != null) {
                    byteOut.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            }
        }
        return encryptedSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterPDFgServiceManager(PDFgServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        String url = serviceManager.getURL();
        if (url == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair(ACTION, UNREGISTER));
        nameValuePairs.add(new BasicNameValuePair(SERVERID, PDFgServiceManagerHelper.serverId));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                String reasonPhrase = statusLine.getReasonPhrase();
                PDFgErrorHandler.handleRegisterError(statusCode, reasonPhrase, url);
            } else {
                CFLogs.SERVER_LOG.info((Object)RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_UNREGISTER, (Object)url));
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            }
        }
    }

    public static boolean verifyPDFgServiceManager(PDFgServiceManager serviceManager) {
        boolean verified = false;
        if (serviceManager == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        String url = serviceManager.getURL();
        if (url == null) {
            throw new PDFgServiceManagerSetupException(RB.getString(HttpPDFRequestHandler.class, (String)SERVICE_MANAGER_CONFIG_ERROR));
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + VERIFY;
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                String reasonPhrase = statusLine.getReasonPhrase();
                PDFgErrorHandler.handleVerifyError(reasonPhrase, url);
            } else {
                verified = true;
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            throw new PDFgErrorHandler.ConnectionVerificationFailedException(e.getMessage());
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error((Object)(e.getMessage() + " " + url));
            }
        }
        return verified;
    }
}

