/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.Struct;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;

public class LifecycleExpirationConsumer
extends ConsumerMap<LifecycleExpiration.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static LifecycleExpirationConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LifecycleExpirationConsumer getInstance() {
        if (instance != null) return instance;
        Class<LifecycleExpirationConsumer> clazz = LifecycleExpirationConsumer.class;
        synchronized (LifecycleExpirationConsumer.class) {
            instance = new LifecycleExpirationConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LifecycleExpirationConsumer() {
        this.put("date", new ConsumerValidator((builder, value) -> builder.date(this.cast.getMidNightInstant(value)), Collections.emptyList()));
        this.put("days", new ConsumerValidator((builder, value) -> builder.days(Integer.valueOf(this.cast.getIntegerProperty(value))), Collections.emptyList()));
        this.put("expiredObjectDeleteMarker", new ConsumerValidator((builder, value) -> builder.expiredObjectDeleteMarker(this.cast.getBooleanProperty(value)), Collections.emptyList()));
    }

    public Struct getLifecycleExpirationStruct(LifecycleExpiration lifecycleExpiration) {
        Struct expiration = new Struct();
        Optional.ofNullable(lifecycleExpiration).ifPresent(lc -> {
            if (Objects.nonNull(lifecycleExpiration.days())) {
                expiration.put((Object)"days", (Object)lifecycleExpiration.days());
            }
            if (Objects.nonNull(lifecycleExpiration.date())) {
                expiration.put((Object)"date", (Object)lifecycleExpiration.date().toString());
            }
        });
        return expiration;
    }
}

