/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.test;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ClassShutterMethodTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectMethodHidden() throws Exception {
        Context context = Context.enter();
        try {
            ScriptableObject scriptableObject = context.initStandardObjects();
            context.setClassShutter((ClassShutter)new MethodShutter());
            context.evaluateString((Scriptable)scriptableObject, "var o = new java.lang.Object(); if ( typeof(o.toString) != 'undefined' ) { throw \"Object.toString not undefined\"; }", "test source", 1, null);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerivedMethodVisible() throws Exception {
        Context context = Context.enter();
        try {
            ScriptableObject scriptableObject = context.initStandardObjects();
            context.setClassShutter((ClassShutter)new MethodShutter());
            context.evaluateString((Scriptable)scriptableObject, "var o = new java.util.Vector(); if ( typeof(o.toString) == 'undefined' ) { throw \"Vector.toString is undefined\"; }", "test source", 1, null);
        }
        finally {
            Context.exit();
        }
    }

    static class MethodShutter
    implements ClassShutter {
        MethodShutter() {
        }

        public boolean visibleToScripts(String string) {
            return true;
        }

        public boolean visibleToScripts(Method method) {
            System.err.println("MethodSutter asked for: " + method.toGenericString());
            String string = method.getDeclaringClass().getCanonicalName();
            String string2 = method.getName();
            return !"toString".equals(string2) || !"java.lang.Object".equals(string);
        }
    }
}

