/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.xmp;

import com.adobe.internal.xmp.XMPDateTime;
import com.adobe.internal.xmp.XMPDateTimeFactory;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPPathFactory;
import com.adobe.internal.xmp.XMPUtils;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.adobe.internal.xmp.properties.XMPProperty;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.RichTextNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.content.BooleanValue;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.Base64;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UniCharIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.xerces.util.XMLChar;

public class XMPHelper {
    private static final String XMP_NS_DESC_URI = "http://ns.adobe.com/xfa/promoted-desc/";
    private static final String XMP_NS_DESC_PREFIX = "desc";
    public static final int OUTPUTTYPE_RDF = 0;
    private final String msDateTime;
    private final XMPMeta mXMP;
    private final boolean mbAllowTemplateUpdates;
    private final AppModel mAppModel;
    private String msCreatorToolValue;
    private String msProducerValue;
    private int miPart;
    private String msConformance;
    private String msAmendment;

    public static byte[] getXMPPacket(AppModel appModel) {
        String sXMPmeta = "xmpmeta";
        Element xmpPacket = (Element)appModel.resolveNode("xmpmeta");
        if (xmpPacket instanceof Element) {
            ByteArrayOutputStream originalXMP = new ByteArrayOutputStream();
            DOMSaveOptions saveOpts = new DOMSaveOptions();
            saveOpts.setDisplayFormat(0);
            saveOpts.setIndentLevel(0);
            saveOpts.setExcludePreamble(true);
            xmpPacket.saveXML(originalXMP, saveOpts);
            return originalXMP.toByteArray();
        }
        return null;
    }

    public XMPHelper(AppModel appModel, byte[] xmp, String sDateTime, boolean bAllowTemplateUpdates) throws XMPException {
        this.mAppModel = appModel;
        this.mXMP = xmp != null ? XMPMetaFactory.parseFromBuffer(xmp) : XMPMetaFactory.create();
        this.msDateTime = sDateTime;
        this.mbAllowTemplateUpdates = bAllowTemplateUpdates;
        this.miPart = 0;
        XMPMetaFactory.getSchemaRegistry().registerNamespace(XMP_NS_DESC_URI, XMP_NS_DESC_PREFIX);
    }

    private void createTextNode(String sXMPArrayName, int nIndex, TemplateModel templateModel, Element parentNode, Element descNode, String sXFAName) throws XMPException {
        XMPProperty value = this.mXMP.getArrayItem("http://purl.org/dc/elements/1.1/", sXMPArrayName, nIndex);
        if (value != null) {
            Element oNode = (Element)descNode.resolveNode("$." + sXFAName);
            if (oNode == null) {
                oNode = new TextValue(descNode, null);
                oNode.setName(sXFAName);
            }
            TextNode textNode = oNode.getText(false, false, false);
            textNode.setValue(value.toString(), true, false);
        }
    }

    private boolean useXMP() throws XMPException {
        TemplateModel templateModel = TemplateModel.getTemplateModel(this.mAppModel, false);
        if (templateModel == null) {
            return true;
        }
        Node desc = templateModel.resolveNode("$template.#subform.#desc");
        boolean bRetValue = true;
        if (desc != null) {
            String gsTimeStamp = "MetadataDate";
            XMPDateTime xmpTimeStamp = this.mXMP.getPropertyDate("http://ns.adobe.com/xap/1.0/", "MetadataDate");
            String sMetaDate = null;
            Attribute attr = this.mAppModel.getAttribute(XFA.TIMESTAMPTAG);
            if (attr != null) {
                sMetaDate = attr.toString();
            }
            if (xmpTimeStamp == null) {
                bRetValue = false;
            } else if (StringUtils.isEmpty(sMetaDate)) {
                bRetValue = true;
            } else {
                XMPDateTime xfaTimeStamp = XMPUtils.convertToDate(sMetaDate);
                bRetValue = xmpTimeStamp.getCalendar().after(xfaTimeStamp);
            }
        }
        return bRetValue;
    }

    public String metadata(int nOutputType) throws XMPException {
        if (nOutputType != 0) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "XMPHelper#metadata - PlainXMP");
        }
        this.synchronize(false);
        this.processOtherDesc();
        int optionsFlags = 16;
        SerializeOptions options = new SerializeOptions(optionsFlags);
        options.setIndent("   ");
        return XMPMetaFactory.serializeToString(this.mXMP, options);
    }

    public void processTemplateDesc() throws XMPException {
        String sUUId;
        Attribute oUUId;
        TemplateModel templateModel = TemplateModel.getTemplateModel(this.mAppModel, false);
        if (templateModel == null) {
            return;
        }
        XMPDateTime sXMPTimeStamp = StringUtils.isEmpty(this.msDateTime) ? XMPDateTimeFactory.getCurrentDateTime() : XMPDateTimeFactory.createFromISO8601(this.msDateTime);
        String gsTimeStamp = "MetadataDate";
        this.mXMP.setPropertyDate("http://ns.adobe.com/xap/1.0/", "MetadataDate", sXMPTimeStamp);
        if (this.msCreatorToolValue != null) {
            String gsCreatorTool = "CreatorTool";
            this.mXMP.setProperty("http://ns.adobe.com/xap/1.0/", "CreatorTool", this.msCreatorToolValue);
        }
        if (this.miPart != 0) {
            this.processPDFAVersionInfo();
        }
        if (this.msProducerValue != null) {
            String gsProducer = "Producer";
            this.mXMP.setProperty("http://ns.adobe.com/pdf/1.3/", "Producer", this.msProducerValue);
        }
        if ((oUUId = this.mAppModel.getAttribute(XFA.UUIDTAG)) != null && !StringUtils.isEmpty(sUUId = oUUId.toString())) {
            String gsDocumentID = "DocumentID";
            String gsUuid = "uuid:";
            String sDocumentIdValue = "uuid:" + sUUId;
            this.mXMP.setProperty("http://ns.adobe.com/xap/1.0/mm/", "DocumentID", sDocumentIdValue);
        }
        XMPUtils.removeProperties(this.mXMP, XMP_NS_DESC_URI, null, true, true);
        String gsDate = "date";
        String gsDescription = "description";
        String gsCreator = "creator";
        String gsTitle = "title";
        this.mXMP.deleteProperty("http://purl.org/dc/elements/1.1/", "date");
        this.mXMP.deleteProperty("http://purl.org/dc/elements/1.1/", "description");
        this.mXMP.deleteProperty("http://purl.org/dc/elements/1.1/", "creator");
        this.mXMP.deleteProperty("http://purl.org/dc/elements/1.1/", "title");
        Node desc = templateModel.resolveNode("$template.#subform.#desc");
        if (desc != null) {
            String gsElementRefinement = "element-refinement";
            String gsDCPrefix = "dc:";
            if (this.miPart == 0) {
                String sQualifierName;
                String sPath;
                String sCreated = "";
                String gsCreated = "created";
                Node oNode = desc.resolveNode("$.created");
                if (oNode instanceof TextValue) {
                    sCreated = ((TextValue)oNode).getValue();
                }
                String sIssued = "";
                String gsIssued = "issued";
                Node node = desc.resolveNode("$.issued");
                if (node instanceof TextValue) {
                    sIssued = ((TextValue)node).getValue();
                }
                if (!StringUtils.isEmpty(sCreated) || !StringUtils.isEmpty(sIssued)) {
                    this.mXMP.setProperty("http://purl.org/dc/elements/1.1/", "date", null, new PropertyOptions(1024));
                }
                int nIndex = 1;
                if (!StringUtils.isEmpty(sCreated)) {
                    this.mXMP.appendArrayItem("http://purl.org/dc/elements/1.1/", "date", sCreated);
                    sPath = "date[1]";
                    sQualifierName = "dc:created";
                    this.mXMP.setQualifier("http://purl.org/dc/elements/1.1/", "date[1]", "http://purl.org/dc/elements/1.1/", "element-refinement", "dc:created");
                    ++nIndex;
                }
                if (!StringUtils.isEmpty(sIssued)) {
                    this.mXMP.appendArrayItem("http://purl.org/dc/elements/1.1/", "date", sIssued);
                    sPath = XMPPathFactory.composeArrayItemPath("date", nIndex);
                    sQualifierName = "dc:issued";
                    this.mXMP.setQualifier("http://purl.org/dc/elements/1.1/", sPath, "http://purl.org/dc/elements/1.1/", "element-refinement", "dc:issued");
                }
            }
            String sDescription = "";
            Node node = desc.resolveNode("$.description");
            if (node instanceof TextValue) {
                sDescription = ((TextValue)node).getValue();
            }
            if (!StringUtils.isEmpty(sDescription)) {
                this.mXMP.setLocalizedText("http://purl.org/dc/elements/1.1/", "description", null, "x-default", sDescription);
            }
            String sCreator = null;
            node = desc.resolveNode("$.creator");
            if (node instanceof TextValue) {
                sCreator = ((TextValue)node).getValue();
            }
            if (!StringUtils.isEmpty(sCreator)) {
                this.mXMP.setProperty("http://purl.org/dc/elements/1.1/", "creator", null, new PropertyOptions(1024));
                this.mXMP.appendArrayItem("http://purl.org/dc/elements/1.1/", "creator", sCreator);
            }
            String sTitle = null;
            Node node2 = desc.resolveNode("$.title");
            if (node2 instanceof TextValue) {
                sTitle = ((TextValue)node2).getValue();
            }
            if (!StringUtils.isEmpty(sTitle)) {
                this.mXMP.setLocalizedText("http://purl.org/dc/elements/1.1/", "title", null, "x-default", sTitle);
            }
            this.processDesc(desc.getXFAParent());
        }
    }

    public void processOtherDesc() throws XMPException {
        TemplateModel templateModel = TemplateModel.getTemplateModel(this.mAppModel, false);
        if (templateModel == null) {
            return;
        }
        Node topSubForm = templateModel.resolveNode("$template.#subform");
        if (topSubForm == null) {
            return;
        }
        for (Node child = topSubForm.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() == XFA.DESCTAG) continue;
            this.metadata_helper(child);
        }
    }

    public void processXMP() throws XMPException {
        Element topSubForm;
        TemplateModel templateModel = TemplateModel.getTemplateModel(this.mAppModel, false);
        if (templateModel == null) {
            return;
        }
        String gsMetadataDate = "MetadataDate";
        String sXMPTimeStamp = this.mXMP.getPropertyString("http://ns.adobe.com/xap/1.0/", "MetadataDate");
        if (sXMPTimeStamp != null) {
            this.mAppModel.setAttribute(new StringAttr("timeStamp", sXMPTimeStamp), XFA.TIMESTAMPTAG);
        }
        String gsDocumentID = "DocumentID";
        String sUUId = "uuid:";
        String sDocumentIdValue = this.mXMP.getPropertyString("http://ns.adobe.com/xap/1.0/mm/", "DocumentID");
        if (sDocumentIdValue != null) {
            assert (sDocumentIdValue.startsWith("uuid:"));
            sDocumentIdValue = sDocumentIdValue.substring("uuid:".length());
            this.mAppModel.setAttribute(new StringAttr("uuid", sDocumentIdValue), XFA.UUIDTAG);
        }
        if ((topSubForm = (Element)templateModel.resolveNode("$template.#subform")) == null) {
            return;
        }
        Element desc = (Element)topSubForm.resolveNode("$.#desc");
        if (desc == null) {
            return;
        }
        String gsDate = "date";
        String gsCreated = "created";
        String gsIssued = "issued";
        String gsDescription = "description";
        String gsCreator = "creator";
        String gsTitle = "title";
        this.createTextNode("date", 1, templateModel, topSubForm, desc, "created");
        this.createTextNode("date", 2, templateModel, topSubForm, desc, "issued");
        this.createTextNode("description", 1, templateModel, topSubForm, desc, "description");
        this.createTextNode("creator", 1, templateModel, topSubForm, desc, "creator");
        this.createTextNode("title", 1, templateModel, topSubForm, desc, "title");
    }

    public void processDesc(Element element) throws XMPException {
        if (this.miPart != 0) {
            return;
        }
        Element desc = element.peekElement(XFA.DESCTAG, false, 0);
        if (desc != null) {
            for (Node child = desc.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                XMPDateTime dateValue;
                String sName;
                String aName = child.getName();
                if (aName == "") {
                    aName = element.getName();
                }
                if ((sName = XMPHelper.fixupName(aName)).equals("created") || sName.equals("issued") || sName.equals("description") || sName.equals("creator") || sName.equals("title") || this.mXMP.getProperty(XMP_NS_DESC_URI, sName) != null) continue;
                boolean bProcessedChild = false;
                boolean bEmbeddedImage = false;
                if (child instanceof TextValue) {
                    String sValue = ((TextValue)child).getValue();
                    this.mXMP.setProperty(XMP_NS_DESC_URI, sName, sValue);
                    bProcessedChild = true;
                } else if (child instanceof ExDataValue) {
                    ExDataValue exDataValue = (ExDataValue)child;
                    if (exDataValue.isPropertySpecified(XFA.HREFTAG, true, 0)) {
                        Attribute oHref = exDataValue.getAttribute(XFA.HREFTAG);
                        String sHref = oHref.toString();
                        this.mXMP.setProperty(XMP_NS_DESC_URI, sName, sHref, new PropertyOptions(2));
                        bProcessedChild = true;
                    } else {
                        Node node = exDataValue.getFirstXFAChild();
                        byte[] value = null;
                        if (node instanceof TextNode) {
                            try {
                                value = ((TextNode)node).getValue().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException ex) {}
                        } else if (node instanceof XMLMultiSelectNode || node instanceof RichTextNode) {
                            value = XMPHelper.getXML((Element)node);
                        }
                        String sBase64Encoded = Base64.encode(value, true);
                        String sHref = "data:;base64," + sBase64Encoded;
                        this.mXMP.setProperty(XMP_NS_DESC_URI, sName, sHref, new PropertyOptions(2));
                        String gsContentType = "contentType";
                        Attribute oContentType = ((Element)child).getAttribute(XFA.CONTENTTYPETAG);
                        String sContentTypeValue = oContentType.toString();
                        this.mXMP.setQualifier(XMP_NS_DESC_URI, sName, XMP_NS_DESC_URI, "contentType", sContentTypeValue);
                        bProcessedChild = true;
                    }
                } else if (child instanceof ImageValue) {
                    ImageValue imageValue = (ImageValue)child;
                    String sValue = imageValue.getValue();
                    if (child.isPropertySpecified(XFA.HREFTAG, true, 0)) {
                        this.mXMP.setProperty(XMP_NS_DESC_URI, sName, sValue, new PropertyOptions(2));
                    } else {
                        String sContentType = imageValue.getProperty(XFA.CONTENTTYPETAG, 0).toString();
                        String sTransferEncoding = imageValue.getProperty(XFA.TRANSFERENCODINGTAG, 0).toString();
                        this.setImageProperty(XMP_NS_DESC_URI, sName, sContentType, sTransferEncoding, sValue);
                        bEmbeddedImage = true;
                    }
                    bProcessedChild = true;
                } else if (child instanceof DecimalValue) {
                    double dValue = ((DecimalValue)child).getValue();
                    this.mXMP.setPropertyDouble(XMP_NS_DESC_URI, sName, dValue);
                    bProcessedChild = true;
                } else if (child instanceof FloatValue) {
                    double dValue = ((FloatValue)child).getValue();
                    this.mXMP.setPropertyDouble(XMP_NS_DESC_URI, sName, dValue);
                    bProcessedChild = true;
                } else if (child instanceof IntegerValue) {
                    int iValue = ((IntegerValue)child).getValue();
                    this.mXMP.setPropertyInteger(XMP_NS_DESC_URI, sName, iValue);
                    bProcessedChild = true;
                } else if (child instanceof DateValue) {
                    String sValue = ((DateValue)child).getValue();
                    dateValue = XMPDateTimeFactory.createFromISO8601(sValue);
                    this.mXMP.setPropertyDate(XMP_NS_DESC_URI, sName, dateValue);
                    bProcessedChild = true;
                } else if (child instanceof TimeValue) {
                    String sValue = ((TimeValue)child).getValue();
                    dateValue = XMPDateTimeFactory.createFromISO8601(sValue);
                    this.mXMP.setPropertyDate(XMP_NS_DESC_URI, sName, dateValue);
                    bProcessedChild = true;
                } else if (child instanceof DateTimeValue) {
                    String sValue = ((DateTimeValue)child).getValue();
                    dateValue = XMPDateTimeFactory.createFromISO8601(sValue);
                    this.mXMP.setPropertyDate(XMP_NS_DESC_URI, sName, dateValue);
                    bProcessedChild = true;
                } else if (child instanceof BooleanValue) {
                    boolean bValue = ((BooleanValue)child).getValue();
                    this.mXMP.setPropertyBoolean(XMP_NS_DESC_URI, sName, bValue);
                    bProcessedChild = true;
                }
                if (!bProcessedChild || bEmbeddedImage) continue;
                String gsRef = "ref";
                String sXPathValue = this.getXPATH(element);
                this.mXMP.setQualifier(XMP_NS_DESC_URI, sName, XMP_NS_DESC_URI, "ref", sXPathValue);
            }
        }
    }

    public String getXPATH(Element oNode) {
        HashMap<String, String> nameSpacePrefixList = new HashMap<String, String>();
        Model model = oNode.getModel();
        StringBuilder sXPATH = new StringBuilder(oNode.getXPath(nameSpacePrefixList, model));
        int nSlashPos = 0;
        int nColonPos = 0;
        int nLastPos = 0;
        while (nLastPos < sXPATH.length() && (nSlashPos = sXPATH.indexOf("/", nLastPos)) != -1) {
            nColonPos = sXPATH.indexOf(":", nSlashPos);
            if (nColonPos != -1) {
                sXPATH.replace(nSlashPos, nColonPos - nSlashPos + 1, "/");
            }
            nLastPos = nSlashPos + 1;
        }
        return "/template" + sXPATH;
    }

    public static String fixupName(String sName) {
        StringBuilder sRetValue = new StringBuilder(sName.length());
        UniCharIterator it = new UniCharIterator(sName);
        boolean bFirstChar = true;
        while (!it.isAtEnd()) {
            int ch = it.next();
            boolean valid = XMLChar.isNCName((int)ch);
            if (valid) {
                char c = (char)ch;
                if (bFirstChar) {
                    bFirstChar = false;
                    if (Character.isDigit(c) || c == '.' || c == '_' || c == '-') {
                        continue;
                    }
                } else {
                    valid = c != '.';
                }
            }
            sRetValue.append((char)(valid ? (int)ch : 95));
        }
        return sRetValue.toString();
    }

    public void synchronize(boolean bUpdateXMPPacket) throws XMPException {
        if (this.useXMP()) {
            if (this.msProducerValue != null) {
                String gsProducer = "Producer";
                this.mXMP.setProperty("http://ns.adobe.com/pdf/1.3/", "Producer", this.msProducerValue);
            }
            if (this.miPart != 0) {
                XMPUtils.removeProperties(this.mXMP, XMP_NS_DESC_URI, null, true, true);
                String gsDate = "date";
                this.mXMP.deleteProperty("http://purl.org/dc/elements/1.1/", "date");
                this.processPDFAVersionInfo();
            }
            if (this.mbAllowTemplateUpdates) {
                this.processXMP();
            }
        } else {
            this.processTemplateDesc();
            if (bUpdateXMPPacket) {
                SerializeOptions options = new SerializeOptions(16);
                options.setIndent("   ");
                byte[] buffer = XMPMetaFactory.serializeToBuffer(this.mXMP, options);
                this.saveXMPPacket(buffer);
            }
        }
    }

    private void saveXMPPacket(byte[] buffer) {
        String sXMPmeta = "xmpmeta";
        Element xmpPacket = (Element)this.mAppModel.resolveNode("xmpmeta");
        if (xmpPacket != null) {
            xmpPacket.loadXML((InputStream)new ByteArrayInputStream(buffer), true, true);
            TextNode textNode = new TextNode(null, null, "\n   ");
            xmpPacket.insertChild(textNode, xmpPacket.getFirstXMLChild(), false);
        }
    }

    public void setCreatorTool(String sCreatorTool, boolean bForceApply) throws XMPException {
        this.msCreatorToolValue = sCreatorTool;
        if (bForceApply && this.msCreatorToolValue != null) {
            String gsCreatorTool = "CreatorTool";
            this.mXMP.setProperty("http://ns.adobe.com/xap/1.0/", gsCreatorTool, this.msCreatorToolValue);
        }
    }

    public void setProducer(String sProducer, boolean bForceApply) throws XMPException {
        this.msProducerValue = sProducer;
        if (bForceApply && this.msProducerValue != null) {
            String gsProducer = "Producer";
            this.mXMP.setProperty("http://ns.adobe.com/pdf/1.3/", gsProducer, this.msProducerValue);
        }
    }

    public void putPDFAdata(int iPart, String sConformance, String sAmendment) {
        this.miPart = iPart;
        this.msConformance = sConformance;
        this.msAmendment = sAmendment;
    }

    private void metadata_helper(Node node) throws XMPException {
        Element element;
        if (node instanceof Element && (element = (Element)node).isSpecified(XFA.DESCTAG, true, 0)) {
            this.processDesc(element);
        }
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            this.metadata_helper(child);
        }
    }

    private void processPDFAVersionInfo() throws XMPException {
        String gsPart = "part";
        this.mXMP.setPropertyInteger("http://www.aiim.org/pdfa/ns/id/", "part", this.miPart);
        String gsConformance = "conformance";
        this.mXMP.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", this.msConformance);
        if (!StringUtils.isEmpty(this.msAmendment)) {
            String gsAmd = "amd";
            this.mXMP.setProperty("http://www.aiim.org/pdfa/ns/id/", "amd", this.msAmendment);
        }
    }

    private static byte[] getXML(Element element) {
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DOMSaveOptions options = new DOMSaveOptions();
        options.setExcludePreamble(true);
        element.saveXML(memStream, options);
        return memStream.toByteArray();
    }

    private boolean setImageProperty(String sPropNameSpace, String sPropName, String sImageContentType, String sImageEncoding, String sImageContents) throws XMPException {
        if (!sImageEncoding.equals("base64")) {
            return false;
        }
        String sAdjustedContentType = sImageContentType;
        if (sAdjustedContentType.startsWith("image/")) {
            sAdjustedContentType = sAdjustedContentType.substring("image/".length());
        }
        if (!sAdjustedContentType.equals("jpeg")) {
            return false;
        }
        this.mXMP.appendArrayItem("http://ns.adobe.com/xap/1.0/", "Thumbnails", new PropertyOptions(2048), null, new PropertyOptions(256));
        String itemPath = XMPPathFactory.composeArrayItemPath("Thumbnails", -1);
        this.mXMP.setStructField("http://ns.adobe.com/xap/1.0/", itemPath, "http://ns.adobe.com/xap/1.0/g/img/", "format", "JPEG");
        this.mXMP.setStructField("http://ns.adobe.com/xap/1.0/", itemPath, "http://ns.adobe.com/xap/1.0/g/img/", "image", sImageContents);
        return true;
    }

    public void addCustomInfo(String sName, String sValue) throws XMPException {
        assert (!StringUtils.isEmpty(sName));
        if (!StringUtils.isEmpty(sName)) {
            String sNonConstValue = sValue;
            this.mXMP.setProperty("http://ns.adobe.com/pdfx/1.3/", sName, sNonConstValue);
        }
    }

    public String getCustomInfo(String sPropName) throws XMPException {
        assert (!StringUtils.isEmpty(sPropName));
        if (!StringUtils.isEmpty(sPropName)) {
            return this.mXMP.getProperty("http://ns.adobe.com/pdfx/1.3/", sPropName).toString();
        }
        return null;
    }
}

