/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.GraphemeBreakIterator;
import com.adobe.xfa.text.IteratorData;
import com.adobe.xfa.text.TextBreakIterator;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextCharPropIterator;

class WordBreakIterator
extends TextBreakIterator {
    private final GraphemeBreakIterator moGraphemeIterator;
    private final IteratorData moData = new IteratorData();
    private IteratorData moPrevData = new IteratorData();
    private boolean mbPrev;
    private static final int WB_NO = 0;
    private static final int WB_YES = 1;
    private static final int WB_1ST = 2;
    private static final int WB_MID = 3;
    static final int[][] gbWordBreak = new int[][]{{0, 1, 0, 2, 1, 3, 1, 1}, {1, 1, 1, 2, 1, 1, 1, 1}, {0, 1, 0, 2, 0, 1, 1, 0}, {1, 1, 1, 2, 1, 1, 1, 1}, {1, 1, 0, 2, 0, 1, 1, 1}, {1, 1, 1, 2, 1, 1, 1, 1}, {1, 1, 1, 2, 1, 1, 1, 1}, {0, 1, 0, 2, 1, 1, 3, 1}};

    public WordBreakIterator(TextCharPropIterator poTextCharPropIterator) {
        this.moGraphemeIterator = new GraphemeBreakIterator(poTextCharPropIterator);
        this.mbPrev = false;
        this.doFirst();
    }

    @Override
    public int first() {
        return this.doFirst();
    }

    @Override
    public int next() {
        if (this.mbPrev ? this.moPrevData.mbEnd : this.moData.mbEnd) {
            return Integer.MAX_VALUE;
        }
        block6: while (true) {
            int eNextData;
            int ePrevData;
            int nTestIndex = this.moData.mnCharIndex;
            if (this.mbPrev) {
                ePrevData = this.moPrevData.mePrevData;
                eNextData = this.moData.mePrevData;
                this.mbPrev = false;
            } else {
                ePrevData = this.moData.mePrevData;
                eNextData = this.moData.next(this.moGraphemeIterator);
            }
            if (this.moData.mbEnd) {
                return nTestIndex;
            }
            int nPrevIndex = TextCharProp.wordToIndex(ePrevData);
            int nNextIndex = TextCharProp.wordToIndex(eNextData);
            switch (gbWordBreak[nPrevIndex][nNextIndex]) {
                case 0: {
                    this.moData.mePrevData = eNextData;
                    break;
                }
                case 1: {
                    return nTestIndex;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.moPrevData = this.moData;
                    this.moData.mePrevData = eNextData;
                    eNextData = this.moData.next(this.moGraphemeIterator);
                    if (!this.moData.mbEnd && TextCharProp.getWordClass(eNextData) == TextCharProp.getWordClass(this.moPrevData.mePrevData)) continue block6;
                    return nTestIndex;
                }
            }
        }
    }

    private int doFirst() {
        int nIndex;
        this.moData.mnCharIndex = nIndex = this.moGraphemeIterator.first();
        this.moData.mePrevData = this.moData.next(this.moGraphemeIterator);
        return nIndex;
    }
}

