/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.BasicFormatter;
import com.adobe.xfa.text.AFEElement;
import com.adobe.xfa.text.AFERun;
import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispMapSet;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispTab;
import com.adobe.xfa.text.FormatInfo;
import com.adobe.xfa.text.Glyph;
import com.adobe.xfa.text.GlyphLoc;
import com.adobe.xfa.text.LineDesc;
import com.adobe.xfa.text.MappingManager;
import com.adobe.xfa.text.PosnStack;
import com.adobe.xfa.text.RawBuilder;
import com.adobe.xfa.text.RawCounter;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBreakFinder;
import com.adobe.xfa.text.TextBreakIterator;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextCharPropDataIterator;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.UnitSpan;

class DispLineRaw
extends DispLine {
    static final int NEW_LINE_CONTINUE = 0;
    static final int NEW_LINE_STOP = 1;
    static final int NEW_LINE_RETRY = 2;
    static final int GLYPH_ACCUMULATE = 0;
    static final int GLYPH_ALREADY_HANDLED = 1;
    static final int GLYPH_BREAK_NOW = 2;
    static final int GLYPH_BREAK_NEXT = 3;
    static final int GLYPH_BREAK_WORD = 4;
    static final int GLYPH_BREAK_TAB = 5;
    private FormatInfo moFormatInfo;

    DispLineRaw(FormatInfo oFormatInfo, boolean bIsFirstParaLine) {
        super(oFormatInfo.getFrame());
        this.moFormatInfo = oFormatInfo;
        this.setFirstLineInStream(oFormatInfo.isFirstLine());
        this.setFirstParaLine(bIsFirstParaLine);
        this.setVerticalOrientation(this.frame().getLayoutOrientation() != 0);
    }

    boolean fill() {
        boolean bRTL = false;
        if (this.moFormatInfo.isNewPara()) {
            int eDirection = 0;
            TextAttr poAttr = this.moFormatInfo.getAttr();
            if (poAttr != null) {
                eDirection = poAttr.paraDirection();
            }
            block0 : switch (eDirection) {
                case 1: {
                    bRTL = false;
                    break;
                }
                case 2: {
                    bRTL = true;
                    break;
                }
                default: {
                    switch (this.display().stream().defaultDirection()) {
                        case 1: {
                            bRTL = false;
                            break block0;
                        }
                        case 2: {
                            bRTL = true;
                            break block0;
                        }
                    }
                    bRTL = this.display().isRTL(poAttr);
                }
            }
            this.moFormatInfo.setRTL(bRTL);
        } else {
            bRTL = this.moFormatInfo.isRTL();
        }
        this.setRTL(bRTL);
        int nTabStart = this.moFormatInfo.getTabSize();
        boolean bContinue = this.extractRawLine();
        this.format();
        bContinue = this.wrap(nTabStart, bContinue);
        return bContinue;
    }

    void fill(DispLineRaw poSource, int nSourceIndex, int nSourceLength, TextAttr poAttr, String sContent, boolean bIsPrefix) {
        this.clear();
        this.initialize(poSource.frame());
        this.setHasBIDI(poSource.hasBIDI());
        this.setOptycaMapping(poSource.getGlyphLocMap().size() > 0);
        this.preAllocChars(sContent.length());
        this.clearPositionMap();
        CharMapper oMapper = new CharMapper(this, poSource, nSourceIndex, nSourceLength, bIsPrefix);
        oMapper.map();
        this.format();
    }

    FormatInfo getFormatInfo() {
        return this.moFormatInfo;
    }

    int newLine(WrapInfo oInfo, TabControl poTabControl, int eLineBreak) {
        oInfo.moLineDesc.mnInternalSpaces = oInfo.moLine.getInternalSpaces();
        oInfo.moLineDesc.mnTrailingSpaces = oInfo.moLine.getTrailingSpaces() + oInfo.moLine.getTrailingGlue();
        int nLineMax = oInfo.moLine.getStartCharIndex() + oInfo.moLine.getCharLength();
        for (int nTrail = nLineMax - oInfo.moLineDesc.mnTrailingSpaces; nTrail < nLineMax; ++nTrail) {
            DispTab poTab = this.tabAt(nTrail);
            if (poTab == null) continue;
            this.setChar(nTrail, 32, TextCharProp.defaultSpace);
            poTab.setTrailing(true);
        }
        int eNewLine = this.newLine(oInfo.mbFirstLine, oInfo.moLine.getStartCharIndex(), oInfo.moLine.getCharLength(), oInfo.moLineDesc, oInfo.meLineBreak, eLineBreak);
        switch (eNewLine) {
            case 2: {
                oInfo.meLineBreak = 0;
                if (poTabControl == null) break;
                poTabControl.restartLine(oInfo);
                break;
            }
            case 1: {
                return 1;
            }
            default: {
                oInfo.mbFirstLine = false;
                oInfo.moLine.reset(oInfo.moWord);
                if (poTabControl != null) {
                    oInfo.mnNextTab = poTabControl.getTabIndex();
                }
                oInfo.meLineBreak = eLineBreak;
            }
        }
        this.determineLineLimits(oInfo, false);
        oInfo.moLineDesc.mnInternalSpaces = 0;
        oInfo.moLineDesc.mnTrailingSpaces = 0;
        return eNewLine;
    }

    int newLine(WrapInfo oInfo, TabControl poTabControl) {
        return this.newLine(oInfo, poTabControl, 0);
    }

    private boolean extractRawLine() {
        PosnStack oTempStack = new PosnStack(this.moFormatInfo.posnStack());
        RawCounter oCounter = new RawCounter(this.moFormatInfo, oTempStack);
        oCounter.run();
        this.preAllocChars(oCounter.getCount());
        RawBuilder oBuilder = new RawBuilder(this.moFormatInfo, this);
        oBuilder.run();
        oBuilder.finish();
        return oBuilder.canContinue();
    }

    private void format() {
        int i;
        int limit;
        AFERun afeRun;
        MappingManager mappingManager;
        block15: {
            mappingManager = null;
            if (this.hasBIDI()) {
                mappingManager = this.display().getContext().getMappingManager();
                mappingManager.analyze(this);
            }
            this.moFormatInfo.setMappingManager(mappingManager);
            afeRun = this.moFormatInfo.getAFERun();
            afeRun.load(this);
            BasicFormatter formatter = BasicFormatter.getFormatterInstance();
            limit = this.getCharCount();
            boolean allowKerning = false;
            try {
                int start = 0;
                for (i = 0; i < limit; ++i) {
                    AFEElement element = afeRun.getElement(i);
                    if (!element.getRunBreak()) continue;
                    if (start < i) {
                        int end = i;
                        if (afeRun.getElement(start).getEmbed() == null) {
                            end = formatter.preFormat(afeRun, start, end);
                            end = formatter.format(afeRun, start, end, allowKerning);
                        }
                        limit += end - i;
                        start = end;
                        i = end;
                    }
                    allowKerning = element.allowKerning();
                }
                if (start < limit && afeRun.getElement(start).getEmbed() == null) {
                    limit = formatter.preFormat(afeRun, start, limit);
                    limit = formatter.format(afeRun, start, limit, allowKerning);
                }
            }
            catch (FontLoadingException e) {
                assert (false);
            }
            catch (InvalidFontException e) {
                assert (false);
            }
            catch (UnsupportedFontException e) {
                assert (false);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        DispMapSet maps = this.getMaps();
        boolean mapRequired = afeRun.isMapRequired();
        maps.preAllocGlyphs(limit, mapRequired);
        if (mapRequired && mappingManager == null) {
            mappingManager = this.display().getContext().getMappingManager();
            mappingManager.analyze(this);
            this.moFormatInfo.setMappingManager(mappingManager);
        }
        DispLine.GlyphMaker glyphMaker = new DispLine.GlyphMaker(this);
        for (i = 0; i < limit; ++i) {
            AFEElement afeElement = afeRun.getElement(i);
            int charIndex = afeElement.getMapIndex();
            glyphMaker.addGlyph(afeElement, charIndex);
            if (!mapRequired) continue;
            GlyphLoc glyphLoc = new GlyphLoc(i, charIndex, afeElement.getMapLength());
            maps.moGlyphLocMap.add(glyphLoc);
        }
        glyphMaker.applyWidths();
    }

    private boolean wrap(int nTabStart, boolean bContinue) {
        boolean bWordWrap;
        WrapInfo oInfo = new WrapInfo(this.moFormatInfo, this, nTabStart);
        TextAttr poAttr = null;
        if (this.getCharCount() == 0) {
            poAttr = this.getLastAttr();
        } else {
            int nRunMapIndex = this.getRunMap().findItem(0);
            assert (this.getRunMap().isValidMapIndex(nRunMapIndex));
            poAttr = this.getRun(nRunMapIndex).getAttr();
        }
        oInfo.moLineDesc.meJustifyH = 5;
        oInfo.moLineDesc.mnInternalSpaces = 0;
        oInfo.moLineDesc.mnTrailingSpaces = 0;
        if (poAttr != null) {
            float oSpecial;
            if (poAttr.justifyHEnable()) {
                oInfo.moLineDesc.meJustifyH = poAttr.justifyH();
            }
            if (poAttr.marginLEnable()) {
                oInfo.moLineDesc.moMarginL = Units.toFloat(poAttr.marginL().getLength());
            }
            if (poAttr.marginREnable()) {
                oInfo.moLineDesc.moMarginR = Units.toFloat(poAttr.marginR().getLength());
            }
            if ((oSpecial = Units.toFloat(poAttr.special().getLength())) >= 0.0f) {
                oInfo.moSpecialFirst = oSpecial;
            } else {
                oInfo.moSpecialRest = -oSpecial;
            }
        }
        this.determineLineLimits(oInfo, true);
        boolean bl = bWordWrap = !oInfo.moFormat.getFrame().unlimitedWidth() && !oInfo.moFormat.getFrame().suppressWordWrap();
        if (this.getCharCount() == 0) {
            for (int nTry = 0; nTry < 2; ++nTry) {
                int eNewLine = this.newLine(oInfo, null);
                if (eNewLine == 2) continue;
                if (eNewLine == 1) {
                    bContinue = false;
                }
                break;
            }
        } else if (this.getCombCells() > 0) {
            int nCharFirst = 0;
            if (bWordWrap) {
                int nCell = 0;
                int nGlyph = 0;
                int nCharNext = 0;
                while (true) {
                    if (nCell >= this.getCombCells()) {
                        this.newLine(oInfo.mbFirstLine, nCharFirst, nCharNext - nCharFirst, oInfo.moLineDesc);
                        nCell = 0;
                    }
                    GlyphLoc oGlyphLoc = this.getOrderedGlyphLoc(nGlyph);
                    if (nCell == 0) {
                        nCharFirst = oGlyphLoc.getMapIndex();
                    }
                    if ((nGlyph = this.nextGlyphBaseAccentIndex(nGlyph)) >= this.getGlyphCount()) break;
                    nCharNext = this.getOrderedGlyphLoc(nGlyph).getMapIndex();
                    ++nCell;
                }
            }
            this.newLine(oInfo.mbFirstLine, nCharFirst, this.getCharCount() - nCharFirst, oInfo.moLineDesc);
        } else {
            double nBreakTolerance = this.legacyPositioning() ? 0.001 : 0.5;
            boolean[] pbBreakCandidates = null;
            if (bWordWrap) {
                pbBreakCandidates = this.display().getBreakCandidates(this.getCharCount());
                TextBreakFinder poBreakFinder = this.display().getBreakFinder();
                poBreakFinder.setBreakCandidates(this.getCharArray(), this.getBreakArray(), pbBreakCandidates, this.legacyPositioning());
            }
            boolean bForceBreak = false;
            TabControl oTabControl = new TabControl(this, this.moFormatInfo, nTabStart, bWordWrap, oInfo.moLineWidth);
            HyphenControl oHyphenControl = new HyphenControl(this, oInfo, oTabControl, poAttr);
            boolean bBreakLoop = false;
            int nGlyph = 0;
            while (nGlyph < this.getGlyphCount() && !bBreakLoop) {
                Glyph oGlyph = this.getGlyph(nGlyph);
                int nCharIndex = this.getGlyphLocCharIndex(nGlyph);
                int c = this.getChar(nCharIndex);
                int eBreak = this.getBreakClass(nCharIndex);
                if (c >= 8234 && c <= 8238) {
                    eBreak = 31;
                }
                if (bWordWrap && (bForceBreak || nCharIndex > 0 && pbBreakCandidates[nCharIndex])) {
                    oInfo.moLine.commitWord(oInfo.moWord);
                }
                bForceBreak = false;
                int eProcess = oTabControl.processGlyph(oGlyph, nCharIndex, c);
                eProcess = oHyphenControl.testHyphenation(eProcess, nGlyph);
                float oNewWidth = oTabControl.getLineWidth();
                if (eProcess == 0) {
                    eProcess = !bWordWrap || oNewWidth <= oInfo.moLineWidth || eBreak == 31 || nGlyph + 1 >= this.getVisualCharCount() && (double)(oNewWidth - oInfo.moLineWidth) <= nBreakTolerance ? 0 : (!oInfo.moLine.isEmpty() ? 4 : (!oInfo.moWord.isEmpty() ? 2 : 3));
                }
                switch (eProcess) {
                    case 0: {
                        oInfo.moWord.accumulate(oGlyph, nGlyph, eBreak);
                        ++nGlyph;
                        break;
                    }
                    case 1: {
                        oInfo.moWord.accumulate(oGlyph, nGlyph, eBreak);
                        ++nGlyph;
                        break;
                    }
                    case 2: {
                        nGlyph = oHyphenControl.hyphenate(eProcess, eBreak, pbBreakCandidates, oGlyph, nGlyph);
                        if (nGlyph >= 0) break;
                        bBreakLoop = true;
                        break;
                    }
                    case 3: {
                        oInfo.moWord.accumulate(oGlyph, nGlyph, eBreak);
                        bForceBreak = true;
                        ++nGlyph;
                        break;
                    }
                    case 4: {
                        nGlyph = oHyphenControl.hyphenate(eProcess, eBreak, pbBreakCandidates, oGlyph, nGlyph);
                        if (nGlyph >= 0) break;
                        bBreakLoop = true;
                        break;
                    }
                    case 5: {
                        oInfo.moWord.accumulate(oGlyph, nGlyph, eBreak);
                        oInfo.moLine.commitWord(oInfo.moWord);
                        int eNewLine = this.newLine(oInfo, oTabControl);
                        if (eNewLine == 2) {
                            nGlyph = oInfo.moLine.getStartGlyphIndex();
                            break;
                        }
                        oInfo.moFormat.getLastChanged().setLastParaLine(1);
                        if (eNewLine == 1) {
                            bBreakLoop = true;
                            break;
                        }
                        oTabControl.startLine();
                    }
                }
                if (bBreakLoop || nGlyph != this.getGlyphCount()) continue;
                oTabControl.commitTab();
                oInfo.moLine.commitWord(oInfo.moWord);
                switch (this.newLine(oInfo, oTabControl)) {
                    case 2: {
                        nGlyph = oInfo.moLine.getStartGlyphIndex();
                        break;
                    }
                    case 1: {
                        bBreakLoop = true;
                    }
                }
            }
            if (bBreakLoop) {
                bContinue = false;
            }
        }
        return bContinue;
    }

    private int newLine(boolean bFirstLine, int nStartIndex, int nLength, LineDesc oLineDesc, int eLineBreakStart, int eLineBreakEnd) {
        DispLineWrapped poLine = this.frame().allocateWrappedLine(oLineDesc);
        poLine.setRTL(this.isRTL());
        poLine.setHasBIDI(this.hasBIDI());
        if (bFirstLine) {
            if (this.isFirstParaLine()) {
                poLine.setFirstParaLine(true);
            }
            if (this.isFirstLineInStream()) {
                poLine.setFirstLineInStream(true);
            }
        }
        if (nStartIndex + nLength >= this.getCharCount() && this.getLastParaLine() != 0) {
            poLine.setLastParaLine(this.getLastParaLine());
        }
        poLine.fill(this, nStartIndex, nLength);
        int eCommit = this.moFormatInfo.commitLine(poLine);
        this.setFrame(this.moFormatInfo.getFrame());
        switch (eCommit) {
            case 1: {
                this.moFormatInfo.setFits(false);
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        poLine.setStartBreak(eLineBreakStart);
        poLine.setEndBreak(eLineBreakEnd);
        if (!this.moFormatInfo.isUpdate()) {
            return 0;
        }
        int nNextLineStart = nStartIndex + nLength;
        if (nNextLineStart >= this.getCharCount()) {
            return 0;
        }
        DispPosn oNextMapPosn = this.getMappedPosition(nNextLineStart);
        TextPosnBase oNextPosn = new TextPosnBase(oNextMapPosn.pp().stream(), DispLineRaw.charToStreamIndex(oNextMapPosn, nNextLineStart, 0));
        if (this.moFormatInfo.canStopNow(oNextPosn)) {
            return 1;
        }
        return 0;
    }

    private int newLine(boolean bFirstLine, int nStartIndex, int nLength, LineDesc oLineDesc) {
        return this.newLine(bFirstLine, nStartIndex, nLength, oLineDesc, 0, 0);
    }

    private void determineLineLimits(WrapInfo oInfo, boolean bFirst) {
        oInfo.moMaxWidth = 0.0f;
        oInfo.moLineWidth = 0.0f;
        if (this.frame().isOrientationVertical()) {
            if (!oInfo.moFormat.getFrame().unlimitedHeight()) {
                oInfo.moMaxWidth = Units.toFloat(oInfo.moFormat.getFrame().maxHeight());
            }
        } else if (!oInfo.moFormat.getFrame().unlimitedWidth()) {
            oInfo.moMaxWidth = Units.toFloat(oInfo.moFormat.getFrame().maxWidth());
        }
        oInfo.moLineDesc.moSpecial = bFirst && this.isFirstParaLine() ? oInfo.moSpecialFirst : oInfo.moSpecialRest;
        if (oInfo.moMaxWidth > 0.0f) {
            oInfo.moMaxWidth -= oInfo.moLineDesc.moMarginL;
            oInfo.moMaxWidth -= oInfo.moLineDesc.moMarginR;
            oInfo.moLineWidth = oInfo.moMaxWidth;
            oInfo.moLineWidth -= oInfo.moLineDesc.moSpecial;
        }
    }

    private static class CharMapper {
        private final DispLineRaw mpoDest;
        private final int mnDestLength;
        private final DispLineRaw mpoSource;
        private final int mnSourceStart;
        private final int mnSourceLength;
        private final boolean mbIsPrefix;
        private boolean mbExactMappings;
        private int mnCopyLength;
        private int mnDestIndex;
        private int mnDestExtra;
        private int mnSourceIndex;
        private int mnSourceExtra;
        private TextStream mpoStream;
        private int mnStreamIndex;
        private int mnStreamLength;
        private int mnMapIndex;
        private int mnMapLength;

        CharMapper(DispLineRaw poDest, DispLineRaw poSource, int nSourceStart, int nSourceLength, boolean bIsPrefix) {
            this.mpoDest = poDest;
            this.mnDestLength = poDest.getCharCount();
            this.mpoSource = poSource;
            this.mnSourceStart = nSourceStart;
            this.mnSourceLength = nSourceLength;
            this.mbIsPrefix = bIsPrefix;
            assert (this.mnDestLength > 0);
            assert (this.mnSourceLength > 0);
            if (this.mnDestLength < this.mnSourceLength) {
                this.mnCopyLength = this.mnDestLength - 1;
                this.mnDestExtra = 1;
                this.mnSourceExtra = this.mnSourceLength - this.mnDestLength + 1;
            } else if (this.mnDestLength > this.mnSourceLength) {
                this.mnCopyLength = this.mnSourceLength - 1;
                this.mnDestExtra = this.mnDestLength - this.mnSourceLength + 1;
                this.mnSourceExtra = 1;
            } else {
                this.mnCopyLength = this.mnDestLength;
                this.mnDestExtra = 0;
                this.mnSourceExtra = 0;
            }
        }

        void map() {
            int nCopy = this.initialize();
            for (int i = 0; i < nCopy; ++i) {
                this.copyMappings(1, 1);
            }
            this.finish();
        }

        private int initialize() {
            this.mnDestIndex = 0;
            this.mnSourceIndex = this.mnSourceStart;
            DispPosn oPosition = this.mpoSource.getMappedPosition(this.mnSourceIndex);
            this.mpoStream = oPosition.pp().stream();
            this.mnStreamIndex = DispLine.charToStreamIndex(oPosition, this.mnSourceIndex, 0);
            this.mnStreamLength = 0;
            this.mnMapIndex = 0;
            this.mnMapLength = 0;
            this.mpoDest.clearPositionMap();
            if (!this.mbIsPrefix && !this.mbExactMappings) {
                this.copyMappings(this.mnDestExtra, this.mnSourceExtra);
            }
            return this.mnCopyLength;
        }

        private void finish() {
            if (this.mbIsPrefix && !this.mbExactMappings) {
                this.copyMappings(this.mnDestExtra, this.mnSourceExtra);
            }
            this.flushMappings();
        }

        private void copyMappings(int nDestLength, int nSourceLength) {
            DispPosn oPosition = this.mpoSource.getMappedPosition(this.mnSourceIndex);
            int nStreamIndex = DispLine.charToStreamIndex(oPosition, this.mnSourceIndex, 0);
            if (this.mpoStream != oPosition.pp().stream() || nStreamIndex != this.mnStreamIndex + this.mnStreamLength) {
                this.flushMappings();
                this.mpoStream = oPosition.pp().stream();
                this.mnStreamIndex = nStreamIndex;
            }
            int nStreamCount = 0;
            block4: for (int i = 0; i < nSourceLength; ++i) {
                DispPosn poPosition = i == 0 ? oPosition : this.mpoSource.getMappedPosition(this.mnSourceIndex + i);
                switch (DispLine.getPositionType(poPosition)) {
                    case 1: {
                        ++nStreamCount;
                        continue block4;
                    }
                    case 2: {
                        nStreamCount += poPosition.getStreamCount();
                        continue block4;
                    }
                    default: {
                        assert (false);
                        ++nStreamCount;
                    }
                }
            }
            if (nDestLength < nStreamCount) {
                assert (nDestLength > 0);
                int n1To1 = nDestLength - 1;
                this.mnStreamLength += n1To1;
                this.mnMapLength += n1To1;
                this.flushMappings();
                this.mnStreamLength = nStreamCount - n1To1;
                this.mnMapLength = 1;
                this.flushMappings();
            } else if (nDestLength > nStreamCount) {
                assert (nSourceLength > 0);
                int n1To1 = nSourceLength - 1;
                this.mnStreamLength += n1To1;
                this.mnMapLength += n1To1;
                this.flushMappings();
                this.mnStreamLength = 1;
                this.mnMapLength = nDestLength - n1To1;
                this.flushMappings();
            } else {
                this.mnStreamLength += nDestLength;
                this.mnMapLength += nDestLength;
            }
            this.mnDestIndex += nDestLength;
            this.mnSourceIndex += nSourceLength;
        }

        private void flushMappings() {
            if (this.mnMapLength == 0) {
                return;
            }
            DispPosn oDispPosn = new DispPosn(this.mpoStream, this.mnStreamIndex);
            if (this.mnStreamLength != this.mnMapLength) {
                oDispPosn.setStreamCount(this.mnStreamLength);
            }
            this.mpoDest.add(oDispPosn, this.mnMapIndex, this.mnMapLength);
            this.mnStreamIndex += this.mnStreamLength;
            this.mnStreamLength = 0;
            this.mnMapIndex += this.mnMapLength;
            this.mnMapLength = 0;
        }
    }

    private static class HyphenControl {
        private HyphenData mpoData;
        private DispLineRaw mpoLine;
        private WrapInfo moWrapInfo;
        private TabControl moTabControl;

        HyphenControl(DispLineRaw poLine, WrapInfo oWrapInfo, TabControl oTabControl, TextAttr poAttr) {
            this.mpoLine = poLine;
            this.moWrapInfo = oWrapInfo;
            this.moTabControl = oTabControl;
            this.mpoData = null;
            if (poAttr == null || !poAttr.hyphLevelEnable() || poAttr.hyphLevel() != 0) {
                // empty if block
            }
        }

        int testHyphenation(int eProcess, int nGlyphIndex) {
            int eReturn = eProcess;
            if (this.mpoData != null && this.mpoData.meState != 0) {
                int nCharIndex = this.mpoLine.getGlyphLocCharIndex(nGlyphIndex);
                if (this.mpoData.meState == 1) {
                    if (nCharIndex == this.mpoData.mnSuffixStart) {
                        eReturn = 2;
                    }
                } else if (nCharIndex >= this.mpoData.mnSuffixStart + this.mpoData.mnSuffixLength) {
                    this.endHyphenation();
                }
            }
            return eReturn;
        }

        int hyphenate(int eProcess, int eBreak, boolean[] pbBreakCandidates, Glyph oGlyph, int nGlyph) {
            IntegerHolder eLineBreak = new IntegerHolder(0);
            int nReturnGlyph = -1;
            if (!(this.mpoData == null || this.moWrapInfo.moWord.isEmpty() && this.mpoData.meState != 1)) {
                nReturnGlyph = this.doHyphenation(eProcess, eBreak, pbBreakCandidates, oGlyph, nGlyph, eLineBreak);
            }
            if (nReturnGlyph < 0) {
                nReturnGlyph = nGlyph;
                if (eProcess == 2) {
                    this.moWrapInfo.moLine.commitWord(this.moWrapInfo.moWord);
                    if (eLineBreak.value == 0) {
                        eLineBreak.value = 3;
                    }
                }
                this.moWrapInfo.moWord.accumulate(oGlyph, nGlyph, eBreak);
                switch (this.mpoLine.newLine(this.moWrapInfo, this.moTabControl, eLineBreak.value)) {
                    case 2: {
                        nReturnGlyph = this.moWrapInfo.moLine.getStartGlyphIndex();
                        break;
                    }
                    case 1: {
                        nReturnGlyph = -1;
                        break;
                    }
                    default: {
                        if (eProcess == 4) {
                            nReturnGlyph = this.moWrapInfo.moLine.getStartGlyphIndex();
                        }
                        this.moTabControl.startLine();
                    }
                }
            }
            return nReturnGlyph;
        }

        private int doHyphenation(int eProcess, int eBreak, boolean[] pbBreakCandidates, Glyph oGlyph, int nGlyph, IntegerHolder eLineBreak) {
            int nCharIndex = this.mpoLine.getGlyphLocCharIndex(nGlyph);
            HyphExtents oHyphExtents = new HyphExtents();
            String sPrefixPrefix = "";
            switch (this.mpoData.meState) {
                case 0: {
                    if (!this.determineWordExtents(pbBreakCandidates, nCharIndex, oHyphExtents, eLineBreak)) {
                        return -1;
                    }
                    this.mpoData.moHyphExtents.copyFrom(oHyphExtents);
                    if (this.getHyphenation(oHyphExtents.mnWordStart, oHyphExtents.mnWordLength)) break;
                    return -1;
                }
                case 1: {
                    this.mpoData.meState = 2;
                    eLineBreak.value = 2;
                    return -1;
                }
                case 2: {
                    oHyphExtents.mnHyphStart = this.mpoData.mnSuffixStart;
                    oHyphExtents.mnWordStart = this.mpoData.mnSuffixStart;
                    oHyphExtents.mnWordLength = this.mpoData.mnSuffixLength;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            TextAttr poAttr = this.mpoLine.getMappedAttr(nCharIndex);
            DispLineRaw oPrefixLine = new DispLineRaw(this.moWrapInfo.moFormat, false);
            String sPrefix = "";
            String sPrefixHyphen = "";
            int nPrefixMapLength = 0;
            String sSuffix = "";
            String sSuffixHyphen = "";
            int nSuffixMapLength = 0;
            this.getHyphenChars(sPrefixHyphen, sSuffixHyphen);
            boolean bFound = false;
            if (!bFound) {
                this.endHyphenation();
                return -1;
            }
            if (sPrefixPrefix.length() > 0) {
                oPrefixLine.fill(this.mpoLine, oHyphExtents.mnWordStart, nPrefixMapLength, poAttr, sPrefix + sPrefixHyphen, true);
            }
            DispLineRaw oSuffixLine = new DispLineRaw(this.moWrapInfo.moFormat, false);
            oSuffixLine.fill(this.mpoLine, oHyphExtents.mnWordStart + nPrefixMapLength, nSuffixMapLength, poAttr, sSuffixHyphen + sSuffix, false);
            int nNewWordLength = oPrefixLine.getCharCount() + oSuffixLine.getCharCount();
            this.resizeBreakCandidates(oHyphExtents.mnWordStart, oHyphExtents.mnWordLength, nNewWordLength, pbBreakCandidates);
            pbBreakCandidates[oHyphExtents.mnWordStart + oPrefixLine.getCharCount()] = true;
            this.mpoData.mnSuffixStart = oHyphExtents.mnWordStart + oPrefixLine.getCharCount();
            this.mpoData.mnSuffixLength = oSuffixLine.getCharCount();
            this.mpoData.meState = 1;
            this.mpoLine.removeContent(oHyphExtents.mnWordStart, oHyphExtents.mnWordLength);
            this.mpoLine.insertContent(oPrefixLine, oHyphExtents.mnWordStart);
            this.mpoLine.insertContent(oSuffixLine, this.mpoData.mnSuffixStart);
            nGlyph = this.moWrapInfo.moWord.getStartGlyphIndex();
            this.moTabControl.backUp(this.moWrapInfo.moLine.getCurrentWidth());
            this.moWrapInfo.moWord.restart();
            return nGlyph;
        }

        private boolean determineWordExtents(boolean[] pbBreakCandidates, int nCharIndex, HyphExtents oHyphExtents, IntegerHolder eLineBreak) {
            int nEnd;
            eLineBreak.value = 0;
            if (this.moWrapInfo.moWord.isEmpty()) {
                return false;
            }
            oHyphExtents.mnHyphStart = this.moWrapInfo.moWord.getStartCharIndex();
            for (nEnd = oHyphExtents.mnHyphStart + 1; nEnd < this.mpoLine.getCharCount() && !pbBreakCandidates[nEnd]; ++nEnd) {
            }
            if (nEnd >= this.mpoLine.getCharCount()) {
                int nGlyphIndex = this.moWrapInfo.moWord.getStartGlyphIndex();
                Glyph oGlyph = this.mpoLine.getGlyph(nGlyphIndex);
                float oWordSize = this.mpoLine.getWidth() - this.mpoLine.getTrailingWidth() - oGlyph.getOriginalX();
                if (oWordSize < this.moWrapInfo.moMaxWidth) {
                    eLineBreak.value = 1;
                    return false;
                }
            }
            TextCharPropDataIterator oDataIterator = new TextCharPropDataIterator(this.mpoLine.getBreakArray(), oHyphExtents.mnHyphStart);
            TextBreakIterator poBreakIterator = TextBreakIterator.createWordInstance(oDataIterator);
            boolean bFound = false;
            int nIndex = poBreakIterator.first();
            while (nIndex != Integer.MAX_VALUE) {
                int nTestIndex = oHyphExtents.mnHyphStart + nIndex;
                if (this.mpoLine.getWordClass(nTestIndex) == 0) {
                    bFound = true;
                    oHyphExtents.mnWordStart = nTestIndex;
                    break;
                }
                if (nIndex > 0 && pbBreakCandidates[nTestIndex]) break;
                nIndex = poBreakIterator.next();
            }
            if (!bFound) {
                return false;
            }
            nIndex = poBreakIterator.next();
            if (nIndex == Integer.MAX_VALUE) {
                return false;
            }
            oHyphExtents.mnWordLength = oHyphExtents.mnHyphStart + nIndex - oHyphExtents.mnWordStart;
            if (oHyphExtents.mnWordLength <= 1) {
                return false;
            }
            int nLimit = oHyphExtents.mnWordStart + oHyphExtents.mnWordLength;
            TextStream poStream = null;
            for (nIndex = oHyphExtents.mnWordStart; nIndex < nLimit; ++nIndex) {
                DispPosn oPosition = this.mpoLine.getMappedPosition(nIndex);
                TextStream poTestStream = oPosition.pp().stream();
                if (poTestStream == poStream) continue;
                if (poStream != null) {
                    return false;
                }
                poStream = poTestStream;
            }
            return true;
        }

        private boolean getHyphenation(int nWordStart, int nWordLength) {
            return false;
        }

        private void getHyphenChars(String sPrefixChars, String sSuffixChars) {
        }

        private void resizeBreakCandidates(int nWordStart, int nOldWordLength, int nNewWordLength, boolean[] pbBreakCandidates) {
            int nOldCount = this.mpoLine.getCharCount();
            int nNewCount = nOldCount + nNewWordLength - nOldWordLength;
            if (nNewWordLength != nOldWordLength) {
                int nOldWordEnd = nWordStart + nOldWordLength;
                if (nNewWordLength < nOldWordLength) {
                    int nShift = nOldWordLength - nNewWordLength;
                    for (int nSrc = nOldWordEnd; nSrc < nOldCount; ++nSrc) {
                        pbBreakCandidates[nSrc - nShift] = pbBreakCandidates[nSrc];
                    }
                } else {
                    pbBreakCandidates = this.mpoLine.display().getBreakCandidates(nNewCount, nOldCount);
                    int nSrc = nOldCount;
                    int nDst = nNewCount;
                    while (nSrc > nOldWordEnd) {
                        pbBreakCandidates[--nDst] = pbBreakCandidates[--nSrc];
                    }
                }
            }
            for (int i = 0; i < nNewWordLength; ++i) {
                pbBreakCandidates[nWordStart + i] = false;
            }
        }

        private void endHyphenation() {
            this.mpoData.meState = 0;
        }

        private static class HyphenData {
            static final int STATE_OFF = 0;
            static final int STATE_PREFIX = 1;
            static final int STATE_SUFFIX = 2;
            String msLocale;
            int meState = 0;
            HyphExtents moHyphExtents = new HyphExtents();
            int mnSuffixStart;
            int mnSuffixLength;

            HyphenData(TextAttr poAttr) {
                this.msLocale = poAttr.actualLocale();
            }
        }

        private static class HyphExtents {
            int mnHyphStart;
            int mnWordStart;
            int mnWordLength;

            private HyphExtents() {
            }

            void copyFrom(HyphExtents source) {
                this.mnHyphStart = source.mnHyphStart;
                this.mnWordStart = source.mnWordStart;
                this.mnWordLength = source.mnWordLength;
            }
        }
    }

    private static class TabControl {
        private static final int RTL_DECIMAL_OFF = 0;
        private static final int RTL_DECIMAL_WHOLE_PART = 1;
        private static final int RTL_DECIMAL_FRACTION_PART = 2;
        private DispLineRaw mpoLine;
        private FormatInfo moFormatInfo;
        private int mnTabIndex;
        private boolean mbWordWrap;
        private float moMaxWidth;
        private DispTab mpoCurrentDispTab;
        private TextTab moCurrentTabStop;
        private float moAccumulatedLineWidth;
        private float moCurrentTabOffset;
        private float moCurrentTabTextWidth;
        private float moTrailingSpaceWidth;
        private int meRTLDecimalState;
        private float moRTLDigitWidth;

        TabControl(DispLineRaw poLine, FormatInfo oFormatInfo, int nTabStart, boolean bWordWrap, float oMaxWidth) {
            this.mpoLine = poLine;
            this.moFormatInfo = oFormatInfo;
            this.mnTabIndex = nTabStart;
            this.mbWordWrap = bWordWrap;
            this.moMaxWidth = oMaxWidth;
        }

        int getTabIndex() {
            return this.mnTabIndex;
        }

        float getLineWidth() {
            float oResult = this.moAccumulatedLineWidth;
            if (this.mpoCurrentDispTab != null && this.moCurrentTabStop.tabType() == 1) {
                oResult += this.moCurrentTabTextWidth / 2.0f;
            }
            return oResult;
        }

        void setMaxWidth(float oMaxWidth) {
            this.moMaxWidth = oMaxWidth;
        }

        int processGlyph(Glyph oGlyph, int nCharIndex, int c) {
            int eReturn = 0;
            if (c != 9) {
                float oGlyphWidth = oGlyph.getOriginalNextX() - oGlyph.getOriginalX();
                if (this.mpoCurrentDispTab == null) {
                    this.moAccumulatedLineWidth += oGlyphWidth;
                } else {
                    switch (this.moCurrentTabStop.tabType()) {
                        case 1: {
                            if (this.mpoLine.getBreakClass(nCharIndex) == 31) {
                                this.moTrailingSpaceWidth += oGlyphWidth;
                                break;
                            }
                            this.commitTrailingSpace();
                            this.moCurrentTabTextWidth += oGlyphWidth;
                            if (!(this.moCurrentTabTextWidth / 2.0f > this.moCurrentTabOffset)) break;
                            this.cancelTab();
                            break;
                        }
                        case 5: {
                            if (this.mpoLine.getBreakClass(nCharIndex) == 31) {
                                this.moTrailingSpaceWidth += oGlyphWidth;
                                break;
                            }
                            this.commitTrailingSpace();
                            this.moCurrentTabTextWidth += oGlyphWidth;
                            if (!(this.moCurrentTabTextWidth > this.moCurrentTabOffset)) break;
                            this.cancelTab();
                            break;
                        }
                        case 3: {
                            TextAttr poAttr = this.mpoLine.getMappedAttr(nCharIndex);
                            boolean bAccumulateGlyph = false;
                            if (poAttr != null && c == poAttr.radixChar()) {
                                if (this.meRTLDecimalState == 1) {
                                    bAccumulateGlyph = true;
                                    this.meRTLDecimalState = 2;
                                } else {
                                    this.commitTrailingSpace();
                                    this.commitTab();
                                    this.moAccumulatedLineWidth += oGlyphWidth;
                                }
                            } else {
                                switch (this.meRTLDecimalState) {
                                    case 1: {
                                        if (this.mpoLine.getBreakClass(nCharIndex) == 24) {
                                            this.moRTLDigitWidth += oGlyphWidth;
                                            break;
                                        }
                                        this.moCurrentTabTextWidth += this.moRTLDigitWidth;
                                        this.moRTLDigitWidth = 0.0f;
                                        bAccumulateGlyph = true;
                                        break;
                                    }
                                    case 2: {
                                        if (this.mpoLine.getBreakClass(nCharIndex) == 24) {
                                            bAccumulateGlyph = true;
                                            break;
                                        }
                                        this.commitTab();
                                        break;
                                    }
                                    default: {
                                        bAccumulateGlyph = true;
                                    }
                                }
                            }
                            if (!bAccumulateGlyph) break;
                            if (this.mpoLine.getBreakClass(nCharIndex) == 31) {
                                this.moTrailingSpaceWidth += oGlyphWidth;
                                break;
                            }
                            this.commitTrailingSpace();
                            this.moCurrentTabTextWidth += oGlyphWidth;
                            if (!(this.moCurrentTabTextWidth > this.moCurrentTabOffset)) break;
                            this.cancelTab();
                        }
                    }
                }
            } else {
                this.commitTab();
                assert (this.mnTabIndex < this.moFormatInfo.getTabSize());
                DispTab poDispTab = this.moFormatInfo.getTab(this.mnTabIndex);
                ++this.mnTabIndex;
                TextTab oTabStop = new TextTab();
                TextAttr poAttr = this.mpoLine.getMappedAttr(nCharIndex);
                boolean bFillTab = false;
                if (poAttr != null) {
                    int eLeader;
                    oTabStop = poAttr.tabs().next(Units.toUnitSpan(this.moAccumulatedLineWidth));
                    if (oTabStop.tabStop().value() > 0) {
                        UnitSpan oSpaceAfter = Units.toUnitSpan(this.moMaxWidth).subtract(oTabStop.tabStop());
                        if (!this.mbWordWrap || !this.mpoLine.legacyPositioning() || oSpaceAfter.value() > 0) {
                            this.mpoCurrentDispTab = poDispTab;
                            if (this.mbWordWrap && oSpaceAfter.value() < 0) {
                                poDispTab.setFillWidth(this.moMaxWidth - this.moAccumulatedLineWidth);
                            }
                        }
                    }
                    if (poAttr.leaderContentEnable() && poAttr.leaderPatternEnable() && ((eLeader = poAttr.leaderPattern()) == 2 || eLeader == 3)) {
                        bFillTab = true;
                    }
                }
                oTabStop.tabType(TextTab.resolveType(oTabStop.tabType(), this.mpoLine.isRTL(), true));
                this.meRTLDecimalState = 0;
                if (this.mpoCurrentDispTab == null) {
                    if (this.mpoLine.legacyPositioning()) {
                        eReturn = 5;
                        bFillTab = false;
                    } else if (this.mbWordWrap) {
                        poDispTab.setWidth(this.moMaxWidth - this.moAccumulatedLineWidth);
                        this.moAccumulatedLineWidth = this.moMaxWidth;
                    } else {
                        eReturn = 3;
                        bFillTab = false;
                    }
                    this.mpoLine.setChar(nCharIndex, 32, TextCharProp.defaultSpace);
                } else if (oTabStop.tabType() == 4) {
                    float width;
                    float oTabWidth = width = Units.toFloat(oTabStop.tabStop());
                    poDispTab.setWidth(oTabWidth -= this.moAccumulatedLineWidth);
                    this.moAccumulatedLineWidth = width;
                    this.mpoCurrentDispTab = null;
                    this.mpoLine.setChar(nCharIndex, 65532, TextCharProp.defaultSpace);
                    eReturn = 1;
                } else {
                    this.moCurrentTabStop = oTabStop;
                    float oTabOffset = Units.toFloat(oTabStop.tabStop());
                    this.moCurrentTabOffset = oTabOffset - this.moAccumulatedLineWidth;
                    this.moAccumulatedLineWidth = oTabOffset;
                    this.mpoLine.setChar(nCharIndex, 65532, TextCharProp.defaultSpace);
                    if (this.mpoLine.isRTL() && oTabStop.tabType() == 3) {
                        this.meRTLDecimalState = 1;
                        this.moRTLDigitWidth = 0.0f;
                    }
                    eReturn = 1;
                }
                if (bFillTab) {
                    TextDisplay poDisplay = this.mpoLine.display();
                    assert (poDisplay != null);
                    poDispTab.fill(poDisplay.getContext(), poAttr, poDisplay.getGFXEnv());
                }
            }
            return eReturn;
        }

        void startLine() {
            this.moAccumulatedLineWidth = 0.0f;
            this.moCurrentTabOffset = 0.0f;
            this.moCurrentTabTextWidth = 0.0f;
            this.moTrailingSpaceWidth = 0.0f;
        }

        void restartLine(WrapInfo oInfo) {
            this.startLine();
            this.mnTabIndex = oInfo.mnNextTab;
        }

        void backUp(float oNewWidth) {
            this.moAccumulatedLineWidth = oNewWidth;
        }

        void cancelTab() {
            this.moAccumulatedLineWidth -= this.moCurrentTabOffset;
            this.moAccumulatedLineWidth += this.moCurrentTabTextWidth;
            this.moCurrentTabOffset = 0.0f;
            this.moCurrentTabTextWidth = 0.0f;
            this.moTrailingSpaceWidth = 0.0f;
            this.mpoCurrentDispTab = null;
        }

        void commitTab() {
            if (this.mpoCurrentDispTab != null) {
                float oTabWidth = 0.0f;
                switch (this.moCurrentTabStop.tabType()) {
                    case 1: {
                        this.moCurrentTabTextWidth /= 2.0f;
                        oTabWidth = this.moCurrentTabOffset - this.moCurrentTabTextWidth;
                        this.moAccumulatedLineWidth += this.moCurrentTabTextWidth + this.moTrailingSpaceWidth;
                        break;
                    }
                    case 3: 
                    case 5: {
                        oTabWidth = this.moCurrentTabOffset - this.moCurrentTabTextWidth;
                        this.moAccumulatedLineWidth += this.moRTLDigitWidth;
                        if (this.meRTLDecimalState == 2) break;
                        this.moAccumulatedLineWidth += this.moTrailingSpaceWidth;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.mpoCurrentDispTab.setWidth(oTabWidth);
            }
            this.moCurrentTabOffset = 0.0f;
            this.moCurrentTabTextWidth = 0.0f;
            this.moTrailingSpaceWidth = 0.0f;
            this.mpoCurrentDispTab = null;
        }

        void commitTrailingSpace() {
            this.moCurrentTabTextWidth += this.moTrailingSpaceWidth;
            this.moTrailingSpaceWidth = 0.0f;
        }
    }

    private static class WrapInfo {
        FormatInfo moFormat;
        MeasuredText moLine;
        MeasuredText moWord;
        LineDesc moLineDesc;
        float moMaxWidth;
        float moLineWidth;
        float moSpecialFirst;
        float moSpecialRest;
        int mnNextTab;
        boolean mbFirstLine;
        int meLineBreak;

        WrapInfo(FormatInfo oFormatInfo, DispLineRaw poLine, int nNextTab) {
            this.moFormat = oFormatInfo;
            this.moLine = new MeasuredText(poLine);
            this.moWord = new MeasuredText(poLine);
            this.moLineDesc = new LineDesc();
            this.mnNextTab = nNextTab;
            this.mbFirstLine = true;
            this.meLineBreak = 0;
        }
    }

    private static class MeasuredText {
        private DispLineRaw mpoLine;
        private boolean mbStarted;
        private int mnStartGlyphIndex;
        private int mnStartCharIndex;
        private int mnEndCharIndex;
        private float moStartOffset;
        private float moCurrentWidth;
        private int mnInternalSpaces;
        private int mnTrailingSpaces;
        private int mnTrailingGlue;

        MeasuredText(DispLineRaw poLine) {
            this.mpoLine = poLine;
        }

        boolean isEmpty() {
            return !this.mbStarted;
        }

        int getStartGlyphIndex() {
            return this.mnStartGlyphIndex;
        }

        int getStartCharIndex() {
            return this.mnStartCharIndex;
        }

        int getCharLength() {
            return this.mnEndCharIndex - this.mnStartCharIndex;
        }

        float getStartOffset() {
            return this.moStartOffset;
        }

        float getCurrentWidth() {
            return this.mbStarted ? this.moCurrentWidth : 0.0f;
        }

        int getInternalSpaces() {
            return this.mnInternalSpaces;
        }

        int getTrailingSpaces() {
            return this.mnTrailingSpaces;
        }

        int getTrailingGlue() {
            return this.mnTrailingGlue;
        }

        void accumulate(Glyph oGlyph, int nGlyphIndex, int eBreak) {
            GlyphLoc oGlyphLoc = this.mpoLine.getGlyphLoc(nGlyphIndex);
            if (!this.mbStarted) {
                this.moStartOffset = oGlyph.getDrawX(this.mpoLine);
                this.moCurrentWidth = 0.0f;
                this.mnStartGlyphIndex = nGlyphIndex;
                this.mnStartCharIndex = oGlyphLoc.getMapIndex();
                this.mnInternalSpaces = 0;
                this.mnTrailingSpaces = 0;
                this.mnTrailingGlue = 0;
                this.mbStarted = true;
            }
            this.mnEndCharIndex = oGlyphLoc.getMapIndex() + oGlyphLoc.getMapLength();
            this.moCurrentWidth += oGlyph.getOriginalNextX() - oGlyph.getOriginalX();
            switch (eBreak) {
                case 31: {
                    ++this.mnTrailingSpaces;
                    break;
                }
                case 11: {
                    ++this.mnTrailingGlue;
                    break;
                }
                default: {
                    this.mnInternalSpaces += this.mnTrailingSpaces + this.mnTrailingGlue;
                    this.mnTrailingSpaces = 0;
                    this.mnTrailingGlue = 0;
                }
            }
        }

        void commitWord(MeasuredText oWord) {
            if (oWord.mbStarted) {
                if (!this.mbStarted) {
                    this.copyFrom(oWord);
                } else {
                    this.mnEndCharIndex = oWord.mnEndCharIndex;
                    if (oWord.mnTrailingSpaces + oWord.mnTrailingGlue == oWord.getCharLength()) {
                        this.mnTrailingSpaces += oWord.mnTrailingSpaces;
                        this.mnTrailingGlue += oWord.mnTrailingGlue;
                    } else {
                        this.mnInternalSpaces += this.mnTrailingSpaces + this.mnTrailingGlue + oWord.mnInternalSpaces;
                        this.mnTrailingSpaces = oWord.mnTrailingSpaces;
                        this.mnTrailingGlue = oWord.mnTrailingGlue;
                    }
                    this.moCurrentWidth += oWord.moCurrentWidth;
                }
                oWord.mbStarted = false;
            }
        }

        void restart() {
            this.mbStarted = false;
        }

        void reset(MeasuredText oWord) {
            this.mbStarted = false;
            this.mnStartGlyphIndex = oWord.mnStartGlyphIndex;
            this.mnStartCharIndex = oWord.mnStartCharIndex;
            this.moStartOffset = oWord.moStartOffset;
            this.moCurrentWidth = oWord.moCurrentWidth;
            this.mnInternalSpaces = 0;
            this.mnTrailingSpaces = 0;
            this.mnTrailingGlue = 0;
            oWord.mbStarted = false;
        }

        void copyFrom(MeasuredText source) {
            this.mpoLine = source.mpoLine;
            this.mbStarted = source.mbStarted;
            this.mnStartGlyphIndex = source.mnStartGlyphIndex;
            this.mnStartCharIndex = source.mnStartCharIndex;
            this.mnEndCharIndex = source.mnEndCharIndex;
            this.moStartOffset = source.moStartOffset;
            this.moCurrentWidth = source.moCurrentWidth;
            this.mnInternalSpaces = source.mnInternalSpaces;
            this.mnTrailingSpaces = source.mnTrailingSpaces;
            this.mnTrailingGlue = source.mnTrailingGlue;
        }
    }
}

