/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextBreakFinder;
import com.adobe.xfa.text.TextCharProp;

class DefaultBreakFinder
extends TextBreakFinder {
    DefaultBreakFinder() {
    }

    @Override
    public void setBreakCandidates(int[] pcText, int[] peBreakData, boolean[] pbCandidates, boolean bLegacyPositioning) {
        int i;
        assert (peBreakData.length == pcText.length);
        assert (pbCandidates.length >= pcText.length);
        int nChars = pcText.length;
        if (nChars == 0) {
            return;
        }
        for (i = 0; i < nChars; ++i) {
            pbCandidates[i] = false;
        }
        int cPrev = pcText[0];
        int ePrevNonSpace = peBreakData[0];
        int nSpaces = 0;
        for (i = 1; i < nChars; ++i) {
            int c = pcText[i];
            int eNextData = peBreakData[i];
            if (TextCharProp.getBreakClass(eNextData) == 31) {
                ++nSpaces;
                continue;
            }
            int eRule = TextCharProp.getPairRule(ePrevNonSpace, eNextData);
            switch (eRule) {
                case 0: {
                    break;
                }
                case 1: {
                    if (nSpaces <= 0) break;
                    pbCandidates[i] = true;
                    break;
                }
                case 2: {
                    if (nSpaces <= 0) break;
                    pbCandidates[i - 1] = true;
                    break;
                }
                case 3: {
                    if (!TextCharProp.kinsokuAllowEnd(cPrev) || !TextCharProp.kinsokuAllowStart(c)) break;
                    if (bLegacyPositioning) {
                        if (nSpaces <= 0 && (cPrev == 46 || cPrev == 44 || cPrev == 45 || cPrev == 47)) break;
                        pbCandidates[i] = true;
                        break;
                    }
                    pbCandidates[i] = true;
                }
            }
            nSpaces = 0;
            ePrevNonSpace = eNextData;
            cPrev = c;
        }
    }

    @Override
    public String getCurrentLocale() {
        return null;
    }
}

