/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.RichTextNode;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptInfo;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.template.TemplateModelFactory;
import com.adobe.xfa.template.TemplateModelFixup;
import com.adobe.xfa.template.TemplateModelScript;
import com.adobe.xfa.template.TemplateResolver;
import com.adobe.xfa.template.TemplateSchema;
import com.adobe.xfa.template.Value;
import com.adobe.xfa.template.automation.EventTag;
import com.adobe.xfa.template.automation.Script;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.PageSet;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.containers.Variables;
import com.adobe.xfa.template.formatting.Color;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.xmp.XMPHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

public final class TemplateModel
extends Model {
    private static final boolean ACROBAT_PLUGIN = ResourceLoader.loadProperty("ACROBAT_PLUGIN").equalsIgnoreCase("true");
    private static final TemplateSchema gTemplateSchema = new TemplateSchema();
    private static final String INSERTION_POINT_NAME = "insertionPoint";
    private static final String INSERTION_POINT_PLACEHOLDER_NAME = "insertionPointPlaceholder";
    private boolean mbApplyFixups;
    private boolean mbFixupRenderCache;
    private boolean mbCheckRelevant;
    private boolean mbHasServerSideScript;
    protected boolean mbIsSourceSetModelInitialized;
    private int meInputGenerator = 0;
    protected int mnIDCount;
    private final Storage<String> moGlobalFields = new Storage();
    private final Storage<IndexTableElement> moIndexTable = new Storage();
    private final Storage<String> moRelevantList = new Storage();
    private AppModel.LegacyMask mnLegacyInfo;
    private int mnOriginalTemplateVersion;
    private TemplateResolver moTemplateResolver = new TemplateResolver();
    private static final String Adobe_patent_B1081 = "AdobePatentID=\"B1081\"";

    public static void enumerateScripts(Model model, Node node, List<ScriptInfo> scripts, String sSingleLanguage) {
        if (node instanceof Field || node instanceof Subform || node instanceof ExclGroup) {
            ScriptInfo si;
            Element validateProp;
            ScriptInfo si2;
            Container element = (Container)node;
            Element calcProp = element.getElement(XFA.CALCULATETAG, true, 0, false, false);
            if (calcProp != null && (si2 = TemplateModel.getScriptInfo(element, calcProp, sSingleLanguage, 1)) != null) {
                scripts.add(si2);
            }
            if ((validateProp = element.getElement(XFA.VALIDATETAG, true, 0, false, false)) != null && (si = TemplateModel.getScriptInfo(element, validateProp, sSingleLanguage, 2)) != null) {
                scripts.add(si);
            }
            NodeList children = element.getNodes();
            for (int nIndex = 0; nIndex < children.length(); ++nIndex) {
                TextNode text;
                Node child = (Node)children.item(nIndex);
                if (child instanceof Variables) {
                    NodeList variablesChildren = child.getNodes();
                    for (int nVariablesIndex = 0; nVariablesIndex < variablesChildren.length(); ++nVariablesIndex) {
                        TextNode text2;
                        Node script = (Node)variablesChildren.item(nVariablesIndex);
                        if (!(script instanceof Script)) continue;
                        Script scriptElement = (Script)script;
                        String sLanguageName = scriptElement.getAttribute(XFA.CONTENTTYPETAG).toString();
                        if (!StringUtils.isEmpty(sSingleLanguage) && !sSingleLanguage.equals(sLanguageName) || (text2 = scriptElement.getText(true, false, false)) == null) continue;
                        String sScript = text2.getValue();
                        ScriptInfo si3 = new ScriptInfo(sScript, sLanguageName, script, "", 0);
                        scripts.add(si3);
                    }
                    continue;
                }
                if (!(child instanceof EventTag)) continue;
                EventTag eventElement = (EventTag)child;
                Node script = child.peekOneOfChild(false);
                if (!(script instanceof Script)) continue;
                Script scriptElement = (Script)script;
                String sLanguageName = scriptElement.getAttribute(XFA.CONTENTTYPETAG).toString();
                if (!StringUtils.isEmpty(sSingleLanguage) && !sSingleLanguage.equals(sLanguageName) || (text = scriptElement.getText(true, false, false)) == null) continue;
                String sScript = text.getValue();
                String sReason = eventElement.getAttribute(XFA.ACTIVITYTAG).toString();
                String sRef = eventElement.getAttribute(XFA.REFTAG).toString();
                int eReason = ScriptHandler.stringToExecuteReason(sReason);
                ScriptInfo si4 = new ScriptInfo(sScript, sLanguageName, element, sRef, eReason);
                scripts.add(si4);
            }
        }
        if (node.isContainer()) {
            for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                TemplateModel.enumerateScripts(model, child, scripts, sSingleLanguage);
            }
        }
    }

    private static ScriptInfo getScriptInfo(Node node, Element eventNode, String sSingleLanguage, int eReason) {
        Element scriptNode = eventNode.getElement(XFA.SCRIPTTAG, true, 0, false, false);
        if (!(scriptNode instanceof Script)) {
            return null;
        }
        Script scriptElement = (Script)scriptNode;
        String sBinding = scriptElement.getAttribute(XFA.BINDINGTAG).toString();
        if (!StringUtils.isEmpty(sBinding) && !sBinding.equals("XFA")) {
            return null;
        }
        TextNode scriptText = scriptElement.getText(true, false, false);
        if (scriptText == null) {
            return null;
        }
        String sLanguageName = scriptElement.getAttribute(XFA.CONTENTTYPETAG).toString();
        if (!StringUtils.isEmpty(sSingleLanguage) && !sSingleLanguage.equals(sLanguageName)) {
            return null;
        }
        return new ScriptInfo(scriptElement.getValue(), sLanguageName, node, "", eReason);
    }

    public static Schema getModelSchema() {
        return gTemplateSchema;
    }

    public static TemplateModel getTemplateModel(AppModel app, boolean bCreateIfNotFound) {
        TemplateModel tm = (TemplateModel)Model.getNamedModel(app, "template");
        if (bCreateIfNotFound && tm == null) {
            TemplateModelFactory factory = new TemplateModelFactory();
            tm = (TemplateModel)factory.createDOM((Element)app.getXmlPeer());
            tm.setDocument(app.getDocument());
            app.notifyPeers(4, "template", tm);
        }
        return tm;
    }

    public static String getValidationMessage(Element poValidateNode, String aType) {
        Element poMessageNode;
        String sMessage = null;
        if (poValidateNode != null && (poMessageNode = poValidateNode.getElement(XFA.MESSAGETAG, true, 0, false, false)) != null) {
            boolean bFirst = true;
            for (Node poChild = poMessageNode.getFirstXFAChild(); poChild != null; poChild = poChild.getNextXFASibling()) {
                if (!(poChild instanceof TextValue)) continue;
                TextValue oText = (TextValue)poChild;
                String aName = poChild.getName();
                if (aName == aType) {
                    sMessage = oText.getValue();
                    break;
                }
                if (!bFirst || aName != "") continue;
                sMessage = oText.getValue();
                bFirst = false;
            }
        }
        return sMessage;
    }

    @Override
    public String getOriginalVersion(boolean bDefault) {
        if (bDefault && this.mnOriginalTemplateVersion != 0) {
            String sVer = super.getOriginalVersion(false);
            if (sVer.length() == 0 && this.mnOriginalTemplateVersion <= this.getCurrentVersion()) {
                return this.getNS(this.mnOriginalTemplateVersion);
            }
            return super.getOriginalVersion(bDefault);
        }
        return super.getOriginalVersion(bDefault);
    }

    @Override
    public int getVersion(String sNS) {
        int nVersion = super.getVersion(sNS);
        if (nVersion == 0) {
            if (this.meInputGenerator == 0) {
                this.initGenerator();
            }
            if (this.meInputGenerator == 1 || this.meInputGenerator == 2 || this.meInputGenerator == 3 || this.meInputGenerator == 4 || this.meInputGenerator == 5 || this.meInputGenerator == 50 || this.meInputGenerator == 51 || this.meInputGenerator == 52 || this.meInputGenerator == 150) {
                return 21;
            }
            if (this.meInputGenerator == 53 || this.meInputGenerator == 54) {
                return 22;
            }
            if (this.meInputGenerator == 55 || this.meInputGenerator == 56 || this.meInputGenerator == 154) {
                return 24;
            }
            if (this.meInputGenerator == 57 || this.meInputGenerator == 58) {
                return 25;
            }
            return 21;
        }
        return nVersion;
    }

    protected void updateLegacyFlags(boolean bValue, AppModel.LegacyMask nLegacyFlags, AppModel.LegacyMask oLegacyInfo) {
        AppModel.LegacyMask oDependentFlagsToClear = new AppModel.LegacyMask(0);
        AppModel.LegacyMask oDependentFlagsToSet = new AppModel.LegacyMask(0);
        AppModel.LegacyMask[] DEPENDENT_LAYOUTLEGACY_FLAGS = new AppModel.LegacyMask[]{AppModel.XFA_LEGACY_V27_LAYOUT, AppModel.XFA_LEGACY_V28_LAYOUT, AppModel.XFA_LEGACY_V29_LAYOUT, AppModel.XFA_LEGACY_V30_LAYOUT};
        int[] DEPENDENT_LAYOUT_VERSIONS = new int[]{28, 29, 30, 31};
        int nSize = DEPENDENT_LAYOUTLEGACY_FLAGS.length;
        assert (DEPENDENT_LAYOUTLEGACY_FLAGS.length == DEPENDENT_LAYOUT_VERSIONS.length);
        this.getDependentFlags(bValue, nLegacyFlags, oDependentFlagsToSet, oDependentFlagsToClear, DEPENDENT_LAYOUTLEGACY_FLAGS, DEPENDENT_LAYOUT_VERSIONS, nSize);
        AppModel.LegacyMask[] DEPENDENT_SCRIPTINGLEGACY_FLAGS = new AppModel.LegacyMask[]{AppModel.XFA_LEGACY_V27_SCRIPTING, AppModel.XFA_LEGACY_V28_SCRIPTING, AppModel.XFA_LEGACY_V29_SCRIPTING, AppModel.XFA_LEGACY_V30_SCRIPTING, AppModel.XFA_LEGACY_V32_SCRIPTING, AppModel.XFA_LEGACY_V34_SCRIPTING};
        int[] DEPENDENT_SCRIPTING_VERSIONS = new int[]{28, 29, 30, 31, 33, 35};
        nSize = DEPENDENT_SCRIPTINGLEGACY_FLAGS.length;
        assert (DEPENDENT_SCRIPTINGLEGACY_FLAGS.length == DEPENDENT_SCRIPTING_VERSIONS.length);
        this.getDependentFlags(bValue, nLegacyFlags, oDependentFlagsToSet, oDependentFlagsToClear, DEPENDENT_SCRIPTINGLEGACY_FLAGS, DEPENDENT_SCRIPTING_VERSIONS, nSize);
        AppModel.LegacyMask[] DEPENDENT_TRAVERSALLEGACY_FLAGS = new AppModel.LegacyMask[]{AppModel.XFA_LEGACY_V27_TRAVERSALORDER, AppModel.XFA_LEGACY_V29_TRAVERSALORDER};
        int[] DEPENDENT_TRAVERSAL_VERSIONS = new int[]{28, 30};
        nSize = DEPENDENT_TRAVERSALLEGACY_FLAGS.length;
        assert (DEPENDENT_TRAVERSALLEGACY_FLAGS.length == DEPENDENT_TRAVERSAL_VERSIONS.length);
        this.getDependentFlags(bValue, nLegacyFlags, oDependentFlagsToSet, oDependentFlagsToClear, DEPENDENT_TRAVERSALLEGACY_FLAGS, DEPENDENT_TRAVERSAL_VERSIONS, nSize);
        if (bValue) {
            oLegacyInfo.set(oLegacyInfo.or(nLegacyFlags));
        } else {
            oLegacyInfo.set(oLegacyInfo.and(nLegacyFlags.not()));
        }
        oLegacyInfo.set(oLegacyInfo.and(oDependentFlagsToClear.not()));
        oLegacyInfo.set(oLegacyInfo.or(oDependentFlagsToSet));
    }

    private void getDependentFlags(boolean bValue, AppModel.LegacyMask nLegacyFlags, AppModel.LegacyMask oDependentFlagsToSet, AppModel.LegacyMask oDependentFlagsToClear, AppModel.LegacyMask[] DEPENDENT_LEGACY_FLAGS, int[] DEPENDENT_VERSIONS, int nSize) {
        int i = nSize - 1;
        for (int nCount = 0; nCount < nSize; ++nCount) {
            if (DEPENDENT_LEGACY_FLAGS[i].and(nLegacyFlags).isNonZero()) {
                int j = 0;
                if (bValue) {
                    for (j = 0; j < i; ++j) {
                        oDependentFlagsToClear.or_n_set(DEPENDENT_LEGACY_FLAGS[j]);
                    }
                    for (j = i + 1; j < nSize; ++j) {
                        oDependentFlagsToSet.or_n_set(DEPENDENT_LEGACY_FLAGS[j]);
                    }
                } else {
                    while (this.mnOriginalVersion > DEPENDENT_VERSIONS[i] && i + 1 < nSize) {
                        ++i;
                    }
                    for (j = 0; j < i; ++j) {
                        oDependentFlagsToClear.or_n_set(DEPENDENT_LEGACY_FLAGS[j]);
                    }
                    for (j = i + 1; j < nSize; ++j) {
                        oDependentFlagsToSet.or_n_set(DEPENDENT_LEGACY_FLAGS[j]);
                    }
                }
                break;
            }
            --i;
        }
    }

    void updateLegacyInfo(String sPIValue, String sOption, AppModel.LegacyMask nLegacyFlags, AppModel.LegacyMask oLegacyInfo, String sBehaviorOverride) {
        String sNum = null;
        int nStart = -1;
        if (sBehaviorOverride != null && (nStart = sBehaviorOverride.indexOf(sOption)) != -1) {
            int nOffset = nStart + sOption.length() + 1;
            sNum = sBehaviorOverride.substring(nOffset, nOffset + 1);
            if (sNum.equals("0")) {
                this.updateLegacyFlags(false, nLegacyFlags, oLegacyInfo);
            } else {
                this.updateLegacyFlags(true, nLegacyFlags, oLegacyInfo);
            }
            return;
        }
        nStart = sPIValue.indexOf(sOption);
        if (nStart != -1) {
            int nOffset = nStart + sOption.length() + 1;
            sNum = sPIValue.substring(nOffset, nOffset + 1);
        }
        if (sNum != null) {
            if (sNum.equals("0")) {
                this.updateLegacyFlags(false, nLegacyFlags, oLegacyInfo);
            } else {
                this.updateLegacyFlags(true, nLegacyFlags, oLegacyInfo);
            }
        }
    }

    public static void setValidationMessage(Element validateNode, String sMessage, String aType) {
        Element messageNode;
        if (validateNode != null && (messageNode = validateNode.getElement(XFA.MESSAGETAG, true, 0, true, false)) != null) {
            TextValue text;
            Node child;
            boolean bFirst = true;
            if (messageNode.getFirstXFAChild() == null) {
                messageNode.getModel().createElement(messageNode, null, messageNode.getModel().getNS(), "text", "text", null, 0, null);
                messageNode.makeNonDefault(false);
            }
            boolean bFound = false;
            for (child = messageNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof TextValue)) continue;
                text = (TextValue)child;
                String aName = child.getName();
                if (aName == aType) {
                    text.setValue(sMessage);
                    bFound = true;
                    break;
                }
                if (!bFirst || aName != "") continue;
                text.setValue(sMessage);
                bFound = true;
                bFirst = false;
            }
            if (!bFound) {
                messageNode.getModel().createElement(messageNode, messageNode.getLastXMLChild(), messageNode.getModel().getNS(), aType, aType, null, 0, null);
                text = (TextValue)child;
                assert (child.getName() == aType);
                text.setValue(sMessage);
            }
        }
    }

    public static String templateNS() {
        return "http://www.xfa.org/schema/xfa-template/3.6/";
    }

    private static String updateLegacyString(String sPIValue, AppModel.LegacyMask nLegacyFlags, AppModel.LegacyMask nFlag, AppModel.LegacyMask nDefaults) {
        if (nLegacyFlags.and(nFlag).equals(nDefaults.and(nFlag))) {
            return sPIValue;
        }
        boolean bLegacy = nLegacyFlags.and(nFlag).isNonZero();
        String sOption = "";
        if (nFlag.equals(AppModel.XFA_LEGACY_POSITIONING)) {
            sOption = "LegacyPositioning";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_EVENTMODEL)) {
            sOption = "LegacyEventModel";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_PLUSPRINT)) {
            sOption = "LegacyPlusPrint";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_PERMISSIONS)) {
            sOption = "LegacyXFAPermissions";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_CALCOVERRIDE)) {
            sOption = "LegacyCalcOverride";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_RENDERING)) {
            sOption = "LegacyRendering";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V26_HIDDENPOSITIONED)) {
            sOption = "v2.6-hiddenPositioned";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_MULTIRECORDCONTEXTCACHE)) {
            sOption = "v2.7-multiRecordContextCache";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_LAYOUT)) {
            sOption = "v2.7-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            sOption = "v2.7-scripting";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_EVENTMODEL)) {
            sOption = "v2.7-eventModel";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_TRAVERSALORDER)) {
            sOption = "v2.7-traversalOrder";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING)) {
            sOption = "v2.7-XHTMLVersionProcessing";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V27_ACCESSIBILITY)) {
            sOption = "v2.7-accessibility";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V28_LAYOUT)) {
            sOption = "v2.8-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V28_SCRIPTING)) {
            sOption = "v2.8-scripting";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V29_LAYOUT)) {
            sOption = "v2.9-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
            sOption = "v2.9-scripting";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V30_LAYOUT)) {
            sOption = "v3.0-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
            sOption = "v3.0-scripting";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V29_TRAVERSALORDER)) {
            sOption = "v2.9-traversalOrder";
        } else if (nFlag.equals(AppModel.XFA_PATCH_B_02518)) {
            sOption = "patch-B-02518";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V29_FIELDPRESENCE)) {
            sOption = "v2.9-fieldPresence";
        } else if (nFlag.equals(AppModel.XFA_PATCH_W_2393121)) {
            sOption = "patch-W-2393121";
        } else if (nFlag.equals(AppModel.XFA_PATCH_W_2447677)) {
            sOption = "patch-W-2447677";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
            sOption = "v3.2-scripting";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V31_LAYOUT)) {
            sOption = "v3.1-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V32_LAYOUT)) {
            sOption = "v3.2-layout";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V32_RENDERING)) {
            sOption = "v3.2-rendering";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V32_CANONICALIZATION)) {
            sOption = "v3.2-canonicalization";
        } else if (nFlag.equals(AppModel.XFA_PATCH_W_2757988)) {
            sOption = "patch-W-2757988";
        } else if (nFlag.equals(AppModel.XFA_LEGACY_V34_SCRIPTING)) {
            sOption = "v3.4-scripting";
        } else if (nFlag == AppModel.XFA_PATCH_W_2693910) {
            sOption = "patch-W-2693910";
        } else if (nFlag == AppModel.XFA_OVERFLOW_TARGET_ALTERNATE) {
            sOption = "OverflowTargetAlternate";
        } else assert (false);
        sPIValue = sPIValue + ' ';
        sPIValue = sPIValue + sOption;
        sPIValue = bLegacy ? sPIValue + ":1" : sPIValue + ":0";
        return sPIValue;
    }

    public TemplateModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, TemplateModel.templateNS(), "template", "template", "$template", XFA.TEMPLATETAG, "template", TemplateModel.getModelSchema());
    }

    public TemplateModel(Element parent, Node prevSibling, String uri, String QName2, String name) {
        super(parent, prevSibling, uri, QName2, name, "$template", XFA.TEMPLATETAG, "template", TemplateModel.getModelSchema());
        this.mnOriginalTemplateVersion = this.getCurrentVersion();
    }

    private void initGenerator() {
        Generator g = this.getGenerator();
        if (g != null) {
            this.meInputGenerator = this.getGenerator().generator();
        }
    }

    void addIndexEntry(ContainerIndex indexEntry, String nodeName, Object parent) {
        boolean parentFound = false;
        int i = 0;
        for (i = 0; i < this.moIndexTable.size(); ++i) {
            if (((IndexTableElement)this.moIndexTable.get((int)i)).parent != parent) continue;
            parentFound = true;
            break;
        }
        if (parentFound) {
            IndexTableElement ite = (IndexTableElement)this.moIndexTable.get(i);
            int j = 0;
            for (j = 0; j < ite.likeChildren.size(); ++j) {
                int k;
                LikeNamedContainers likeChild = ite.likeChildren.get(j);
                if (!likeChild.likeName.equals(nodeName)) continue;
                int listSize = likeChild.containers.size();
                for (k = 0; k < listSize && indexEntry.nContainerIndex >= likeChild.containers.get((int)k).nContainerIndex; ++k) {
                }
                likeChild.containers.add(k, indexEntry);
                break;
            }
        } else {
            LikeNamedContainers newLikeNamedContainer = new LikeNamedContainers(nodeName);
            newLikeNamedContainer.containers.add(indexEntry);
            IndexTableElement newParentEntry = new IndexTableElement(parent);
            newParentEntry.likeChildren.add(newLikeNamedContainer);
            this.moIndexTable.add(newParentEntry);
        }
    }

    public void applyFixups() {
        this.mbApplyFixups = true;
    }

    public void fixupRenderCache() {
        this.mbFixupRenderCache = true;
    }

    public void convertToGeographicalOrder() {
        this.orderNodes(this.getModel());
    }

    @Override
    public Element createElement(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int lineNumber, String fileName) {
        int index;
        Element node = super.createElement(parent, prevSibling, uri, localName, qName, attributes, lineNumber, fileName);
        if (node.getElementClass() == XFA.INVALID_ELEMENT) {
            return node;
        }
        String aNodeName = node.getName();
        if (!this.isViewAdmissable(node, aNodeName)) {
            node.setClass(node.getClassName(), XFA.INVALID_ELEMENT);
        } else if (node instanceof Color) {
            Color oColor = (Color)node;
            this.getTemplateResolver().addActiveColor(oColor);
        } else if (localName == "bind" && parent != null && (index = node.findAttr(null, "match")) != -1 && node.getAttrVal(index).equals("global")) {
            this.setAsGlobalField(parent);
        }
        return node;
    }

    @Override
    public Node createNode(int eTag, Element parent, String aName, String aNS, boolean bDoVersionCheck) {
        assert (aName != null);
        assert (aNS != null);
        Element retVal = this.getSchema().getInstance(eTag, this, parent, null, bDoVersionCheck);
        if (aName != null && aName != "") {
            retVal.setName(aName);
        }
        retVal.setNS(aNS);
        return retVal;
    }

    public ProtoableNode createLeaderTrailer(String sReference, Node oParentContainer, boolean bPeek) {
        return this.findInternalProto(XFA.SUBFORMTAG, XFA.SUBFORMSETTAG, oParentContainer, sReference, bPeek);
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xfa-template/";
    }

    @Override
    public String getHeadNS() {
        return TemplateModel.templateNS();
    }

    @Override
    public boolean getLegacySetting(AppModel.LegacyMask nLegacyFlag) {
        this.getOriginalXFAVersion();
        if (nLegacyFlag.equals(AppModel.XFA_LEGACY_RENDERING) && this.mnLegacyInfo.and(AppModel.XFA_LEGACY_POSITIONING).isNonZero()) {
            return true;
        }
        return this.mnLegacyInfo.and(nLegacyFlag).isNonZero();
    }

    @Override
    public void normalizeNameSpaces(String aNewNS) {
        super.normalizeNameSpaces(aNewNS);
        this.mnLegacyInfo = new AppModel.LegacyMask(0);
    }

    @Override
    public int getOriginalXFAVersion() {
        if (this.mnOriginalVersion == 0) {
            int nVersion;
            Node child;
            Element oPresent;
            String sPIValue = this.getOriginalVersion(false);
            Element oBehaviorOverride = null;
            Element oConfig = this.getAppModel().getElement(XFA.CONFIGTAG, true, 0, false, false);
            if (oConfig != null && oConfig instanceof Element && (oPresent = oConfig.peekElement(XFA.PRESENTTAG, false, 0)) != null && oPresent instanceof Element) {
                oBehaviorOverride = oPresent.peekElement(XFA.BEHAVIOROVERRIDETAG, false, 0);
            }
            String sBehaviorOverride = null;
            if (oBehaviorOverride != null && oBehaviorOverride instanceof Element && (child = ((Element)oBehaviorOverride).getFirstXFAChild()) != null && child instanceof TextNode) {
                sBehaviorOverride = ((TextNode)child).getValue();
            }
            int nCurrentVersion = this.getCurrentVersion();
            AppModel.LegacyMask nDeprecatedFlags = this.getXFALegacyDeprecatedForXFAVersion(nCurrentVersion);
            if (StringUtils.isEmpty(sPIValue)) {
                sPIValue = this.getOriginalVersion(true);
                nVersion = this.getVersion(sPIValue);
                this.mnLegacyInfo = this.getXFALegacyDefaultsForXFAVersion(nVersion);
                this.mnOriginalVersion = nVersion;
                if (StringUtils.isEmpty(sBehaviorOverride)) {
                    if (nDeprecatedFlags.isNonZero()) {
                        AppModel.LegacyMask nDefaultFlags;
                        this.mnLegacyInfo = nDefaultFlags = this.mnLegacyInfo.and(nDeprecatedFlags.not());
                    }
                    return nVersion;
                }
            } else {
                nVersion = this.getVersion(sPIValue);
                this.mnLegacyInfo = this.getXFALegacyDefaultsForXFAVersion(nVersion);
                this.mnOriginalVersion = nVersion;
            }
            AppModel.LegacyMask oLegacyInfo = new AppModel.LegacyMask(this.mnLegacyInfo);
            this.updateLegacyInfo(sPIValue, "LegacyPositioning", AppModel.XFA_LEGACY_POSITIONING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "LegacyEventModel", AppModel.XFA_LEGACY_EVENTMODEL, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "LegacyPlusPrint", AppModel.XFA_LEGACY_PLUSPRINT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "LegacyXFAPermissions", AppModel.XFA_LEGACY_PERMISSIONS, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "LegacyCalcOverride", AppModel.XFA_LEGACY_CALCOVERRIDE, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "LegacyRendering", AppModel.XFA_LEGACY_RENDERING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.6-hiddenPositioned", AppModel.XFA_LEGACY_V26_HIDDENPOSITIONED, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-multiRecordContextCache", AppModel.XFA_LEGACY_V27_MULTIRECORDCONTEXTCACHE, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-layout", AppModel.XFA_LEGACY_V27_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-scripting", AppModel.XFA_LEGACY_V27_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-eventModel", AppModel.XFA_LEGACY_V27_EVENTMODEL, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-traversalOrder", AppModel.XFA_LEGACY_V27_TRAVERSALORDER, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-XHTMLVersionProcessing", AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.7-accessibility", AppModel.XFA_LEGACY_V27_ACCESSIBILITY, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.8-layout", AppModel.XFA_LEGACY_V28_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.8-scripting", AppModel.XFA_LEGACY_V28_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.9-layout", AppModel.XFA_LEGACY_V29_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.9-scripting", AppModel.XFA_LEGACY_V29_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.0-layout", AppModel.XFA_LEGACY_V30_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.0-scripting", AppModel.XFA_LEGACY_V30_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.9-traversalOrder", AppModel.XFA_LEGACY_V29_TRAVERSALORDER, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "patch-B-02518", AppModel.XFA_PATCH_B_02518, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v2.9-fieldPresence", AppModel.XFA_LEGACY_V29_FIELDPRESENCE, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "patch-W-2393121", AppModel.XFA_PATCH_W_2393121, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "patch-W-2447677", AppModel.XFA_PATCH_W_2447677, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "patch-W-2757988", AppModel.XFA_PATCH_W_2757988, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "patch-W-2693910", AppModel.XFA_PATCH_W_2693910, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.2-scripting", AppModel.XFA_LEGACY_V32_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.1-layout", AppModel.XFA_LEGACY_V31_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.2-layout", AppModel.XFA_LEGACY_V32_LAYOUT, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.2-rendering", AppModel.XFA_LEGACY_V32_RENDERING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.2-canonicalization", AppModel.XFA_LEGACY_V32_CANONICALIZATION, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "v3.4-scripting", AppModel.XFA_LEGACY_V34_SCRIPTING, oLegacyInfo, sBehaviorOverride);
            this.updateLegacyInfo(sPIValue, "OverflowTargetAlternate", AppModel.XFA_OVERFLOW_TARGET_ALTERNATE, oLegacyInfo, sBehaviorOverride);
            this.mnLegacyInfo = new AppModel.LegacyMask(oLegacyInfo);
            assert (this.mnOriginalVersion == nVersion);
            if (nDeprecatedFlags.isNonZero()) {
                AppModel.LegacyMask nDefaultFlags;
                this.mnLegacyInfo = nDefaultFlags = this.mnLegacyInfo.and(nDeprecatedFlags.not());
                this.updateOriginalXFAVersionPI();
            }
            if (!StringUtils.isEmpty(sBehaviorOverride) || nDeprecatedFlags.isNonZero()) {
                this.updateOriginalXFAVersionPI();
            }
        }
        return this.mnOriginalVersion;
    }

    private AppModel.LegacyMask getXFALegacyDefaultsForXFAVersion(int nXFAVersion) {
        AppModel.LegacyMask nVersion = new AppModel.LegacyMask(0);
        switch (nXFAVersion) {
            case 21: {
                nVersion = AppModel.XFA_LEGACY_21_DEFAULT;
                break;
            }
            case 22: {
                nVersion = AppModel.XFA_LEGACY_22_DEFAULT;
                break;
            }
            case 23: {
                nVersion = AppModel.XFA_LEGACY_23_DEFAULT;
                break;
            }
            case 24: {
                nVersion = AppModel.XFA_LEGACY_24_DEFAULT;
                break;
            }
            case 25: {
                nVersion = AppModel.XFA_LEGACY_25_DEFAULT;
                break;
            }
            case 26: {
                nVersion = AppModel.XFA_LEGACY_26_DEFAULT;
                break;
            }
            case 27: {
                nVersion = AppModel.XFA_LEGACY_27_DEFAULT;
                break;
            }
            case 28: {
                nVersion = AppModel.XFA_LEGACY_28_DEFAULT;
                break;
            }
            case 29: {
                nVersion = AppModel.XFA_LEGACY_29_DEFAULT;
                break;
            }
            case 30: {
                nVersion = AppModel.XFA_LEGACY_30_DEFAULT;
                break;
            }
            case 31: {
                nVersion = AppModel.XFA_LEGACY_31_DEFAULT;
                break;
            }
            case 32: {
                nVersion = AppModel.XFA_LEGACY_32_DEFAULT;
                break;
            }
            case 33: {
                nVersion = AppModel.XFA_LEGACY_33_DEFAULT;
                break;
            }
            case 34: {
                nVersion = AppModel.XFA_LEGACY_34_DEFAULT;
                break;
            }
            case 35: {
                nVersion = AppModel.XFA_LEGACY_35_DEFAULT;
                break;
            }
            case 36: {
                nVersion = AppModel.XFA_LEGACY_36_DEFAULT;
                break;
            }
            default: {
                int nDefault = 0;
                if (nXFAVersion > 36) {
                    nVersion = AppModel.XFA_LEGACY_HEAD_DEFAULT;
                    nDefault = 36;
                } else {
                    nVersion = AppModel.XFA_LEGACY_21_DEFAULT;
                    nDefault = 21;
                }
                String sVer = "0.0";
                if (nXFAVersion > 0) {
                    double dVersion = (double)nXFAVersion / 10.0;
                    sVer = Numeric.doubleToString(dVersion, 1, false);
                }
                String sVerDefault = "0.0";
                if (nDefault > 0) {
                    double dDefault = (double)nDefault / 10.0;
                    sVerDefault = Numeric.doubleToString(dDefault, 1, false);
                }
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnRecognizedNameSpaceWarning);
                oMessage.format(sVer);
                oMessage.format(sVerDefault);
                ExFull err = new ExFull(oMessage);
                this.addErrorList(err, 3, this);
            }
        }
        return nVersion;
    }

    private AppModel.LegacyMask getXFALegacyDeprecatedForXFAVersion(int nXFAVersion) {
        AppModel.LegacyMask nVersion = new AppModel.LegacyMask(0);
        switch (nXFAVersion) {
            case 21: {
                nVersion = AppModel.XFA_LEGACY_21_DEPRECATED;
                break;
            }
            case 22: {
                nVersion = AppModel.XFA_LEGACY_22_DEPRECATED;
                break;
            }
            case 23: {
                nVersion = AppModel.XFA_LEGACY_23_DEPRECATED;
                break;
            }
            case 24: {
                nVersion = AppModel.XFA_LEGACY_24_DEPRECATED;
                break;
            }
            case 25: {
                nVersion = AppModel.XFA_LEGACY_25_DEPRECATED;
                break;
            }
            case 26: {
                nVersion = AppModel.XFA_LEGACY_26_DEPRECATED;
                break;
            }
            case 27: {
                nVersion = AppModel.XFA_LEGACY_27_DEPRECATED;
                break;
            }
            case 28: {
                nVersion = AppModel.XFA_LEGACY_28_DEPRECATED;
                break;
            }
            case 29: {
                nVersion = AppModel.XFA_LEGACY_29_DEPRECATED;
                break;
            }
            case 30: {
                nVersion = AppModel.XFA_LEGACY_30_DEPRECATED;
                break;
            }
            case 31: {
                nVersion = AppModel.XFA_LEGACY_31_DEPRECATED;
                break;
            }
            case 32: {
                nVersion = AppModel.XFA_LEGACY_32_DEPRECATED;
                break;
            }
            case 33: {
                nVersion = AppModel.XFA_LEGACY_33_DEPRECATED;
                break;
            }
            case 34: {
                nVersion = AppModel.XFA_LEGACY_34_DEPRECATED;
                break;
            }
            case 35: {
                nVersion = AppModel.XFA_LEGACY_35_DEPRECATED;
                break;
            }
            case 36: {
                nVersion = AppModel.XFA_LEGACY_36_DEPRECATED;
                break;
            }
            default: {
                int nDefault = 0;
                if (nXFAVersion > 36) {
                    nVersion = AppModel.XFA_LEGACY_HEAD_DEPRECATED;
                    nDefault = 36;
                } else {
                    nVersion = AppModel.XFA_LEGACY_21_DEPRECATED;
                    nDefault = 21;
                }
                String sVer = "0.0";
                if (nXFAVersion > 0) {
                    double dVersion = (double)nXFAVersion / 10.0;
                    sVer = Numeric.doubleToString(dVersion, 1, false);
                }
                String sVerDefault = "0.0";
                if (nDefault > 0) {
                    double dDefault = (double)nDefault / 10.0;
                    sVerDefault = Numeric.doubleToString(dDefault, 1, false);
                }
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnRecognizedNameSpaceWarning);
                oMessage.format(sVer);
                oMessage.format(sVerDefault);
                ExFull err = new ExFull(oMessage);
                this.addErrorList(err, 3, this);
            }
        }
        return nVersion;
    }

    @Override
    public ScriptTable getScriptTable() {
        return TemplateModelScript.getScriptTable();
    }

    TemplateResolver getTemplateResolver() {
        return this.moTemplateResolver;
    }

    boolean hasServerSideScripts() {
        return this.mbHasServerSideScript;
    }

    void invalidMethod(char[] sName) {
    }

    boolean isCornerEqual(Element pCornerL, Element pCornerR) {
        return true;
    }

    boolean isEdgeEqual(Element pEdgeL, Element pEdgeR) {
        return true;
    }

    boolean isViewAdmissable(Element node, String aNodeName) {
        int nRelvantListSize;
        String sRelevant;
        if (!this.mbCheckRelevant) {
            TextNode textNode;
            Node oRelevant = this.resolveNode("config.present.common.template.relevant");
            if (oRelevant != null && 1 == oRelevant.getXFAChildCount() && !StringUtils.isEmpty(sRelevant = (textNode = (TextNode)oRelevant.getFirstXFAChild()).getValue())) {
                String[] tokens = sRelevant.split(" ");
                for (int i = 0; i < tokens.length; ++i) {
                    this.moRelevantList.add(tokens[i]);
                }
            }
            this.mbCheckRelevant = true;
        }
        if ((nRelvantListSize = this.moRelevantList.size()) == 0) {
            return true;
        }
        if (!this.isViewSensitiveNode(node, aNodeName)) {
            return true;
        }
        int attr = node.findAttr(null, "relevant");
        if (attr == -1) {
            return true;
        }
        sRelevant = node.getAttrVal(attr).trim();
        if (StringUtils.isEmpty(sRelevant)) {
            return true;
        }
        boolean bAdmissable = true;
        boolean bFound = false;
        String[] tokens = sRelevant.split(" ");
        for (int j = 0; bAdmissable && j < tokens.length; ++j) {
            boolean bIsPlus;
            String sViewName = tokens[j];
            boolean bIsMinus = sViewName.length() > 0 && sViewName.charAt(0) == '-';
            boolean bl = bIsPlus = sViewName.length() > 0 && sViewName.charAt(0) == '+';
            if (bIsMinus || bIsPlus) {
                sViewName = sViewName.substring(1);
            }
            for (int i = 0; i < nRelvantListSize; ++i) {
                if (!sViewName.equals(this.moRelevantList.get(i))) continue;
                if (bIsMinus) {
                    bAdmissable = false;
                }
                bFound = true;
                break;
            }
            if (bFound || bIsMinus) continue;
            bAdmissable = false;
        }
        return bAdmissable;
    }

    boolean isViewSensitiveNode(Node node, String aNodeName) {
        if (node == null || aNodeName == "") {
            return false;
        }
        return node instanceof Element && (aNodeName == "subform" || aNodeName == "subformSet" || aNodeName == "contentArea" || aNodeName == "pageArea" || aNodeName == "pageSet" || aNodeName == "area" || aNodeName == "value" || aNodeName == "field" || aNodeName == "draw" || aNodeName == "border" || aNodeName == "exclGroup");
    }

    @Override
    public void loadNode(Element parent, Node node, Generator generator) {
        if (node instanceof Element) {
            this.doLoadNode((Element)node);
        }
    }

    @Override
    public boolean loadSpecialAttribute(Attribute attribute, String aLocalName, Element element, boolean bCheckOnly) {
        if (aLocalName == "match" && element.getClassTag() == XFA.BINDTAG && attribute.getAttrValue().equals("global")) {
            this.setAsGlobalField(element.getXFAParent());
            return true;
        }
        if (!this.mbHasServerSideScript && aLocalName == "runAt" && element.getClassTag() == XFA.SCRIPTTAG && attribute.getAttrValue().equals("server")) {
            this.mbHasServerSideScript = true;
            return true;
        }
        return super.loadSpecialAttribute(attribute, aLocalName, element, bCheckOnly);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void nodeCleanup(Node node, boolean bHasAttrs, boolean bHasChildren) {
        Element element;
        block29: {
            block30: {
                EnumValue presence;
                block28: {
                    Measurement oReserve;
                    Element parentElem;
                    int nChildren;
                    if (node instanceof Chars) {
                        Chars x = (Chars)node;
                        if (x.getData().length() == 0) {
                            node.remove();
                        }
                        return;
                    }
                    element = (Element)node;
                    boolean isTransient = element.isTransient();
                    if (isTransient) {
                        element.remove();
                        return;
                    }
                    if ((element.isSameClass(XFA.BORDERTAG) || element.isSameClass(XFA.RECTANGLETAG)) && (nChildren = element.getXFAChildCount()) > 3) {
                        Element[] edges = new Element[4];
                        Element[] corners = new Element[4];
                        int nEdges = 0;
                        int nCorners = 0;
                        Node child = element.getFirstXFAChild();
                        while (child != null) {
                            block27: {
                                Node nextChild;
                                if (child.isSameClass(XFA.EDGETAG)) {
                                    if (nEdges < 4) {
                                        edges[nEdges] = (Element)child;
                                        ++nEdges;
                                        break block27;
                                    } else {
                                        nextChild = child.getNextXFASibling();
                                        child.remove();
                                        child = nextChild;
                                        continue;
                                    }
                                }
                                if (child.isSameClass(XFA.CORNERTAG)) {
                                    if (nCorners < 4) {
                                        corners[nCorners] = (Element)child;
                                        ++nCorners;
                                    } else {
                                        nextChild = child.getNextXFASibling();
                                        child.remove();
                                        child = nextChild;
                                        continue;
                                    }
                                }
                            }
                            child = child.getNextXFASibling();
                        }
                        if (nEdges == 4 && this.isEdgeEqual(edges[0], edges[1]) && this.isEdgeEqual(edges[0], edges[2]) && this.isEdgeEqual(edges[0], edges[3])) {
                            edges[1].remove();
                            edges[2].remove();
                            edges[3].remove();
                        }
                        if (nCorners == 4 && this.isCornerEqual(corners[0], corners[1]) && this.isCornerEqual(corners[0], corners[2]) && this.isCornerEqual(corners[0], corners[3])) {
                            corners[1].remove();
                            corners[2].remove();
                            corners[3].remove();
                        }
                    }
                    if (!element.isSameClass(XFA.CAPTIONTAG)) break block28;
                    Element parent = element.getXFAParent();
                    Node child = element.locateChildByClass(XFA.FONTTAG, 0);
                    if (child != null && (parentElem = parent.getElement(XFA.FONTTAG, true, 0, false, false)) != null && child.compareVersions(parentElem, null, null) && ((Element)child).compareVersionsAttr(parentElem, XFA.USEHREFTAG) && ((Element)child).compareVersionsAttr(parentElem, XFA.USETAG)) {
                        child.remove();
                    }
                    if ((oReserve = (Measurement)element.getAttribute(XFA.RESERVETAG, true, false)) != null) {
                        return;
                    }
                    Element items = element.getXFAParent().getElement(XFA.ITEMSTAG, true, 0, false, false);
                    if (items == null) break block29;
                    break block30;
                }
                if (element.getXFAParent() == null) {
                    return;
                }
                int nodeTag = element.getClassTag();
                int parentTag = element.getXFAParent().getClassTag();
                if (!(bHasChildren || nodeTag != XFA.FILLTAG || parentTag == XFA.FONTTAG || (presence = (EnumValue)element.getAttribute(XFA.PRESENCETAG, true, false)) == null || presence.getInt() != 1076494338 && presence.getInt() != 1076494337 && presence.getInt() != 1076494339)) {
                    element.remove();
                    return;
                }
                if (bHasAttrs || bHasChildren) {
                    return;
                }
                if (nodeTag == XFA.FILLTAG && parentTag != XFA.FONTTAG) {
                    return;
                }
                if (nodeTag == XFA.MARGINTAG && parentTag != XFA.FIELDTAG && parentTag != XFA.DRAWTAG && parentTag != XFA.SUBFORMTAG && parentTag != XFA.BORDERTAG && parentTag != XFA.CAPTIONTAG) {
                    return;
                }
                if (nodeTag == XFA.CORNERTAG) {
                    boolean isDefault = this.isDefault(false);
                    if (isDefault) {
                        element.remove();
                    }
                    return;
                }
                if (nodeTag != XFA.EDGETAG && nodeTag != XFA.BORDERTAG && nodeTag != XFA.CORNERTAG && nodeTag != XFA.COMBTAG) {
                    element.remove();
                    return;
                }
                return;
            }
            for (Node oItem = ((Node)items).getFirstXFAChild(); oItem != null; oItem = oItem.getNextXFASibling()) {
                String sName;
                Element item;
                if (!(oItem instanceof Element) || (item = (Element)oItem).peekAttribute(XFA.NAMETAG) == null || !(sName = item.peekAttribute(XFA.NAMETAG).toString()).equals("rollover") && !sName.equals("down")) continue;
                return;
            }
        }
        NodeList children = element.getNodes();
        int n = children.length();
        int i = 0;
        while (true) {
            if (i >= n) {
                element.remove();
                return;
            }
            if (children.item(i).isSameClass("value")) {
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean doAttributeCleanup(Node pNode, int eAttributeTag, String sAttrValue) {
        if (eAttributeTag == XFA.HTAG || eAttributeTag == XFA.WTAG || eAttributeTag == XFA.INITIALNUMBERTAG || eAttributeTag == XFA.OVERFLOWLEADERTAG || eAttributeTag == XFA.OVERFLOWTRAILERTAG || eAttributeTag == XFA.LEADERTAG || eAttributeTag == XFA.TRAILERTAG) {
            return false;
        }
        return super.doAttributeCleanup(pNode, eAttributeTag, sAttrValue);
    }

    private void orderContainers(Element node) {
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Container)) continue;
            containers.add((Container)child);
        }
        Collections.sort(containers, new Comparator<Container>(){

            @Override
            public int compare(Container left, Container right) {
                double nXRight;
                double nYRight;
                double nYLeft = ((Measurement)left.getAttribute(XFA.YTAG)).getValueAsUnit(0x3C0003);
                if (nYLeft < (nYRight = ((Measurement)right.getAttribute(XFA.YTAG)).getValueAsUnit(0x3C0003))) {
                    return -1;
                }
                if (nYLeft > nYRight) {
                    return 1;
                }
                double nXLeft = ((Measurement)left.getAttribute(XFA.XTAG)).getValueAsUnit(0x3C0003);
                return nXLeft < (nXRight = ((Measurement)right.getAttribute(XFA.XTAG)).getValueAsUnit(0x3C0003)) ? -1 : (nXLeft > nXRight ? 1 : 0);
            }
        });
        for (Container child : containers) {
            node.appendChild(child, false);
            ((Element)child).setModel(this);
        }
    }

    private void orderNodes(Element node) {
        if (node.getFirstXFAChild() == null) {
            return;
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            this.orderNodes((Element)child);
        }
        this.orderContainers(node);
    }

    @Override
    public void postLoad() {
        Node pChild;
        TemplateModel startNode = this;
        this.isLoading(true);
        this.initGenerator();
        String sOriginalNS = this.getOriginalVersion(false);
        if (StringUtils.isEmpty(sOriginalNS) && this.meInputGenerator == 53 && this.mnOriginalTemplateVersion == 21) {
            this.setCurrentVersion(22);
            this.setNeedsNSNormalize(true);
            this.mnOriginalTemplateVersion = 22;
            this.setNameSpaceURI("http://www.xfa.org/schema/xfa-template/2.2/", false, false, true);
        }
        this.loadNode(this.getXFAParent(), startNode, this.getGenerator());
        if (pChild != null) {
            Element pTopLevelSubform;
            boolean bFoundTopLevelSubform = false;
            for (pChild = this.getFirstXFAChild(); pChild != null; pChild = pChild.getNextXFASibling()) {
                if (!pChild.isSameClass(XFA.SUBFORMTAG)) continue;
                bFoundTopLevelSubform = true;
                break;
            }
            if (bFoundTopLevelSubform && (pChild = (pTopLevelSubform = (Element)pChild).getFirstXFAChild()) != null) {
                boolean bFound = false;
                int i = 0;
                while (pChild != null) {
                    if (pChild.isSameClass(XFA.PAGESETTAG)) {
                        bFound = true;
                        break;
                    }
                    ++i;
                    pChild = pChild.getNextXFASibling();
                }
                if (bFound && i > 0) {
                    pTopLevelSubform.insertChild(pChild, pTopLevelSubform.getFirstXFAChild(), false);
                }
            }
        }
        this.resolveProtos(false);
        TemplateModelFixup tmf = null;
        if (this.mbApplyFixups) {
            tmf = new TemplateModelFixup(this, this.mbFixupRenderCache);
            tmf.processFixups();
        }
        if (this.mbApplyFixups && tmf != null) {
            tmf.applyFixups(this);
        }
        this.isLoading(false);
    }

    private void doLoadNode(Element element) {
        try {
            int nAttributes = element.getNumAttrs();
            for (int i = 0; i < nAttributes; ++i) {
                Attribute attr = element.getAttr(i);
                this.loadSpecialAttribute(attr, attr.getLocalName(), element, false);
            }
            if (element instanceof ExDataValue) {
                ExDataValue exData = (ExDataValue)element;
                boolean bIsRichText = false;
                boolean bIsXmlContent = false;
                int index = exData.findAttr(null, "contentType");
                if (index != -1) {
                    String contentType = exData.getAttrVal(index);
                    if (contentType.equals("text/xml")) {
                        bIsXmlContent = true;
                    } else if (contentType.equals("text/html")) {
                        bIsRichText = true;
                    }
                }
                if (bIsXmlContent) {
                    String sOpen;
                    Element choiceList;
                    Element ui;
                    Element grandParent;
                    bIsXmlContent = false;
                    Element parent = element.getXFAParent();
                    if (parent instanceof Value && (grandParent = parent.getXFAParent()) instanceof Field && (ui = (Element)grandParent.locateChildByClass(XFA.UITAG, 0)) != null && (choiceList = (Element)ui.locateChildByClass(XFA.CHOICELISTTAG, 0)) != null && (index = choiceList.findAttr(null, "open")) != -1 && (sOpen = choiceList.getAttrVal(index)).equals("multiSelect")) {
                        bIsXmlContent = true;
                    }
                }
                boolean previousWillDirty = this.getDocument().getWillDirty();
                this.getOwnerDocument().setWillDirty(false);
                Node child = exData.getFirstXMLChild();
                while (child != null) {
                    child = this.preLoadNode(element, child, this.getGenerator());
                }
                Node[] children = new Node[exData.getXMLChildCount()];
                int i = 0;
                Node child2 = exData.getFirstXMLChild();
                while (child2 != null) {
                    Node nextChild = child2.getNextXMLSibling();
                    children[i] = child2;
                    child2.remove();
                    child2 = nextChild;
                    ++i;
                }
                for (i = 0; i < children.length; ++i) {
                    child2 = children[i];
                    if (!(child2 instanceof TextNode) && !(child2 instanceof Element)) {
                        exData.appendChild(child2);
                        continue;
                    }
                    boolean bLoadNode = true;
                    if (bIsRichText) {
                        if (child2 instanceof TextNode && ((TextNode)child2).isXMLSpace()) continue;
                        if (child2 instanceof Element && ((Element)child2).getNS() == "http://www.w3.org/1999/xhtml") {
                            RichTextNode newRichText;
                            RichTextNode newRichTextNode = new RichTextNode(null, null);
                            if (this.convertGenericContentElement(exData, (Element)child2, newRichTextNode) && !this.validateUsage((newRichText = newRichTextNode).getVersionRequired(), 0, this.getAppModel().bumpVersionOnRichTextLoad())) {
                                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidChildVersionException);
                                reason.format("");
                                reason.format(newRichText.getClassAtom());
                                this.addErrorList(new ExFull(reason), 3, newRichText);
                            }
                            bLoadNode = false;
                        }
                    }
                    if (bIsXmlContent) {
                        if (child2 instanceof TextNode && ((TextNode)child2).isXMLSpace()) continue;
                        if (child2 instanceof Element) {
                            XMLMultiSelectNode newMultiSelectNode = new XMLMultiSelectNode(null, null);
                            this.convertGenericContentElement(exData, (Element)child2, newMultiSelectNode);
                            bLoadNode = false;
                        }
                    }
                    if (!bLoadNode) continue;
                    if (child2 instanceof Element) {
                        Element childElement = (Element)child2;
                        int eTag = this.getSchema().getElementTag(childElement.getNS(), childElement.getLocalName());
                        if (eTag != -1 && (childElement.getNS() == "" || childElement.getNS().startsWith("http://www.xfa.org/schema/xfa-template/"))) {
                            MsgFormatPos msg = new MsgFormatPos(ResId.InvalidChildAppendException, exData.getClassName());
                            msg.format(((Element)child2).getLocalName());
                            ExFull ex = new ExFull(msg);
                            this.addXMLLoadErrorContext(child2, ex);
                            this.getModel().addErrorList(ex, 5, exData);
                        } else {
                            childElement.inhibitPrettyPrint(true);
                        }
                        exData.appendChild(childElement, false);
                        continue;
                    }
                    if (!(child2 instanceof TextNode)) continue;
                    try {
                        exData.appendChild(child2, true);
                        continue;
                    }
                    catch (ExFull ex) {
                        exData.appendChild(child2, false);
                        throw ex;
                    }
                }
                this.getDocument().setWillDirty(previousWillDirty);
            } else {
                for (Node child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!(child instanceof Element)) continue;
                    this.doLoadNode((Element)child);
                }
            }
        }
        catch (ExFull ex) {
            this.getModel().addErrorList(ex, 5, null);
        }
    }

    private boolean convertGenericContentElement(Element parent, Element contentElement, Element newNode) {
        assert (contentElement.getClassTag() == XFA.INVALID_ELEMENT);
        assert (newNode.getClassTag() == XFA.RICHTEXTNODETAG || newNode.getClassTag() == XFA.XMLMULTISELECTNODETAG);
        newNode.setModel(this);
        newNode.setDocument(this.getOwnerDocument());
        newNode.setDOMProperties(contentElement.getNS(), contentElement.getLocalName(), contentElement.getXMLName(), null);
        newNode.setLineNumber(contentElement.getLineNumber());
        for (int i = 0; i < contentElement.getNumAttrs(); ++i) {
            Attribute a = contentElement.getAttr(i);
            newNode.setAttribute(a.getNS(), a.getQName(), a.getLocalName(), a.getAttrValue(), false);
        }
        try {
            parent.appendChild(newNode, true);
        }
        catch (ExFull ex) {
            this.getModel().addErrorList(ex, 5, null);
            parent.appendChild(contentElement, false);
            return false;
        }
        Node child = contentElement.getFirstXMLChild();
        while (child != null) {
            Node nextSibling = child.getNextXMLSibling();
            newNode.appendChild(child, false);
            child = nextSibling;
        }
        contentElement.remove();
        return true;
    }

    void setAsGlobalField(Node poNodeImpl) {
        String aName = poNodeImpl.getName();
        for (int i = 0; i < this.moGlobalFields.size(); ++i) {
            if (this.moGlobalFields.get(i) != aName) continue;
            return;
        }
        this.moGlobalFields.add(poNodeImpl.getName());
    }

    public void setLegacySetting(AppModel.LegacyMask nLegacyFlags, boolean bValue) {
        this.mnOriginalVersion = this.getOriginalXFAVersion();
        AppModel.LegacyMask oLegacyInfo = new AppModel.LegacyMask(this.mnLegacyInfo);
        this.updateLegacyFlags(bValue, nLegacyFlags, oLegacyInfo);
        this.mnLegacyInfo = new AppModel.LegacyMask(oLegacyInfo);
        this.updateOriginalXFAVersionPI();
    }

    public boolean cleanupLegacySetting(AppModel.LegacyMask nIgnoreLegacyFlags) {
        this.getOriginalXFAVersion();
        int nCurrentVersion = this.getCurrentVersion();
        AppModel.LegacyMask nDefaultFlags = new AppModel.LegacyMask(this.getXFALegacyDefaultsForXFAVersion(nCurrentVersion));
        AppModel.LegacyMask nCurrentFlags = new AppModel.LegacyMask(this.mnLegacyInfo);
        if (nIgnoreLegacyFlags.isNonZero()) {
            AppModel.LegacyMask nDefaultFlagsHolder = new AppModel.LegacyMask(nDefaultFlags);
            this.updateLegacyFlags(false, nIgnoreLegacyFlags, nDefaultFlagsHolder);
            nDefaultFlags = new AppModel.LegacyMask(nDefaultFlagsHolder);
            AppModel.LegacyMask nCurrentFlagsHolder = new AppModel.LegacyMask(nCurrentFlags);
            this.updateLegacyFlags(false, nIgnoreLegacyFlags, nCurrentFlagsHolder);
            nCurrentFlags = new AppModel.LegacyMask(nCurrentFlagsHolder);
        }
        if (nCurrentFlags.equals(nDefaultFlags)) {
            this.removeOriginalVersionNode();
            return true;
        }
        return false;
    }

    @Override
    public void setOriginalXFAVersion(int nXFAVersion) {
        if (nXFAVersion == 0) {
            this.mnLegacyInfo = new AppModel.LegacyMask(0);
        }
        super.setOriginalXFAVersion(nXFAVersion);
    }

    void setTemplateResolver(TemplateResolver oResolver) {
        this.moTemplateResolver = oResolver;
    }

    public List<Insertion> splice(List<Insertion> insertions, boolean removeInsertionPoints) {
        HashSet<String> usedKeys = new HashSet<String>(insertions.size());
        ArrayList<String> insertionStack = new ArrayList<String>();
        this.spliceInternal(this, insertions, removeInsertionPoints, usedKeys, insertionStack, "");
        ArrayList<Insertion> result = null;
        for (Insertion insertion : insertions) {
            if (usedKeys.contains(insertion.getKey())) continue;
            if (result == null) {
                result = new ArrayList<Insertion>();
            }
            result.add(insertion);
        }
        return result;
    }

    private void spliceInternal(Element startNode, List<Insertion> insertions, boolean removeInsertionPoints, Set<String> usedKeys, List<String> insertionStack, String basePath) {
        ArrayList<TextValue> insertionPoints = new ArrayList<TextValue>();
        ArrayList<TextValue> insertionPointPlaceholders = new ArrayList<TextValue>();
        this.findInsertionPoints(startNode, insertionPoints, insertionPointPlaceholders);
        for (Insertion insertion : insertions) {
            if (insertion.getKey() == null || insertion.getReference() == null || insertion.getReference().trim().length() == 0) continue;
            for (TextValue textValue : insertionPoints) {
                URI ref;
                String path;
                int index;
                Element insertionPoint;
                Element insertionPointParent;
                if (!insertion.getKey().equals(textValue.toString()) || (insertionPointParent = (insertionPoint = textValue.getXFAParent().getXFAParent()).getXFAParent()) == null || insertion.getContainedBySom() != null && insertion.getContainedBySom().trim().length() != 0 && !this.isElementContainedWithinSom(insertionPoint, insertion.getContainedBySom())) continue;
                if (insertionStack.contains(insertion.getKey())) {
                    StringBuilder buf = new StringBuilder("splice: '");
                    for (String key2 : insertionStack) {
                        buf.append(key2);
                        buf.append("'->'");
                    }
                    buf.append(insertion.getKey());
                    buf.append('\'');
                    ExFull ex = new ExFull(new MsgFormatPos(ResId.CircularProtoException, buf.toString()));
                    this.addErrorList(ex, 3, insertionPoint);
                    return;
                }
                ProtoableNode clonedInsertionPoint = (ProtoableNode)insertionPoint.clone(null, true);
                insertionPointParent.insertChild(clonedInsertionPoint, insertionPoint, false);
                Element extras = clonedInsertionPoint.getElement(XFA.EXTRASTAG, 0);
                for (Node child = extras.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    TextValue clonedInsertionPointTextValue;
                    if (!(child instanceof TextValue) || !(clonedInsertionPointTextValue = (TextValue)child).getName().equals(INSERTION_POINT_NAME)) continue;
                    clonedInsertionPointTextValue.remove();
                    break;
                }
                this.removeInsertionPointPlaceholders(clonedInsertionPoint);
                if (extras.getFirstXFAChild() == null) {
                    extras.remove();
                }
                clonedInsertionPoint.setAttribute(new StringAttr("usehref", insertion.getReference()), XFA.USEHREFTAG);
                clonedInsertionPoint.isFragment(false, true);
                String uri = insertion.getReference();
                int sharp = uri.indexOf(35);
                if (sharp >= 0) {
                    uri = uri.substring(0, sharp);
                }
                path = (index = (path = (ref = URI.create(uri).normalize()).getPath()).lastIndexOf(47)) == -1 ? "" : path.substring(0, index + 1);
                String string = basePath = ref.isAbsolute() ? ref.toString() : URI.create(basePath + path).normalize().toString();
                if (basePath != null && !StringUtils.isEmpty(basePath)) {
                    TemplateModel.rebaseRelativeReferencesInFragment(clonedInsertionPoint, basePath);
                }
                insertionStack.add(insertion.getKey());
                this.spliceInternal(clonedInsertionPoint, insertions, removeInsertionPoints, usedKeys, insertionStack, basePath);
                insertionStack.remove(insertionStack.size() - 1);
                usedKeys.add(insertion.getKey());
            }
        }
        if (removeInsertionPoints) {
            for (TextValue textValue : insertionPoints) {
                textValue.getXFAParent().getXFAParent().remove();
            }
        }
        for (TextValue textValue : insertionPointPlaceholders) {
            textValue.getXFAParent().getXFAParent().remove();
        }
    }

    private boolean isElementContainedWithinSom(Element element, String containedBySom) {
        NodeList nodes = this.resolveNodes(containedBySom, true, false, false);
        for (int i = 0; i < nodes.length(); ++i) {
            Node contextNode = (Node)nodes.item(i);
            for (Element parent = element; parent != null; parent = parent.getXFAParent()) {
                if (parent != contextNode) continue;
                return true;
            }
        }
        return false;
    }

    private void findInsertionPoints(Element element, List<TextValue> insertionPoints, List<TextValue> insertionPointPlaceholders) {
        Node child;
        if (element.getClassTag() == XFA.EXTRASTAG && element.getXFAParent() instanceof ProtoableNode) {
            for (child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof TextValue)) continue;
                TextValue textValue = (TextValue)child;
                if (textValue.getName().equals(INSERTION_POINT_NAME)) {
                    insertionPoints.add(textValue);
                    continue;
                }
                if (!textValue.getName().equals(INSERTION_POINT_PLACEHOLDER_NAME)) continue;
                insertionPointPlaceholders.add(textValue);
            }
        }
        for (child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            this.findInsertionPoints((Element)child, insertionPoints, insertionPointPlaceholders);
        }
    }

    private void removeInsertionPointPlaceholders(Node node) {
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            TextValue clonedInsertionPointTextValue;
            if (child instanceof TextValue && (clonedInsertionPointTextValue = (TextValue)child).getName().equals(INSERTION_POINT_PLACEHOLDER_NAME)) {
                clonedInsertionPointTextValue.getXFAParent().getXFAParent().remove();
            }
            this.removeInsertionPointPlaceholders(child);
        }
    }

    private static void rebaseRelativeReferencesInFragment(Element node, String base) {
        int index;
        assert (base.length() > 1 && base.endsWith("/"));
        String schemaAttrName = null;
        if (node.getClassTag() == XFA.IMAGETAG || node.getClassTag() == XFA.EXDATATAG) {
            schemaAttrName = "href";
        } else if (node.getClassTag() == XFA.EXOBJECTTAG) {
            schemaAttrName = "codeBase";
        }
        if (schemaAttrName != null && (index = node.findSchemaAttr(schemaAttrName)) != -1) {
            try {
                Attribute attr = node.getAttr(index);
                URI uri = new URI(attr.getAttrValue());
                if (!uri.toString().equals("") && !uri.isAbsolute()) {
                    String rebasedURI = URI.create(base + attr.getAttrValue()).normalize().toString();
                    node.setAttribute(attr.getNS(), attr.getQName(), attr.getLocalName(), rebasedURI, false);
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            TemplateModel.rebaseRelativeReferencesInFragment((Element)child, base);
        }
    }

    public void synchronizeXMPMetaData(String sCreatorTool, String sProducer) {
        AppModel appModel = this.getAppModel();
        if (appModel == null) {
            return;
        }
        try {
            XMPHelper oXMP = new XMPHelper(appModel, XMPHelper.getXMPPacket(appModel), "", true);
            oXMP.setCreatorTool(sCreatorTool, false);
            oXMP.setProducer(sProducer, false);
            oXMP.synchronize(true);
        }
        catch (Exception ex) {
            throw new ExFull(ex);
        }
    }

    @Override
    protected void updateOriginalXFAVersionPI() {
        if (!ACROBAT_PLUGIN) {
            String sPIValue = this.getNS(this.mnOriginalVersion);
            int nVersion = this.getVersion(sPIValue);
            AppModel.LegacyMask nDefaults = this.getXFALegacyDefaultsForXFAVersion(nVersion);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_POSITIONING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_EVENTMODEL, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_PLUSPRINT, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_PERMISSIONS, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_CALCOVERRIDE, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_RENDERING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V26_HIDDENPOSITIONED, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_MULTIRECORDCONTEXTCACHE, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_LAYOUT, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_EVENTMODEL, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_TRAVERSALORDER, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V27_ACCESSIBILITY, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V28_LAYOUT, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V28_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V29_LAYOUT, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V29_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V30_LAYOUT, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V30_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V29_TRAVERSALORDER, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_PATCH_B_02518, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V29_FIELDPRESENCE, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_PATCH_W_2393121, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_PATCH_W_2447677, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_PATCH_W_2757988, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_PATCH_W_2693910, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V32_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V32_CANONICALIZATION, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_LEGACY_V34_SCRIPTING, nDefaults);
            sPIValue = TemplateModel.updateLegacyString(sPIValue, this.mnLegacyInfo, AppModel.XFA_OVERFLOW_TARGET_ALTERNATE, nDefaults);
            ProcessingInstruction oPI = this.getOriginalVersionNode(false, "");
            if (oPI == null) {
                this.getOriginalVersionNode(true, sPIValue);
            } else {
                oPI.setData(sPIValue);
            }
        }
    }

    public boolean validateGlobalField(Element poNodeImpl) {
        Element poBind;
        int eMatch = 0x1F0001;
        if (poNodeImpl.isSameClass(XFA.FIELDTAG) && (poBind = poNodeImpl.getElement(XFA.BINDTAG, true, 0, false, false)) != null) {
            EnumValue eValue = (EnumValue)poBind.getAttribute(XFA.MATCHTAG);
            eMatch = eValue.getInt();
        }
        String aName = poNodeImpl.getName();
        for (int i = 0; i < this.moGlobalFields.size(); ++i) {
            if (this.moGlobalFields.get(i) != aName) continue;
            return eMatch == 2031618;
        }
        return true;
    }

    public void invalidMethod(String sName) {
    }

    public void adjustForVersion(int nVersion) {
        if (nVersion == 0) {
            nVersion = this.getCurrentVersion();
        }
        if (nVersion >= 26) {
            return;
        }
        this.adjustForVersion(this, nVersion);
    }

    private void adjustForVersion(Element element, int nVersion) {
        Element subform;
        if (element.isSameClass(XFA.BREAKTAG)) {
            Element pageSet = this.findPageSet(element);
            subform = element.getXFAParent();
            assert (subform == null || subform instanceof Subform);
            this.adjustAttributeForVersion(element, XFA.AFTERTARGETTAG, pageSet, nVersion);
            this.adjustAttributeForVersion(element, XFA.BEFORETARGETTAG, pageSet, nVersion);
            this.adjustAttributeForVersion(element, XFA.OVERFLOWTARGETTAG, subform, nVersion);
            this.adjustAttributeForVersion(element, XFA.OVERFLOWLEADERTAG, subform, nVersion);
            this.adjustAttributeForVersion(element, XFA.OVERFLOWTRAILERTAG, subform, nVersion);
            this.adjustAttributeForVersion(element, XFA.BOOKENDLEADERTAG, subform, nVersion);
            this.adjustAttributeForVersion(element, XFA.BOOKENDTRAILERTAG, subform, nVersion);
        } else if (element.isSameClass(XFA.BREAKAFTERTAG) || element.isSameClass(XFA.BREAKBEFORETAG) || element.isSameClass(XFA.OVERFLOWTAG)) {
            Element contextNode = null;
            if (element.isSameClass(XFA.OVERFLOWTAG)) {
                subform = element.getXFAParent();
                assert (subform == null || subform instanceof Subform);
                contextNode = subform;
            } else {
                contextNode = this.findPageSet(element);
            }
            this.adjustAttributeForVersion(element, XFA.TARGETTAG, contextNode, nVersion);
            this.adjustAttributeForVersion(element, XFA.LEADERTAG, contextNode, nVersion);
            this.adjustAttributeForVersion(element, XFA.TRAILERTAG, contextNode, nVersion);
        } else if (element.isSameClass(XFA.BOOKENDTAG)) {
            Element subform2 = element.getXFAParent();
            assert (subform2 == null || subform2 instanceof Subform);
            this.adjustAttributeForVersion(element, XFA.LEADERTAG, subform2, nVersion);
            this.adjustAttributeForVersion(element, XFA.TRAILERTAG, subform2, nVersion);
        }
        for (Node child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Element)) continue;
            this.adjustForVersion((Element)child, nVersion);
        }
    }

    private void adjustAttributeForVersion(Element element, int eTag, Element contextNode, int version) {
        String sAttrValue;
        Attribute oAttr = null;
        if (element.isPropertySpecified(eTag, false, 0)) {
            oAttr = element.getAttribute(eTag);
        }
        if (oAttr != null && !(sAttrValue = oAttr.getAttrValue()).startsWith("#")) {
            String sSOM = sAttrValue;
            if (sSOM.startsWith("som(") && sSOM.endsWith(")")) {
                sSOM = sSOM.substring(4, sSOM.length() - 1);
            }
            Node oTargetNode = null;
            if (contextNode != null) {
                oTargetNode = contextNode.resolveNode(sSOM);
            }
            if (oTargetNode instanceof Element) {
                String sID = ((Element)oTargetNode).establishID();
                element.setAttribute(new StringAttr("value", "#" + sID), eTag);
            } else {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.CannotConvertSOMToID);
                oMessage.format(sSOM);
                oMessage.format(element.getSOMExpression());
                Model model = element.getModel();
                if (model != null) {
                    model.addErrorList(new ExFull(oMessage), 3, this);
                }
            }
        }
    }

    private Element findPageSet(Element element) {
        for (Element parent = element; parent != null; parent = parent.getXFAParent()) {
            if (!(parent instanceof Subform)) continue;
            for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof PageSet)) continue;
                return (Element)child;
            }
        }
        return null;
    }

    @Override
    public boolean publish(Model.Publisher publisher) {
        HashMap<String, String> hrefCache = new HashMap<String, String>();
        this.publishNode(publisher, this, hrefCache);
        return super.publish(publisher);
    }

    private void publishNode(Model.Publisher publisher, Node node, Map<String, String> hrefCache) {
        if (node instanceof ProtoableNode) {
            ProtoableNode protoableNode = (ProtoableNode)node;
            if (protoableNode.isPropertySpecified(XFA.USEHREFTAG, true, 0)) {
                String sNewURL;
                String sURL = protoableNode.getAttribute(XFA.USEHREFTAG).getAttrValue();
                int nHash = sURL.indexOf(35);
                String sFragIdent = "";
                if (nHash != -1) {
                    sFragIdent = sURL.substring(nHash);
                    sURL = sURL.substring(0, nHash);
                }
                if (StringUtils.isEmpty(sNewURL = hrefCache.get(sURL))) {
                    sNewURL = publisher.updateExternalRef(node, XFA.USEHREFTAG, sURL);
                    hrefCache.put(sURL, sNewURL);
                }
                if (!sURL.equals(sNewURL)) {
                    sNewURL = sNewURL + sFragIdent;
                    protoableNode.setAttribute(new StringAttr("usehref", sNewURL), XFA.USEHREFTAG);
                }
            }
            if (protoableNode.isPropertySpecified(XFA.HREFTAG, true, 0)) {
                String sHref = protoableNode.getAttribute(XFA.HREFTAG).getAttrValue();
                String sNewHRef = hrefCache.get(sHref);
                if (StringUtils.isEmpty(sNewHRef)) {
                    sNewHRef = publisher.updateExternalRef(node, XFA.HREFTAG, sHref);
                    hrefCache.put(sHref, sNewHRef);
                }
                if (!sHref.equals(sNewHRef)) {
                    protoableNode.setAttribute(new StringAttr("href", sNewHRef), XFA.HREFTAG);
                }
            }
        }
        if (node instanceof RichTextNode) {
            RichTextNode richTextNode = (RichTextNode)node;
            ArrayList<Element> anchors = new ArrayList<Element>();
            this.getElementsByTagNamesNS(this, richTextNode.getNS(), "a", anchors);
            int nAnchors = anchors.size();
            for (int j = 0; j < nAnchors; ++j) {
                String sNewHRef;
                Element oAnchor = (Element)anchors.get(j);
                Attribute href = oAnchor.getAttribute(XFA.HREFTAG);
                if (href == null) continue;
                String sHref = href.getAttrValue();
                String sQuery = "";
                int nFoundAt = sHref.indexOf(63);
                if (nFoundAt == -1) {
                    nFoundAt = sHref.indexOf(35);
                }
                if (nFoundAt != -1) {
                    sQuery = sHref.substring(nFoundAt);
                    sHref = sHref.substring(0, nFoundAt);
                }
                if (StringUtils.isEmpty(sNewHRef = hrefCache.get(sHref))) {
                    sNewHRef = publisher.updateExternalRef(node, XFA.HREFTAG, sHref);
                    hrefCache.put(sHref, sNewHRef);
                }
                if (sHref.equals(sNewHRef)) continue;
                sNewHRef = sNewHRef + sQuery;
                richTextNode.setAttribute(new StringAttr("href", sNewHRef), XFA.HREFTAG);
            }
        }
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.publishNode(publisher, child, hrefCache);
        }
    }

    private void getElementsByTagNamesNS(Node node, String ns, String name, List<Element> anchors) {
        for (Node child = node.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            Element element;
            if (child instanceof Element && (element = (Element)child).getNS().equals(ns) && element.getLocalName().equals(name)) {
                anchors.add(element);
            }
            this.getElementsByTagNamesNS(child, ns, name, anchors);
        }
    }

    @Override
    public Node preLoadNode(Element parent, Node node, Generator genTag) {
        Node nextSibling = node.getNextXMLSibling();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            ChildReln childReln = parent.getChildReln(XFA.TEXTNODETAG);
            if (childReln == null || parent instanceof ExDataValue) {
                if (textNode.isXMLSpace()) {
                    nextSibling = textNode.getNextXMLSibling();
                    textNode.remove();
                }
            } else if (childReln.getMax() == 1) {
                Node child = nextSibling;
                while (child != null) {
                    Node nextChild = child.getNextXMLSibling();
                    if (child instanceof TextNode) {
                        textNode.setText(textNode.getText() + ((TextNode)child).getText());
                        child.remove();
                    }
                    child = nextChild;
                }
                nextSibling = textNode.getNextXMLSibling();
            }
        }
        String original = this.getOriginalVersion(false);
        super.preLoadNode(parent, node, genTag);
        if (!this.getOriginalVersion(false).equals(original)) {
            this.mnOriginalVersion = 0;
        }
        return nextSibling;
    }

    public static class Insertion {
        private final String key;
        private final String reference;
        private final String containedBySom;

        public Insertion(String key, String reference) {
            this.key = key;
            this.reference = reference;
            this.containedBySom = null;
        }

        public Insertion(String key, String reference, String somContext) {
            this.key = key;
            this.reference = reference;
            this.containedBySom = somContext;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getReference() {
            return this.reference;
        }

        public final String getContainedBySom() {
            return this.containedBySom;
        }
    }

    static final class LikeNamedContainers {
        public final List<ContainerIndex> containers = new ArrayList<ContainerIndex>();
        public final String likeName;

        public LikeNamedContainers(String likeName) {
            this.likeName = likeName;
        }
    }

    static final class IndexTableElement {
        public final List<LikeNamedContainers> likeChildren = new ArrayList<LikeNamedContainers>();
        public final Object parent;

        public IndexTableElement(Object parent) {
            this.parent = parent;
        }
    }

    static final class ContainerIndex {
        public final int nContainerIndex;
        public final Object container;

        public ContainerIndex(int nContainerIndex, Object container) {
            this.nContainerIndex = nContainerIndex;
            this.container = container;
        }
    }
}

