/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.localeset;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.localeset.LocaleSetModelFactory;
import com.adobe.xfa.localeset.LocaleSetSchema;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.service.storage.XMLStorage;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class LocaleSetModel
extends Model {
    private static final int[] geDateTimePats = new int[]{-2142175232, -2142175231, -2142175230, -2142175229};
    private static final int[] geNumPats = new int[]{-2142109696, -2142109695, -2142109694};
    private static final LocaleSetSchema gLocaleSchema = new LocaleSetSchema();
    private static final String gsAmbient = "ambient";

    @Override
    public Node createNode(int eTag, Element parent, String aName, String aNS, boolean bDoVersionCheck) {
        assert (aName != null);
        assert (aNS != null);
        Element retVal = this.getSchema().getInstance(eTag, this, parent, null, bDoVersionCheck);
        if (aName != "") {
            retVal.setName(aName);
        }
        return retVal;
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xfa-locale-set/";
    }

    @Override
    public String getHeadNS() {
        return LocaleSetModel.localeSetNS();
    }

    public static LocaleSetModel getLocaleSetModel(AppModel appModel, boolean bCreateIfNotFound) {
        LocaleSetModel lsm = (LocaleSetModel)Model.getNamedModel(appModel, "localeSet");
        if (bCreateIfNotFound && lsm == null) {
            LocaleSetModelFactory factory = new LocaleSetModelFactory();
            lsm = (LocaleSetModel)factory.createDOM((Element)appModel.getXmlPeer());
            lsm.setDocument(appModel.getDocument());
            appModel.notifyPeers(4, "localeSet", lsm);
        }
        return lsm;
    }

    protected static Schema getModelSchema() {
        return gLocaleSchema;
    }

    public static String localeSetNS() {
        return "http://www.xfa.org/schema/xfa-locale-set/2.7/";
    }

    public static boolean setLocaleSetModel(AppModel oAppModel, Element oNode) {
        ArrayList<String> oLocales = new ArrayList<String>();
        LocaleSetModel.find(oNode, oLocales);
        if (oLocales.size() == 0) {
            return true;
        }
        LocaleSetModel oModel = LocaleSetModel.getLocaleSetModel(oAppModel, true);
        ArrayList<String> oLsLocales = new ArrayList<String>();
        LocaleSetModel.find(oModel, oLsLocales);
        int n = oLsLocales.size();
        block0: for (int i = oLocales.size(); i > 0; --i) {
            for (int j = 0; j < n; ++j) {
                if (oLsLocales.get(j) != oLocales.get(i - 1)) continue;
                oLocales.remove(i - 1);
                continue block0;
            }
        }
        int nLocales = oLocales.size();
        if (nLocales == 0) {
            return true;
        }
        Element oLocaleSym = oModel.createElement(null, null, null, "locale", "locale", null, 0, null);
        Element oCalendarSyms = oModel.createElement(null, null, null, "calendarSymbols", "calendarSymbols", null, 0, null);
        Element oMonthNames = oModel.createElement(null, null, null, "monthNames", "monthNames", null, 0, null);
        Element oDayNames = oModel.createElement(null, null, null, "dayNames", "dayNames", null, 0, null);
        Element oMeridiemNames = oModel.createElement(null, null, null, "meridiemNames", "meridiemNames", null, 0, null);
        Element oEraNames = oModel.createElement(null, null, null, "eraNames", "eraNames", null, 0, null);
        Element oDatePats = oModel.createElement(null, null, null, "datePatterns", "datePatterns", null, 0, null);
        Element oTimePats = oModel.createElement(null, null, null, "timePatterns", "timePatterns", null, 0, null);
        Element oDateTimeSym = oModel.createElement(null, null, null, "dateTimeSymbols", "dateTimeSymbols", null, 0, null);
        Element oNumPats = oModel.createElement(null, null, null, "numberPatterns", "numberPatterns", null, 0, null);
        Element oNumSyms = oModel.createElement(null, null, null, "numberSymbols", "numberSymbols", null, 0, null);
        Element oCurSyms = oModel.createElement(null, null, null, "currencySymbols", "currencySymbols", null, 0, null);
        Element oTypefaces = oModel.createElement(null, null, null, "typefaces", "typefaces", null, 0, null);
        Model model = oLocaleSym.getModel();
        boolean bLocalesOk = true;
        for (int i = 0; i < nLocales; ++i) {
            Element oSym;
            TextNode tval;
            TextNode tval2;
            Element oDay;
            int j;
            TextNode tval3;
            Element oMonth;
            int j2;
            String sLocale = (String)oLocales.get(i);
            LcLocale oLocale = new LcLocale(sLocale);
            if (!oLocale.isValid()) {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.LocaleUnknown);
                oMessage.format(sLocale);
                ExFull oErr = new ExFull(oMessage.resId(), oMessage.toString());
                model.addErrorList(oErr, 3, oNode);
                bLocalesOk = false;
                continue;
            }
            LcData oLcData = new LcData(oLocale.getIsoName());
            Element oLocaleSymClone = oLocaleSym.clone(null, true);
            Attribute oProp = new StringAttr("name", oLocale.getIsoName());
            oLocaleSymClone.setAttribute(oProp, XFA.NAMETAG);
            String sDesc = "";
            if (!StringUtils.isEmpty(sDesc)) {
                oProp = new StringAttr("desc", sDesc);
                oLocaleSymClone.setAttribute(oProp, XFA.DESCTAG);
            }
            oModel.appendChild(oLocaleSymClone, false);
            Element oCalendarSymsClone = oCalendarSyms.clone(null, true);
            oProp = new StringAttr("name", "gregorian");
            oCalendarSymsClone.setAttribute(oProp, XFA.NAMETAG);
            oLocaleSymClone.appendChild(oCalendarSymsClone, false);
            Element oMonthNamesClone = oMonthNames.clone(null, true);
            for (j2 = 0; j2 <= 11; ++j2) {
                oMonth = oMonthNamesClone.getElement(XFA.MONTHTAG, j2);
                tval3 = oMonth.getText(false, true, false);
                tval3.setValue(oLcData.getMonthName(j2), true, false);
            }
            oCalendarSymsClone.appendChild(oMonthNamesClone, false);
            oMonthNamesClone = oMonthNames.clone(null, true);
            oProp = new StringAttr("abbr", "1");
            oMonthNamesClone.setAttribute(oProp, XFA.ABBRTAG);
            for (j2 = 0; j2 <= 11; ++j2) {
                oMonth = oMonthNamesClone.getElement(XFA.MONTHTAG, j2);
                tval3 = oMonth.getText(false, true, false);
                tval3.setValue(oLcData.getAbbrMonthName(j2), true, false);
            }
            oCalendarSymsClone.appendChild(oMonthNamesClone, false);
            Element oDayNamesClone = oDayNames.clone(null, true);
            for (j = 0; j <= 6; ++j) {
                oDay = oDayNamesClone.getElement(XFA.DAYTAG, j);
                tval2 = oDay.getText(false, true, false);
                tval2.setValue(oLcData.getWeekDayName(j), true, false);
            }
            oCalendarSymsClone.appendChild(oDayNamesClone, false);
            oDayNamesClone = oDayNames.clone(null, true);
            oProp = new StringAttr("abbr", "1");
            oDayNamesClone.setAttribute(oProp, XFA.ABBRTAG);
            for (j = 0; j <= 6; ++j) {
                oDay = oDayNamesClone.getElement(XFA.DAYTAG, j);
                tval2 = oDay.getText(false, true, false);
                tval2.setValue(oLcData.getAbbrWeekdayName(j), true, false);
            }
            oCalendarSymsClone.getNodes().append(oDayNamesClone);
            Element oMeridiemNamesClone = oMeridiemNames.clone(null, true);
            for (int j3 = 0; j3 <= 1; ++j3) {
                Element oMeri = oMeridiemNamesClone.getElement(XFA.MERIDIEMTAG, j3);
                TextNode tval4 = oMeri.getText(false, true, false);
                tval4.setValue(oLcData.getMeridiemName(j3), true, false);
            }
            oCalendarSymsClone.getNodes().append(oMeridiemNamesClone);
            Element oEraNamesClone = oEraNames.clone(null, true);
            for (int j4 = 0; j4 <= 1; ++j4) {
                Element oEra = oEraNamesClone.getElement(XFA.ERATAG, j4);
                TextNode tval5 = oEra.getText(false, true, false);
                tval5.setValue(oLcData.getEraName(j4), true, false);
            }
            oCalendarSymsClone.getNodes().append(oEraNamesClone);
            Element oDatePatsClone = oDatePats.clone(null, true);
            for (int j5 = 0; j5 <= 3; ++j5) {
                Element oPat = oDatePatsClone.getElement(XFA.DATEPATTERNTAG, j5);
                oProp = EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(geDateTimePats[j5]));
                oPat.setAttribute(oProp, XFA.NAMETAG);
                tval = oPat.getText(false, true, false);
                tval.setValue(oLcData.getDateFormat(3 - j5 + 1), true, false);
            }
            oLocaleSymClone.getNodes().append(oDatePatsClone);
            Element oTimePatsClone = oTimePats.clone(null, true);
            for (int j6 = 0; j6 <= 3; ++j6) {
                Element oPat = oTimePatsClone.getElement(XFA.TIMEPATTERNTAG, j6);
                oProp = EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(geDateTimePats[j6]));
                oPat.setAttribute(oProp, XFA.NAMETAG);
                TextNode tval6 = oPat.getText(false, true, false);
                tval6.setValue(oLcData.getTimeFormat(3 - j6 + 1), true, false);
            }
            oLocaleSymClone.getNodes().append(oTimePatsClone);
            Element oDateTimeClone = oDateTimeSym.clone(null, true);
            tval = oDateTimeClone.getText(false, true, false);
            tval.setValue(oLcData.getDateTimePattern(), true, false);
            oLocaleSymClone.getNodes().append(oDateTimeClone);
            Element oNumPatsClone = oNumPats.clone(null, true);
            for (int j7 = 0; j7 <= 2; ++j7) {
                Element oPat = oNumPatsClone.getElement(XFA.NUMBERPATTERNTAG, j7);
                oProp = EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(geNumPats[j7]));
                oPat.setAttribute(oProp, XFA.NAMETAG);
                tval = oPat.getText(false, true, false);
                tval.setValue(oLcData.getNumericFormat(j7), true, false);
            }
            oLocaleSymClone.getNodes().append(oNumPatsClone);
            Element oNumSymsClone = oNumSyms.clone(null, true);
            for (int j8 = 0; j8 <= 4; ++j8) {
                int eTag;
                String sSymbol;
                if (j8 == 0) {
                    sSymbol = oLcData.getRadixSymbol();
                    eTag = -2142044160;
                } else if (j8 == 1) {
                    sSymbol = oLcData.getGroupingSymbol();
                    eTag = -2142044159;
                } else if (j8 == 2) {
                    sSymbol = oLcData.getPercentSymbol();
                    eTag = -2142044158;
                } else if (j8 == 3) {
                    sSymbol = oLcData.getNegativeSymbol();
                    eTag = -2142044157;
                } else {
                    sSymbol = oLcData.getZeroSymbol();
                    eTag = -2142044156;
                }
                Element oSym2 = oNumSymsClone.getElement(XFA.NUMBERSYMBOLTAG, j8);
                oProp = EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(eTag));
                oSym2.setAttribute(oProp, XFA.NAMETAG);
                tval = oSym2.getText(false, true, false);
                tval.setValue(sSymbol, true, false);
            }
            oLocaleSymClone.getNodes().append(oNumSymsClone);
            Element oCurSymsClone = oCurSyms.clone(null, true);
            for (int j9 = 0; j9 <= 2; ++j9) {
                int eTag;
                String sSymbol;
                if (j9 == 0) {
                    sSymbol = oLcData.getCurrencySymbol();
                    eTag = -2141978624;
                } else if (j9 == 1) {
                    sSymbol = oLcData.getCurrencyName();
                    eTag = -2141978623;
                } else {
                    sSymbol = oLcData.getCurrencyRadix();
                    eTag = -2141978622;
                }
                oSym = oCurSymsClone.getElement(XFA.CURRENCYSYMBOLTAG, j9);
                oProp = EnumValue.getEnum(XFA.NAMETAG, EnumAttr.getEnum(eTag));
                oSym.setAttribute(oProp, XFA.NAMETAG);
                tval = oSym.getText(false, true, false);
                tval.setValue(sSymbol, true, false);
            }
            oLocaleSymClone.getNodes().append(oCurSymsClone);
            Element oTypefacesClone = oTypefaces.clone(null, true);
            List<String> oTypefaceList = oLcData.getTypefaces();
            for (int k = 0; k < oTypefaceList.size(); ++k) {
                oSym = oModel.createElement(null, null, null, "typeface", "typeface", null, 0, null);
                oProp = new StringAttr("name", oTypefaceList.get(k));
                oSym.setAttribute(oProp, XFA.NAMETAG);
                oTypefacesClone.appendChild(oSym, false);
            }
            oLocaleSymClone.getNodes().append(oTypefacesClone);
        }
        return bLocalesOk;
    }

    public LocaleSetModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, LocaleSetModel.localeSetNS(), "localeSet", "localeSet", "$localeSet", XFA.LOCALESETTAG, "localeSet", LocaleSetModel.getModelSchema());
    }

    @Override
    protected void postLoad() {
        this.refreshLocales();
    }

    public void refreshLocales() {
        Model oModel = this.getModel();
        for (Node oChild = this.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            LcData.LcRunTimeData oLcData;
            block5: {
                StringHolder sLoc = new StringHolder();
                try {
                    ExFull oErr;
                    MsgFormatPos oMessage;
                    oLcData = this.walk(oChild, sLoc, null);
                    if (oLcData == null || StringUtils.isEmpty(oLcData.localeName)) {
                        oMessage = new MsgFormatPos(ResId.LocaleUnknown);
                        oMessage.format("");
                        oErr = new ExFull(oMessage);
                        oModel.addErrorList(oErr, 3, this);
                        continue;
                    }
                    if (!LcData.validate(oLcData)) {
                        oMessage = new MsgFormatPos(ResId.LocaleDataIncomplete);
                        oMessage.format(oLcData.localeName);
                        oErr = new ExFull(oMessage);
                        oModel.addErrorList(oErr, 3, this);
                    }
                    break block5;
                }
                catch (ExFull oErr) {
                    oModel.addErrorList(oErr, 3, this);
                }
                continue;
            }
            LcData.update(oLcData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLocalesFromConfig(Node oContext) {
        String sLocaleSetPath = null;
        String sBasePath = null;
        String sUriPath = null;
        if (oContext != null) {
            Node oTree = oContext.resolveNode("localeSet");
            if (oTree != null && oTree.getXFAChildCount() == 1) {
                TextNode textNode = (TextNode)oTree.getFirstXFAChild();
                sLocaleSetPath = textNode.getValue();
            }
            sBasePath = ProtocolUtils.getTemplateBasePathFromConfig(oContext);
            sUriPath = ProtocolUtils.getTemplateUriPathFromConfig(oContext);
        }
        if (StringUtils.isEmpty(sLocaleSetPath)) {
            return;
        }
        InputStream isResolved = null;
        AppModel oTmpAppModel = new AppModel(null);
        try {
            StringHolder resolvedUrl = new StringHolder();
            isResolved = ProtocolUtils.checkUrl(sBasePath, sLocaleSetPath, true, resolvedUrl);
            if (isResolved == null) {
                isResolved = ProtocolUtils.checkUrl(sUriPath, sLocaleSetPath, true, resolvedUrl);
            }
            if (isResolved == null) {
                MsgFormatPos oMsg = new MsgFormatPos(ResId.XFAHrefStoreException);
                oMsg.format(sLocaleSetPath);
                throw new ExFull(oMsg);
            }
            LocaleSetModelFactory oLocaleSetFactory = new LocaleSetModelFactory();
            oTmpAppModel.addFactory(oLocaleSetFactory);
            XMLStorage oXMLStorage = new XMLStorage();
            oXMLStorage.loadModel(oTmpAppModel, isResolved, resolvedUrl.value, "", null);
        }
        finally {
            try {
                if (isResolved != null) {
                    isResolved.close();
                }
            }
            catch (IOException ex) {}
        }
        LocaleSetModel oLocaleSetModel = LocaleSetModel.getLocaleSetModel(oTmpAppModel, false);
        if (oLocaleSetModel != null && oLocaleSetModel.getErrorList().size() > 0) {
            List<ExFull> errorList = oLocaleSetModel.getErrorList();
            int n = errorList.size();
            for (int i = 0; i < n; ++i) {
                ExFull error = errorList.get(i);
                error.resolve();
            }
        }
    }

    @Override
    public int getHeadVersion() {
        return 27;
    }

    @Override
    public String getNS() {
        int nVersion = this.getCurrentVersion();
        AppModel appModel = this.getAppModel();
        if (appModel != null) {
            for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof TemplateModel)) continue;
                nVersion = ((TemplateModel)child).getCurrentVersion();
                break;
            }
        }
        if (nVersion > 0) {
            if (nVersion > 27) {
                nVersion = 27;
            }
            if (nVersion <= 25) {
                nVersion = 21;
            }
            String sNS = this.getBaseNS();
            double dVersion = (double)nVersion / 10.0;
            sNS = sNS + Numeric.doubleToString(dVersion, 1, false);
            sNS = sNS + '/';
            return sNS.intern();
        }
        return super.getNS();
    }

    @Override
    public boolean isVersionCompatible(int nVersion, int nTargetVersion) {
        if (nVersion <= 25) {
            nVersion = 25;
        }
        if (nTargetVersion <= 25) {
            nTargetVersion = 25;
        }
        return super.isVersionCompatible(nVersion, nTargetVersion);
    }

    private static void find(Element oNode, List<String> oLocales) {
        LcLocale oLocale;
        String sLocale;
        if (oNode == null) {
            return;
        }
        if (oNode.isSameClass(XFA.SUBFORMTAG) || oNode.isSameClass(XFA.DRAWTAG) || oNode.isSameClass(XFA.FIELDTAG)) {
            LcLocale oLocale2;
            String sLocale2;
            Attribute oAttr;
            int eLocale = XFA.LOCALETAG;
            if (oNode.isPropertyValid(eLocale) && oNode.isPropertySpecified(eLocale, true, 0) && (oAttr = oNode.getAttribute(eLocale)) != null && !oAttr.isEmpty() && !(sLocale2 = oAttr.toString()).equals(gsAmbient) && (oLocale2 = new LcLocale(sLocale2)).isValid()) {
                int i;
                sLocale2 = oLocale2.getName();
                int n = oLocales.size();
                for (i = 0; i < n && !oLocales.get(i).equals(sLocale2); ++i) {
                }
                if (i == n) {
                    oLocales.add(sLocale2);
                }
            }
        } else if (oNode.isSameClass(XFA.PICTURETAG)) {
            LcLocale oLocale3;
            StringBuilder sMask;
            StringBuilder sLoc;
            StringBuilder sCat;
            String sPicture;
            TextNode oPicture = oNode.getText(true, false, false);
            if (oPicture != null && PictureFmt.isSubPicture(sPicture = oPicture.getValue(), 0, sCat = new StringBuilder(), sLoc = new StringBuilder(), sMask = new StringBuilder()) && (oLocale3 = new LcLocale(sLoc.toString())).isValid()) {
                int i;
                String sLocale3 = oLocale3.getName();
                int n = oLocales.size();
                for (i = 0; i < n && !oLocales.get(i).equals(sLocale3); ++i) {
                }
                if (i == n) {
                    oLocales.add(sLocale3);
                }
            }
        } else if (oNode.isSameClass(XFA.LOCALETAG) && !(sLocale = oNode.getName()).equals(gsAmbient) && (oLocale = new LcLocale(sLocale)).isValid()) {
            int i;
            sLocale = oLocale.getName();
            int n = oLocales.size();
            for (i = 0; i < n && !oLocales.get(i).equals(sLocale); ++i) {
            }
            if (i == n) {
                oLocales.add(sLocale);
            }
        }
        if (!oNode.isSameClass(XFA.DRAWTAG) && !oNode.isSameClass(XFA.LOCALETAG)) {
            Node oChild = oNode.getFirstXFAChild();
            while (oChild instanceof Element) {
                LocaleSetModel.find((Element)oChild, oLocales);
                oChild = oChild.getNextXFASibling();
            }
        }
    }

    private LcData.LcRunTimeData walk(Node oNode, StringHolder sLoc, LcData.LcRunTimeData oLcData) {
        block64: {
            block75: {
                block74: {
                    block73: {
                        block72: {
                            String sPat;
                            block71: {
                                block70: {
                                    block69: {
                                        block68: {
                                            block67: {
                                                block66: {
                                                    block65: {
                                                        block63: {
                                                            if (oNode == null) {
                                                                return oLcData;
                                                            }
                                                            if (!oNode.isSameClass(XFA.LOCALETAG)) break block63;
                                                            String sDesc = ((Element)oNode).getAttribute(XFA.DESCTAG).toString();
                                                            String sName = oNode.getName();
                                                            if (StringUtils.isEmpty(sName)) {
                                                                return oLcData;
                                                            }
                                                            oLcData = LcData.get(sName);
                                                            for (Node oChild = oNode.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                                                                oLcData = this.walk(oChild, sLoc, oLcData);
                                                            }
                                                            LcLocale oLocale = new LcLocale(sName);
                                                            if (!oLocale.isValid()) {
                                                                LcLocale.update(sName, sDesc);
                                                            }
                                                            sLoc.value = LcLocale.normalize(sName);
                                                            break block64;
                                                        }
                                                        if (!oNode.isSameClass(XFA.CALENDARSYMBOLSTAG)) break block65;
                                                        for (Node oChild = oNode.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                                                            oLcData = this.walk(oChild, sLoc, oLcData);
                                                        }
                                                        break block64;
                                                    }
                                                    if (!oNode.isSameClass(XFA.MONTHNAMESTAG)) break block66;
                                                    int eAbbr = ((Element)oNode).getEnum(XFA.ABBRTAG);
                                                    switch (eAbbr) {
                                                        case 0x40040000: 
                                                        case 0x40040001: {
                                                            break;
                                                        }
                                                        default: {
                                                            return oLcData;
                                                        }
                                                    }
                                                    Element oMonth = (Element)oNode.getFirstXFAChild();
                                                    for (int i = 0; oMonth != null && i < 12; oMonth = (Element)oMonth.getNextXFASibling(), ++i) {
                                                        String sMonth = oMonth.getText(false, false, false).getValue();
                                                        if (eAbbr == 0x40040001) {
                                                            oLcData.abbrMonthNames[i] = sMonth;
                                                            continue;
                                                        }
                                                        oLcData.monthNames[i] = sMonth;
                                                    }
                                                    break block64;
                                                }
                                                if (!oNode.isSameClass(XFA.DAYNAMESTAG)) break block67;
                                                int eAbbr = ((Element)oNode).getEnum(XFA.ABBRTAG);
                                                switch (eAbbr) {
                                                    case 0x40040000: 
                                                    case 0x40040001: {
                                                        break;
                                                    }
                                                    default: {
                                                        return oLcData;
                                                    }
                                                }
                                                Element oDay = (Element)oNode.getFirstXFAChild();
                                                for (int i = 0; oDay != null && i < 7; oDay = (Element)oDay.getNextXFASibling(), ++i) {
                                                    String sDay = oDay.getText(false, false, false).getValue();
                                                    if (eAbbr == 0x40040001) {
                                                        oLcData.abbrWeekdayNames[i] = sDay;
                                                        continue;
                                                    }
                                                    oLcData.dayNames[i] = sDay;
                                                }
                                                break block64;
                                            }
                                            if (!oNode.isSameClass(XFA.MERIDIEMNAMESTAG)) break block68;
                                            Element oMeridiem = (Element)oNode.getFirstXFAChild();
                                            for (int i = 0; oMeridiem != null && i < 2; oMeridiem = (Element)oMeridiem.getNextXFASibling(), ++i) {
                                                String sMeridiem;
                                                oLcData.meridiemNames[i] = sMeridiem = oMeridiem.getText(false, false, false).getValue();
                                            }
                                            break block64;
                                        }
                                        if (!oNode.isSameClass(XFA.ERANAMESTAG)) break block69;
                                        Element oEra = (Element)oNode.getFirstXFAChild();
                                        for (int i = 0; oEra != null && i < 2; oEra = (Element)oEra.getNextXFASibling(), ++i) {
                                            String sEra;
                                            oLcData.eraNames[i] = sEra = oEra.getText(false, false, false).getValue();
                                        }
                                        break block64;
                                    }
                                    if (!oNode.isSameClass(XFA.DATEPATTERNSTAG)) break block70;
                                    block41: for (Element oDatePat = (Element)oNode.getFirstXFAChild(); oDatePat != null; oDatePat = (Element)oDatePat.getNextXFASibling()) {
                                        int eName = oDatePat.getEnum(XFA.NAMETAG);
                                        String sPat2 = oDatePat.getText(false, false, false).getValue();
                                        switch (eName) {
                                            case -2142175232: {
                                                oLcData.datePatterns[0] = sPat2;
                                                continue block41;
                                            }
                                            case -2142175231: {
                                                oLcData.datePatterns[1] = sPat2;
                                                continue block41;
                                            }
                                            case -2142175230: {
                                                oLcData.datePatterns[2] = sPat2;
                                                continue block41;
                                            }
                                            case -2142175229: {
                                                oLcData.datePatterns[3] = sPat2;
                                                continue block41;
                                            }
                                            default: {
                                                return oLcData;
                                            }
                                        }
                                    }
                                    break block64;
                                }
                                if (!oNode.isSameClass(XFA.TIMEPATTERNSTAG)) break block71;
                                block42: for (Element oTimePat = (Element)oNode.getFirstXFAChild(); oTimePat != null; oTimePat = (Element)oTimePat.getNextXFASibling()) {
                                    int eName = oTimePat.getEnum(XFA.NAMETAG);
                                    String sPat3 = oTimePat.getText(false, false, false).getValue();
                                    switch (eName) {
                                        case -2142175232: {
                                            oLcData.timePatterns[0] = sPat3;
                                            continue block42;
                                        }
                                        case -2142175231: {
                                            oLcData.timePatterns[1] = sPat3;
                                            continue block42;
                                        }
                                        case -2142175230: {
                                            oLcData.timePatterns[2] = sPat3;
                                            continue block42;
                                        }
                                        case -2142175229: {
                                            oLcData.timePatterns[3] = sPat3;
                                            continue block42;
                                        }
                                        default: {
                                            return oLcData;
                                        }
                                    }
                                }
                                break block64;
                            }
                            if (!oNode.isSameClass(XFA.DATETIMESYMBOLSTAG)) break block72;
                            Element oDateTimePat = (Element)oNode;
                            oLcData.dateTimeSymbols[0] = sPat = oDateTimePat.getText(false, false, false).getValue();
                            break block64;
                        }
                        if (!oNode.isSameClass(XFA.NUMBERPATTERNSTAG)) break block73;
                        block43: for (Element oNumPat = (Element)oNode.getFirstXFAChild(); oNumPat != null; oNumPat = (Element)oNumPat.getNextXFASibling()) {
                            int eName = oNumPat.getEnum(XFA.NAMETAG);
                            String sPat = oNumPat.getText(false, false, false).getValue();
                            switch (eName) {
                                case -2142109696: {
                                    oLcData.numberPatterns[0] = sPat;
                                    continue block43;
                                }
                                case -2142109695: {
                                    oLcData.numberPatterns[1] = sPat;
                                    continue block43;
                                }
                                case -2142109694: {
                                    oLcData.numberPatterns[2] = sPat;
                                    continue block43;
                                }
                                default: {
                                    return oLcData;
                                }
                            }
                        }
                        break block64;
                    }
                    if (!oNode.isSameClass(XFA.NUMBERSYMBOLSTAG)) break block74;
                    block44: for (Element oNumSym = (Element)oNode.getFirstXFAChild(); oNumSym != null; oNumSym = (Element)oNumSym.getNextXFASibling()) {
                        int eName = oNumSym.getEnum(XFA.NAMETAG);
                        String sSym = oNumSym.getText(false, false, false).getValue();
                        switch (eName) {
                            case -2142044160: {
                                oLcData.numericSymbols[0] = sSym;
                                continue block44;
                            }
                            case -2142044159: {
                                oLcData.numericSymbols[1] = sSym;
                                continue block44;
                            }
                            case -2142044158: {
                                oLcData.numericSymbols[2] = sSym;
                                continue block44;
                            }
                            case -2142044157: {
                                oLcData.numericSymbols[3] = sSym;
                                continue block44;
                            }
                            case -2142044156: {
                                oLcData.numericSymbols[4] = sSym;
                                continue block44;
                            }
                            default: {
                                return oLcData;
                            }
                        }
                    }
                    break block64;
                }
                if (!oNode.isSameClass(XFA.CURRENCYSYMBOLSTAG)) break block75;
                block45: for (Element oCurSym = (Element)oNode.getFirstXFAChild(); oCurSym != null; oCurSym = (Element)oCurSym.getNextXFASibling()) {
                    int eName = oCurSym.getEnum(XFA.NAMETAG);
                    String sSym = oCurSym.getText(false, false, false).getValue();
                    switch (eName) {
                        case -2141978624: {
                            oLcData.currencySymbols[0] = sSym;
                            continue block45;
                        }
                        case -2141978623: {
                            oLcData.currencySymbols[1] = sSym;
                            continue block45;
                        }
                        case -2141978622: {
                            oLcData.currencySymbols[2] = sSym;
                            continue block45;
                        }
                        default: {
                            return oLcData;
                        }
                    }
                }
                break block64;
            }
            if (!oNode.isSameClass(XFA.TYPEFACESTAG)) break block64;
            int nTypefaces = oNode.getXMLChildCount();
            oLcData.typefaceList.clear();
            for (int i = 0; i < nTypefaces; ++i) {
                Element oTypeface = ((Element)oNode).getElement(XFA.TYPEFACETAG, i);
                String sName = oTypeface.getAttribute(XFA.NAMETAG).toString();
                String sCorrectedName = null;
                if (sName.equals("Kozuka Gothic Pro VI")) {
                    sCorrectedName = "Kozuka Gothic Pro-VI M";
                } else if (sName.equals("Kozuka Mincho Pro VI")) {
                    sCorrectedName = "Kozuka Mincho Pro-VI R";
                } else if (sName.equals("Adobe Ming Std")) {
                    sCorrectedName = "Adobe Ming Std L";
                } else if (sName.equals("Adobe Song Std")) {
                    sCorrectedName = "Adobe Song Std L";
                } else if (sName.equals("Adobe Myungjo Std")) {
                    sCorrectedName = "Adobe Myungjo Std M";
                }
                if (!StringUtils.isEmpty(sCorrectedName)) {
                    sName = sCorrectedName;
                    StringAttr oProp = new StringAttr("name", sName);
                    oTypeface.setAttribute(oProp, XFA.NAMETAG);
                }
                oLcData.typefaceList.add(sName);
            }
            LcData oRootData = new LcData("root");
            List<String> oRootList = oRootData.getTypefaces();
            for (int i = 0; i < oRootList.size(); ++i) {
                String sName = oRootList.get(i);
                if (oLcData.typefaceList.contains(sName)) continue;
                oLcData.typefaceList.add(sName);
            }
        }
        return oLcData;
    }
}

