/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationElement;
import com.adobe.xfa.configuration.ConfigurationValueScript;
import com.adobe.xfa.ut.BooleanHolder;

public class ConfigurationValue
extends ConfigurationElement {
    public ConfigurationValue(Element parent, Node prevSibling, int classTag, String className) {
        super(parent, prevSibling, null, className, className, null, classTag, className);
    }

    public ConfigurationValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "configurationValue", "configurationValue", null, XFA.CONFIGURATIONVALUETAG, "configurationValue");
    }

    public Attribute getValue() {
        return this.getValue(null);
    }

    public Attribute getValue(BooleanHolder oIsDefault) {
        TextNode textNode = null;
        if (this.getXFAChildCount() == 1) {
            textNode = (TextNode)this.getFirstXFAChild();
        }
        int eParentTag = XFA.XFA_START;
        if (this.getXFAParent() != null) {
            eParentTag = this.getXFAParent().getClassTag();
        }
        if (textNode != null) {
            if (oIsDefault != null) {
                oIsDefault.value = false;
            }
            return this.getModel().getSchema().newAttribute(this.getClassTag(), textNode.getValue(), eParentTag);
        }
        if (oIsDefault != null) {
            oIsDefault.value = true;
        }
        return this.getModel().getSchema().defaultAttribute(this.getClassTag(), eParentTag);
    }

    @Override
    public ScriptTable getScriptTable() {
        return ConfigurationValueScript.getScriptTable();
    }

    public void setValue(Attribute oData) {
        if (this.getXFAChildCount() == 1) {
            TextNode textNode = (TextNode)this.getFirstXFAChild();
            textNode.setValue(oData.toString(), true, false);
        } else {
            this.getModel().createTextNode(this, null, oData.toString());
        }
    }
}

