/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.configuration;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.SchemaPairs;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.configuration.ConfigurationKey;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationUri;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class ConfigurationSchema
extends Schema {
    private boolean mbInitPrintSchema;
    private Map<String, String> moPrintAttributes;
    private Map<String, String> moPrintComments;
    private final boolean[] mbLeafTags;
    private static final String gsXMLPrefix = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String gsNewLine = System.getProperty("line.separator");

    public ConfigurationSchema() {
        super("http://www.xfa.org/schema/xci/", XFA.XFA_ATTRIBUTE_MIN, XFA.XFA_ATTRIBUTE_MAX, XFA.XFA_ELEMENT_MIN, XFA.XFA_ELEMENT_MAX);
        this.mbLeafTags = new boolean[this.mnElementMax - this.mnElementMin + 1];
        this.initSchema();
    }

    @Override
    public Attribute defaultAttribute(int eAttrTag, int eClassTag) {
        AttributeInfo oAttrInfo;
        Attribute oAttr = null;
        ChildReln oReln = null;
        ChildRelnInfo oRelnInfo = super.getNodeSchema(eClassTag).getChildRelnInfo(eAttrTag);
        if (oRelnInfo != null) {
            oReln = oRelnInfo.getRelationship();
        }
        if (oReln instanceof ConfigValueChildReln) {
            oAttr = ((ConfigValueChildReln)oReln).getDefaultValue();
        }
        if (oAttr == null && (oAttrInfo = super.getNodeSchema(eClassTag).getAttributeInfo(eAttrTag)) != null) {
            oAttr = oAttrInfo.getDefault();
        }
        return oAttr;
    }

    @Override
    public Attribute newAttribute(int eAttrTag, String value, int eClassTag) {
        Attribute oAttr = null;
        ChildReln oReln = this.getNodeSchema(eClassTag).getChildRelnInfo(eAttrTag).getRelationship();
        if (oReln instanceof ConfigValueChildReln) {
            oAttr = ((ConfigValueChildReln)oReln).getDefaultValue();
        }
        if (oAttr == null) {
            oAttr = super.getNodeSchema(eClassTag).getAttributeInfo(eAttrTag).getDefault();
        }
        if (oAttr == null && (eClassTag == XFA.CONFIGURATIONVALUETAG || eClassTag == XFA.CONFIGURATIONKEYTAG)) {
            return new StringAttr(XFA.getString(eAttrTag), value);
        }
        if (oAttr == null) {
            throw new ExFull(ResId.InvalidAttributeException, " (" + XFA.getString(eAttrTag) + "=" + value + ")");
        }
        return oAttr.newAttribute(value);
    }

    @Override
    protected int getElementTag(Element element) {
        if (element.isValidChild(XFA.CONFIGURATIONKEYTAG, 0, false, false)) {
            return XFA.CONFIGURATIONKEYTAG;
        }
        if (element.isValidChild(XFA.CONFIGURATIONVALUETAG, 0, false, false)) {
            return XFA.CONFIGURATIONVALUETAG;
        }
        return XFA.INVALID_ELEMENT;
    }

    @Override
    protected void initSchema() {
        super.initSchema();
        this.addUri(XFA.URITAG);
        this.addValue(XFA.ADJUSTDATATAG);
        this.addValue(XFA.ATTRIBUTESTAG);
        this.addValue(XFA.BASETAG);
        this.addValue(XFA.BEHAVIOROVERRIDETAG);
        this.addValue(XFA.BINARYTAG);
        this.addValue(XFA.CSPACETAG);
        this.addValue(XFA.ENCRYPTTAG);
        this.addValue(XFA.USERPASSWORDTAG);
        this.addValue(XFA.MASTERPASSWORDTAG);
        this.addValue(XFA.ENCRYPTIONLEVELTAG);
        this.addValue(XFA.PLAINTEXTMETADATATAG);
        this.addValue(XFA.PRINTTAG);
        this.addValue(XFA.CHANGETAG);
        this.addValue(XFA.CONTENTCOPYTAG);
        this.addValue(XFA.FORMFIELDFILLINGTAG);
        this.addValue(XFA.ACCESSIBLECONTENTTAG);
        this.addValue(XFA.DOCUMENTASSEMBLYTAG);
        this.addValue(XFA.TAGGEDTAG);
        this.addValue(XFA.TAGGEDMODETAG);
        this.addValue(XFA.SUBMITFORMATTAG);
        this.addValue(XFA.CREATORTAG);
        this.addValue(XFA.PRODUCERTAG);
        this.addValue(XFA.SCRIPTMODELTAG);
        this.addValue(XFA.COPIESTAG);
        this.addValue(XFA.DESTINATIONTAG);
        this.addValue(XFA.ENCODINGTAG);
        this.addValue(XFA.EVENTTAG);
        this.addValue(XFA.EXCLUDENSTAG);
        this.addValue(XFA.FILTERTAG);
        this.addValue(XFA.FONTINDEXTAG);
        this.addValue(XFA.FONTRESOURCETAG);
        this.addValue(XFA.FONTSELECTTAG);
        this.addValue(XFA.GROUPPARENTTAG);
        this.addValue(XFA.IFEMPTYTAG);
        this.addValue(XFA.INCREMENTALLOADTAG);
        this.addValue(XFA.INCREMENTALMERGETAG);
        this.addValue(XFA.INTERACTIVETAG);
        this.addValue(XFA.LEVELTAG);
        this.addValue(XFA.LINEARIZEDTAG);
        this.addValue(XFA.MODETAG);
        this.addValue(XFA.MODIFYANNOTSTAG);
        this.addValue(XFA.MSGIDTAG);
        this.addValue(XFA.NAMEATTRTAG);
        this.addValue(XFA.OPERATIONTAG);
        this.addValue(XFA.PICTURETAG);
        this.addValue(XFA.PRESENCETAG);
        this.addValue(XFA.PRINTHIGHQUALITYTAG);
        this.addValue(XFA.RANGETAG);
        this.addValue(XFA.RECORDTAG);
        this.addValue(XFA.RECURSIVETAG);
        this.addValue(XFA.RENAMETAG);
        this.addValue(XFA.SEVERITYTAG);
        this.addValue(XFA.STARTNODETAG);
        this.addValue(XFA.SUBMITURLTAG);
        this.addValue(XFA.SUPPRESSBANNERTAG);
        this.addValue(XFA.THRESHOLDTAG);
        this.addValue(XFA.TOTAG);
        this.addValue(XFA.TYPETAG);
        this.addValue(XFA.VERSIONTAG);
        this.addValue(XFA.WHITESPACETAG);
        this.addValue(XFA.WINDOWTAG);
        this.addValue(XFA.RELEVANTTAG);
        this.addValue(XFA.EMBEDTAG);
        this.addValue(XFA.SUBSETBELOWTAG);
        this.addValue(XFA.DEFAULTTYPEFACETAG);
        this.addValue(XFA.SYSTEMTAG);
        this.addValue(XFA.ADOBETAG);
        this.addValue(XFA.NETWORKTAG);
        this.addValue(XFA.LOCALTAG);
        this.addValue(XFA.EMBEDRENDEREDOUTPUTTAG);
        this.addValue(XFA.PACKETSTAG);
        this.addValue(XFA.STARTPAGETAG);
        this.addValue(XFA.LOCALETAG);
        this.addValue(XFA.LOCALESETTAG);
        this.addValue(XFA.DYNAMICRENDERTAG);
        this.addValue(XFA.RENDERPOLICYTAG);
        this.addValue(XFA.CURRENTPAGETAG);
        this.addValue(XFA.LAYOUTTAG);
        this.addValue(XFA.RUNSCRIPTSTAG);
        this.addValue(XFA.EXCLUDETAG);
        this.addValue(XFA.COMPRESSLOGICALSTRUCTURETAG);
        this.addValue(XFA.COMPRESSOBJECTSTREAMTAG);
        this.addValue(XFA.OUTPUTBINTAG);
        this.addValue(XFA.VALIDATETAG);
        this.addValue(XFA.ADDVIEWERPREFERENCESTAG);
        this.addValue(XFA.NUMBEROFCOPIESTAG);
        this.addValue(XFA.DUPLEXOPTIONTAG);
        this.addValue(XFA.PAGERANGETAG);
        this.addValue(XFA.PRINTSCALINGTAG);
        this.addValue(XFA.ENFORCETAG);
        this.addValue(XFA.PICKTRAYBYPDFSIZETAG);
        this.addValue(XFA.ADBE_JSDEBUGGERTAG);
        this.addValue(XFA.ADBE_JSCONSOLETAG);
        this.addValue(XFA.ADDSILENTPRINTTAG);
        this.addValue(XFA.PRINTERNAMETAG);
        this.addValue(XFA.PAGINATIONTAG);
        this.addValue(XFA.PAGINATIONOVERRIDETAG);
        this.addValue(XFA.FLIPLABELTAG);
        this.addValue(XFA.JOGTAG);
        this.addValue(XFA.STAPLETAG);
        this.addValue(XFA.ALWAYSEMBEDTAG);
        this.addValue(XFA.NEVEREMBEDTAG);
        this.addValue(XFA.PARTTAG);
        this.addValue(XFA.AMDTAG);
        this.addValue(XFA.CONFORMANCETAG);
        this.addValue(XFA.INCLUDEXDPCONTENTTAG);
        this.addValue(XFA.OVERPRINTTAG);
        this.addValue(XFA.ADOBEEXTENSIONLEVELTAG);
        this.addValue(XFA.VALIDATEAPPROVALSIGNATURESTAG);
        this.addValue(XFA.VALIDATIONMESSAGINGTAG);
        this.putAttribute(XFA.EQUATETAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.EQUATETAG, EnumValue.getEnum(XFA.VALIDATETAG, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putAttribute(XFA.EQUATETAG, XFA.DESCTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATETAG, XFA.FROMTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATETAG, XFA.TOTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATETAG, XFA.FORCETAG, null, 10, 1, 0);
        this.setLeaf(XFA.EQUATETAG);
        this.putAttribute(XFA.EQUATERANGETAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.EQUATERANGETAG, XFA.DESCTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATERANGETAG, XFA.FROMTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATERANGETAG, XFA.TOTAG, null, 10, 1, 0);
        this.putAttribute(XFA.EQUATERANGETAG, XFA.UNICODERANGETAG, null, 27, 1, 0);
        this.setLeaf(XFA.EQUATERANGETAG);
        this.putAttribute(XFA.VERSIONCONTROLTAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.VERSIONCONTROLTAG, EnumValue.getEnum(XFA.SOURCEBELOWTAG, EnumAttr.getEnum(0x7D0000)), 10, 1, 0);
        this.putAttribute(XFA.VERSIONCONTROLTAG, EnumValue.getEnum(XFA.SOURCEABOVETAG, EnumAttr.getEnum(0x7E0000)), 10, 1, 0);
        this.putAttribute(XFA.VERSIONCONTROLTAG, EnumValue.getEnum(XFA.OUTPUTBELOWTAG, EnumAttr.getEnum(8323073)), 10, 1, 0);
        this.setLeaf(XFA.VERSIONCONTROLTAG);
        this.putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.FONTTAG, XFA.TYPEFACETAG, null, 10, 1, 0);
        this.putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.WEIGHTTAG, EnumAttr.getEnum(0x140000)), 10, 1, 0);
        this.putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.POSTURETAG, EnumAttr.getEnum(0x110001)), 10, 1, 0);
        this.putAttribute(XFA.FONTTAG, XFA.PSNAMETAG, null, 10, 1, 0);
        this.putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.GENERICFAMILYTAG, EnumAttr.getEnum(0x840000)), 27, 1, 0);
        this.setLeaf(XFA.FONTTAG);
        this.addValue(XFA.CONFIGURATIONVALUETAG);
        this.putValue(XFA.CONFIGURATIONKEYTAG, XFA.CONFIGURATIONVALUETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(XFA.CONFIGURATIONKEYTAG, XFA.CONFIGURATIONKEYTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(XFA.CONFIGURATIONKEYTAG);
        this.putValue(XFA.ADDFONTTAG, XFA.ENCODINGTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.ADDFONTTAG, XFA.FONTSELECTTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.ADDFONTTAG, XFA.FONTRESOURCETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.ADDFONTTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.ADDFONTTAG);
        this.putAttribute(XFA.MACROCACHETAG, XFA.FORMATSTAG, null, 24, 1, 0);
        this.addKey(XFA.MACROCACHETAG);
        this.putAttribute(XFA.RENDERCACHETAG, EnumValue.getEnum(XFA.ENABLETAG, EnumAttr.getEnum(0x40040001)), 24, 1, 0);
        this.addKey(XFA.RENDERCACHETAG);
        this.putAttribute(XFA.TEMPLATECACHETAG, XFA.MAXENTRIESTAG, new Int("maxEntries", 5), 24, 1, 0);
        this.addKey(XFA.TEMPLATECACHETAG);
        this.putElement(XFA.CACHETAG, XFA.MACROCACHETAG, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(XFA.CACHETAG, XFA.RENDERCACHETAG, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(XFA.CACHETAG, XFA.TEMPLATECACHETAG, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.addKey(XFA.CACHETAG);
        this.putAttribute(XFA.CALLOUTTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putValue(XFA.CALLOUTTAG, XFA.EVENTTAG, ChildReln.getZeroOrOne(), null, 24, 1, 0);
        this.putValue(XFA.CALLOUTTAG, XFA.BINARYTAG, ChildReln.getZeroOrOne(), null, 24, 1, 0);
        this.addKey(XFA.CALLOUTTAG);
        this.addKey(XFA.METADATATAG);
        this.putValue(XFA.COMMONTAG, XFA.LOCALETAG, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.METADATATAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(XFA.COMMONTAG, XFA.LOCALESETTAG, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(XFA.COMMONTAG, XFA.SUPPRESSBANNERTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.SUPPRESSBANNERTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.DATATAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.TEMPLATETAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.TEMPTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.LOGTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.CALLOUTTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.COMMONTAG, XFA.MESSAGINGTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.COMMONTAG, XFA.VERSIONCONTROLTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.COMMONTAG, XFA.VALIDATIONMESSAGINGTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.VALIDATIONMESSAGINGTAG, EnumAttr.getEnum(1082654722)), 30, 1, 0);
        this.addKey(XFA.COMMONTAG);
        this.putValue(XFA.COMPRESSIONTAG, XFA.TYPETAG, ChildReln.getZeroOrOne(), new StringAttr("type", "none"), 10, 1, 0);
        this.putValue(XFA.COMPRESSIONTAG, XFA.LEVELTAG, ChildReln.getZeroOrOne(), new Int("compression", 6), 10, 1, 0);
        this.putValue(XFA.COMPRESSIONTAG, XFA.COMPRESSLOGICALSTRUCTURETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.COMPRESSLOGICALSTRUCTURETAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.COMPRESSIONTAG, XFA.COMPRESSOBJECTSTREAMTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.COMPRESSOBJECTSTREAMTAG, EnumAttr.getEnum(0x40040001)), 28, 1, 0);
        this.addKey(XFA.COMPRESSIONTAG);
        this.putValue(XFA.ENCRYPTIONTAG, XFA.ENCRYPTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ENCRYPTTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.ENCRYPTIONTAG, XFA.USERPASSWORDTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.ENCRYPTIONTAG, XFA.MASTERPASSWORDTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.ENCRYPTIONTAG, XFA.ENCRYPTIONLEVELTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ENCRYPTIONLEVELTAG, EnumAttr.getEnum(0x400A0000)), 10, 1, 0);
        this.putElement(XFA.ENCRYPTIONTAG, XFA.PERMISSIONSTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.ENCRYPTIONTAG);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.ADDVIEWERPREFERENCESTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ADDVIEWERPREFERENCESTAG, EnumAttr.getEnum(0x40040000)), 25, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.NUMBEROFCOPIESTAG, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.DUPLEXOPTIONTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.DUPLEXOPTIONTAG, EnumAttr.getEnum(1081409536)), 25, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.PAGERANGETAG, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.PRINTSCALINGTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PRINTSCALINGTAG, EnumAttr.getEnum(1082785793)), 30, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.ENFORCETAG, ChildReln.getZeroOrOne(), null, 30, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.PICKTRAYBYPDFSIZETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PICKTRAYBYPDFSIZETAG, EnumAttr.getEnum(0x40040000)), 30, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.ADBE_JSDEBUGGERTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ADBE_JSDEBUGGERTAG, EnumAttr.getEnum(1083179010)), 33, 1, 0);
        this.putValue(XFA.VIEWERPREFERENCESTAG, XFA.ADBE_JSCONSOLETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ADBE_JSCONSOLETAG, EnumAttr.getEnum(1083179010)), 33, 1, 0);
        this.addKey(XFA.VIEWERPREFERENCESTAG);
        this.putValue(XFA.SILENTPRINTTAG, XFA.ADDSILENTPRINTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ADDSILENTPRINTTAG, EnumAttr.getEnum(0x40040000)), 25, 1, 0);
        this.putValue(XFA.SILENTPRINTTAG, XFA.PRINTERNAMETAG, ChildReln.getZeroOrOne(), null, 25, 1, 0);
        this.addKey(XFA.SILENTPRINTTAG);
        this.putAttribute(XFA.DEFAULTTYPEFACETAG, EnumValue.getEnum(XFA.WRITINGSCRIPTTAG, EnumAttr.getEnum(0x690000)), 24, 1, 0);
        this.putValue(XFA.FONTINFOTAG, XFA.EMBEDTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.EMBEDTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.FONTINFOTAG, XFA.SUBSETBELOWTAG, ChildReln.getZeroOrOne(), new Int("subsetBelow", 100), 10, 1, 0);
        this.putValue(XFA.FONTINFOTAG, XFA.DEFAULTTYPEFACETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(XFA.FONTINFOTAG, XFA.ALWAYSEMBEDTAG, ChildReln.getZeroOrMore(), null, 26, 1, 0);
        this.putValue(XFA.FONTINFOTAG, XFA.NEVEREMBEDTAG, ChildReln.getZeroOrMore(), null, 26, 1, 0);
        this.putElement(XFA.FONTINFOTAG, XFA.MAPTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.FONTINFOTAG);
        this.putElement(XFA.MEDIUMINFOTAG, XFA.MAPTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(XFA.MEDIUMINFOTAG);
        this.putValue(XFA.PSMAPTAG, XFA.FONTTAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.addKey(XFA.PSMAPTAG);
        this.putValue(XFA.PDFATAG, XFA.PARTTAG, ChildReln.getZeroOrOne(), new Int("part", 1), 26, 1, 0);
        this.putValue(XFA.PDFATAG, XFA.AMDTAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(XFA.PDFATAG, XFA.CONFORMANCETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.CONFORMANCETAG, EnumAttr.getEnum(1082261504)), 26, 1, 0);
        this.putValue(XFA.PDFATAG, XFA.INCLUDEXDPCONTENTTAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.addKey(XFA.PDFATAG);
        this.putAttribute(XFA.PAGEOFFSETTAG, XFA.XTAG, new StringAttr("x", "useXDCSetting"), 26, 1, 0);
        this.putAttribute(XFA.PAGEOFFSETTAG, XFA.YTAG, new StringAttr("y", "useXDCSetting"), 26, 1, 0);
        this.addKey(XFA.PAGEOFFSETTAG);
        this.putAttribute(XFA.COMPRESSTAG, EnumValue.getEnum(XFA.SCOPETAG, EnumAttr.getEnum(0x800000)), 26, 1, 0);
        this.addKey(XFA.COMPRESSTAG);
        this.putValue(XFA.XDPTAG, XFA.EMBEDRENDEREDOUTPUTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.EMBEDRENDEREDOUTPUTTAG, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(XFA.XDPTAG, XFA.PACKETSTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.XDPTAG);
        this.putValue(XFA.PERMISSIONSTAG, XFA.MODIFYANNOTSTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.PRINTHIGHQUALITYTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.PRINTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PRINTTAG, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.CHANGETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.CHANGETAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.CONTENTCOPYTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.CONTENTCOPYTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.FORMFIELDFILLINGTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.FORMFIELDFILLINGTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.ACCESSIBLECONTENTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ACCESSIBLECONTENTTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.DOCUMENTASSEMBLYTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.DOCUMENTASSEMBLYTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PERMISSIONSTAG, XFA.PLAINTEXTMETADATATAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PLAINTEXTMETADATATAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.addKey(XFA.PERMISSIONSTAG);
        this.putValue(XFA.DATATAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.RECORDTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.RANGETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.STARTNODETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.INCREMENTALLOADTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.INCREMENTALLOADTAG, EnumAttr.getEnum(0x40470000)), 25, 1, 0);
        this.putValue(XFA.DATATAG, XFA.ATTRIBUTESTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ATTRIBUTESTAG, EnumAttr.getEnum(1073938434)), 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.WINDOWTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.ADJUSTDATATAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.ADJUSTDATATAG, EnumAttr.getEnum(0x40040001)), 10, 1, 0);
        this.putValue(XFA.DATATAG, XFA.EXCLUDENSTAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(XFA.DATATAG, XFA.XSLTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.DATATAG, XFA.TRANSFORMTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.DATATAG, XFA.OUTPUTXSLTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.DATATAG);
        this.putValue(XFA.DEBUGTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.DEBUGTAG);
        this.putValue(XFA.MAPTAG, XFA.EQUATETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(XFA.MAPTAG, XFA.EQUATERANGETAG, ChildReln.getZeroOrMore(), null, 27, 1, 0);
        this.addKey(XFA.MAPTAG);
        this.putAttribute(XFA.IMAGETAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putValue(XFA.IMAGETAG, XFA.CSPACETAG, ChildReln.getZeroOrOne(), new StringAttr("cSpace", "SRGB"), 10, 1, 0);
        this.putValue(XFA.IMAGETAG, XFA.VERSIONTAG, ChildReln.getZeroOrOne(), new StringAttr("version", "1.3"), 10, 1, 0);
        this.putElement(XFA.IMAGETAG, XFA.COMPRESSIONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.IMAGETAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.IMAGETAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.IMAGETAG);
        this.putElement(XFA.LISTFONTTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.LISTFONTTAG, XFA.XFTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.LISTFONTTAG, XFA.OUTPUTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.LISTFONTTAG);
        this.putValue(XFA.LOGTAG, XFA.THRESHOLDTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.THRESHOLDTAG, EnumAttr.getEnum(0x40200000)), 10, 1, 0);
        this.putValue(XFA.LOGTAG, XFA.TOTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.TOTAG, EnumAttr.getEnum(-2145517565)), 10, 1, 0);
        this.putValue(XFA.LOGTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.LOGTAG, XFA.MODETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.MODETAG, EnumAttr.getEnum(1075904512)), 10, 1, 0);
        this.addKey(XFA.LOGTAG);
        this.putValue(XFA.MESSAGETAG, XFA.MSGIDTAG, ChildReln.getZeroOrOne(), new Int("msgId", 0), 10, 1, 0);
        this.putValue(XFA.MESSAGETAG, XFA.SEVERITYTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.SEVERITYTAG, EnumAttr.getEnum(1076822016)), 10, 1, 0);
        this.addKey(XFA.MESSAGETAG);
        this.putElement(XFA.MESSAGINGTAG, XFA.MESSAGETAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(XFA.MESSAGINGTAG);
        this.putValue(XFA.OPENACTIONTAG, XFA.DESTINATIONTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.DESTINATIONTAG, EnumAttr.getEnum(0x40410000)), 10, 1, 0);
        this.addKey(XFA.OPENACTIONTAG);
        this.putAttribute(XFA.BATCHOUTPUTTAG, EnumValue.getEnum(XFA.FORMATTAG, EnumAttr.getEnum(0x670000)), 10, 1, 0);
        this.addKey(XFA.BATCHOUTPUTTAG);
        this.putValue(XFA.OUTPUTTAG, XFA.TOTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.TOTAG, EnumAttr.getEnum(-2144927741)), 10, 1, 0);
        this.putValue(XFA.OUTPUTTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.OUTPUTTAG, XFA.TYPETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(0x4F0000)), 10, 1, 0);
        this.addKey(XFA.OUTPUTTAG);
        this.putValue(XFA.PRESENTTAG, XFA.INCREMENTALMERGETAG, ChildReln.getZeroOrOne(), new Int("incrementalMerge", 1), 25, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.DESTINATIONTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.COPIESTAG, ChildReln.getZeroOrOne(), new Int("copies", 1), 10, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.LAYOUTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.LAYOUTTAG, EnumAttr.getEnum(1079771136)), 10, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.SUBMITURLTAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.VALIDATETAG, ChildReln.getZeroOrOne(), new StringAttr("validate", "preSubmit"), 25, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.PAGINATIONTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PAGINATIONTAG, EnumAttr.getEnum(1081671680)), 26, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.PAGINATIONOVERRIDETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PAGINATIONOVERRIDETAG, EnumAttr.getEnum(1082589184)), 27, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.OVERPRINTTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.OVERPRINTTAG, EnumAttr.getEnum(1082327040)), 26, 1, 0);
        this.putValue(XFA.PRESENTTAG, XFA.BEHAVIOROVERRIDETAG, ChildReln.getZeroOrOne(), null, 30, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.COMMONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.OUTPUTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.CACHETAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.PDFTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.PCLTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.PSTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.ZPLTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.XDPTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.WEBCLIENTTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.PRESENTTAG, XFA.DRIVERTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(XFA.PRESENTTAG);
        this.putValue(XFA.PATHTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.PATHTAG);
        this.putAttribute(XFA.STAPLETAG, XFA.MODETAG, EnumValue.getEnum(XFA.MODETAG, EnumAttr.getEnum(8454146)), 26, 1, 0);
        this.putAttribute(XFA.PCLTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.MACROTAG, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.PAGEOFFSETTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(XFA.PCLTAG, XFA.JOGTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.JOGTAG, EnumAttr.getEnum(1081737216)), 26, 1, 0);
        this.putValue(XFA.PCLTAG, XFA.STAPLETAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(XFA.PCLTAG, XFA.OUTPUTBINTAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.BATCHOUTPUTTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putElement(XFA.PCLTAG, XFA.MEDIUMINFOTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(XFA.PCLTAG);
        this.putAttribute(XFA.ZPLTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.ZPLTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.ZPLTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.ZPLTAG, XFA.MACROTAG, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putValue(XFA.ZPLTAG, XFA.FLIPLABELTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.FLIPLABELTAG, EnumAttr.getEnum(0x40040000)), 26, 1, 0);
        this.putElement(XFA.ZPLTAG, XFA.BATCHOUTPUTTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(XFA.ZPLTAG);
        this.putAttribute(XFA.PSTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.PSTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PSTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PSTAG, XFA.MACROTAG, ChildReln.getZeroOrOne(), 22, 1, 0);
        this.putElement(XFA.PSTAG, XFA.COMPRESSTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putValue(XFA.PSTAG, XFA.JOGTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.JOGTAG, EnumAttr.getEnum(1081737216)), 26, 1, 0);
        this.putValue(XFA.PSTAG, XFA.STAPLETAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putValue(XFA.PSTAG, XFA.OUTPUTBINTAG, ChildReln.getZeroOrOne(), null, 26, 1, 0);
        this.putElement(XFA.PSTAG, XFA.BATCHOUTPUTTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.putElement(XFA.PSTAG, XFA.MEDIUMINFOTAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(XFA.PSTAG);
        this.putAttribute(XFA.WEBCLIENTTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.WEBCLIENTTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.WEBCLIENTTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.WEBCLIENTTAG);
        this.putAttribute(XFA.DRIVERTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.DRIVERTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.DRIVERTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.DRIVERTAG, XFA.CONFIGURATIONVALUETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(XFA.DRIVERTAG, XFA.CONFIGURATIONKEYTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putAttribute(XFA.DRIVERTAG, XFA.LEVELTAG, null, 22, 1, 0);
        this.addKey(XFA.DRIVERTAG);
        this.putAttribute(XFA.DRIVERTAG, XFA.LEVELTAG, null, 22, 1, 0);
        this.addKey(XFA.MACROTAG);
        this.putAttribute(XFA.PDFTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.SCRIPTMODELTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.SCRIPTMODELTAG, EnumAttr.getEnum(1076690944)), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.SUBMITFORMATTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.SUBMITFORMATTAG, EnumAttr.getEnum(1077346304)), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.TAGGEDTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.TAGGEDTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.TAGGEDMODETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.TAGGEDMODETAG, EnumAttr.getEnum(1080688640)), 24, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.VERSIONTAG, ChildReln.getZeroOrOne(), new StringAttr("version", "1.7"), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.ADOBEEXTENSIONLEVELTAG, ChildReln.getZeroOrOne(), null, 28, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.INTERACTIVETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.INTERACTIVETAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.CREATORTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.PRODUCERTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.LINEARIZEDTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.LINEARIZEDTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putValue(XFA.PDFTAG, XFA.RENDERPOLICYTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.RENDERPOLICYTAG, EnumAttr.getEnum(1080557568)), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.COMPRESSIONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.OPENACTIONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.ENCRYPTIONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.FONTINFOTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.BATCHOUTPUTTAG, ChildReln.getZeroOrOne(), 24, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.VIEWERPREFERENCESTAG, ChildReln.getZeroOrOne(), 25, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.SILENTPRINTTAG, ChildReln.getZeroOrOne(), 25, 1, 0);
        this.putElement(XFA.PDFTAG, XFA.PDFATAG, ChildReln.getZeroOrOne(), 26, 1, 0);
        this.addKey(XFA.PDFTAG);
        this.putValue(XFA.SCRIPTTAG, XFA.CURRENTPAGETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.SCRIPTTAG, XFA.EXCLUDETAG, ChildReln.getZeroOrOne(), new StringAttr("exclude", "nullTest formatTest"), 10, 1, 0);
        this.putValue(XFA.SCRIPTTAG, XFA.RUNSCRIPTSTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.RUNSCRIPTSTAG, EnumAttr.getEnum(1080754178)), 10, 1, 0);
        this.addKey(XFA.SCRIPTTAG);
        this.putValue(XFA.REMOVEFONTTAG, XFA.FONTINDEXTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.REMOVEFONTTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.REMOVEFONTTAG);
        this.putElement(XFA.RESOLVEFONTTAG, XFA.SEARCHFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.RESOLVEFONTTAG, XFA.OUTPUTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.RESOLVEFONTTAG, XFA.FONTTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.RESOLVEFONTTAG);
        this.putValue(XFA.SEARCHFONTTAG, XFA.FILTERTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.SEARCHFONTTAG, XFA.RECURSIVETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.SEARCHFONTTAG, XFA.PATHTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.SEARCHFONTTAG, XFA.OUTPUTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.SEARCHFONTTAG);
        this.putValue(XFA.TEMPTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.TEMPTAG);
        this.putValue(XFA.TEMPLATETAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.TEMPLATETAG, XFA.STARTPAGETAG, ChildReln.getZeroOrOne(), new Int("startPage", 0), 10, 1, 0);
        this.putValue(XFA.TEMPLATETAG, XFA.BASETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.TEMPLATETAG, XFA.RELEVANTTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.TEMPLATETAG, XFA.XSLTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.TEMPLATETAG);
        this.putAttribute(XFA.TRANSFORMTAG, XFA.REFTAG, null, 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.IFEMPTYTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.IFEMPTYTAG, EnumAttr.getEnum(1075314691)), 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.PRESENCETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(0x220002)), 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.RENAMETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.WHITESPACETAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.WHITESPACETAG, EnumAttr.getEnum(1077870596)), 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.NAMEATTRTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.TRANSFORMTAG, XFA.GROUPPARENTTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.TRANSFORMTAG);
        this.putValue(XFA.UPDATEXDCTAG, XFA.ENCODINGTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putValue(XFA.UPDATEXDCTAG, XFA.FONTSELECTTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.UPDATEXDCTAG, XFA.XDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.UPDATEXDCTAG, XFA.XCITAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.UPDATEXDCTAG, XFA.SEARCHFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.UPDATEXDCTAG);
        this.putValue(XFA.XCITAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.XCITAG);
        this.putValue(XFA.XDCTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.XDCTAG, XFA.XSLTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.XDCTAG);
        this.putValue(XFA.XDCFONTAGENTTAG, XFA.OPERATIONTAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.COMMONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.SEARCHFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.UPDATEXDCTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.ADDFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.REMOVEFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.LISTFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.XDCFONTAGENTTAG, XFA.RESOLVEFONTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.XDCFONTAGENTTAG);
        this.putAttribute(XFA.AGENTTAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putElement(XFA.AGENTTAG, XFA.COMMONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.AGENTTAG, XFA.CONFIGURATIONVALUETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(XFA.AGENTTAG, XFA.CONFIGURATIONKEYTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.addKey(XFA.AGENTTAG);
        this.putElement(XFA.ACROBATTAG, XFA.ACROBAT7TAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.ACROBATTAG, XFA.SUBMITURLTAG, ChildReln.getZeroOrMore(), null, 28, 1, 0);
        this.putElement(XFA.ACROBATTAG, XFA.COMMONTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putValue(XFA.ACROBATTAG, XFA.CONFIGURATIONVALUETAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.putElement(XFA.ACROBATTAG, XFA.CONFIGURATIONKEYTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putValue(XFA.ACROBATTAG, XFA.VALIDATETAG, ChildReln.getZeroOrOne(), new StringAttr("validate", "preSubmit"), 28, 1, 0);
        this.putValue(XFA.ACROBATTAG, XFA.VALIDATEAPPROVALSIGNATURESTAG, ChildReln.getZeroOrOne(), new StringAttr("validateApprovalSignatures", "docReady postSign"), 28, 1, 0);
        this.addKey(XFA.ACROBATTAG);
        this.putValue(XFA.ACROBAT7TAG, XFA.DYNAMICRENDERTAG, ChildReln.getZeroOrOne(), EnumValue.getEnum(XFA.DYNAMICRENDERTAG, EnumAttr.getEnum(0x40660000)), 10, 1, 0);
        this.addKey(XFA.ACROBAT7TAG);
        this.putValue(XFA.XFTTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.XFTTAG);
        this.putValue(XFA.XSLTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.putElement(XFA.XSLTAG, XFA.DEBUGTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.addKey(XFA.XSLTAG);
        this.putValue(XFA.OUTPUTXSLTAG, XFA.URITAG, ChildReln.getZeroOrOne(), null, 10, 1, 0);
        this.addKey(XFA.OUTPUTXSLTAG);
        this.putAttribute(XFA.AREATAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.AREATAG, XFA.NAMETAG, null, 10, 1, 0);
        this.putAttribute(XFA.AREATAG, XFA.LEVELTAG, new Int("level", 0), 10, 1, 0);
        this.setLeaf(XFA.AREATAG);
        this.putValue(XFA.TRACETAG, XFA.AREATAG, ChildReln.getZeroOrMore(), null, 10, 1, 0);
        this.addKey(XFA.TRACETAG);
        this.putAttribute(XFA.CONFIGTAG, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(XFA.CONFIGTAG, XFA.DESCTAG, null, 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.PRESENTTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.TRACETAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.AGENTTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.CONFIGURATIONKEYTAG, ChildReln.getZeroOrMore(), 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.PSMAPTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.putElement(XFA.CONFIGTAG, XFA.ACROBATTAG, ChildReln.getZeroOrOne(), 10, 1, 0);
    }

    @Override
    protected Element newElement(int eTag, Element parent, Node prevSibling) {
        Element newNode;
        if (eTag == XFA.CONFIGTAG) {
            newNode = new ConfigurationModel(parent, prevSibling);
        } else if (eTag == XFA.CONFIGURATIONKEYTAG || eTag == XFA.ADDFONTTAG || eTag == XFA.MACROCACHETAG || eTag == XFA.RENDERCACHETAG || eTag == XFA.TEMPLATECACHETAG || eTag == XFA.CACHETAG || eTag == XFA.CALLOUTTAG || eTag == XFA.METADATATAG || eTag == XFA.COMMONTAG || eTag == XFA.COMPRESSIONTAG || eTag == XFA.ENCRYPTIONTAG || eTag == XFA.VIEWERPREFERENCESTAG || eTag == XFA.SILENTPRINTTAG || eTag == XFA.FONTINFOTAG || eTag == XFA.MEDIUMINFOTAG || eTag == XFA.PSMAPTAG || eTag == XFA.PDFATAG || eTag == XFA.PAGEOFFSETTAG || eTag == XFA.COMPRESSTAG || eTag == XFA.XDPTAG || eTag == XFA.PERMISSIONSTAG || eTag == XFA.DATATAG || eTag == XFA.DEBUGTAG || eTag == XFA.MAPTAG || eTag == XFA.IMAGETAG || eTag == XFA.LISTFONTTAG || eTag == XFA.LOGTAG || eTag == XFA.MESSAGETAG || eTag == XFA.MESSAGINGTAG || eTag == XFA.OPENACTIONTAG || eTag == XFA.BATCHOUTPUTTAG || eTag == XFA.OUTPUTTAG || eTag == XFA.PRESENTTAG || eTag == XFA.PATHTAG || eTag == XFA.PCLTAG || eTag == XFA.ZPLTAG || eTag == XFA.PSTAG || eTag == XFA.WEBCLIENTTAG || eTag == XFA.DRIVERTAG || eTag == XFA.MACROTAG || eTag == XFA.PDFTAG || eTag == XFA.SCRIPTTAG || eTag == XFA.REMOVEFONTTAG || eTag == XFA.RESOLVEFONTTAG || eTag == XFA.SEARCHFONTTAG || eTag == XFA.TEMPTAG || eTag == XFA.TEMPLATETAG || eTag == XFA.TRANSFORMTAG || eTag == XFA.UPDATEXDCTAG || eTag == XFA.XCITAG || eTag == XFA.XDCTAG || eTag == XFA.XDCFONTAGENTTAG || eTag == XFA.AGENTTAG || eTag == XFA.ACROBATTAG || eTag == XFA.ACROBAT7TAG || eTag == XFA.XFTTAG || eTag == XFA.XSLTAG || eTag == XFA.OUTPUTXSLTAG || eTag == XFA.TRACETAG) {
            newNode = new ConfigurationKey(parent, prevSibling);
        } else if (eTag == XFA.EQUATETAG || eTag == XFA.EQUATERANGETAG || eTag == XFA.VERSIONCONTROLTAG || eTag == XFA.FONTTAG || eTag == XFA.AREATAG || eTag == XFA.ADJUSTDATATAG || eTag == XFA.ATTRIBUTESTAG || eTag == XFA.BASETAG || eTag == XFA.BEHAVIOROVERRIDETAG || eTag == XFA.BINARYTAG || eTag == XFA.CSPACETAG || eTag == XFA.ENCRYPTTAG || eTag == XFA.USERPASSWORDTAG || eTag == XFA.MASTERPASSWORDTAG || eTag == XFA.ENCRYPTIONLEVELTAG || eTag == XFA.PLAINTEXTMETADATATAG || eTag == XFA.PRINTTAG || eTag == XFA.CHANGETAG || eTag == XFA.CONTENTCOPYTAG || eTag == XFA.FORMFIELDFILLINGTAG || eTag == XFA.ACCESSIBLECONTENTTAG || eTag == XFA.DOCUMENTASSEMBLYTAG || eTag == XFA.TAGGEDTAG || eTag == XFA.TAGGEDMODETAG || eTag == XFA.SUBMITFORMATTAG || eTag == XFA.CREATORTAG || eTag == XFA.PRODUCERTAG || eTag == XFA.SCRIPTMODELTAG || eTag == XFA.COPIESTAG || eTag == XFA.DESTINATIONTAG || eTag == XFA.ENCODINGTAG || eTag == XFA.EVENTTAG || eTag == XFA.EXCLUDENSTAG || eTag == XFA.FILTERTAG || eTag == XFA.FONTINDEXTAG || eTag == XFA.FONTRESOURCETAG || eTag == XFA.FONTSELECTTAG || eTag == XFA.GROUPPARENTTAG || eTag == XFA.IFEMPTYTAG || eTag == XFA.INCREMENTALLOADTAG || eTag == XFA.INCREMENTALMERGETAG || eTag == XFA.INTERACTIVETAG || eTag == XFA.LEVELTAG || eTag == XFA.LINEARIZEDTAG || eTag == XFA.MODETAG || eTag == XFA.MODIFYANNOTSTAG || eTag == XFA.MSGIDTAG || eTag == XFA.NAMEATTRTAG || eTag == XFA.OPERATIONTAG || eTag == XFA.PICTURETAG || eTag == XFA.PRESENCETAG || eTag == XFA.PRINTHIGHQUALITYTAG || eTag == XFA.RANGETAG || eTag == XFA.RECORDTAG || eTag == XFA.RECURSIVETAG || eTag == XFA.RENAMETAG || eTag == XFA.SEVERITYTAG || eTag == XFA.STARTNODETAG || eTag == XFA.SUBMITURLTAG || eTag == XFA.SUPPRESSBANNERTAG || eTag == XFA.THRESHOLDTAG || eTag == XFA.TOTAG || eTag == XFA.TYPETAG || eTag == XFA.VERSIONTAG || eTag == XFA.WHITESPACETAG || eTag == XFA.WINDOWTAG || eTag == XFA.RELEVANTTAG || eTag == XFA.EMBEDTAG || eTag == XFA.SUBSETBELOWTAG || eTag == XFA.DEFAULTTYPEFACETAG || eTag == XFA.SYSTEMTAG || eTag == XFA.ADOBETAG || eTag == XFA.ADOBEEXTENSIONLEVELTAG || eTag == XFA.NETWORKTAG || eTag == XFA.LOCALTAG || eTag == XFA.EMBEDRENDEREDOUTPUTTAG || eTag == XFA.PACKETSTAG || eTag == XFA.STARTPAGETAG || eTag == XFA.LOCALETAG || eTag == XFA.LOCALESETTAG || eTag == XFA.DYNAMICRENDERTAG || eTag == XFA.RENDERPOLICYTAG || eTag == XFA.CURRENTPAGETAG || eTag == XFA.LAYOUTTAG || eTag == XFA.RUNSCRIPTSTAG || eTag == XFA.EXCLUDETAG || eTag == XFA.COMPRESSLOGICALSTRUCTURETAG || eTag == XFA.COMPRESSOBJECTSTREAMTAG || eTag == XFA.OUTPUTBINTAG || eTag == XFA.VALIDATETAG || eTag == XFA.VALIDATEAPPROVALSIGNATURESTAG || eTag == XFA.VALIDATIONMESSAGINGTAG || eTag == XFA.ADDVIEWERPREFERENCESTAG || eTag == XFA.NUMBEROFCOPIESTAG || eTag == XFA.DUPLEXOPTIONTAG || eTag == XFA.PAGERANGETAG || eTag == XFA.PRINTSCALINGTAG || eTag == XFA.ENFORCETAG || eTag == XFA.PICKTRAYBYPDFSIZETAG || eTag == XFA.ADDSILENTPRINTTAG || eTag == XFA.PRINTERNAMETAG || eTag == XFA.PAGINATIONTAG || eTag == XFA.PAGINATIONOVERRIDETAG || eTag == XFA.FLIPLABELTAG || eTag == XFA.JOGTAG || eTag == XFA.STAPLETAG || eTag == XFA.ALWAYSEMBEDTAG || eTag == XFA.NEVEREMBEDTAG || eTag == XFA.PARTTAG || eTag == XFA.AMDTAG || eTag == XFA.CONFORMANCETAG || eTag == XFA.INCLUDEXDPCONTENTTAG || eTag == XFA.OVERPRINTTAG || eTag == XFA.CONFIGURATIONVALUETAG || eTag == XFA.ADBE_JSCONSOLETAG || eTag == XFA.ADBE_JSDEBUGGERTAG) {
            newNode = new ConfigurationValue(parent, prevSibling);
        } else if (eTag == XFA.URITAG) {
            newNode = new ConfigurationUri(parent, prevSibling);
        } else {
            return null;
        }
        newNode.setClass(XFA.getAtom(eTag), eTag);
        return newNode;
    }

    private void addKey(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, XFA.DESCTAG, null, 10, 1, 0);
    }

    private void addValue(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, XFA.DESCTAG, null, 10, 1, 0);
        this.putElement(eTag, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.setLeaf(eTag);
    }

    private void addUri(int eTag) {
        this.putAttribute(eTag, EnumValue.getEnum(XFA.LOCKTAG, EnumAttr.getEnum(0x40040000)), 10, 1, 0);
        this.putAttribute(eTag, XFA.DESCTAG, null, 10, 1, 0);
        this.putElement(eTag, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), 10, 1, 0);
        this.setLeaf(eTag);
    }

    private void putValue(int eParent, int eTag, ChildReln oRelation, Attribute oDefaultValue, int nVersionIntro, int nAvailability, int nVersionDep) {
        ConfigValueChildReln oNewRelation = null;
        oNewRelation = oDefaultValue == null ? new ConfigValueChildReln(oRelation, new StringAttr(XFA.getString(eTag), "")) : new ConfigValueChildReln(oRelation, oDefaultValue);
        this.putElement(eParent, eTag, oNewRelation, nVersionIntro, nAvailability, nVersionDep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printConfigSchema(String sSchemaName, String sUri, boolean bWriteToStdout) {
        String sConfiguration;
        block22: {
            StringBuilder sConfigurationSchema = new StringBuilder();
            boolean bPrint = true;
            int nPos = XFA.getTag(sSchemaName.intern());
            if (nPos >= 0) {
                if (nPos == XFA.CONFIGURATIONVALUETAG) {
                    bPrint = false;
                } else if (nPos == XFA.CONFIGURATIONKEYTAG) {
                    bPrint = false;
                }
            } else {
                nPos = XFA.AGENTTAG;
            }
            if (bPrint) {
                if (!this.mbInitPrintSchema) {
                    this.initPrintSchema();
                }
                sConfigurationSchema.ensureCapacity(5120);
                sConfigurationSchema.append(gsXMLPrefix);
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append('<');
                sConfigurationSchema.append("xdp:xdp");
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append(':');
                sConfigurationSchema.append("xdp");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append("http://ns.adobe.com/xdp/");
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append("   ");
                sConfigurationSchema.append('<');
                sConfigurationSchema.append("config");
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(ConfigurationModel.configurationNS());
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(' ');
                sConfigurationSchema.append("xmlns");
                sConfigurationSchema.append(':');
                sConfigurationSchema.append("xfa");
                sConfigurationSchema.append('=');
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append(ConfigurationModel.configurationNS());
                sConfigurationSchema.append('\"');
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                if (nPos <= XFA.XFA_ELEMENTS) {
                    String sName = null;
                    if (nPos == XFA.AGENTTAG) {
                        sName = sSchemaName;
                    }
                    this.printSchema(sConfigurationSchema, XFA.CONFIGTAG, nPos, 2, sName, "   ");
                }
                sConfigurationSchema.append("   ");
                sConfigurationSchema.append('<');
                sConfigurationSchema.append('/');
                sConfigurationSchema.append("config");
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
                sConfigurationSchema.append('<');
                sConfigurationSchema.append('/');
                sConfigurationSchema.append("xdp:xdp");
                sConfigurationSchema.append('>');
                sConfigurationSchema.append(gsNewLine);
            }
            sConfiguration = sConfigurationSchema.toString();
            if (!StringUtils.isEmpty(sUri)) {
                try {
                    String outputStreamFile = sUri;
                    if (outputStreamFile.indexOf(".xci") == -1) {
                        outputStreamFile = sUri + "." + "xci";
                    }
                    Writer oStream = null;
                    try {
                        oStream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputStreamFile), "UTF-8");
                        oStream.write(sConfiguration);
                        oStream.write(gsNewLine);
                        break block22;
                    }
                    finally {
                        if (oStream != null) {
                            try {
                                oStream.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new ExFull(e);
                }
            }
            if (bWriteToStdout) {
                System.out.println(sConfiguration);
            }
        }
        return sConfiguration;
    }

    private void initPrintSchema() {
        this.moPrintAttributes = new HashMap<String, String>(4);
        this.moPrintComments = new HashMap<String, String>(16);
        MsgFormat oPrintAttrPa = new MsgFormat(ResId.XFAConfigPrintAttrPa);
        this.moPrintAttributes.put("pa", oPrintAttrPa.toString());
        MsgFormat oPrintAttrTp = new MsgFormat(ResId.XFAConfigPrintAttrTp);
        this.moPrintAttributes.put("tp", oPrintAttrTp.toString());
        MsgFormat oPrintCmntCommonUri = new MsgFormat(ResId.XFAConfigPrintCmmntCommonUri);
        this.moPrintComments.put("common.uri", oPrintCmntCommonUri.toString());
        MsgFormat oPrintCmntPaDestination = new MsgFormat(ResId.XFAConfigPrintCmmntPaDestination);
        this.moPrintComments.put("present.destination", oPrintCmntPaDestination.toString());
        MsgFormat oConfigPrintCmmntcSpace = new MsgFormat(ResId.XFAConfigPrintCmmntcSpace);
        this.moPrintComments.put("image.cSpace", oConfigPrintCmmntcSpace.toString());
        MsgFormat oPrintCmntCompressionTypeImage = new MsgFormat(ResId.XFAConfigPrintCmmntCompressionTypeTiff);
        this.moPrintComments.put("image.compression.type", oPrintCmntCompressionTypeImage.toString());
        MsgFormat oPrintCmntCompressionLevel = new MsgFormat(ResId.XFAConfigPrintCmmntCompressionLevel);
        this.moPrintComments.put("pdf.compression.level", oPrintCmntCompressionLevel.toString());
        MsgFormat oPrintCmntPdfVersion = new MsgFormat(ResId.XFAConfigPrintCmmntPdfVersion);
        this.moPrintComments.put("pdf.version", oPrintCmntPdfVersion.toString());
        MsgFormat oPrintCmntSubsetBelow = new MsgFormat(ResId.XFAConfigPrintCmmntSubsetBelow);
        this.moPrintComments.put("pdf.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("pcl.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("image.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("ps.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        this.moPrintComments.put("zpl.fontInfo.subsetBelow", oPrintCmntSubsetBelow.toString());
        MsgFormat oPrintCmntFontMapEquate = new MsgFormat(ResId.XFAConfigPrintCmmntFontMapEquate);
        this.moPrintComments.put("fontInfo.map.equate", oPrintCmntFontMapEquate.toString());
        MsgFormat oPrintCmntTraceArea = new MsgFormat(ResId.XFAConfigPrintCmmntTraceArea);
        this.moPrintComments.put("trace.area", oPrintCmntTraceArea.toString());
        this.mbInitPrintSchema = true;
    }

    private String getComment(String sSomeExpr) {
        String sAttr = this.moPrintComments.get(sSomeExpr);
        int nFoundAt = 0;
        while (StringUtils.isEmpty(sAttr) && (nFoundAt = sSomeExpr.indexOf(46, nFoundAt)) != -1) {
            String sNewString = sSomeExpr.substring(++nFoundAt);
            sAttr = this.moPrintComments.get(sNewString);
        }
        return sAttr;
    }

    private void printSchema(StringBuilder sBuffer, int eParentTag, int eTag, int nOccurs, String sContext, String sIndent) {
        SchemaPairs oAttrs;
        String sNextIndent = sIndent + "   ";
        String sTag = XFA.getString(eTag);
        sBuffer.append(sNextIndent);
        sBuffer.append('<');
        sBuffer.append(sTag);
        if (eTag == XFA.AGENTTAG) {
            sBuffer.append(' ');
            sBuffer.append("name");
            sBuffer.append('=');
            sBuffer.append('\"');
            sBuffer.append(sContext);
            sBuffer.append('\"');
        }
        if ((oAttrs = super.getNodeSchema(eTag).getValidAttributes()) != null) {
            for (int i = 0; i < oAttrs.size(); ++i) {
                int eAttrTag = oAttrs.key(i);
                if (eAttrTag == XFA.LOCKTAG || eAttrTag == XFA.DESCTAG || eTag == XFA.AGENTTAG && eAttrTag == XFA.NAMETAG) continue;
                Attribute oAttr = (Attribute)oAttrs.value(i);
                sBuffer.append(' ');
                sBuffer.append(XFA.getString(eAttrTag));
                sBuffer.append('=');
                sBuffer.append('\"');
                sBuffer.append(oAttr.toString());
                sBuffer.append('\"');
            }
        }
        StringBuilder sNewContext = new StringBuilder();
        if (sContext != null) {
            sNewContext.append(sContext);
        }
        if (sNewContext.length() != 0) {
            sNewContext.append('.');
        }
        sNewContext.append(sTag);
        String sAttr = this.moPrintAttributes.get(sNewContext.toString());
        if (!StringUtils.isEmpty(sAttr)) {
            sBuffer.append(' ');
            sBuffer.append(sAttr);
        }
        StringBuilder sCommentText = new StringBuilder();
        String sComments = this.getComment(sNewContext.toString());
        if (sComments != null) {
            sCommentText.append(sComments);
        }
        if (nOccurs != 1) {
            sCommentText.append(' ');
            if (nOccurs == 2) {
                sCommentText.append("[0..n]");
            } else if (nOccurs == 3) {
                sCommentText.append("[1..n]");
            } else if (nOccurs == 4) {
                sCommentText.append("oneOfChild");
            }
            sCommentText.append(' ');
        }
        if (this.isLeaf(eTag)) {
            EnumAttr oEnum;
            String[] oValues;
            Attribute oDefaultValue = this.defaultAttribute(eTag, eParentTag);
            String sDefaultValue = "";
            if (oDefaultValue != null) {
                sDefaultValue = oDefaultValue.toString();
            }
            if (StringUtils.isEmpty(sDefaultValue)) {
                sBuffer.append("/>");
            } else {
                sBuffer.append(">");
                sBuffer.append(sDefaultValue);
                sBuffer.append("</");
                sBuffer.append(sTag);
                sBuffer.append(">");
            }
            if (oDefaultValue instanceof EnumValue && (oValues = (oEnum = ((EnumValue)oDefaultValue).getAttr()).getStrings()).length > 0) {
                sBuffer.append(' ');
                sBuffer.append("<!--");
                sBuffer.append(' ');
                for (int i = 0; i < oValues.length; ++i) {
                    if (i != 0) {
                        sBuffer.append('|');
                    }
                    sBuffer.append(oValues[i]);
                }
                sBuffer.append(' ');
                sBuffer.append("-->");
            }
            if (sCommentText.length() != 0) {
                sBuffer.append(' ');
                sBuffer.append("<!--");
                sBuffer.append(' ');
                sBuffer.append(sCommentText.toString());
                sBuffer.append(' ');
                sBuffer.append("-->");
            }
            sBuffer.append(gsNewLine);
            return;
        }
        sBuffer.append('>');
        if (sCommentText.length() != 0) {
            sBuffer.append(' ');
            sBuffer.append("<!--");
            sBuffer.append(' ');
            sBuffer.append((CharSequence)sCommentText);
            sBuffer.append(' ');
            sBuffer.append("-->");
        }
        sBuffer.append(gsNewLine);
        SchemaPairs oChildren = super.getNodeSchema(eTag).getValidChildren();
        if (oChildren != null) {
            for (int i = 0; i < oChildren.size(); ++i) {
                int eChild = oChildren.key(i);
                if (eChild == XFA.TEXTNODETAG || eChild == XFA.CONFIGURATIONVALUETAG || eChild == XFA.CONFIGURATIONKEYTAG) continue;
                ChildReln oReln = (ChildReln)oChildren.value(i);
                this.printSchema(sBuffer, eTag, eChild, oReln.getOccurrence(), sNewContext.toString(), sNextIndent);
            }
        }
        sBuffer.append(sNextIndent);
        sBuffer.append("</");
        sBuffer.append(sTag);
        sBuffer.append('>');
        sBuffer.append(gsNewLine);
    }

    private void setLeaf(int eTag) {
        this.mbLeafTags[eTag - this.mnElementMin] = true;
    }

    private boolean isLeaf(int eTag) {
        return this.mbLeafTags[eTag - this.mnElementMin];
    }

    private static class ConfigValueChildReln
    extends ChildReln {
        private final Attribute moDefaultValue;

        ConfigValueChildReln(ChildReln oOther, Attribute oDefaultValue) {
            super(oOther.getOccurrence(), oOther.getMax());
            this.moDefaultValue = oDefaultValue;
        }

        Attribute getDefaultValue() {
            return this.moDefaultValue;
        }

        @Override
        public boolean isBaseClass() {
            return false;
        }
    }
}

