/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.agent;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessageData;
import com.adobe.xfa.LogMessageHandler;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.ut.StringUtils;
import java.io.OutputStream;

public class MessageHandlerXML
extends LogMessageHandler {
    private OutputStream moStream = null;
    private Document moDomDoc = null;
    private Element moRootDomElem = null;

    public MessageHandlerXML(OutputStream oSource) {
        this.moStream = oSource;
    }

    @Override
    public void flush() {
        if (this.moDomDoc != null) {
            DOMSaveOptions oOptions = new DOMSaveOptions();
            oOptions.setDisplayFormat(2);
            oOptions.setIncludeDTD(false);
            this.moDomDoc.saveAs(this.moStream, this.moRootDomElem, oOptions);
        }
    }

    @Override
    public void sendMessage(LogMessage oMessage) {
        if (this.moDomDoc == null) {
            AppModel app = new AppModel(null);
            this.moDomDoc = app.getDocument();
            app.newDOM();
            this.moRootDomElem = this.moDomDoc.createElementNS("", "log", null);
            this.moDomDoc.appendChild(this.moRootDomElem);
        }
        int nSize = oMessage.count();
        for (int i = 0; i < nSize; ++i) {
            this.sendMessageData(oMessage.get(i));
        }
    }

    private void sendMessageData(LogMessageData oMessageData) {
        if (oMessageData.getSeverity() < this.getThreshold()) {
            return;
        }
        Document doc = this.moRootDomElem.getOwnerDocument();
        Element message = doc.createElementNS("", "m", null);
        String sMsgId = "mid";
        String sThreadId = "tid";
        String sSeverity = "sev";
        String sDateTime = "d";
        String sRef = "ref";
        String sTidValue = Thread.currentThread().getName();
        Integer nMsgId = oMessageData.getId();
        String sSeverityValue = this.getSeverity(oMessageData.getSeverity());
        String sDateTimeValue = oMessageData.getDateTime();
        if (oMessageData.getSeverity() == 5 || oMessageData.getSeverity() == 4) {
            message.setAttribute("", sRef, sRef, oMessageData.getSOMExpression());
        } else {
            message.setAttribute("", sMsgId, sMsgId, nMsgId.toString());
        }
        message.setAttribute("", sThreadId, sThreadId, sTidValue);
        message.setAttribute("", sSeverity, sSeverity, sSeverityValue);
        message.setAttribute("", sDateTime, sDateTime, sDateTimeValue);
        if (!StringUtils.isEmpty(this.getAppContext())) {
            String sAppContext = "app";
            message.setAttribute("", sAppContext, sAppContext, this.getAppContext());
        }
        TextNode textVal = doc.getAppModel().createTextNode(null, null, oMessageData.getText());
        message.appendChild(textVal, false);
        this.moRootDomElem.appendChild(message, false);
    }

    private String getSeverity(int eSeverity) {
        switch (eSeverity) {
            case 6: {
                return "f";
            }
            case 3: {
                return "w";
            }
            case 2: {
                return "i";
            }
            case 1: {
                return "t";
            }
            case 5: {
                return "ve";
            }
            case 4: {
                return "vw";
            }
        }
        return "";
    }
}

