/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ObjScript;
import com.adobe.xfa.ut.ExFull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ScriptPropObj {
    private final String msName;
    private final int meParamType;
    private final int mnXFAVersion;
    private final int mnAvailability;
    private final int mnVersionDep;
    private final Class<?> mClass;
    private final Method mGetMethod;
    private final boolean mbGetHasDependencyTracker;
    private final Method mSetMethod;

    public ScriptPropObj(Class<?> clazz, String sName, String sGetFunc, String sSetFunc, int eParamType, int nXFAVersion, int nAvailability, int nVersionDep) {
        boolean bGetHasDependencyTracker;
        Method m;
        block11: {
            assert (clazz != null);
            assert (sGetFunc != null || sSetFunc != null);
            this.mClass = clazz;
            this.msName = sName;
            this.meParamType = eParamType;
            this.mnXFAVersion = nXFAVersion;
            this.mnAvailability = nAvailability;
            this.mnVersionDep = nVersionDep;
            m = null;
            bGetHasDependencyTracker = false;
            if (sGetFunc != null) {
                try {
                    m = this.mClass.getMethod(sGetFunc, Obj.class, Arg.class);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            if (sGetFunc != null && m == null) {
                try {
                    m = this.mClass.getMethod(sGetFunc, Obj.class, Arg.class, DependencyTracker.class);
                    bGetHasDependencyTracker = true;
                }
                catch (NoSuchMethodException ex) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
        this.mGetMethod = m;
        this.mbGetHasDependencyTracker = bGetHasDependencyTracker;
        m = null;
        if (sSetFunc != null) {
            try {
                m = this.mClass.getMethod(sSetFunc, Obj.class, Arg.class);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        this.mSetMethod = m;
    }

    public boolean invokeGetProp(Obj scriptThis, Arg oRetValue, DependencyTracker dependencyTracker) {
        boolean bError = false;
        try {
            if (this.mbGetHasDependencyTracker) {
                this.mGetMethod.invoke((Object)this, scriptThis, oRetValue, dependencyTracker);
            } else {
                this.mGetMethod.invoke((Object)this, scriptThis, oRetValue);
            }
            assert (this.getParamType() == 0 || oRetValue.isCompatibleWith(this.getParamType()));
        }
        catch (IllegalAccessException e3) {
            bError = true;
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getCause();
            if (t instanceof ExFull) {
                throw (ExFull)t;
            }
            bError = true;
        }
        return bError;
    }

    public boolean invokeSetProp(Obj scriptThis, Arg oRetValue) {
        assert (this.hasSetter());
        boolean bError = false;
        try {
            this.mSetMethod.invoke((Object)scriptThis, scriptThis, oRetValue);
        }
        catch (IllegalAccessException e3) {
            bError = true;
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getCause();
            if (t instanceof ExFull) {
                throw (ExFull)t;
            }
            bError = true;
        }
        return bError;
    }

    public boolean invokePermsFunc(Obj scriptThis) {
        return ObjScript.setPropPermsCheck(scriptThis);
    }

    public boolean hasGetter() {
        return this.mGetMethod != null;
    }

    public boolean hasSetter() {
        return this.mSetMethod != null;
    }

    public int getXFAVersion() {
        return this.mnXFAVersion;
    }

    public int getAvailability() {
        return this.mnAvailability;
    }

    public int getVersionDeprecated() {
        return this.mnVersionDep;
    }

    public int getParamType() {
        return this.meParamType;
    }

    public String getName() {
        return this.msName;
    }
}

