/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Element;
import com.adobe.xfa.IDValueMap;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Proto;
import com.adobe.xfa.ProtoableNodeScript;
import com.adobe.xfa.SchemaPairs;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class ProtoableNode
extends Element {
    private static final String patentRef = "AdobePatentID=\"B624\"";
    private boolean mbCurrentlyResolvingProto;
    private boolean mbExternalProtoFailed;
    private boolean mbExternalProtoResolved;
    private boolean mbHasExternalProto;
    private ProtoableNode mProto;
    private ProtoableNode mExternalProto;
    private List<ProtoableNode> mProtoed;

    private static void establishProtoRelationship(Element parent, Node srcProtoChild, Node targetProtoChild, boolean bFull, boolean bCreate, boolean bMarkTransient, boolean bSrcIsExternal) {
        if (targetProtoChild != null && targetProtoChild.isSameClass(srcProtoChild)) {
            if (targetProtoChild instanceof ProtoableNode) {
                String sUse = "";
                if (targetProtoChild.isPropertySpecified(XFA.USEHREFTAG, false, 0)) {
                    sUse = ((Element)targetProtoChild).getAttribute(XFA.USEHREFTAG).toString();
                } else if (targetProtoChild.isPropertySpecified(XFA.USETAG, false, 0)) {
                    sUse = ((Element)targetProtoChild).getAttribute(XFA.USETAG).toString();
                }
                if (StringUtils.isEmpty(sUse)) {
                    ((ProtoableNode)targetProtoChild).resolveProto((ProtoableNode)srcProtoChild, bFull, bMarkTransient, bSrcIsExternal);
                }
            }
        } else if (bCreate) {
            Node ourChild = null;
            boolean bMute = false;
            if (parent != null) {
                bMute = parent.isMute();
                parent.mute();
            }
            try {
                if (srcProtoChild instanceof ProtoableNode) {
                    ourChild = ((ProtoableNode)srcProtoChild).createProto(parent, bFull);
                } else {
                    ourChild = srcProtoChild.clone(parent);
                    if (srcProtoChild.isTransient() || parent.isTransient()) {
                        bMarkTransient = true;
                    }
                    if (srcProtoChild instanceof Element) {
                        if (((Element)srcProtoChild).isFragment() || parent.isFragment()) {
                            bSrcIsExternal = true;
                        }
                    } else if (srcProtoChild instanceof TextNode && (((TextNode)srcProtoChild).isFragment() || parent.isFragment())) {
                        bSrcIsExternal = true;
                    }
                }
                if (ourChild == null) {
                    MsgFormatPos message = new MsgFormatPos(ResId.DOM_NO_MODIFICATION_ALLOWED_ERR);
                    throw new ExFull(message);
                }
                if (targetProtoChild != null) {
                    ourChild.mute();
                    parent.insertChild(ourChild, targetProtoChild, false);
                    ourChild.unMute();
                }
                if (srcProtoChild.isDefault(true)) {
                    ourChild.makeDefault();
                }
                if (bMarkTransient) {
                    ourChild.isTransient(true, true);
                }
                if (bSrcIsExternal) {
                    if (ourChild instanceof Element) {
                        ((Element)ourChild).isFragment(true, true);
                    } else if (ourChild instanceof TextNode) {
                        ((TextNode)ourChild).isFragment(true);
                    }
                }
                if (parent != null) {
                    if (!bMute) {
                        parent.unMute();
                    }
                    parent.notifyPeers(4, ourChild.getClassAtom(), ourChild);
                }
            }
            catch (ExFull ex) {
                if (!bMute && parent != null) {
                    parent.unMute();
                }
                throw ex;
            }
        }
    }

    private static boolean hasID(Node srcProtoChild, List<String> useIDs) {
        String sID;
        if (!(srcProtoChild instanceof Element)) {
            return false;
        }
        if (useIDs != null && useIDs.size() > 0 && srcProtoChild.isPropertySpecified(XFA.IDTAG, false, 0) && !StringUtils.isEmpty(sID = ((Element)srcProtoChild).getAttribute(XFA.IDTAG).toString())) {
            for (int j = 0; j < useIDs.size(); ++j) {
                String sUse = useIDs.get(j);
                if (!sID.equals(sUse)) continue;
                return true;
            }
        }
        return false;
    }

    public ProtoableNode() {
    }

    protected ProtoableNode(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int classTag, String className) {
        super(parent, prevSibling, uri, localName, qName, attributes, classTag, className);
    }

    protected ProtoableNode(Element parent, Node prevSibling) {
        super(parent, prevSibling);
    }

    private void addProtoed(ProtoableNode protoable) {
        if (this.mProtoed == null) {
            this.mProtoed = new ArrayList<ProtoableNode>();
        }
        this.mProtoed.add(protoable);
    }

    private void clearExternalProtos() {
        this.mExternalProto = null;
        Node child = this.getLastXMLChild();
        while (child != null) {
            Node prevChild = child.getPreviousXMLSibling();
            if (child instanceof ProtoableNode && ((ProtoableNode)child).isFragment()) {
                child.remove();
            }
            child = prevChild;
        }
        SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute peerAttr = this.getAttribute(attrs.key(i), true, false);
                if (peerAttr == null || !this.getAttrProp(this.getAttrIndex(peerAttr), 2)) continue;
                if (attrs.key(i) == XFA.IDTAG) {
                    this.forceID("");
                    continue;
                }
                this.setAttribute(null, attrs.key(i));
            }
        }
    }

    private void clearProtos() {
        if (this.mProto != null) {
            this.mProto.removeProtoed(this);
            this.mProto = null;
        }
        Node child = this.getLastXMLChild();
        while (child != null) {
            ProtoableNode protoChild;
            Node prevChild = child.getPreviousXMLSibling();
            if (child instanceof ProtoableNode && (protoChild = (ProtoableNode)child).hasProto()) {
                if (protoChild.isDefault(false)) {
                    child.remove();
                } else {
                    protoChild.performResolveProtos(false);
                }
            }
            child = prevChild;
        }
        SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                String aAttr = XFA.getAtom(attrs.key(i));
                int index = this.findAttr(null, aAttr);
                if (index == -1 || !this.getAttrProp(index, 1)) continue;
                this.removeAttr(null, aAttr);
            }
        }
    }

    @Override
    public Element clone(Element parent, boolean bDeep) {
        ProtoableNode clone = (ProtoableNode)super.clone(parent, bDeep);
        ProtoableNode proto = this.getProto();
        if (proto != null) {
            if (clone.mProto != null) {
                clone.mProto.removeProtoed(this);
            }
            clone.mProto = proto;
            proto.addProtoed(clone);
        }
        clone.mbHasExternalProto = this.mbHasExternalProto;
        return clone;
    }

    public ProtoableNode createProto(Element parent, boolean bFull) {
        assert (parent != null);
        boolean bMute = false;
        ProtoableNode ret = null;
        try {
            Model parentModel;
            if (parent != null && !bFull) {
                bMute = parent.isMute();
                parent.mute();
            }
            boolean bIsSrcExternal = false;
            String aName = this.getPrivateName();
            Model thisModel = this.getModel();
            Model model = parentModel = parent != null ? parent.getModel() : null;
            if (parent != null && parentModel != thisModel) {
                bIsSrcExternal = true;
            }
            ProtoableNode retNode = null;
            retNode = parentModel != null ? (ProtoableNode)parentModel.createNode(this.getClassTag(), parent, "", this.getNS(), true) : (ProtoableNode)thisModel.createNode(this.getClassTag(), parent, "", this.getNS(), true);
            retNode.setDOMProperties(this.getModel().getHeadNS(), retNode.getLocalName(), retNode.getXMLName(), null);
            ret = retNode;
            if (!StringUtils.isEmpty(aName)) {
                ret.setPrivateName(aName);
            }
            if (this.isTransient() || parent.isTransient()) {
                ret.isTransient(true, true);
            }
            if (this.isFragment() || bIsSrcExternal) {
                ret.isFragment(true, true);
            }
            ret.resolveProto(this, bFull, false, bIsSrcExternal);
            if (!bFull) {
                ret.makeDefault();
            } else {
                ret.makeNonDefault(false);
            }
            ret.mbHasExternalProto = this.mbHasExternalProto;
            if (!bMute && parent != null) {
                parent.unMute();
            }
        }
        catch (ExFull ex) {
            if (!bMute && parent != null) {
                parent.unMute();
            }
            throw ex;
        }
        return ret;
    }

    public Attribute elementGetAttribute(int eTag, boolean bPeek, boolean bValidate) {
        return super.getAttribute(eTag, bPeek, bValidate);
    }

    public final boolean externalProtoFailed() {
        if (this.mbExternalProtoFailed) {
            return true;
        }
        if (this.mExternalProto != null) {
            return this.mExternalProto.externalProtoFailed();
        }
        return false;
    }

    public void fetchIDValues(List<String> idValues) {
    }

    public void moveProtos(int nInstance, int nPosition) {
        ProtoableNode poInstanceProto = this.getProtoed(nInstance);
        if (poInstanceProto == null) {
            return;
        }
        ProtoableNode poPositionProto = this.getProtoed(nPosition);
        if (poPositionProto == null) {
            return;
        }
        this.mProtoed.remove(nInstance);
        this.mProtoed.add(nInstance, poPositionProto);
        this.mProtoed.remove(nPosition);
        this.mProtoed.add(nPosition, poInstanceProto);
    }

    public ProtoableNode getProtoed(int nIndex) {
        if (this.mProtoed == null) {
            return null;
        }
        if (nIndex >= this.mProtoed.size()) {
            return null;
        }
        return this.mProtoed.get(nIndex);
    }

    @Override
    public ScriptTable getScriptTable() {
        return ProtoableNodeScript.getScriptTable();
    }

    public void updateIDValues(String sPrefix, List<String> oldReferenceList) {
    }

    protected final void fullyResolve(boolean bClearProtoLink) {
        Node child;
        super.makeNonDefault(true);
        SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute attr;
                int eTag = attrs.key(i);
                if (eTag == XFA.IDTAG || eTag == XFA.USETAG || eTag == XFA.USEHREFTAG || (attr = this.getAttribute(eTag, true, false)) == null) continue;
                this.setAttribute(attr, eTag);
            }
        }
        ArrayNodeList protoChildren = new ArrayNodeList();
        ArrayNodeList protoProperties = new ArrayNodeList();
        this.resolveAndEnumerateChildren(protoProperties, protoChildren, false, false);
        int nProtoProp = ((ListBase)protoProperties).length();
        for (int i = 0; i < nProtoProp; ++i) {
            child = (Node)((ListBase)protoProperties).item(i);
            int nLookupIndex = child.getIndex(false);
            if (child instanceof TextNode) {
                child = this.getText(false, false, false);
                child.setDefaultFlag(false, true);
            } else {
                child = this.getElement(child.getClassTag(), false, nLookupIndex, false, false);
            }
            if (!(child instanceof ProtoableNode)) continue;
            ((ProtoableNode)child).fullyResolve(bClearProtoLink);
        }
        Node protoOneOfChild = this.getOneOfChild(true, false);
        if (protoOneOfChild != null) {
            child = protoOneOfChild;
            child = this.getOneOfChild();
            if (child instanceof ProtoableNode) {
                ((ProtoableNode)child).fullyResolve(bClearProtoLink);
            }
        }
        int nProtoChildren = ((ListBase)protoChildren).length();
        for (int i = 0; i < nProtoChildren; ++i) {
            Node child2 = (Node)((ListBase)protoChildren).item(i);
            if (!(child2 instanceof ProtoableNode)) continue;
            ((ProtoableNode)child2).fullyResolve(bClearProtoLink);
        }
        if (bClearProtoLink) {
            if (this.mProto != null) {
                this.mProto.removeProtoed(this);
            }
            this.mProto = null;
            this.mExternalProto = null;
            this.mbHasExternalProto = false;
            this.mbExternalProtoFailed = false;
            this.mbExternalProtoResolved = false;
        }
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        Attribute attr = super.getAttribute(eTag, true, bValidate);
        if (attr != null) {
            return attr;
        }
        if (this.hasProto()) {
            if (this.isContextSensitiveAttribute(eTag)) {
                if (this.mProto.isSpecified(eTag, 1, true, 0)) {
                    return this.mProto.getAttribute(eTag, bPeek, false);
                }
            } else {
                return this.mProto.getAttribute(eTag, bPeek, false);
            }
        }
        if (bPeek) {
            return null;
        }
        return this.defaultAttribute(eTag);
    }

    @Override
    public Attribute getAttributeByName(String aAttrName, boolean bSearchProto) {
        Attribute attr = super.getAttributeByName(aAttrName, bSearchProto);
        if (attr == null && bSearchProto && this.hasProto() && aAttrName != "id" && aAttrName != "use" && aAttrName != "usehref") {
            attr = this.getProto().getAttributeByName(aAttrName, true);
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getElement(int eTag, boolean bPeek, int nOccurrence, boolean bReturnDefault, boolean bValidate) {
        Element child = super.getElement(eTag, true, nOccurrence, false, bValidate);
        if (child != null) {
            return child;
        }
        if (this.hasProto()) {
            child = this.mProto.getElement(eTag, true, nOccurrence, false, false);
            if (bPeek) {
                if (child != null) {
                    return child;
                }
                if (!bReturnDefault) {
                    return null;
                }
            }
            if (nOccurrence > 0) {
                for (int i = 0; i < nOccurrence; ++i) {
                    Element otherChild = super.getElement(eTag, true, i, false, false);
                    if (otherChild != null) continue;
                    otherChild = this.mProto.getElement(eTag, true, i, false, false);
                    if (otherChild == null) break;
                    boolean previousWillDirty = this.getWillDirty();
                    this.setWillDirty(false);
                    try {
                        ProtoableNode node = (ProtoableNode)otherChild;
                        node.createProto(this, false);
                        continue;
                    }
                    finally {
                        this.setWillDirty(previousWillDirty);
                    }
                }
            }
            if (child instanceof ProtoableNode) {
                ProtoableNode node = (ProtoableNode)child;
                boolean previousWillDirty = this.getWillDirty();
                this.setWillDirty(false);
                try {
                    ProtoableNode protoableNode = node.createProto(this, false);
                    return protoableNode;
                }
                finally {
                    this.setWillDirty(previousWillDirty);
                }
            }
        }
        if (!bPeek || bReturnDefault) {
            return super.getElement(eTag, bPeek, nOccurrence, bReturnDefault, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getOneOfChild(boolean bPeek, boolean bReturnDefault) {
        Node node = super.getOneOfChild(true, false);
        if (node != null) {
            return node;
        }
        if (this.hasProto() && (node = this.mProto.getOneOfChild(true, false)) != null) {
            if (!bPeek) {
                boolean previousWillDirty = this.getWillDirty();
                this.setWillDirty(false);
                try {
                    if (node instanceof ProtoableNode) {
                        ProtoableNode protoableNode = ((ProtoableNode)node).createProto(this, false);
                        return protoableNode;
                    }
                    Node node2 = node.clone(this);
                    return node2;
                }
                finally {
                    this.setWillDirty(previousWillDirty);
                }
            }
            return node;
        }
        if (!bPeek || bReturnDefault) {
            return super.getOneOfChild(bPeek, bReturnDefault);
        }
        return null;
    }

    @Override
    void getPI(List<String> pis, boolean bCheckProtos) {
        super.getPI(pis, bCheckProtos);
        if (pis.size() == 0 && bCheckProtos && this.hasProto()) {
            this.mProto.getPI(pis, bCheckProtos);
        }
    }

    @Override
    public void getPI(String aPiName, List<String> pis, boolean bCheckProtos) {
        assert (aPiName != null);
        super.getPI(aPiName, pis, bCheckProtos);
        if (pis.size() == 0 && bCheckProtos && this.hasProto()) {
            this.mProto.getPI(aPiName, pis, bCheckProtos);
        }
    }

    @Override
    public void getPI(String aPiName, String sPropName, List<String> pis, boolean bCheckProtos) {
        assert (aPiName != null);
        super.getPI(aPiName, sPropName, pis, bCheckProtos);
        if (pis.size() == 0 && bCheckProtos && this.hasProto()) {
            this.mProto.getPI(aPiName, sPropName, pis, bCheckProtos);
        }
    }

    public ProtoableNode getProto() {
        return this.mProto;
    }

    public ProtoableNode getExternalProtoSource() {
        return this.mExternalProto;
    }

    @Override
    public final TextNode getText(boolean bPeek, boolean bReturnDefault, boolean bValidate) {
        TextNode child = super.getText(true, bReturnDefault, bValidate);
        if (child != null) {
            return child;
        }
        if (this.hasProto()) {
            child = this.mProto.getText(true, false, false);
            if (child != null && bPeek) {
                return child;
            }
            TextNode otherChild = super.getText(true, false, false);
            if (otherChild == null) {
                otherChild = this.mProto.getText(true, false, false);
            }
            if (otherChild != null) {
                return otherChild.createProto(this, otherChild.getText(), false);
            }
        }
        if (!bPeek || bReturnDefault) {
            return super.getText(bPeek, bReturnDefault, false);
        }
        return null;
    }

    public boolean hasExternalProto() {
        return this.mbHasExternalProto;
    }

    public boolean hasProto() {
        return this.mProto != null;
    }

    public boolean isContextSensitiveAttribute(int eTag) {
        return eTag == XFA.LOCALETAG;
    }

    @Override
    public boolean isDefault(boolean bCheckProto) {
        boolean bDefault = super.isDefault(false);
        if (bCheckProto && bDefault && this.hasProto()) {
            bDefault = this.getProto().isDefault(bCheckProto);
        }
        return bDefault;
    }

    @Override
    public boolean isSpecified(int eTag, int eType, boolean bCheckProtos, int nOccurrence) {
        if (super.isSpecified(eTag, eType, bCheckProtos, nOccurrence)) {
            return true;
        }
        if (bCheckProtos && this.hasProto() && eTag != XFA.IDTAG && eTag != XFA.USETAG && eTag != XFA.USEHREFTAG) {
            return this.mProto.isSpecified(eTag, eType, true, nOccurrence);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPeers(int eventType, String arg1, Object arg2) {
        int nProtoed;
        if (this.getModel() == null || this.getModel().isLoading()) {
            return;
        }
        super.notifyPeers(eventType, arg1, arg2);
        if (this.mProtoed != null && this.getModel().allowUpdates() && (nProtoed = this.mProtoed.size()) > 0) {
            int newEventType;
            Element parent = this.getXFAParent();
            Object newArg2 = arg2;
            switch (eventType) {
                case 1: {
                    newEventType = 12;
                    newArg2 = this;
                    break;
                }
                case 4: {
                    newEventType = 14;
                    break;
                }
                case 5: {
                    newEventType = 15;
                    break;
                }
                case 2: {
                    newEventType = 13;
                    newArg2 = this;
                    break;
                }
                case 6: {
                    newEventType = 16;
                    break;
                }
                case 7: {
                    newEventType = 17;
                    break;
                }
                case 8: {
                    newEventType = 18;
                    break;
                }
                case 9: {
                    newEventType = 19;
                    break;
                }
                default: {
                    return;
                }
            }
            for (int i = 0; i < nProtoed; ++i) {
                ProtoableNode proto = this.mProtoed.get(i);
                Obj mutedNode = null;
                try {
                    Element protoParent;
                    if (proto.notifyParent() && !(protoParent = proto.getXFAParent()).isMute() && protoParent instanceof ProtoableNode && ((ProtoableNode)protoParent).getProto() == parent) {
                        mutedNode = protoParent;
                        mutedNode.mute();
                    }
                    proto.notifyPeers(newEventType, arg1, newArg2);
                    continue;
                }
                finally {
                    if (mutedNode != null) {
                        mutedNode.unMute();
                    }
                }
            }
        }
        this.sendParentUpdate(eventType, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performResolveProtos(boolean bResolveExternalProtos) {
        ProtoableNode proto = null;
        int eClassTag = this.getClassTag();
        if (this.mbCurrentlyResolvingProto) {
            MsgFormatPos message = new MsgFormatPos(ResId.CircularProtoException);
            message.format(this.getSOMExpression());
            throw new ExFull(message);
        }
        this.mbHasExternalProto = false;
        this.mbExternalProtoFailed = false;
        this.mbExternalProtoResolved = false;
        this.mbCurrentlyResolvingProto = true;
        IDValueMap idValueMap = new IDValueMap();
        try {
            boolean bMarkAsTransient = false;
            int eAttrTag = -1;
            StringBuilder sAttrValue = new StringBuilder();
            if (bResolveExternalProtos && this.isPropertySpecified(XFA.USEHREFTAG, false, 0)) {
                boolean bIsInternalProto;
                eAttrTag = XFA.USEHREFTAG;
                sAttrValue.append(this.getAttribute(eAttrTag, false, false).toString());
                if (sAttrValue.length() == 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = bIsInternalProto = sAttrValue.length() > 1 && sAttrValue.charAt(0) == '.' && sAttrValue.charAt(1) == '#';
                if (bIsInternalProto) {
                    sAttrValue.delete(0, 1);
                    if (sAttrValue.length() > 5 && sAttrValue.charAt(1) == 's' && sAttrValue.charAt(2) == 'o' && sAttrValue.charAt(3) == 'm' && sAttrValue.charAt(4) == '(' && sAttrValue.charAt(sAttrValue.length() - 1) == ')') {
                        sAttrValue.delete(0, 5);
                        sAttrValue.delete(sAttrValue.length() - 1, sAttrValue.length());
                    }
                }
                if (bIsInternalProto) {
                    proto = this.findInternalProto(eClassTag, eClassTag, this, sAttrValue.toString(), false);
                } else {
                    this.mbHasExternalProto = true;
                    proto = this.findExternalProto(eClassTag, eClassTag, sAttrValue.toString(), false);
                    this.mbExternalProtoFailed = proto == null;
                    bMarkAsTransient = this.getAppModel().getExternalProtosAreTransient();
                    idValueMap.installOnModel(this.getModel());
                    if (!bMarkAsTransient && this.getAppModel().getHrefHandler() != null) {
                        this.removeAttr(null, this.getAtom(eAttrTag));
                    }
                }
            } else if (proto == null) {
                eAttrTag = XFA.USETAG;
                sAttrValue.setLength(0);
                Attribute attr = this.getAttribute(eAttrTag, true, false);
                sAttrValue.append(null == attr ? "" : attr.toString());
                if (bResolveExternalProtos) {
                    if (sAttrValue.length() > 0) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    if (sAttrValue.length() == 0) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bIsFragmentDoc = this.getAppModel().getIsFragmentDoc();
                    assert (!bIsFragmentDoc);
                    if (!bIsFragmentDoc) {
                        proto = this.findInternalProto(eClassTag, eClassTag, this, sAttrValue.toString(), false);
                    } else {
                        this.getModel().removeIDReferenceNode(this);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            this.getModel().removeIDReferenceNode(this);
            if (proto == null || proto == this) {
                this.foundBadAttribute(eAttrTag, sAttrValue.toString());
                boolean bl = true;
                return bl;
            }
            this.resolveProto(proto, this.mbHasExternalProto, bMarkAsTransient, this.mbHasExternalProto);
            if (idValueMap.isActive() && !idValueMap.verifySelfContained(sAttrValue.toString(), this.getSOMExpression(), proto)) {
                this.clearExternalProtos();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            idValueMap.destroy();
            this.mbCurrentlyResolvingProto = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSave(boolean bSaveXMLScript) {
        if (bSaveXMLScript && this.getSaveXMLSaveTransient() && this.hasProto()) {
            boolean bOldMuteValue = this.isMute();
            this.mute();
            try {
                boolean previousWillDirty = this.getWillDirty();
                this.setWillDirty(false);
                try {
                    boolean bWasDefault = this.isDefault(false);
                    this.fullyResolve(false);
                    if (bWasDefault) {
                        this.makeDefault();
                    }
                }
                finally {
                    this.setWillDirty(previousWillDirty);
                }
            }
            finally {
                if (!bOldMuteValue) {
                    this.unMute();
                }
            }
        }
        super.preSave(bSaveXMLScript);
    }

    private void removeProtoed(ProtoableNode protoable) {
        if (this.mProtoed == null) {
            return;
        }
        if (this.getModel() == null) {
            if (this.mProtoed != null) {
                this.mProtoed.clear();
                this.mProtoed = null;
            }
            return;
        }
        int nSize = this.mProtoed.size();
        for (int nIndex = 0; nIndex < nSize; ++nIndex) {
            if (this.mProtoed.get(nIndex) != protoable) continue;
            this.mProtoed.remove(nIndex);
            break;
        }
    }

    public final boolean reResolveProto(boolean bFull) {
        ProtoableNode proto = this.getProto();
        if (proto != null) {
            this.clearProtos();
            return this.resolveProto(proto, bFull, false, false);
        }
        return false;
    }

    public boolean resolveProto(ProtoableNode srcProto, boolean bFull, boolean bMarkTransient, boolean bSrcIsExternal) {
        IDValueMap idValueMap;
        Node targetChild;
        Node srcChild;
        NodeList srcProtoChildren;
        if (srcProto == this) {
            assert (false);
            return false;
        }
        assert (this.isSameClass(srcProto));
        if (this.hasProto()) {
            if (srcProto == this.mProto) {
                return true;
            }
            this.clearProtos();
        }
        if (bSrcIsExternal) {
            this.clearExternalProtos();
            this.mExternalProto = srcProto;
        }
        if (this.mbHasExternalProto && bSrcIsExternal) {
            this.mbExternalProtoResolved = true;
        }
        AppModel sourceAppModel = srcProto.getAppModel();
        assert (sourceAppModel != null);
        boolean bSourceResolved = false;
        if (srcProto.isPropertySpecified(XFA.USEHREFTAG, false, 0) && !srcProto.mbExternalProtoResolved) {
            srcProto.performResolveProtos(true);
        } else if (!bSourceResolved && srcProto.isPropertySpecified(XFA.USETAG, false, 0) && !srcProto.hasProto() && !sourceAppModel.getIsFragmentDoc()) {
            srcProto.performResolveProtos(false);
        }
        if (!bFull) {
            if (this.mProto != null) {
                this.mProto.removeProtoed(this);
            }
            this.mProto = srcProto;
            srcProto.addProtoed(this);
            if (srcProto.isSameClass(XFA.EXDATATAG) && srcProto.isPropertySpecified(XFA.CONTENTTYPETAG, false, 0)) {
                boolean bMute = this.isMute();
                this.mute();
                this.setAttribute(srcProto.getAttribute(XFA.CONTENTTYPETAG), XFA.CONTENTTYPETAG);
                if (!bMute) {
                    this.unMute();
                }
            }
            if (srcProto.isLeaf()) {
                return true;
            }
        } else {
            this.mProto = null;
        }
        boolean bWasLocked = this.getLocked();
        this.unLock();
        if (bFull) {
            SchemaPairs attrs = this.getNodeSchema().getValidAttributes();
            IDValueMap idValueMap2 = this.getModel().getIDValueMap();
            if (attrs != null) {
                for (int i = 0; i < attrs.size(); ++i) {
                    int eTag = attrs.key(i);
                    if (eTag == XFA.USEHREFTAG || !srcProto.isPropertySpecified(eTag, true, 0) || this.isPropertySpecified(eTag, true, 0)) continue;
                    if (eTag == XFA.IDTAG && idValueMap2 != null) {
                        String sSrcIDValue = srcProto.getAttribute(eTag).toString();
                        String sNewIDValue = idValueMap2.getPrefix() + ":" + sSrcIDValue;
                        this.setAttribute(new StringAttr("id", sNewIDValue), eTag);
                    } else if (eTag == XFA.USETAG && idValueMap2 != null) {
                        String sSrcReference = srcProto.getAttribute(eTag).toString();
                        if (sSrcReference.length() >= 1 && sSrcReference.charAt(0) == '#') {
                            sSrcReference = sSrcReference.substring(1);
                            String sNewReference = "#" + idValueMap2.getPrefix() + ":" + sSrcReference;
                            this.setAttribute(new StringAttr("use", sNewReference), eTag);
                            idValueMap2.getReferenceList().add(sSrcReference);
                        } else {
                            this.setAttribute(srcProto.getAttribute(eTag), eTag);
                        }
                    } else {
                        this.setAttribute(srcProto.getAttribute(eTag), eTag);
                    }
                    if (!bMarkTransient && !bSrcIsExternal) continue;
                    Attribute node = this.getAttribute(eTag, false, false);
                    int index = this.getAttrIndex(node);
                    this.setAttrProp(index, 4, bMarkTransient);
                    this.setAttrProp(index, 2, bSrcIsExternal);
                }
            }
        }
        ArrayList<String> useIDs = null;
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.isPropertySpecified(XFA.USEHREFTAG, false, 0)) {
                String sUseRef = ((Element)child).getAttribute(XFA.USEHREFTAG, false, false).toString();
                int nSharp = sUseRef.indexOf(35);
                assert (nSharp >= 0);
                if (useIDs == null) {
                    useIDs = new ArrayList<String>();
                }
                useIDs.add(sUseRef.substring(nSharp + 1));
                continue;
            }
            if (!child.isPropertySpecified(XFA.USETAG, false, 0)) continue;
            String sUse = ((Element)child).getAttribute(XFA.USETAG, false, false).toString();
            if (useIDs == null) {
                useIDs = new ArrayList();
            }
            useIDs.add(sUse.substring(1));
        }
        NodeList targetProtoProperties = this.enumerateProperties();
        if (!bFull && targetProtoProperties == null) {
            srcProtoChildren = srcProto.enumerateChildren();
        } else {
            ArrayNodeList srcProtoProperties = new ArrayNodeList();
            srcProtoChildren = new ArrayNodeList();
            srcProto.resolveAndEnumerateChildren(srcProtoProperties, srcProtoChildren, false, false);
            int nSrcProtoProp = ((ListBase)srcProtoProperties).length();
            for (int i = 0; i < nSrcProtoProp; ++i) {
                int index;
                srcChild = (Node)((ListBase)srcProtoProperties).item(i);
                if (srcChild.isSameClass(XFA.PROTOTAG) || ProtoableNode.hasID(srcChild, useIDs)) continue;
                targetChild = null;
                if (targetProtoProperties != null && targetProtoProperties.length() > 0) {
                    Integer nLookupIndex = ((NodeList)srcProtoProperties).getOccurrence(srcChild);
                    targetChild = targetProtoProperties.getNamedItem(srcChild.getPrivateName(), srcChild.getClassAtom(), nLookupIndex);
                }
                if (targetChild != null && targetChild instanceof TextNode && srcProto != null && srcProto instanceof ImageValue && (index = srcProto.findSchemaAttr("transferEncoding")) != -1) {
                    targetChild = null;
                }
                boolean bCreate = false;
                if (targetChild == null && bFull) {
                    bCreate = true;
                }
                ProtoableNode.establishProtoRelationship(this, srcChild, targetChild, bFull, bCreate, bMarkTransient, bSrcIsExternal);
            }
        }
        Element srcOneOfChild = (Element)srcProto.getOneOfChild(true, false);
        if (!(srcOneOfChild == null || !bFull && srcOneOfChild instanceof Proto || ProtoableNode.hasID(srcOneOfChild, useIDs))) {
            Element targetOneOfChild = (Element)super.getOneOfChild(true, false);
            boolean bCreate = false;
            if (targetOneOfChild == null && bFull) {
                bCreate = true;
            }
            ProtoableNode.establishProtoRelationship(this, srcOneOfChild, targetOneOfChild, bFull, bCreate, bMarkTransient, bSrcIsExternal);
        }
        int nSrcProtoChildren = srcProtoChildren != null ? srcProtoChildren.length() : 0;
        for (int i = 0; i < nSrcProtoChildren; ++i) {
            srcChild = (Node)srcProtoChildren.item(i);
            if (!bFull && srcChild.isSameClass(XFA.PROTOTAG) || ProtoableNode.hasID(srcChild, useIDs)) continue;
            targetChild = null;
            NodeList targetProtoChildren = this.enumerateChildren();
            if (targetProtoChildren != null && targetProtoChildren.length() > 0) {
                Integer nLookupIndex = srcProtoChildren.getOccurrence(srcChild);
                targetChild = (Element)targetProtoChildren.getNamedItem(srcChild.getPrivateName(), srcChild.getClassAtom(), nLookupIndex);
            }
            ProtoableNode.establishProtoRelationship(this, (Element)srcChild, targetChild, bFull, true, bMarkTransient, bSrcIsExternal);
        }
        if (bFull && (idValueMap = this.getModel().getIDValueMap()) != null) {
            this.updateIDValues(idValueMap.getPrefix(), idValueMap.getReferenceList());
        }
        if (bWasLocked || srcProto.getLocked() || this.getXFAParent() != null && this.getXFAParent().getLocked()) {
            this.setLocked(true);
        }
        return true;
    }

    @Override
    public Node setElement(Node child, int eTag, int nOccurrence) {
        Element element;
        child = super.setElement(child, eTag, nOccurrence);
        if (this.hasProto() && child instanceof ProtoableNode && (element = this.mProto.peekElement(eTag, false, nOccurrence)) != null) {
            ProtoableNode protoableNode = (ProtoableNode)this.mProto.getElement(eTag, false, nOccurrence, false, false);
            ((ProtoableNode)child).resolveProto(protoableNode, false, false, false);
        }
        return child;
    }

    @Override
    public Node setOneOfChild(Node child) {
        Node oneOf;
        child = super.setOneOfChild(child);
        if (this.hasProto() && child instanceof ProtoableNode && (oneOf = this.mProto.getOneOfChild(true, false)) != null && child.isSameClass(oneOf.getClassTag())) {
            ProtoableNode oneOfChild = (ProtoableNode)this.mProto.getOneOfChild(false, false);
            ((ProtoableNode)child).resolveProto(oneOfChild, false, false, false);
        }
        return child;
    }

    @Override
    public void setAttribute(Attribute attr, int eTag) {
        super.setAttribute(attr, eTag);
        if (eTag == XFA.USETAG || eTag == XFA.USEHREFTAG) {
            if (attr == null) {
                if (eTag == XFA.USETAG && this.hasProto()) {
                    this.clearProtos();
                } else if (eTag == XFA.USEHREFTAG) {
                    this.clearProtos();
                    this.clearExternalProtos();
                    this.mbHasExternalProto = false;
                    if (this.isPropertySpecified(XFA.USETAG, false, 0)) {
                        this.performResolveProtos(false);
                    }
                }
                return;
            }
            Model model = this.getModel();
            if (model.isLoading()) {
                if (eTag == XFA.USETAG) {
                    model.addUseNode(this);
                }
            } else {
                this.clearProtos();
                this.clearExternalProtos();
                model.addUseNode(this);
                model.addUseHRefNode(this);
                model.resolveProtos(false);
            }
        }
    }

    @Override
    public void setPermsLock(boolean bPermsLock) {
        super.setPermsLock(bPermsLock);
        if (this.hasProto()) {
            this.mProto.setPermsLock(bPermsLock);
        }
    }

    public void setProto(ProtoableNode refProto) {
        if (this.mProto != null) {
            this.mProto.removeProtoed(this);
        }
        this.mProto = refProto;
        refProto.addProtoed(this);
        for (Node child = refProto.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            ProtoableNode srcProtoChild;
            ChildReln childR;
            if (!(child instanceof ProtoableNode) || (childR = this.getChildReln((srcProtoChild = (ProtoableNode)child).getClassTag())).getMax() == -1 || !srcProtoChild.isTransparent()) continue;
            srcProtoChild.createProto(this, false);
        }
    }

    public static void releaseExternalProtos(ProtoableNode node) {
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof ProtoableNode)) continue;
            ((ProtoableNode)child).mExternalProto = null;
            ProtoableNode.releaseExternalProtos((ProtoableNode)child);
        }
    }
}

