/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Delta;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Generator;
import com.adobe.xfa.HostPseudoModel;
import com.adobe.xfa.IDValueMap;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.ModelScript;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.NodeValidationInfo;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.Proto;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptDispatcher;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.SymbolTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public abstract class Model
extends Element
implements Element.DualDomNode {
    private static final boolean ACROBAT_PLUGIN = ResourceLoader.loadProperty("ACROBAT_PLUGIN").equalsIgnoreCase("true");
    private boolean mbLoading;
    protected boolean mbNormalizedNameSpaces;
    private boolean mbReady;
    protected boolean mbValidateTextOnLoad = true;
    private boolean mbWillDirtyDoc;
    private final List<Element> mErrorContextList = new ArrayList<Element>();
    private final List<ExFull> mErrorList = new ArrayList<ExFull>();
    private Generator mGenerator;
    private IDValueMap mIDValueMap;
    private String mName;
    private int mnCurrentVersion;
    private Element mAliasNode;
    private ProcessingInstruction moOriginalVersion;
    private final List<ProtoableNode> moProtoList = new ArrayList<ProtoableNode>();
    private Node moSOMContext;
    private final List<ProtoableNode> moUseHRefList = new ArrayList<ProtoableNode>();
    private final List<ProtoableNode> moUseList = new ArrayList<ProtoableNode>();
    private AppModel mAppModel;
    private String msCachedLocale;
    private final Schema mSchema;
    private final String mShortCutName;
    private SOMParser mSOMParser;
    private boolean mbAppModelIsTransient;
    private SymbolTable mSymbolTable;
    private boolean mbAllowUpdates;
    private Element mXmlPeer;
    protected int mnOriginalVersion = 0;

    public static boolean checkforCompatibleNS(String aNS, String aModelNS) {
        if (aNS == null) {
            return false;
        }
        if (aNS.length() == 0) {
            return false;
        }
        int nNSLen = aModelNS.length();
        return aNS.length() >= nNSLen && aNS.startsWith(aModelNS);
    }

    protected static Model getNamedModel(AppModel oAppModel, String aModelName) {
        for (Node child = oAppModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassName() != aModelName) continue;
            return (Model)child;
        }
        return null;
    }

    @Override
    public ScriptTable getScriptTable() {
        return ModelScript.getScriptTable();
    }

    static Node lookupShortCut(Model startModel, String sShortCutName) {
        if (startModel.shortCutName().equals(sShortCutName)) {
            return startModel.getAliasNode();
        }
        for (Node child = startModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            Node retNode;
            if (!(child instanceof Model) || (retNode = Model.lookupShortCut((Model)child, sShortCutName)) == null) continue;
            return retNode;
        }
        return null;
    }

    static void resolveList(List<? extends ProtoableNode> oPendingProtos, boolean bResolveExternalOnly) {
        int nPos = 0;
        int nLen = oPendingProtos.size();
        while (nLen > 0 && nPos != nLen) {
            ProtoableNode oObject = oPendingProtos.get(nPos);
            boolean bRemoved = oObject.performResolveProtos(bResolveExternalOnly);
            if (!bRemoved) {
                ++nPos;
            }
            nLen = oPendingProtos.size();
        }
    }

    protected Model(Element parent, Node prevSibling, String uri, String qName, String name, String aShortCutName, int classTag, String className, Schema schema) {
        super(parent, prevSibling, uri, name, qName, null, classTag, className);
        Element currentParent;
        if (this.getClass() == AppModel.class) assert (parent == null);
        if (parent != null && parent.getClass() != AppModel.class) {
            throw new IllegalArgumentException("parent is not an AppModel.");
        }
        this.mShortCutName = aShortCutName;
        this.mSchema = schema;
        this.setModel(this);
        if (name.length() > 0) {
            this.setName(name);
        }
        if ((currentParent = parent) != null) {
            for (parent = parent.getXFAParent(); parent != null; parent = parent.getXFAParent()) {
                currentParent = parent;
            }
            assert (currentParent instanceof AppModel);
            if (currentParent instanceof AppModel) {
                this.setAppModel((AppModel)currentParent);
            }
        }
        this.setCurrentVersion(this.getHeadVersion());
        if (uri != "" && uri != null) {
            int nVersion = this.getVersion(uri);
            this.setCurrentVersion(nVersion);
        }
    }

    protected void addAttributes(Element pParent, Attribute[] oAttributes, Generator generator) {
    }

    public final void addErrorList(ExFull error, int eSeverity, Element context) {
        this.mErrorList.add(error);
        this.mErrorContextList.add(context);
        LogMessage oMsg = new LogMessage();
        oMsg.insertMessage(error, eSeverity, this.getCachedLocale());
        this.getLogMessenger().sendMessage(oMsg);
    }

    public final void removeLastError() {
        if (this.mErrorList.size() > 0) {
            this.mErrorList.remove(this.mErrorList.size() - 1);
        }
    }

    protected void removeOriginalVersionNode() {
        if (this.moOriginalVersion != null) {
            this.moOriginalVersion.remove();
        }
    }

    void addProto(ProtoableNode poProto) {
        this.moProtoList.add(poProto);
    }

    public void addUseHRefNode(Element poUseHRefNode) {
        if (poUseHRefNode instanceof ProtoableNode) {
            this.moUseHRefList.add((ProtoableNode)poUseHRefNode);
        }
    }

    public void addUseNode(Element poUse) {
        for (int i = 0; i < this.moUseList.size(); ++i) {
            if (poUse != this.moUseList.get(i)) continue;
            return;
        }
        if (poUse instanceof ProtoableNode) {
            this.moUseList.add((ProtoableNode)poUse);
        }
    }

    protected final void addXMLLoadErrorContext(int lineNumber, String fileName, ExFull oEx) {
        if (!StringUtils.isEmpty(fileName) && lineNumber != 0) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLFileLineNumberLoadException);
            oMessage.format(fileName);
            oMessage.format(Integer.toString(lineNumber));
            ExFull err2 = new ExFull(oMessage);
            oEx.insert(err2, true);
        } else if (!StringUtils.isEmpty(fileName)) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLFileLoadException);
            oMessage.format(fileName);
            ExFull err2 = new ExFull(oMessage);
            oEx.insert(err2, true);
        } else if (lineNumber > 0) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLLineNumberLoadException);
            oMessage.format(Integer.toString(lineNumber));
            ExFull err2 = new ExFull(oMessage);
            oEx.insert(err2, true);
        }
    }

    public void addXMLLoadErrorContext(Node oSrc, ExFull oEx) {
        Node oNode = oSrc;
        String sFileName = oNode.getOwnerDocument().getParseFileName();
        if (sFileName == null) {
            sFileName = "";
        }
        if (oNode instanceof Chars) {
            oNode = oNode.getXMLParent();
        }
        String sLineNumber = "";
        if (oNode instanceof Element) {
            int nLineNumber = ((Element)oNode).getLineNumber();
            sLineNumber = Integer.toString(nLineNumber);
        }
        if (sFileName.length() > 0 && sLineNumber.length() > 0) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLFileLineNumberLoadException);
            oMessage.format(sFileName);
            oMessage.format(sLineNumber);
            ExFull pErr2 = new ExFull(oMessage);
            oEx.insert(pErr2, true);
        } else if (sFileName.length() > 0) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLFileLoadException);
            oMessage.format(sFileName);
            ExFull pErr2 = new ExFull(oMessage.resId(), oMessage.toString());
            oEx.insert(pErr2, true);
        } else if (sLineNumber.length() > 0) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.XMLLineNumberLoadException);
            oMessage.format(sLineNumber);
            ExFull pErr2 = new ExFull(oMessage.resId(), oMessage.toString());
            oEx.insert(pErr2, true);
        }
    }

    boolean allowUpdates() {
        return this.mbAllowUpdates;
    }

    public void allowUpdates(boolean bAllowUpdates) {
        this.mbAllowUpdates = bAllowUpdates;
    }

    public void clearErrorList() {
        this.mErrorList.clear();
        this.mErrorContextList.clear();
    }

    @Override
    public Element clone(Element parent, boolean bDeep) {
        MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidMethodException, this.getClassAtom());
        oMessage.format("clone");
        throw new ExFull(oMessage);
    }

    protected void createDOM(Element parent) {
        List<ModelFactory> factoryList = parent.getAppModel().factories();
        int count = factoryList.size();
        for (int i = 0; i < count; ++i) {
            ModelFactory factory = factoryList.get(i);
            factory.createDOM(parent);
        }
    }

    public Element createElement(Element parent, Node prevSibling, String uri, String qName) {
        return this.createElement(parent, prevSibling, uri, qName, qName, null, 0, null);
    }

    public Element createElement(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int lineNumber, String fileName) {
        int eTag;
        Element retVal;
        block15: {
            super.setLineNumber(lineNumber);
            retVal = null;
            eTag = XFA.INVALID_ELEMENT;
            Schema oSchema = this.getSchema();
            Model model = null;
            if (parent != null) {
                model = parent.getModel();
            }
            if (parent instanceof Model) {
                model = (Model)parent;
                oSchema = model.getSchema();
            } else if (parent instanceof Element) {
                model = parent.getModel();
                oSchema = model.getSchema();
            }
            try {
                if (parent != null && (parent.getElementClass() == XFA.INVALID_ELEMENT || parent.getElementClass() == XFA.PACKETTAG)) {
                    retVal = new Element(parent, prevSibling, uri, localName, qName, attributes, XFA.INVALID_ELEMENT, localName);
                    return retVal;
                }
                eTag = oSchema.getElementTag(uri, localName);
                if (eTag < 0) {
                    eTag = oSchema.getElementTag(parent);
                }
                if (eTag < 0) {
                    throw new ExFull(ResId.InvalidNodeTypeException, localName);
                }
                boolean bValid = true;
                if (parent != null && !parent.isValidChild(eTag, 0, true, false)) {
                    bValid = false;
                    int eRemappedTag = this.remapTag(eTag);
                    if (eTag != eRemappedTag && parent.isValidChild(eRemappedTag, 0, true, false)) {
                        eTag = eRemappedTag;
                        bValid = true;
                    }
                }
                retVal = oSchema.getInstance(eTag, this, parent, prevSibling, true);
                if (!bValid) {
                    MsgFormatPos msg = new MsgFormatPos(ResId.InvalidChildAppendException, parent.getClassName());
                    msg.format(localName);
                    ExFull err = new ExFull(msg);
                    if (null != parent.getChildReln(retVal.getClassTag())) {
                        ExFull err2 = new ExFull(ResId.OccurrenceViolationException, localName);
                        err.insert(err2, true);
                    }
                    this.addXMLLoadErrorContext(lineNumber, fileName, err);
                    retVal.setClass(retVal.getClassName(), XFA.INVALID_ELEMENT);
                    this.addErrorList(err, 3, retVal);
                }
            }
            catch (ExFull e) {
                boolean bReportError = true;
                if (uri != null && uri.length() > 0 && model != null && !model.isCompatibleNS(uri)) {
                    if (retVal != null) {
                        retVal.inhibitPrettyPrint(true);
                    }
                    bReportError = false;
                }
                retVal = new Element(parent, prevSibling, uri, localName, qName, null, XFA.INVALID_ELEMENT, localName);
                if (!bReportError) break block15;
                this.addXMLLoadErrorContext(lineNumber, fileName, e);
                this.addErrorList(e, 3, retVal);
            }
        }
        retVal.setLineNumber(lineNumber);
        retVal.setClass(parent, eTag);
        retVal.setDOMProperties(uri, localName, qName, attributes);
        return retVal;
    }

    public final Element createElement(int eTag, String name) {
        String className = XFA.getAtom(eTag);
        Element e = this.createElement(null, null, null, className, className, null, 0, null);
        if (name != null && name.length() > 0) {
            e.setName(name);
        }
        return e;
    }

    public final Element createElement(String className, String name, Element parent) {
        Element e = this.createElement(parent, null, parent.getModel().getNS(), className, className, null, 0, null);
        if (name != null && name.length() > 0) {
            e.setName(name);
        }
        return e;
    }

    public Element createElement(String name) {
        return this.createElement(null, null, null, name, name, null, 0, null);
    }

    public abstract Node createNode(int var1, Element var2, String var3, String var4, boolean var5);

    public final TextNode createTextNode(Element parent, Node prevSibling, char[] ch, int start, int length) {
        return new TextNode(parent, prevSibling, ch, start, length);
    }

    public final TextNode createTextNode(Element parent, Node prevSibling, String text) {
        return new TextNode(parent, prevSibling, text);
    }

    public final Element getAliasNode() {
        if (this.mAliasNode == null) {
            return this;
        }
        return this.mAliasNode;
    }

    @Override
    public AppModel getAppModel() {
        return this.mAppModel;
    }

    public boolean getAppModelIsTransient() {
        return this.mbAppModelIsTransient;
    }

    public abstract String getBaseNS();

    public String getCachedLocale() {
        if (StringUtils.isEmpty(this.msCachedLocale)) {
            LcLocale oLocale = new LcLocale(LcLocale.getLocale());
            if (!oLocale.isValid()) {
                oLocale = new LcLocale("en_US");
            }
            this.msCachedLocale = oLocale.getIsoName();
        }
        return this.msCachedLocale;
    }

    public final Node getContext() {
        if (this.moSOMContext == null) {
            return this;
        }
        return this.moSOMContext;
    }

    public int getCurrentVersion() {
        if (this.mnCurrentVersion == 0) {
            return this.getHeadVersion();
        }
        if (this.mnCurrentVersion > this.getHeadVersion()) {
            return this.getHeadVersion();
        }
        return this.mnCurrentVersion;
    }

    public Obj getDeltas(Element oNode) {
        return new XFAList();
    }

    public final Document getDocument() {
        return this.getOwnerDocument();
    }

    public Obj getDelta(Element node, String sSOM) {
        return new Delta(node, null, sSOM);
    }

    public List<Element> getErrorContextList() {
        return this.mErrorContextList;
    }

    public List<ExFull> getErrorList() {
        return this.mErrorList;
    }

    public EventManager getEventManager() {
        return this.getAppModel().getEventManager();
    }

    public Generator getGenerator() {
        return this.mGenerator;
    }

    public abstract String getHeadNS();

    public int getHeadVersion() {
        return 36;
    }

    public IDValueMap getIDValueMap() {
        return this.mIDValueMap;
    }

    public boolean getLegacySetting(AppModel.LegacyMask nLegacyFlag) {
        assert (false);
        return false;
    }

    public LogMessenger getLogMessenger() {
        return this.getAppModel().getLogMessenger();
    }

    @Override
    public final String getName() {
        if (this.mName != null) {
            return this.mName;
        }
        return super.getName();
    }

    public boolean getNeedsNSNormalize() {
        return this.mbNormalizedNameSpaces;
    }

    public Element getNode(String aID) {
        String aModelNamespace = this.getNSInternal();
        Element oElement = this.getOwnerDocument().getElementByXFAId(aModelNamespace, aID);
        if (oElement == null) {
            return null;
        }
        return oElement.getXfaPeer();
    }

    @Override
    public String getNS() {
        int nVersion = this.getCurrentVersion();
        if (nVersion > 0) {
            return this.getNS(nVersion);
        }
        if (this.getAppModel().getSourceBelow() == 0x7D0000) {
            return this.getHeadNS();
        }
        return super.getNS();
    }

    protected String getNS(int nVersion) {
        String sNS = "";
        if (nVersion > 0) {
            StringBuilder sNSBuf = new StringBuilder(this.getBaseNS());
            sNSBuf.append(nVersion);
            sNSBuf.insert(sNSBuf.length() - 1, '.');
            sNSBuf.append('/');
            sNS = sNSBuf.toString().intern();
        }
        return sNS;
    }

    public String getOriginalVersion(boolean bDefault) {
        if (this.moOriginalVersion != null) {
            if (this.moOriginalVersion.getXMLParent() == null) {
                this.moOriginalVersion = null;
            } else {
                return this.moOriginalVersion.getData();
            }
        }
        if (this.moOriginalVersion == null && bDefault) {
            return "";
        }
        return "";
    }

    public ProcessingInstruction getOriginalVersionNode(boolean bCreate, String sValue) {
        if ((this.moOriginalVersion == null || this.moOriginalVersion.getXMLParent() == null) && bCreate) {
            this.moOriginalVersion = new ProcessingInstruction(null, null, "originalXFAVersion", sValue);
            if (!ACROBAT_PLUGIN) {
                this.appendChild(this.moOriginalVersion, false);
            }
        }
        return this.moOriginalVersion;
    }

    public List<ProtoableNode> getProtoList() {
        return this.moProtoList;
    }

    @Override
    public final Schema getSchema() {
        return this.mSchema;
    }

    ScriptHandler getScriptHandler(String sLanguageName) {
        return this.getAppModel().getScriptHandler(sLanguageName);
    }

    public int getSourceBelow() {
        return this.getAppModel().getSourceBelow();
    }

    public int getVersion(String sNS) {
        int nLast;
        String sBaseNS;
        int nStart;
        int nRet = 0;
        if (!StringUtils.isEmpty(sNS) && (nStart = sNS.indexOf(sBaseNS = this.getBaseNS())) >= 0 && (nLast = sNS.lastIndexOf(47)) > (nStart += sBaseNS.length())) {
            String sNum = sNS.substring(nStart, nLast);
            double dValue = Double.parseDouble(sNum);
            nRet = (int)(dValue * 10.0);
        }
        return nRet;
    }

    @Override
    public void setXmlPeer(Node peer) {
        this.mXmlPeer = (Element)peer;
    }

    @Override
    public Node getXmlPeer() {
        return this.mXmlPeer;
    }

    final void initializeSymbolTable() {
        this.mSymbolTable = new SymbolTable();
    }

    final void disposeSymbolTable() {
        this.mSymbolTable = null;
    }

    protected Node doLoadNode(Element parent, Node node, Generator genTag) {
        Element newNode;
        Model model = parent.getModel();
        if (node instanceof Chars) {
            return model.createTextNode(parent, null, ((Chars)node).getData());
        }
        assert (node instanceof Element);
        Element element = (Element)node;
        try {
            int eTag = XFA.getElementTag(element.getLocalName());
            if (eTag == -1) {
                throw new ExFull(new MsgFormatPos(ResId.InvalidNodeTypeException, element.getLocalName()));
            }
            newNode = this.getSchema().getInstance(eTag, this, parent, null, true);
            newNode.setDOMProperties(element.getNS(), element.getLocalName(), element.getXMLName(), null);
        }
        catch (ExFull exception) {
            this.addXMLLoadErrorContext(node, exception);
            this.addErrorList(exception, 3, null);
            return null;
        }
        this.doLoadAttributes(element, newNode);
        Node child = node.getFirstXMLChild();
        while (child != null) {
            Node nextChild = this.preLoadNode(newNode, child, genTag);
            if (child.getXFAParent() == null) break;
            if (child instanceof Element || child instanceof Chars) {
                this.doLoadNode(newNode, child, genTag);
            }
            child = nextChild;
        }
        if (newNode instanceof Content && newNode.getFirstXFAChild() == null) {
            new TextNode(newNode, null, "");
        }
        return newNode;
    }

    protected void doLoadAttributes(Element fromElement, Element toElement) {
        int numAttrs = fromElement.getNumAttrs();
        for (int i = 0; i < numAttrs; ++i) {
            Attribute attr = fromElement.getAttr(i);
            String aName = attr.getLocalName();
            if (attr.isXSINilAttr()) {
                toElement.updateAttribute(attr);
                continue;
            }
            boolean bHandled = this.saveProtoInformation(toElement, aName, i == 0);
            if (bHandled) continue;
            int eTag = XFA.getAttributeTag(aName);
            if (eTag == -1 || !toElement.isValidAttr(eTag, true, null)) {
                if (attr.isNameSpaceAttr()) continue;
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidAttributeLoadException);
                message.format(aName);
                message.format(fromElement.getName());
                message.format(fromElement.getLineNumber());
                this.addErrorList(new ExFull(message), 3, null);
                continue;
            }
            toElement.setAttribute(attr, eTag);
        }
    }

    public boolean isCompatibleNS(String aNS) {
        return Model.checkforCompatibleNS(aNS, this.getBaseNS());
    }

    @Override
    public final boolean isContainer() {
        return true;
    }

    public final boolean isLoading() {
        return this.mbLoading;
    }

    protected final void isLoading(boolean bIsLoading) {
        this.mbLoading = bIsLoading;
    }

    public boolean isVersionCompatible(int nVersion, int nTargetVersion) {
        return nVersion <= nTargetVersion;
    }

    public void loadNode(Element parent, Node node, Generator genTag) {
        if (parent instanceof AppModel) {
            AppModel appModel = (AppModel)parent;
            List<ModelFactory> factoryList = appModel.factories();
            int nFactoryCount = factoryList.size();
            for (int i = 0; i < nFactoryCount; ++i) {
                Element oParentNode;
                Model oNewModel;
                ModelFactory factory = factoryList.get(i);
                if (!factory.isRootNode((AppModel)node, null, node.getName())) continue;
                boolean stripWhiteSpace = true;
                for (Node oNode = node.getFirstXMLChild(); oNode != null; oNode = oNode.getNextXMLSibling()) {
                    if (oNode instanceof TextNode) {
                        if (((TextNode)oNode).isXMLSpace()) continue;
                        stripWhiteSpace = false;
                        break;
                    }
                    if (!(oNode instanceof Chars) || ((Chars)oNode).isXMLSpace()) continue;
                    stripWhiteSpace = false;
                    break;
                }
                if (stripWhiteSpace && node instanceof Element && !node.getOwnerDocument().isIncrementalLoad()) {
                    ((Element)node).removeWhiteSpace();
                }
                if ((oNewModel = factory.findModel(oParentNode = parent)) == null) {
                    oNewModel = factory.newModel(appModel, node, null, node.getName(), "", null);
                }
                oNewModel.postLoad();
                return;
            }
            return;
        }
    }

    public boolean loadSpecialAttribute(Attribute attr, String aLocalName, Element element, boolean bCheckOnly) {
        if (attr.isXSINilAttr()) {
            return true;
        }
        String ns = attr.getNS();
        if (ns == null || !attr.getNS().startsWith("http://www.xfa.org/schema/xfa-events/")) {
            return false;
        }
        if (aLocalName == "script") {
            if (bCheckOnly) {
                return true;
            }
            EventManager tm = this.getEventManager();
            String sEventName = element.getEvent().trim();
            if (!StringUtils.isEmpty(sEventName)) {
                int index = sEventName.indexOf(32);
                if (index != -1) {
                    sEventName = sEventName.substring(0, index);
                }
                assert (!StringUtils.isEmpty(sEventName));
                if (StringUtils.isEmpty(sEventName)) {
                    return true;
                }
                String sEventContext = "$";
                index = sEventName.indexOf(58);
                if (index != -1) {
                    sEventContext = sEventName.substring(0, index);
                    sEventName = sEventName.substring(index + 1);
                }
                int nEventID = tm.getEventID(sEventName);
                ScriptDispatcher sd = new ScriptDispatcher(element, sEventContext, nEventID, tm, element.getEventScript(null), element.getEventContentType(null));
                tm.registerEvents(sd);
            }
            return true;
        }
        if (aLocalName == "event") {
            return true;
        }
        return aLocalName == "contentType";
    }

    public boolean loadSpecialNode(Element parent, Node node, boolean bCheckOnly) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String aNodeLocalName = element.getLocalName();
        if (aNodeLocalName != "script") {
            return false;
        }
        String ns = element.getNS();
        if (ns == null || !element.getNS().startsWith("http://www.xfa.org/schema/xfa-events/")) {
            return false;
        }
        if (bCheckOnly) {
            return true;
        }
        if (element.getNumAttrs() != 0) {
            EventManager tm = this.getEventManager();
            int len = element.getNumAttrs();
            for (int i = 0; i < len; ++i) {
                Attribute attr = element.getAttr(i);
                if (attr.getLocalName() != "event" || !attr.getNS().startsWith("http://www.xfa.org/schema/xfa-events/")) continue;
                String sEventName = attr.getAttrValue().trim();
                int index = sEventName.indexOf(32);
                if (index != -1) {
                    sEventName = sEventName.substring(0, index);
                }
                assert (!StringUtils.isEmpty(sEventName));
                if (StringUtils.isEmpty(sEventName)) continue;
                String sEventContext = "$";
                index = sEventName.indexOf(58);
                if (index != -1) {
                    sEventContext = sEventName.substring(0, index);
                    sEventName = sEventName.substring(index + 1);
                }
                int nEventID = tm.getEventID(sEventName);
                ScriptDispatcher sd = new ScriptDispatcher(parent, sEventContext, nEventID, tm, parent.getEventScript(element), parent.getEventContentType(element));
                tm.registerEvents(sd);
                break;
            }
        }
        return true;
    }

    protected void loadXMLImpl(Element parent, InputStream is, boolean bIgnoreAggregatingTag, Element.ReplaceContent eReplaceContent) {
        Node nextChild;
        Node child;
        if (parent instanceof Element.DualDomNode && !(parent instanceof Model) && !(parent instanceof Packet)) {
            assert (false);
            MsgFormatPos msg = new MsgFormatPos(ResId.UnsupportedOperationException);
            msg.format("loadXML");
            msg.format("");
            throw new ExFull(msg);
        }
        if (eReplaceContent == Element.ReplaceContent.AllContent) {
            child = parent.getFirstXMLChild();
            while (child != null) {
                nextChild = child.getNextXMLSibling();
                child.remove();
                child = nextChild;
            }
        } else if (eReplaceContent == Element.ReplaceContent.XFAContent) {
            child = parent.getFirstXFAChild();
            while (child != null) {
                nextChild = child.getNextXFASibling();
                child.remove();
                child = nextChild;
            }
        }
        Document doc = this.getDocument();
        doc.setContext(this, parent, bIgnoreAggregatingTag);
        doc.load(is, null, false);
        parent.resetPostLoadXML();
        this.resolveProtos(false);
        AppModel appModel = this.getAppModel();
        if (appModel != null && !appModel.getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
            parent.notifyPeers(7, "", parent);
        }
    }

    public boolean loadRootAttributes() {
        return false;
    }

    public void modelCleanup(Node node) {
        int nChildren;
        int nodeTag = node.getClassTag();
        if (node instanceof ProtoableNode) {
            ProtoableNode proto = (ProtoableNode)node;
            if (proto.hasExternalProto()) {
                return;
            }
            if (proto.hasProto()) {
                return;
            }
        }
        if (XFA.RICHTEXTNODETAG == nodeTag || XFA.XMLMULTISELECTNODETAG == nodeTag || XFA.INVALID_ELEMENT == nodeTag) {
            return;
        }
        if (node instanceof TextNode) {
            this.nodeCleanup(node, false, false);
        }
        if (!(node instanceof Element)) {
            return;
        }
        Element pNode = (Element)node;
        for (int i = nChildren = pNode.getXFAChildCount(); i > 0; --i) {
            Node pChild = pNode.getXFAChild(i - 1);
            this.modelCleanup(pChild);
        }
        boolean bHasNonDefaultAttributes = false;
        try {
            for (int j = pNode.getNumAttrs(); j > 0; --j) {
                int eTag;
                String aName = pNode.getAttrName(j - 1);
                String sVal = pNode.getAttrVal(j - 1);
                String aNS = pNode.getAttrNS(j - 1);
                if (aNS == "") {
                    aNS = this.getNS();
                }
                if ((eTag = this.getSchema().getAttributeTag(aNS, aName)) != -1 && this.doAttributeCleanup(pNode, eTag, sVal)) {
                    pNode.removeAttr(j - 1);
                    continue;
                }
                bHasNonDefaultAttributes = true;
            }
        }
        catch (ExFull e) {
            // empty catch block
        }
        Element pParent = pNode.getXFAParent();
        int parentTag = pParent.getClassTag();
        if (pNode.getFirstXFAChild() == null && !bHasNonDefaultAttributes) {
            ChildReln pSchema = pParent.getChildReln(nodeTag);
            if (pSchema.getOccurrence() == 1) {
                this.nodeCleanup(pNode, bHasNonDefaultAttributes, false);
                return;
            }
            if (pSchema.getOccurrence() == 2 && parentTag == XFA.BORDERTAG && nodeTag == XFA.CORNERTAG) {
                this.nodeCleanup(pNode, bHasNonDefaultAttributes, false);
                return;
            }
            if (pSchema.getOccurrence() == 4) {
                if (parentTag == XFA.UITAG && pNode.isDefault(false) && nodeTag != XFA.DEFAULTUITAG) {
                    pNode.makeNonDefault(false);
                    return;
                }
                if (parentTag != XFA.UITAG && pNode instanceof Element && pParent.defaultElement() == nodeTag) {
                    this.nodeCleanup(pNode, bHasNonDefaultAttributes, false);
                    return;
                }
            }
            return;
        }
        this.nodeCleanup(pNode, bHasNonDefaultAttributes, pNode.getFirstXFAChild() != null);
    }

    public void nodeCleanup(Node pNode, boolean bHasAttrs, boolean bHasChildren) {
    }

    public boolean doAttributeCleanup(Node node, int eAttributeTag, String sAttrValue) {
        Element pNode = (Element)node;
        Element poParent = null;
        int eClassTag = 0;
        if (pNode != null) {
            poParent = pNode.getXFAParent();
            eClassTag = pNode.getClassTag();
        }
        if (eAttributeTag != XFA.XMLNSTAG && eAttributeTag != XFA.ACTIVITYTAG && eAttributeTag != XFA.COMMITONTAG && eAttributeTag != XFA.HIGHLIGHTTAG && null != pNode && pNode.isValidAttr(eAttributeTag, false, null) && pNode.newAttribute(eAttributeTag, sAttrValue).toString().equals(pNode.defaultAttribute(eAttributeTag).toString())) {
            Element poField;
            if (eAttributeTag == XFA.TYPEFACETAG && poParent != null && (poField = poParent.getXFAParent()) != null) {
                String sVal = "";
                Element pChild = null;
                for (Node child = poField.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    pChild = (Element)child;
                    if (pChild == null || pChild.getClassTag() != eClassTag) continue;
                    sVal = pChild.getAttribute(eAttributeTag).getAttrValue();
                    break;
                }
                if (pChild != null && !sVal.equals("") && pChild.isValidAttr(eAttributeTag, false, null) && pChild.newAttribute(eAttributeTag, sVal).getAttrValue().equals(pChild.defaultAttribute(eAttributeTag).getAttrValue())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void normalizeNameSpaces() {
        String aNS = this.getNS();
        this.normalizeNameSpaces(aNS);
    }

    public void normalizeNameSpaces(Element poNode, String aURI) {
        String aNS = poNode.getNS();
        if (aNS == "" || this.isCompatibleNS(aNS)) {
            poNode.setNameSpaceURI(aURI, false, false, true);
        }
        if (poNode.getLocalName() != "exData") {
            for (Node poChild = poNode.getFirstXMLChild(); poChild != null; poChild = poChild.getNextXMLSibling()) {
                if (!(poChild instanceof Element)) continue;
                this.normalizeNameSpaces((Element)poChild, aURI);
            }
        }
    }

    public boolean normalizeNameSpaces(int nTargetVersion, List<NodeValidationInfo> oResult) {
        boolean bRet = false;
        bRet = nTargetVersion >= this.getCurrentVersion() ? true : (oResult != null ? this.validateSchema(nTargetVersion, 63, true, oResult) : true);
        if (bRet) {
            if (nTargetVersion > this.getHeadVersion()) {
                nTargetVersion = this.getHeadVersion();
            }
            this.setCurrentVersion(nTargetVersion);
            this.normalizeNameSpaces();
        }
        return bRet;
    }

    protected void normalizeNameSpaces(String aNewNS) {
        String sNewNS = aNewNS;
        int nVersion = this.getVersion(sNewNS);
        this.setCurrentVersion(nVersion);
        String sOldNS = this.getOriginalVersion(true);
        String aNS = this.getNS();
        if (aNS == "" || this.isCompatibleNS(aNS)) {
            this.setNameSpaceURI(aNewNS, false, false, true);
        }
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            this.normalizeNameSpaces((Element)child, aNewNS);
        }
        if (this.moOriginalVersion == null && !StringUtils.isEmpty(sOldNS) && !sOldNS.equals(sNewNS) && this.getAppModel().updateOriginalVersion()) {
            this.getOriginalVersionNode(true, sOldNS);
        }
        this.mnOriginalVersion = 0;
    }

    protected abstract void postLoad();

    public Node preLoadNode(Element parent, Node node, Generator genTag) {
        Node nextSibling = node.getNextXMLSibling();
        if (node instanceof ProcessingInstruction && node.getName() == "originalXFAVersion") {
            if (this.moOriginalVersion != null && this.moOriginalVersion.getXFAParent() == this) {
                this.removeChild(this.moOriginalVersion);
            }
            this.moOriginalVersion = (ProcessingInstruction)node;
        }
        return nextSibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSave(boolean bSaveXMLScript) {
        boolean previousWillDirty = this.getWillDirty();
        this.setWillDirty(false);
        try {
            if (this.mbNormalizedNameSpaces || this.isDirty()) {
                this.normalizeNameSpaces();
            }
        }
        finally {
            this.setWillDirty(previousWillDirty);
        }
    }

    public boolean publish(Publisher publisher) {
        int nVersion = publisher.getTargetVersion();
        int nAvailability = publisher.getTargetAvailability();
        return this.validateSchema(nVersion, nAvailability, false, null);
    }

    public boolean ready(boolean bForced) {
        boolean bRet = false;
        if (!bForced && this.mbReady) {
            return bRet;
        }
        EventManager tm = this.getEventManager();
        int nId = tm.getEventID("ready");
        this.mbReady = true;
        return bRet |= tm.eventOccurred(nId, this.getAliasNode());
    }

    @Override
    public void remove() {
        this.setAppModel(null);
        super.remove();
    }

    void removeIDReferenceNode(Element poRefNode) {
        this.moUseList.remove(poRefNode);
        this.moUseHRefList.remove(poRefNode);
    }

    public void removeReferences(Node node) {
        if (node == null) {
            return;
        }
        Node child = node.getFirstXFAChild();
        while (child != null) {
            Node nextChild = child.getNextXFASibling();
            this.removeReferences(child);
            child = nextChild;
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.getModel() != this) {
                return;
            }
            element.setModel(null);
        }
        EventManager.EventTable eventTable = node.getEventTable(false);
        EventManager.resetEventTable(eventTable);
        node.clearPeers();
    }

    private static void verifyModel(Node node, Model model) {
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            assert (child.getModel() != model);
            Model.verifyModel(child, model);
        }
    }

    public int remapTag(int eTag) {
        return eTag;
    }

    @Override
    public NodeList resolveNodes(String somNodes, boolean bPeek, boolean bLastInstance, boolean bNoProperties, DependencyTracker oDependencyTracker, BooleanHolder isAssociation) {
        if (this.mSOMParser == null) {
            this.mSOMParser = new SOMParser(null);
        }
        ArrayNodeList oResult = new ArrayNodeList();
        this.mSOMParser.setOptions(bPeek, bLastInstance, bNoProperties);
        this.mSOMParser.setDependencyTracker(oDependencyTracker);
        if (this.moSOMContext == null || this.moSOMContext.getModel() == null) {
            this.mSOMParser.resolve((Node)this, somNodes, oResult, isAssociation);
        } else {
            this.mSOMParser.resolve(this.moSOMContext, somNodes, oResult, isAssociation);
        }
        return oResult;
    }

    public void resolveProtos(boolean bForceExternalProtoResolve) {
        if (bForceExternalProtoResolve || this.getAppModel().getResolveAllExternalProtos()) {
            Model.resolveList(this.moUseHRefList, true);
        }
        if (!this.getAppModel().getIsFragmentDoc()) {
            Model.resolveList(this.moUseList, false);
        }
    }

    protected boolean saveProtoInformation(Element poXfaNode, String aLocalName, boolean bCheckParent) {
        if (bCheckParent && poXfaNode.getXFAParent() != null && poXfaNode.getXFAParent() instanceof Proto) {
            this.addProto((ProtoableNode)poXfaNode);
        }
        if (aLocalName == "use") {
            this.addUseNode(poXfaNode);
            return true;
        }
        if (aLocalName == "usehref") {
            this.addUseHRefNode(poXfaNode);
            return true;
        }
        return false;
    }

    @Override
    public void serialize(OutputStream outStream, DOMSaveOptions options, int level, Node prevSibling) throws IOException, IOException {
        this.getXmlPeer().serialize(outStream, options, level, prevSibling);
    }

    public final void setAliasNode(Element aliasNode) {
        this.mAliasNode = aliasNode == this ? null : aliasNode;
    }

    public void setAppModel(AppModel pNewModel) {
        this.mAppModel = pNewModel;
    }

    public void setAppModelIsTransient(boolean bAppModelIsTransient) {
        this.mbAppModelIsTransient = bAppModelIsTransient;
    }

    public void setContext(Node node) {
        this.moSOMContext = node == this ? null : node;
    }

    public void setCurrentVersion(int nVersion) {
        this.mnCurrentVersion = nVersion;
    }

    @Override
    public final void setDOMProperties(String uri, String localName, String qName, Attributes attributes) {
        super.setDOMProperties(uri, localName, qName, attributes);
        int nVersion = this.getVersion(uri);
        if (nVersion > this.getHeadVersion()) {
            String sHostName = "";
            HostPseudoModel oHost = (HostPseudoModel)this.getAppModel().lookupPseudoModel("$host");
            if (oHost != null) {
                sHostName = oHost.getName();
            }
            if (StringUtils.isEmpty(sHostName)) {
                sHostName = Numeric.doubleToString((double)this.getHeadVersion() / 10.0, 1, false);
            }
            MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidModelVersionException, localName);
            oMessage.format(sHostName);
            if (this.getAppModel().getSourceAbove() == 0x7E0000) {
                this.addErrorList(new ExFull(oMessage), 3, this);
            } else if (this.getAppModel().getSourceAbove() == 8257537) {
                throw new ExFull(oMessage);
            }
        }
        this.setCurrentVersion(nVersion);
    }

    void setGenerator(Generator gen) {
        this.mGenerator = gen;
    }

    public void setIDValueMap(IDValueMap idValueMap) {
        this.mIDValueMap = idValueMap;
    }

    void setLogMessenger(LogMessenger oMessenger) {
        this.getAppModel().setLogMessenger(oMessenger);
    }

    @Override
    public final void setName(String name) {
        this.mName = name;
    }

    public void setNeedsNSNormalize(boolean bNormalize) {
        this.mbNormalizedNameSpaces = bNormalize;
    }

    public String shortCutName() {
        return this.mShortCutName;
    }

    protected String uniquifyID(String psID) {
        String sTest = psID;
        int iCopyIndex = 1;
        while (this.getNode(sTest) != null) {
            String sCopyIndex = Integer.toString(iCopyIndex++);
            sTest = psID + "_copy" + sCopyIndex;
        }
        return sTest;
    }

    @Override
    public boolean validateUsage(int nXFAVersion, int nAvailability, boolean bUpdateVersion) {
        return this.validateUsage(nXFAVersion, nAvailability, false, bUpdateVersion);
    }

    @Override
    public boolean validateUsageFailedIsFatal(int nXFAVersion, int nAvailability) {
        return this.validateUsage(nXFAVersion, nAvailability, true, false);
    }

    private boolean validateUsage(int nVersion, int nAvailability, boolean bFatalTest, boolean bUpdateVersion) {
        boolean bRet;
        AppModel poAppModel = this.getAppModel();
        int eOutputBelow = poAppModel.getOutputBelow();
        int nTargetOutputVer = poAppModel.getVersionRestriction();
        boolean bl = bRet = !bFatalTest;
        if (!this.isVersionCompatible(nVersion, this.getCurrentVersion()) && this.getSourceBelow() == 8192001) {
            bRet = bFatalTest ? !this.mbLoading : false;
        } else if (this.getHeadVersion() < nVersion) {
            if (bFatalTest) {
                if (poAppModel.getSourceAbove() == 8257537) {
                    bRet = true;
                }
            } else {
                bRet = false;
            }
        } else if (nTargetOutputVer != 0 && !this.isVersionCompatible(nVersion, nTargetOutputVer) && eOutputBelow != 0x7F0000) {
            if (bFatalTest) {
                if (eOutputBelow == 8323074) {
                    bRet = true;
                }
            } else {
                bRet = false;
            }
        } else if (bUpdateVersion && poAppModel.getSourceBelow() == 0x7D0000 && nVersion <= this.getHeadVersion() && this.mnCurrentVersion < nVersion) {
            this.mnCurrentVersion = nVersion;
        }
        return bRet;
    }

    public void willDirtyDoc(boolean bWillDirty) {
        this.mbWillDirtyDoc = bWillDirty;
    }

    public boolean willDirtyDoc() {
        return this.mbWillDirtyDoc;
    }

    final String intern(String value) {
        return this.mSymbolTable != null ? this.mSymbolTable.internSymbol(value) : value.intern();
    }

    public int getOriginalXFAVersion() {
        if (this.mnOriginalVersion == 0) {
            int nVersion;
            String sPIValue = this.getOriginalVersion(false);
            if (StringUtils.isEmpty(sPIValue)) {
                int nVersion2;
                sPIValue = this.getOriginalVersion(true);
                this.mnOriginalVersion = nVersion2 = this.getVersion(sPIValue);
                return nVersion2;
            }
            this.mnOriginalVersion = nVersion = this.getVersion(sPIValue);
        }
        return this.mnOriginalVersion;
    }

    public void setOriginalXFAVersion(int nXFAVersion) {
        if (nXFAVersion == 0) {
            this.mnOriginalVersion = 0;
            this.removeOriginalVersionNode();
        } else if (nXFAVersion <= this.getCurrentVersion()) {
            this.getOriginalXFAVersion();
            this.mnOriginalVersion = nXFAVersion;
            this.updateOriginalXFAVersionPI();
        }
    }

    protected void updateOriginalXFAVersionPI() {
        String sPIValue = this.getNS(this.mnOriginalVersion);
        this.getVersion(sPIValue);
        ProcessingInstruction oPI = this.getOriginalVersionNode(false, "");
        if (oPI == null) {
            this.getOriginalVersionNode(true, sPIValue);
        } else {
            oPI.setData(sPIValue);
        }
    }

    public static abstract class Publisher {
        public abstract String updateExternalRef(Node var1, int var2, String var3);

        public abstract int getTargetVersion();

        public abstract int getTargetAvailability();
    }

    public static interface DualDomModel {
    }
}

