/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.xmp.options.ParseOptions;
import java.util.Date;
import java.util.Random;

public final class MetadataOptions {
    private boolean autoUpdate = true;
    private boolean forceUpdateOnSave;
    private Random documentIdGenerator;
    private boolean removeFiltersFromXMP;
    private boolean filterRemovalMarksXMPDirty;
    private boolean compareMoreThanModDate = true;
    private boolean xmpIsMasterSource = true;
    private ParseOptions xmpParseOptions;

    public ParseOptions getXMPParseOptions() {
        return this.xmpParseOptions;
    }

    public void setXMPParseOptions(ParseOptions xmpParseoptions) {
        this.xmpParseOptions = xmpParseoptions;
    }

    protected MetadataOptions() {
        this.xmpParseOptions = new ParseOptions();
    }

    protected MetadataOptions(MetadataOptions original) {
        this.autoUpdate = original.autoUpdate;
        this.forceUpdateOnSave = original.forceUpdateOnSave;
        this.documentIdGenerator = original.documentIdGenerator;
        this.removeFiltersFromXMP = original.removeFiltersFromXMP;
        this.filterRemovalMarksXMPDirty = original.filterRemovalMarksXMPDirty;
        this.xmpParseOptions = original.xmpParseOptions;
    }

    private void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    private void setForceUpdateOnSave(boolean forceUpdateOnSave) {
        this.forceUpdateOnSave = forceUpdateOnSave;
    }

    public boolean getForceUpdateOnSave() {
        return this.forceUpdateOnSave;
    }

    private void setDocumentIdGenerator(Random documentIdGenerator) {
        this.documentIdGenerator = documentIdGenerator;
    }

    public Random getDocumentIdGenerator() {
        return this.documentIdGenerator;
    }

    private void setRemoveFiltersFromXMP(boolean removeFiltersFromXMP) {
        this.removeFiltersFromXMP = removeFiltersFromXMP;
    }

    public boolean getRemoveFiltersFromXMP() {
        return this.removeFiltersFromXMP;
    }

    private void setFilterRemovalMarksXMPDirty(boolean filterRemovalMarksXMPDirty) {
        this.filterRemovalMarksXMPDirty = filterRemovalMarksXMPDirty;
    }

    public boolean getFilterRemovalMarksXMPDirty() {
        return this.filterRemovalMarksXMPDirty;
    }

    private void setCompareMoreThanModDate(boolean compareMoreThanModDate) {
        this.compareMoreThanModDate = compareMoreThanModDate;
    }

    public boolean getCompareMoreThanModDate() {
        return this.compareMoreThanModDate;
    }

    private void setXMPIsMasterSourceIfModDatesEqual(boolean xmpIsMasterSource) {
        this.xmpIsMasterSource = xmpIsMasterSource;
    }

    public boolean getXMPIsMasterSourceIfModDatesEqual() {
        return this.xmpIsMasterSource;
    }

    public static final class MetadataOptionsBuilder {
        private MetadataOptions options;

        private MetadataOptionsBuilder(MetadataOptions options) {
            this.options = options;
        }

        public static MetadataOptionsBuilder newInstance() {
            return new MetadataOptionsBuilder(new MetadataOptions());
        }

        public static MetadataOptionsBuilder newInstance(MetadataOptions original) {
            return new MetadataOptionsBuilder(new MetadataOptions(original));
        }

        public void setAutoUpdate(boolean autoUpdate) {
            this.options.setAutoUpdate(autoUpdate);
        }

        public void setUpdateOnlyIfDocumentChanged(boolean updateOnlyIfDocumentChanged) {
            this.options.setForceUpdateOnSave(!updateOnlyIfDocumentChanged);
        }

        public void setDocumentIdGenerator(Random documentIdGenerator) {
            this.options.setDocumentIdGenerator(documentIdGenerator);
        }

        public void setRemoveFiltersFromXMP(boolean removeFiltersFromXMP) {
            this.options.setRemoveFiltersFromXMP(removeFiltersFromXMP);
        }

        public void setFilterRemovalMarksXMPDirty(boolean filterRemovalMarksXMPDirty) {
            this.options.setFilterRemovalMarksXMPDirty(filterRemovalMarksXMPDirty);
        }

        public void setCompareMoreThanModificationDate(boolean compareMoreThanModDate) {
            this.options.setCompareMoreThanModDate(compareMoreThanModDate);
        }

        public void setXMPIsMasterSourceIfModDatesEqual(boolean xmpIsMasterSource) {
            this.options.setXMPIsMasterSourceIfModDatesEqual(xmpIsMasterSource);
        }

        public MetadataOptions build() {
            if (this.options.getDocumentIdGenerator() == null) {
                this.options.setDocumentIdGenerator(new Random(new Date().getTime()));
            }
            MetadataOptions options = this.options;
            this.options = null;
            return options;
        }
    }
}

