/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAStream;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.Packet;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class XFADOMProcessor {
    protected PDFInteractiveForm mForm;
    private XFADOM xfaDOM = null;
    private static final long DEFAULT_STREAM_SIZE = 128L;
    private static final String INVISIBLE_SIGNATURE_LOCATION_SOM = "$template.#subform";
    private static final String INVISIBLE_SIGNATURE_NAME_LEADING = "$template.#subform..";

    public XFADOMProcessor(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.mForm = pdfDoc.getInteractiveForm();
        this.xfaDOM = XFADOMService.getXFADOMFromCache(pdfDoc);
    }

    public XFADOMProcessor(XFADOM xfaDOM) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.mForm = xfaDOM.getPDFDocument().getInteractiveForm();
        this.xfaDOM = xfaDOM;
    }

    public List<Field> getFieldsFromFormDOM(String somExpression) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        if (this.xfaDOM == null) {
            this.xfaDOM = XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument());
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Model model = this.xfaDOM.getFormModel();
        if (model == null) {
            model = this.xfaDOM.getTemplateModel();
        }
        this.addFields(fields, somExpression, model);
        if (fields.isEmpty()) {
            return null;
        }
        return fields;
    }

    private void addFields(ArrayList fields, String somExpression, Node startNode) {
        for (Node childNode = startNode.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
            if (childNode instanceof Field) {
                if (childNode.resolveNode(somExpression, true, false, true) == null) continue;
                fields.add(childNode);
                continue;
            }
            this.addFields(fields, somExpression, childNode);
        }
    }

    private TemplateModel getTemplateModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        return (this.xfaDOM == null ? XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument()) : this.xfaDOM).getTemplateModel();
    }

    private AppModel getAppModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        return (this.xfaDOM == null ? XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument()) : this.xfaDOM).getAppModel();
    }

    private DataModel getDataModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        return (this.xfaDOM == null ? XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument()) : this.xfaDOM).getDataModel();
    }

    private DataModel procureDataModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        return DataModel.getDataModel(this.getAppModel(), true, false);
    }

    private FormModel getFormModel() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mForm == null) {
            return null;
        }
        if (this.xfaDOM == null) {
            return null;
        }
        return this.xfaDOM.getFormModel();
    }

    private void resetForm() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (FormModel.getFormModel(this.getAppModel(), false) != null) {
            this.getAppModel().getNodes().remove(this.getDataModel());
            this.getAppModel().getNodes().remove(this.getFormModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillCosStreamWithXFA(Document xfaDoc, PDFInteractiveForm interactiveForm, XFAProcessingOptions xfaOptions) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException {
        block44: {
            OutputStream xdpStream = null;
            OutputByteStream xdpOBS = null;
            OutputByteStream formOBS = null;
            OutputStream formStateStream = null;
            PDFXFAStream xfaStream = null;
            StreamManager streamManager = null;
            long originalStreamLength = 0L;
            try {
                xfaStream = interactiveForm.getXFAAsStream();
                streamManager = xfaStream.getStreamManager();
                originalStreamLength = xfaStream.getLength();
                if (!xfaOptions.saveFormDOMEnabled()) {
                    this.resetForm();
                }
                Canonicalize c = null;
                c = new Canonicalize(xfaDoc, true, true);
                xdpOBS = streamManager.getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, originalStreamLength);
                xdpStream = xdpOBS.toOutputStream();
                c.canonicalize(xdpStream, 4, null);
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            finally {
                if (xdpStream != null) {
                    try {
                        xdpStream.close();
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                }
            }
            InputByteStream xdpIBS = null;
            InputStream inStm = null;
            try {
                xdpIBS = xdpOBS.closeAndConvert();
                if (xdpIBS != null) {
                    inStm = xdpIBS.toInputStream();
                    xfaStream.setStreamData(inStm);
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            finally {
                try {
                    try {
                        if (xdpIBS != null) {
                            xdpIBS.close();
                        }
                    }
                    finally {
                        if (inStm != null) {
                            inStm.close();
                        }
                    }
                }
                catch (IOException e) {}
            }
            try {
                InputByteStream formStateIBS;
                if (!xfaOptions.saveFormDOMEnabled()) break block44;
                formOBS = streamManager.getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, originalStreamLength);
                formStateStream = formOBS.toOutputStream();
                this.writeFormDOM(formStateStream, xfaOptions, this.getFormModel());
                if (this.getFormModel() == null) break block44;
                try {
                    formStateIBS = formOBS.closeAndConvert();
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
                XFAService.importElement(this.mForm.getPDFDocument(), XFAService.XFAElement.FORM, formStateIBS.toInputStream());
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            catch (PDFInvalidXMLException e) {
                throw new PDFInvalidParameterException(e);
            }
            finally {
                if (formStateStream != null) {
                    try {
                        formStateStream.close();
                    }
                    catch (IOException e) {
                        throw new PDFIOException(e);
                    }
                }
            }
        }
    }

    public void serialize(OutputStream xmlStream, XFAProcessingOptions xfaOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.mForm == null) {
            PDFInteractiveForm pDFInteractiveForm = this.mForm = this.xfaDOM != null ? this.xfaDOM.getPDFDocument().getInteractiveForm() : null;
        }
        if (this.mForm == null) {
            return;
        }
        if (this.mForm.xfaIsArray()) {
            this.fillCosArrayWithXFA(this.getAppModel().getDocument(), this.mForm, xfaOptions);
        } else if (this.mForm.xfaIsStream()) {
            this.fillCosStreamWithXFA(this.getAppModel().getDocument(), this.mForm, xfaOptions);
        }
        this.xfaDOM.clearChanged();
        if (xmlStream != null) {
            DOMSaveOptions options = new DOMSaveOptions();
            options.setExcludePreamble(false);
            this.getAppModel().getDocument().saveAs(xmlStream, null, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillCosArrayWithXFA(Document xfaDoc, PDFInteractiveForm interactiveForm, XFAProcessingOptions xfaOptions) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFXFAArray pdfXFAArray = interactiveForm.getXFAAsArray();
        StreamManager streamManager = pdfXFAArray.getStreamManager();
        AppModel appModel = xfaDoc.getAppModel();
        if (xfaOptions != null && xfaOptions.saveFormDOMEnabled() && !this.xfaDOM.formModelExists()) {
            this.xfaDOM.savePacketsDirtyState();
            try {
                this.xfaDOM.createFormModel();
            }
            finally {
                this.xfaDOM.restorePacketsDirtyState();
            }
        }
        OutputStream xdpStream = null;
        OutputByteStream xdpOBS = null;
        boolean processingFormModel = false;
        for (Node oNext = appModel.getFirstXMLChild(); oNext != null; oNext = oNext.getNextXMLSibling()) {
            if (!oNext.isDirty() && !(oNext instanceof DataModel) && !(oNext instanceof FormModel) || !(oNext instanceof Packet) && !(oNext instanceof Model)) continue;
            if (oNext instanceof Model) {
                if (oNext instanceof FormModel) {
                    if (xfaOptions == null || !xfaOptions.saveFormDOMEnabled()) continue;
                    processingFormModel = true;
                } else {
                    processingFormModel = false;
                }
            }
            xdpStream = null;
            xdpOBS = null;
            InputByteStream xdpIBS = null;
            try {
                try {
                    long originalStreamLength = 128L;
                    ASString packetName = new ASString(oNext.getName());
                    int packetIndex = pdfXFAArray.find(packetName);
                    PDFStream packetStream = null;
                    if (packetIndex != -1) {
                        packetStream = pdfXFAArray.getStream(packetIndex);
                        originalStreamLength = packetStream.getLength();
                    }
                    xdpOBS = streamManager.getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, originalStreamLength);
                    xdpStream = xdpOBS.toOutputStream();
                    if (processingFormModel) {
                        this.writeFormDOM(xdpStream, xfaOptions, (FormModel)oNext);
                    } else {
                        XFADOMProcessor.writeXFAElementToXDPStream((Element)oNext, xdpStream);
                    }
                    xdpIBS = xdpOBS.closeAndConvert();
                    xdpOBS = null;
                    if (packetStream == null) {
                        PDFStream stream = PDFStream.newInstance(this.mForm.getPDFDocument());
                        PDFFilterList filterList = XFADOMProcessor.getFilterListFromXFAArray(pdfXFAArray);
                        if (filterList == null) {
                            filterList = PDFFilterList.newInstance(pdfXFAArray.getPDFDocument());
                        }
                        if (filterList.isEmpty()) {
                            filterList.add(PDFFilterFlate.newInstance(pdfXFAArray.getPDFDocument(), null));
                        }
                        stream.setOutputFilters(filterList);
                        stream.setStreamData(xdpIBS.toInputStream());
                        pdfXFAArray.insert(packetName, stream);
                        continue;
                    }
                    if (xdpIBS == null) continue;
                    InputStream inStm = xdpIBS.toInputStream();
                    try {
                        packetStream.setStreamData(inStm);
                        continue;
                    }
                    finally {
                        xdpIBS.close();
                        xdpIBS = null;
                        inStm.close();
                    }
                }
                finally {
                    try {
                        if (xdpStream != null) {
                            xdpStream.close();
                        }
                    }
                    finally {
                        try {
                            if (xdpIBS != null) {
                                xdpIBS.close();
                            }
                        }
                        finally {
                            if (xdpOBS != null) {
                                xdpOBS.close();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    private static PDFFilterList getFilterListFromXFAArray(PDFXFAArray array) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFFilterList filterList = null;
        PDFStream stream = array.getStream(0);
        if (stream != null) {
            filterList = stream.getOutputFilters();
        }
        return filterList;
    }

    private void writeFormDOM(OutputStream outputXDPStream, XFAProcessingOptions xfaOptions, Element formModel) throws IOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xfaOptions.saveFormDOMEnabled()) {
            if (!this.xfaDOM.formModelExists() || formModel == null) {
                this.xfaDOM.createFormModel();
            }
            formModel = this.getFormModel();
        }
        if (formModel != null) {
            XFADOMProcessor.writeXFAElementToXDPStream(formModel, outputXDPStream);
        }
    }

    private static void writeXFAElementToXDPStream(Element element, OutputStream outputXDPStream) throws IOException {
        outputXDPStream.write(10);
        DOMSaveOptions saveOptions = new DOMSaveOptions();
        saveOptions.setExcludePreamble(true);
        element.saveXML(outputXDPStream, saveOptions);
    }

    public static String generateIndexedSignatureFieldName(String baseSignatureFieldName, TemplateModel templateModel) {
        String fieldName;
        String fieldExpression;
        int signatureNumber = 0;
        if (baseSignatureFieldName.lastIndexOf(91) != -1) {
            baseSignatureFieldName = baseSignatureFieldName.substring(0, baseSignatureFieldName.lastIndexOf(91));
        }
        do {
            fieldName = baseSignatureFieldName + "[" + signatureNumber++ + "]";
        } while (templateModel.resolveNode(fieldExpression = INVISIBLE_SIGNATURE_NAME_LEADING + fieldName, false, true, false) != null);
        return fieldName;
    }

    public boolean isFSTargetURLValuePermitted() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String fsTargetURLValue = this.getFSTargetURLValue();
        if (fsTargetURLValue == null) {
            return true;
        }
        return fsTargetURLValue.trim().length() == 0;
    }

    public boolean canValidateSubmitTargets() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isFormSubmitTargetPermitted()) {
            return true;
        }
        if (this.isConfigSubmitTargetPermitted()) {
            return true;
        }
        return this.isFSTargetURLValuePermitted();
    }

    public boolean canCertifySubmitTarget() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isFormSubmitTargetPermitted()) {
            return true;
        }
        return this.isConfigSubmitTargetPermitted();
    }

    public boolean isFormSubmitTargetPermitted() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            boolean retVal = true;
            AppModel appModel = this.getAppModel();
            if (appModel == null) {
                return false;
            }
            DataModel dataModel = this.procureDataModel();
            if (dataModel == null) {
                return false;
            }
            FormModel formModel = XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument()).getFormModel();
            if (formModel == null) {
                return false;
            }
            if (this.findEmptySubmitTarget(formModel.getFirstXFAChild())) {
                return false;
            }
            return retVal;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    protected boolean findEmptySubmitTarget(Node node) {
        boolean peek = true;
        boolean returnDefault = false;
        if (node != null) {
            if (node instanceof FormField) {
                Attribute targetAttr;
                Element submitNode;
                Element eventNode = ((Element)node).getElement(XFA.EVENTTAG, true, 0, false, false);
                return eventNode != null && (submitNode = eventNode.getElement(XFA.SUBMITTAG, true, 0, false, false)) != null && ((targetAttr = submitNode.getAttribute(XFA.TARGETTAG, true, false)) == null || targetAttr.isEmpty());
            }
            if (!(node instanceof Draw)) {
                for (Node childNode = node.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                    if (!this.findEmptySubmitTarget(childNode)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isServerFormStateValuePermitted() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            boolean valuePermitted = true;
            FormModel formModel = XFADOMService.ensureXFADOMCreated(this.mForm.getPDFDocument()).getFormModel();
            if (formModel == null) {
                return false;
            }
            if (formModel.getFormStateRemoved()) {
                return false;
            }
            AppModel appModel = this.getAppModel();
            if (appModel == null) {
                return false;
            }
            for (Node childNode = appModel.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
                if (!(childNode instanceof Packet) || !childNode.getName().equals("formState")) continue;
                for (Node formStateChild = childNode.getFirstXMLChild(); formStateChild != null; formStateChild = formStateChild.getNextXMLSibling()) {
                    if (!(formStateChild instanceof Element)) continue;
                    return false;
                }
                break;
            }
            return valuePermitted;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public String getRestoreStateAttrValue() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            TemplateModel template = this.getTemplateModel();
            if (template == null) {
                return null;
            }
            Node nodeFound = template.resolveNode(INVISIBLE_SIGNATURE_LOCATION_SOM);
            if (!(nodeFound instanceof Element)) {
                return null;
            }
            return XFAUtils.getAttributeValue((Element)nodeFound, "restoreState");
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public String getFSTargetURLValue() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            DataModel dataModel = this.procureDataModel();
            String fsTargetURLValue = "";
            if (dataModel == null) {
                return null;
            }
            Node nodeFound = dataModel.resolveNode("$data.FSTARGETURL_");
            if (!(nodeFound instanceof DataNode)) {
                return null;
            }
            fsTargetURLValue = ((DataNode)nodeFound).getValue();
            return fsTargetURLValue;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    public boolean isConfigSubmitTargetPermitted() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            SignatureManager sigMgr = SignatureManager.newInstance(this.mForm.getPDFDocument());
            DocumentContext docContext = DocumentContext.find(this.mForm.getPDFDocument(), true, new BooleanHolder(false));
            if (docContext == null) {
                throw new PDFInvalidDocumentException("XFA form DOM is not created.");
            }
            String submitURL = docContext.getSubmitUrl(sigMgr.isDocCertified());
            if (submitURL == null) {
                return true;
            }
            return submitURL.length() != 0;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException(e);
        }
    }
}

