/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAStream;
import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFXFAInput;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFXFAOutput;
import com.adobe.internal.pdftoolkit.xml.XMLElemContentReplacer;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PDFFormSupport {
    private static final long DEFAULT_OUTPUT_STREAM_SIZE = 1024L;

    private PDFFormSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean exportXFAData(PDFInteractiveForm form, OutputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        InputByteStream xfaStream = null;
        ByteArrayOutputStream outStm = null;
        try {
            boolean hasXFAData = false;
            if (form == null) {
                boolean bl = hasXFAData;
                return bl;
            }
            if (!form.xfaIsArray()) {
                if (!form.xfaIsStream()) throw new PDFInvalidDocumentException("Invalid object for the XFA entry in the forms dictionary.");
                xfaStream = PDFFormSupport.getStreamFromXFAStream(form.getXFAAsStream());
            } else {
                PDFXFAArray xfaArray = form.getXFAAsArray();
                byte[] ds = new byte[]{100, 97, 116, 97, 115, 101, 116, 115};
                int[] dsnext = new int[]{-1, 0, 0, 0, 0, 0, 0, 0};
                for (int tagNdx = 0; tagNdx < xfaArray.getNumPackets(); ++tagNdx) {
                    ASString tag = xfaArray.getPacketName(tagNdx);
                    if (Utility.KMPFindFirst(ds, dsnext, tag.getBytes()) == -1) continue;
                    PDFStream value = xfaArray.getStream(tagNdx);
                    outStm = new ByteArrayOutputStream(value.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value.getLength());
                    value.getStreamData(outStm);
                    xfaStream = form.getStreamManager().getInputByteStream(outStm.toByteArray());
                    break;
                }
            }
            if (xfaStream == null) {
                boolean xfaArray = hasXFAData;
                return xfaArray;
            }
            PDFXFAOutput xfaout = new PDFXFAOutput(true, "xfa:datasets");
            ServicesUtil.transformToXML(xfaout, xfaStream.toInputStream(), xmlStream);
            xfaStream.close();
            xfaStream = null;
            if (xfaout.hadData()) {
                hasXFAData = true;
            }
            boolean bl = hasXFAData;
            return bl;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                try {
                    if (xfaStream != null) {
                        xfaStream.close();
                    }
                }
                finally {
                    if (outStm != null) {
                        outStm.close();
                    }
                }
            }
            catch (IOException e) {}
        }
    }

    public static void importXFAData(PDFInteractiveForm form, String element, String tagInXML, InputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        PDFFormSupport.importXFAData(form, element, tagInXML, xmlStream, false);
    }

    public static void importXFADataContent(PDFInteractiveForm form, String element, String tagInXML, InputStream xmlStream) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        PDFFormSupport.importXFAData(form, element, tagInXML, xmlStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importXFAData(PDFInteractiveForm form, String element, String tagInXML, InputStream xmlStream, boolean replaceNodeContent) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException {
        if (form == null) {
            return;
        }
        if (xmlStream == null) {
            return;
        }
        int xmlStreamAvailable = 0;
        ByteArrayOutputStream outStm = null;
        ByteArrayInputStream xfaIS = null;
        OutputByteStream newXFAOBS = null;
        OutputStream newXFAOS = null;
        InputByteStream newXFAIBS = null;
        try {
            xmlStreamAvailable = xmlStream.available();
            PDFDocument pdfDocument = form.getPDFDocument();
            XMLReader reader = null;
            reader = replaceNodeContent ? new XMLElemContentReplacer(tagInXML, xmlStream) : new PDFXFAInput(form, tagInXML, xmlStream);
            if (form.xfaIsStream()) {
                PDFXFAStream xfaStream = form.getXFAAsStream();
                outStm = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
                xfaStream.getStreamData(outStm);
                xfaIS = new ByteArrayInputStream(outStm.toByteArray());
                newXFAOBS = form.getStreamManager().getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed.GROWABLE, outStm.size() + xmlStreamAvailable);
                newXFAOS = newXFAOBS.toOutputStream();
                ServicesUtil.transformToXML(reader, xfaIS, newXFAOS);
                newXFAIBS = newXFAOBS.closeAndConvert();
                xfaStream.setStreamData(newXFAIBS.toInputStream());
                newXFAOBS = null;
                return;
            }
            if (form.xfaIsArray()) {
                PDFXFAArray xfaArray = form.getXFAAsArray();
                int packetNumber = xfaArray.find(new ASString(element));
                if (packetNumber != -1) {
                    PDFStream xfaStream = xfaArray.getStream(packetNumber);
                    outStm = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
                    xfaStream.getStreamData(outStm);
                    xfaIS = new ByteArrayInputStream(outStm.toByteArray());
                    newXFAOBS = form.getStreamManager().getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed.GROWABLE, xmlStreamAvailable);
                    newXFAIBS = PDFFormSupport.generateXFAFragment(form, xfaIS, tagInXML, xmlStream, newXFAOBS, replaceNodeContent);
                    newXFAOBS = null;
                    xfaStream.setStreamData(newXFAIBS.toInputStream());
                    return;
                }
                newXFAOBS = form.getStreamManager().getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed.GROWABLE, xmlStreamAvailable);
                newXFAIBS = PDFFormSupport.generateXFAFragment(form, null, tagInXML, xmlStream, newXFAOBS, replaceNodeContent);
                newXFAOBS = null;
                PDFStream xfaStream = PDFStream.newInstance(pdfDocument);
                PDFFilterFlate filter = PDFFilterFlate.newInstance(pdfDocument, null);
                PDFFilterList filterList = PDFFilterList.newInstance(pdfDocument);
                filterList.add(filter);
                xfaStream.setOutputFilters(filterList);
                xfaStream.setStreamData(newXFAIBS.toInputStream());
                xfaArray.insert(new ASString(tagInXML), xfaStream);
                return;
            }
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to read XML Stream.", e);
        }
        finally {
            try {
                try {
                    if (newXFAIBS != null) {
                        newXFAIBS.close();
                    }
                }
                finally {
                    try {
                        if (newXFAOS != null) {
                            newXFAOS.close();
                        }
                    }
                    finally {
                        try {
                            if (xfaIS != null) {
                                xfaIS.close();
                            }
                        }
                        finally {
                            if (outStm != null) {
                                outStm.close();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    private static InputByteStream generateXFAFragment(PDFInteractiveForm form, InputStream oldData, String tagInXML, InputStream xmlStream, OutputByteStream newXFA, boolean replaceNodeContent) throws PDFIOException, PDFInvalidXMLException {
        InputByteStream fullStm = null;
        try {
            try {
                if (replaceNodeContent) {
                    ServicesUtil.transformToXML(new XMLElemContentReplacer(tagInXML, xmlStream), oldData, newXFA.toOutputStream());
                } else {
                    ServicesUtil.transformToXML(new PDFXFAInput(form, tagInXML, xmlStream), oldData, newXFA.toOutputStream());
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            finally {
                fullStm = newXFA.closeAndConvert();
                newXFA = null;
            }
            byte[] dstag = PDFDocEncoding.fromUnicodeString(tagInXML);
            int[] dstagnext = new int[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            long dspos = Utility.KMPFindFirst(dstag, dstagnext, fullStm);
            if (dspos < 1L) {
                throw new PDFInvalidXMLException("XML tag couldn't be found.");
            }
            InputByteStream inputByteStream = fullStm.slice(dspos - 1L, fullStm.length() - dspos + 1L);
            return inputByteStream;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (fullStm != null) {
                    fullStm.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public static InputByteStream getFullXFAStream(PDFInteractiveForm form) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (form == null) {
            return null;
        }
        if (form.xfaIsArray()) {
            return PDFFormSupport.getStreamFromXFAArray(form.getXFAAsArray());
        }
        if (form.xfaIsStream()) {
            return PDFFormSupport.getStreamFromXFAStream(form.getXFAAsStream());
        }
        return null;
    }

    public static InputByteStream getStream(CosObject obj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            switch (obj.getType()) {
                case 7: {
                    return ((CosStream)obj).getStreamDecoded();
                }
                case 4: {
                    return obj.getStreamManager().getInputByteStream(((CosString)obj).byteArrayValue());
                }
                case 5: {
                    return PDFFormSupport.getStreamFromXFACosArray((CosArray)obj);
                }
            }
            throw new PDFCosParseException("Invalid XFA entry");
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static InputByteStream getStreamFromXFAArray(PDFXFAArray array) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (array == null) {
            return null;
        }
        ByteArrayOutputStream outStm = null;
        try {
            int numPackets = array.getNumPackets();
            InputByteStream[] streams = new InputByteStream[numPackets];
            outStm = new ByteArrayOutputStream();
            int index = 0;
            for (int i = 0; i < numPackets; ++i) {
                array.getStream(i).getStreamData(outStm);
                streams[index++] = array.getStreamManager().getInputByteStream(outStm.toByteArray());
                outStm.reset();
            }
            InputByteStream inputByteStream = array.getStreamManager().getInputByteStream(streams);
            return inputByteStream;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (outStm != null) {
                    outStm.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static InputByteStream getStreamFromXFAStream(PDFXFAStream xfaStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xfaStream == null) {
            return null;
        }
        ByteArrayOutputStream outStm = null;
        try {
            outStm = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
            xfaStream.getStreamData(outStm);
            InputByteStream inputByteStream = xfaStream.getPDFDocument().getStreamManager().getInputByteStream(outStm.toByteArray());
            return inputByteStream;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (outStm != null) {
                    outStm.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static InputByteStream getStreamFromXFACosArray(CosArray array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            InputByteStream[] streams = new InputByteStream[array.size() / 2];
            int index = 0;
            for (int i = 1; i < array.size(); i += 2) {
                streams[index++] = array.getStream(i);
            }
            return array.getStreamManager().getInputByteStream(streams);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importXFAElementIntoArray(PDFInteractiveForm interactiveForm, XFAService.XFAElement xfaElement, Source replacementXML) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        PDFXFAArray xfaArray = interactiveForm.getXFAAsArray();
        OutputByteStream convertedXML = null;
        SkippingOutputStream convertedXMLStream = null;
        InputByteStream convertedXMLIBS = null;
        try {
            convertedXML = interactiveForm.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, 1024L);
            convertedXMLStream = convertedXML.toOutputStream();
            boolean succeeded = PDFFormSupport.convertStreamToCorrectFormat(xfaArray, replacementXML, new StreamResult(convertedXMLStream), true, xfaElement, true);
            if (!succeeded) {
                boolean bl = false;
                return bl;
            }
            ASString asElementName = new ASString(xfaElement.getElementName());
            int elementIndex = xfaArray.find(asElementName);
            if (elementIndex == -1) {
                PDFStream stream = PDFStream.newInstance(interactiveForm.getPDFDocument());
                convertedXMLIBS = convertedXML.closeAndConvert();
                stream.setStreamData(convertedXMLIBS.toInputStream());
                if (convertedXMLIBS.length() >= 15L) {
                    stream.setOutputFilter(ASName.k_FlateDecode);
                }
                convertedXML = null;
                xfaArray.insert(asElementName, stream);
                boolean bl = true;
                return bl;
            }
            PDFStream stream = xfaArray.getStream(elementIndex);
            convertedXMLIBS = convertedXML.closeAndConvert();
            stream.setStreamData(convertedXMLIBS.toInputStream());
            if (convertedXMLIBS.length() >= 15L) {
                stream.setOutputFilter(ASName.k_FlateDecode);
            }
            convertedXML = null;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                try {
                    if (convertedXML != null) {
                        convertedXML.close();
                    }
                }
                finally {
                    try {
                        if (convertedXMLStream != null) {
                            convertedXMLStream.close();
                        }
                    }
                    finally {
                        if (convertedXMLIBS != null) {
                            convertedXMLIBS.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean convertStreamToCorrectFormat(PDFXFAArray xfaArray, Source newXML, Result xmlResult, boolean omitXMLDeclaration, XFAService.XFAElement element, boolean validateElement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        PDFStream preamble = xfaArray.getStream(0);
        PDFStream postamble = xfaArray.getStream(xfaArray.getNumPackets() - 1);
        ByteArrayInputStream preambleIS = null;
        ByteArrayOutputStream preambleOS = null;
        ByteArrayInputStream postambleIS = null;
        ByteArrayOutputStream postambleOS = null;
        InputStream xdpWrapperStream = null;
        try {
            preambleOS = new ByteArrayOutputStream(preamble.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)preamble.getLength());
            preamble.getStreamData(preambleOS);
            preambleIS = new ByteArrayInputStream(preambleOS.toByteArray());
            postambleOS = new ByteArrayOutputStream(postamble.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)postamble.getLength());
            postamble.getStreamData(postambleOS);
            postambleIS = new ByteArrayInputStream(postambleOS.toByteArray());
            xdpWrapperStream = new SequenceInputStream(preambleIS, postambleIS);
            if (validateElement) {
                boolean bl = XMLUtils.conformXML(new InputSource(xdpWrapperStream), newXML, xmlResult, element, omitXMLDeclaration);
                return bl;
            }
            boolean bl = XMLUtils.conformXML(new InputSource(xdpWrapperStream), newXML, xmlResult, omitXMLDeclaration);
            return bl;
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException(e);
        }
        finally {
            try {
                try {
                    if (xdpWrapperStream != null) {
                        xdpWrapperStream.close();
                    }
                }
                finally {
                    try {
                        if (postambleIS != null) {
                            postambleIS.close();
                        }
                    }
                    finally {
                        try {
                            if (postambleOS != null) {
                                postambleOS.close();
                            }
                        }
                        finally {
                            try {
                                if (preambleIS != null) {
                                    preambleIS.close();
                                }
                            }
                            finally {
                                if (preambleOS != null) {
                                    preambleOS.close();
                                }
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importXFAElementIntoStream(PDFInteractiveForm interactiveForm, XFAService.XFAElement xfaElement, Source xmlSource) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidXMLException {
        PDFXFAStream xfaStream = interactiveForm.getXFAAsStream();
        InputByteStream xfaIBS = null;
        InputStream xfaIS = null;
        OutputByteStream newXFAOBS = null;
        OutputStream newXFAStream = null;
        ByteArrayOutputStream outStm = null;
        boolean succeeded = false;
        try {
            outStm = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
            xfaStream.getStreamData(outStm);
            if (outStm.size() == 0) {
                boolean bl = false;
                return bl;
            }
            xfaIS = new ByteArrayInputStream(outStm.toByteArray());
            succeeded = XMLUtils.replaceXMLElement(new InputSource(xfaIS), xmlSource, new StreamResult(newXFAStream = (newXFAOBS = interactiveForm.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, (long)outStm.size() + 1024L)).toOutputStream()), xfaElement, false, true, false);
            if (succeeded) {
                xfaIBS = newXFAOBS.closeAndConvert();
                xfaStream.setStreamData(xfaIBS.toInputStream());
            }
            newXFAOBS = null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException(e);
        }
        finally {
            try {
                try {
                    if (xfaIBS != null) {
                        xfaIBS.close();
                    }
                }
                finally {
                    try {
                        if (newXFAStream != null) {
                            newXFAStream.close();
                        }
                    }
                    finally {
                        try {
                            if (newXFAOBS != null) {
                                newXFAOBS.close();
                            }
                        }
                        finally {
                            try {
                                if (xfaIS != null) {
                                    xfaIS.close();
                                }
                            }
                            finally {
                                if (outStm != null) {
                                    outStm.close();
                                }
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportXFAElementFromArray(PDFInteractiveForm interactiveForm, XFAService.XFAElement xfaElement, Result xmlResult) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        ASString asElementName;
        PDFXFAArray xfaArray = interactiveForm.getXFAAsArray();
        int elementIndex = xfaArray.find(asElementName = new ASString(xfaElement.getElementName()));
        if (elementIndex == -1) {
            return false;
        }
        PDFStream xfaStream = xfaArray.getStream(elementIndex);
        ByteArrayOutputStream xfaOS = null;
        ByteArrayInputStream xfaInputStream = null;
        try {
            xfaOS = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
            xfaStream.getStreamData(xfaOS);
            xfaInputStream = new ByteArrayInputStream(xfaOS.toByteArray());
            boolean bl = PDFFormSupport.convertStreamToCorrectFormat(xfaArray, new StreamSource(xfaInputStream), xmlResult, false, xfaElement, true);
            return bl;
        }
        finally {
            try {
                try {
                    if (xfaInputStream != null) {
                        xfaInputStream.close();
                    }
                }
                finally {
                    if (xfaOS != null) {
                        xfaOS.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportXFAElementFromStream(PDFInteractiveForm interactiveForm, XFAService.XFAElement xfaElement, Result xmlResult) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        PDFXFAStream xfaStream = interactiveForm.getXFAAsStream();
        ByteArrayOutputStream xfaOS = null;
        ByteArrayInputStream xfaIS = null;
        try {
            xfaOS = new ByteArrayOutputStream(xfaStream.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)xfaStream.getLength());
            xfaStream.getStreamData(xfaOS);
            xfaIS = new ByteArrayInputStream(xfaOS.toByteArray());
            boolean bl = XMLUtils.extractXMLElement(new InputSource(xfaIS), xmlResult, xfaElement, true, false);
            return bl;
        }
        catch (SAXException e) {
            throw new PDFInvalidXMLException(e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException(e);
        }
        finally {
            try {
                try {
                    if (xfaIS != null) {
                        xfaIS.close();
                    }
                }
                finally {
                    if (xfaOS != null) {
                        xfaOS.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }
}

