/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.xfa.form.Base64;
import com.adobe.xfa.protocol.AuthenticationHandler;
import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.CharacterHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;

public class Protocol
implements com.adobe.xfa.protocol.Protocol {
    private static final int BUFFSIZE = 1024;
    private AuthenticationHandler authHandler = null;
    private PDFDocument mRequestContext;

    public Protocol() {
    }

    public Protocol(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    @Override
    public String scheme() {
        return "";
    }

    @Override
    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    @Override
    public URLStreamHandler getURLStreamHandler() {
        return null;
    }

    @Override
    public InputStream get(String sUrl) {
        if (this.isTrusted(sUrl, Protocol.TrustType.URL, true)) {
            URL url = null;
            HttpURLConnection connection = null;
            InputStream iFile = null;
            try {
                HttpURLConnection newConnection;
                url = new URL(sUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setUseCaches(true);
                if (connection.getResponseCode() == 401 && (newConnection = this.tryHTTPAuthentication(sUrl, connection)) != null) {
                    connection = newConnection;
                }
                iFile = connection.getInputStream();
            }
            catch (MalformedURLException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_READ, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
            catch (IOException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_READ, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
            return iFile;
        }
        return null;
    }

    private HttpURLConnection tryHTTPAuthentication(String sUrl, HttpURLConnection connection) throws IOException {
        if (this.authHandler == null) {
            return null;
        }
        String value = connection.getHeaderField("WWW-Authenticate");
        if (value == null) {
            return null;
        }
        int realmIndex = -1;
        String realm = null;
        if (value.indexOf("Digest ") != 0 && value.indexOf("Basic ") == 0) {
            CharacterHolder passwordHolder;
            StringHolder userIDHolder;
            realmIndex = value.indexOf("realm");
            if (realmIndex != -1) {
                realm = value.substring(realmIndex + 7, value.length() - 1);
            }
            if (!this.authHandler.getBasicCredentials(sUrl, realm, userIDHolder = new StringHolder(), passwordHolder = new CharacterHolder())) {
                return null;
            }
            String userIdPasword = userIDHolder.value + ":" + new String(passwordHolder.value);
            String encodedUserIdPassword = Base64.encode(userIdPasword);
            URL url = new URL(sUrl);
            HttpURLConnection newConnection = (HttpURLConnection)url.openConnection();
            this.copyConnectionAttributes(connection, newConnection);
            newConnection.setRequestProperty("Authorization", "Basic " + encodedUserIdPassword);
            return newConnection;
        }
        return null;
    }

    private void copyConnectionAttributes(HttpURLConnection oldConnection, HttpURLConnection newConnection) throws ProtocolException {
        newConnection.setDoInput(oldConnection.getDoInput());
        newConnection.setDoOutput(oldConnection.getDoOutput());
        newConnection.setRequestMethod(oldConnection.getRequestMethod());
        newConnection.setUseCaches(oldConnection.getUseCaches());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePostData(Protocol.SimplePostData oData, HttpURLConnection connection) throws IOException {
        OutputStream out = null;
        try {
            if (oData.headerMap != null && oData.headerMap.size() > 0) {
                for (Map.Entry<String, String> entry : oData.headerMap.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            } else {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            out = connection.getOutputStream();
            if (oData.data != null) {
                out.write(oData.data);
                out.flush();
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Protocol.PostRsvp post(Protocol.SimplePostData oData, String sUrl) {
        if (this.isTrusted(sUrl, Protocol.TrustType.URL, true)) {
            URL url = null;
            HttpURLConnection connection = null;
            String sResponseType = null;
            byte[] response = null;
            ExFull exception = null;
            try {
                HttpURLConnection newConnection;
                url = new URL(sUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                this.writePostData(oData, connection);
                if (connection.getResponseCode() == 401 && (newConnection = this.tryHTTPAuthentication(sUrl, connection)) != null) {
                    connection = newConnection;
                    this.writePostData(oData, connection);
                }
                InputStream responseStream = connection.getResponseCode() >= 300 ? connection.getErrorStream() : connection.getInputStream();
                try {
                    response = this.readResponseStream(responseStream, connection.getContentLength());
                }
                finally {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                sResponseType = connection.getContentType();
                if (connection.getResponseCode() >= 300) {
                    ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                    String detail = response == null ? connection.getResponseMessage() : new String(response, this.getResponseCharset(sResponseType));
                    ExFull oSysEx = new ExFull(detail, ResId.PROTOCOL_ERR_SYS);
                    oEx.insert(oSysEx, true);
                    exception = oEx;
                }
            }
            catch (MalformedURLException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                exception = oEx;
            }
            catch (IOException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                exception = oEx;
            }
            return new Protocol.PostRsvp(0, sResponseType, response, exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMultiPartPostData(List<? extends Protocol.MultiPartDesc> oData, HttpURLConnection connection) throws IOException {
        OutputStream out = null;
        try {
            connection.setRequestProperty("MIME-version", "1.0");
            byte[] boundary = ProtocolUtils.mimeBoundary(null);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + new String(boundary, "US-ASCII"));
            out = connection.getOutputStream();
            boolean bReset = true;
            byte[] name = null;
            byte[] file = null;
            byte[] type = null;
            byte[] value = null;
            for (Protocol.MultiPartDesc multiPartDesc : oData) {
                Protocol.SectionDataOption eOption;
                if (bReset) {
                    value = null;
                    type = null;
                    file = null;
                    name = null;
                    bReset = false;
                }
                if ((eOption = multiPartDesc.eSectionDataOption) != Protocol.SectionDataOption.SECTION_END) {
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_NAME) {
                        name = multiPartDesc.value;
                        continue;
                    }
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_FILE) {
                        file = multiPartDesc.value;
                        continue;
                    }
                    if (eOption == Protocol.SectionDataOption.SECTION_CONTENT_TYPE) {
                        type = multiPartDesc.value;
                        continue;
                    }
                    if (eOption != Protocol.SectionDataOption.SECTION_CONTENT_VALUE) continue;
                    value = multiPartDesc.value;
                    continue;
                }
                out.write(ProtocolUtils.mimeSection(boundary, name, file, type, value));
                out.write(ProtocolUtils.mimeTrailer(boundary));
                out.flush();
                bReset = true;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Protocol.PostRsvp post(List<? extends Protocol.MultiPartDesc> oData, String sUrl) {
        if (this.isTrusted(sUrl, Protocol.TrustType.URL, true)) {
            URL url = null;
            HttpURLConnection connection = null;
            ExFull exception = null;
            String sResponseType = null;
            byte[] response = null;
            try {
                HttpURLConnection newConnection;
                url = new URL(sUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("POST");
                this.writeMultiPartPostData(oData, connection);
                if (connection.getResponseCode() == 401 && (newConnection = this.tryHTTPAuthentication(sUrl, connection)) != null) {
                    connection = newConnection;
                    this.writeMultiPartPostData(oData, connection);
                }
                if (connection.getResponseCode() >= 300) {
                    ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                    ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, connection.getResponseMessage()));
                    oEx.insert(oSysEx, true);
                    exception = oEx;
                }
                sResponseType = connection.getContentType();
                InputStream responseStream = connection.getInputStream();
                try {
                    response = this.readResponseStream(responseStream, connection.getContentLength());
                }
                finally {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-ASCII encoding not supported.", e);
            }
            catch (MalformedURLException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                exception = oEx;
            }
            catch (IOException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_POST, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                exception = oEx;
            }
            return new Protocol.PostRsvp(0, sResponseType, response, exception);
        }
        return null;
    }

    @Override
    public void put(String sFileName, String sUrl) {
        if (this.isTrusted(sUrl, Protocol.TrustType.URL, true)) {
            FileInputStream iFile = null;
            try {
                iFile = new FileInputStream(sFileName);
                this.put(iFile, sUrl);
            }
            catch (IOException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
            finally {
                try {
                    if (iFile != null) {
                        ((InputStream)iFile).close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDataInConnection(InputStream iFile, URLConnection connection) throws IOException {
        OutputStream oFile = null;
        try {
            oFile = connection.getOutputStream();
            byte[] buf = new byte[1024];
            int iCnt = 0;
            while ((iCnt = iFile.read(buf)) != -1) {
                oFile.write(buf, 0, iCnt);
            }
        }
        finally {
            try {
                if (oFile != null) {
                    oFile.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void put(InputStream iFile, String sUrl) {
        if (this.isTrusted(sUrl, Protocol.TrustType.URL, true)) {
            URL url = null;
            URLConnection connection = null;
            try {
                url = new URL(sUrl);
                connection = url.openConnection();
                connection.setUseCaches(true);
                connection.setDoOutput(true);
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).setRequestMethod("PUT");
                }
                this.putDataInConnection(iFile, connection);
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection newConnection;
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    if (httpConnection.getResponseCode() == 401 && (newConnection = this.tryHTTPAuthentication(sUrl, httpConnection)) != null) {
                        connection = newConnection;
                        this.putDataInConnection(iFile, connection);
                    }
                    if (httpConnection.getResponseCode() >= 300) {
                        ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
                        ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, httpConnection.getResponseMessage()));
                        oEx.insert(oSysEx, true);
                        throw oEx;
                    }
                }
            }
            catch (MalformedURLException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
            catch (IOException e) {
                ExFull oEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_WRITE, sUrl));
                ExFull oSysEx = new ExFull(new MsgFormat(ResId.PROTOCOL_ERR_SYS, e.getMessage()));
                oEx.insert(oSysEx, true);
                throw oEx;
            }
        }
    }

    @Override
    public boolean isTrusted(String sURL, Protocol.TrustType eTrustType, boolean bThrow) {
        return true;
    }

    String postHelper(String sUrl, String sHeader, String sData, String sContentType, String sEnc) {
        try {
            String sEncoding = StringUtils.isEmpty(sEnc) ? "UTF-8" : sEnc;
            Protocol.SimplePostData oData = new Protocol.SimplePostData(sData.getBytes(sEncoding));
            String sHead = "Content-Type";
            if (StringUtils.isEmpty(sContentType)) {
                oData.headerMap.put(sHead, "application/octet-stream");
            } else if (!StringUtils.isEmpty(sEnc)) {
                oData.headerMap.put(sHead, "application/octet-stream");
            } else {
                oData.headerMap.put(sHead, "application/octet-stream; charset=" + sEnc);
            }
            if (!StringUtils.isEmpty(sHeader)) {
                int colon = sHeader.indexOf(58);
                String sHeaderKey = colon > 0 ? sHeader.substring(0, colon) : sHeader;
                String sHeaderVal = colon > 0 ? sHeader.substring(colon + 1) : "";
                oData.headerMap.put(sHeaderKey, sHeaderVal);
            }
            Protocol.PostRsvp oRsvp = this.post(oData, sUrl);
            String sCharSet = "UTF-8";
            if (oRsvp != null) {
                int nCharSet = StringUtils.findNoCase(oRsvp.sType, "charset=", 0);
                if (nCharSet >= 0) {
                    sCharSet = oRsvp.sType.substring(nCharSet + 1);
                }
                return new String(oRsvp.data, sCharSet);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Protocol.exists due to unsupported encoding", e);
        }
    }

    private byte[] readResponseStream(InputStream responseStream, int nContentLength) throws IOException {
        if (responseStream == null) {
            return null;
        }
        byte[] response = null;
        if (nContentLength != -1) {
            response = new byte[nContentLength];
            int nBytesRead = responseStream.read(response);
            assert (nBytesRead == nContentLength);
        } else {
            int nBytesRead;
            ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((nBytesRead = responseStream.read(buffer)) != -1) {
                responseBuffer.write(buffer, 0, nBytesRead);
            }
            response = responseBuffer.toByteArray();
        }
        return response;
    }

    private String getResponseCharset(String sResponseType) {
        int i;
        String sCharset = "ISO-8859-1";
        if (sResponseType != null && (i = sResponseType.indexOf("charset=")) != -1) {
            int endIndex;
            int beginIndex = i + "charset=".length();
            int endDelimiter = 59;
            if (beginIndex < sResponseType.length() && sResponseType.charAt(beginIndex) == '\"') {
                ++beginIndex;
                endDelimiter = 34;
            }
            if ((endIndex = sResponseType.indexOf(endDelimiter, beginIndex)) == -1) {
                endIndex = sResponseType.length();
            }
            sCharset = endIndex == -1 ? sResponseType.substring(beginIndex) : sResponseType.substring(beginIndex, endIndex);
        }
        return sCharset;
    }

    void setRequestContext(PDFDocument doc) {
    }

    PDFDocument getRequestContext() {
        return this.mRequestContext;
    }

    @Override
    public boolean isUrlEncoded(String arg0) {
        return false;
    }
}

