/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CTextWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CWidget;

public class CTextField
extends CPDField {
    private static boolean debugMode = false;
    private boolean m_bEnableFileSelect = false;
    private boolean m_bValuesConsistent = false;

    CTextField(CPDFields pCPDFlds, PDFFieldNode coFld, String esFldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        super(pCPDFlds, coFld, esFldName);
        if ((this.getFlags() & 0x100000) > 0) {
            super.setValue(this.getCosDoc().createCosNull(), ASName.k_V);
            super.setDefaultValue(this.getCosDoc().createCosNull());
        }
    }

    @Override
    void addWidget(CosObject annotation, int i) {
        this.m_vectorWidgets.add(i, new CTextWidget(this, annotation, i));
    }

    @Override
    boolean setValue(CosObject coValue, ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFUnableToCompleteOperationException {
        if (coValue.getType() != 0) {
            String asValue = PDFText.getInstance(coValue).stringValue();
            asValue = this.normalizeNewLines(asValue);
            PDFText pdfText = PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), asValue, asValue.length() > 65535, false);
            PDFFilterFlate filter = PDFFilterFlate.newInstance(this.m_pCPDFlds.getPDDoc(), null);
            pdfText.setFilter(filter);
            coValue = pdfText.getCosObject();
        }
        return this.setValue(coValue, this.getCosDoc().createCosNull(), asaKey);
    }

    String normalizeNewLines(String asValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean bMultiline;
        int nFlags = this.getFlags();
        boolean bl = bMultiline = (nFlags & 0x1000) != 0;
        if (bMultiline || this.getXFANode() != null) {
            asValue = asValue.replaceAll("(\r\n)", "\r");
            asValue = asValue.replaceAll("(\n)", "\r");
        } else {
            asValue = asValue.replaceAll("(\n\r)|(\r\n)|[\n]|[\r]", " ");
        }
        return asValue;
    }

    private boolean setValue(CosObject coValue, CosObject coFlat, ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFUnableToCompleteOperationException {
        int nFlags = this.getFlags();
        if ((nFlags & 0x100000) != 0) {
            return super.setValue(this.m_bEnableFileSelect ? coValue : null, asaKey);
        }
        asaKey = (nFlags & 0x2000000) != 0 ? ASName.k_RV : ASName.k_V;
        PDFFieldNode coFld = this.getPDFFieldNode();
        if (!this.AFCosObjEquivalent(coValue, super.getValue(asaKey))) {
            CosObject coRich = this.getCosDoc().createCosNull();
            if (coValue != null && (coValue.getType() == 4 || coValue.getType() == 7)) {
                PDFText asValue = PDFText.getInstance(coValue);
                if ((nFlags & 0x2000000) != 0) {
                    PDFText flatText = null;
                    flatText = coFlat.getType() != 0 ? PDFText.getInstance(coFlat) : PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), "");
                    if (coFlat.getType() == 0) {
                        if (coValue != null) {
                            flatText = PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), new RichTextHandler().getRawContent(coValue.textValue()));
                        }
                        coRich = asValue.getCosObject();
                        coFlat = flatText.getCosObject();
                    } else {
                        coRich = coValue;
                    }
                } else {
                    coFlat = asValue.getCosObject();
                }
            }
            if (asaKey == ASName.k_RV) {
                if (coRich != null && ((CosObject)coRich).getType() != 0) {
                    coFld.getCosDictionary().put(asaKey, coRich);
                    coFld.getCosDictionary().put(ASName.k_V, coFlat);
                } else {
                    coFld.removeValue(asaKey);
                    coFld.removeValue(ASName.k_V);
                }
            } else if (coFlat != null && coFlat.getType() != 0) {
                coFld.getCosDictionary().put(ASName.k_V, coFlat);
                if (debugMode) {
                    System.out.println("Setting the V value of pdfField " + coFld.getQualifiedName() + " Value = " + coFlat.stringValue());
                }
            } else {
                coFld.removeValue(ASName.k_V);
            }
            return true;
        }
        return false;
    }

    StyleAttributes getDefaultStyle() throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException {
        CosObject coDS = PDFCosUtils.getInheritableValue(ASName.k_DS, ASName.k_Parent, this.getPDFFieldNode());
        return new StyleAttributes(coDS.textValue());
    }

    private void ensureValueConsistency() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFUnableToCompleteOperationException {
        if (this.m_bValuesConsistent) {
            return;
        }
        if ((this.getFlags() & 0x2000000) == 0x2000000) {
            CosObject coFlat;
            String asFlatValue;
            String flatRichText;
            CosObject coRValue = super.getValue(ASName.k_RV);
            if (coRValue.getType() != 4 && coRValue.getType() != 7) {
                CosObject coValue = super.getValue(ASName.k_V);
                if (coValue.getType() == 0 && coRValue.getType() == 0) {
                    this.m_bValuesConsistent = true;
                    return;
                }
                this.getPDFFieldNode().getCosDictionary().put(ASName.k_RV, new CosCloneMgr(this.getCosDoc()).clone(coValue));
            }
            if (!(flatRichText = PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), new RichTextHandler().getRawContent(super.getValue(ASName.k_RV).textValue())).stringValue()).equals(asFlatValue = (coFlat = super.getValue(ASName.k_V)).textValue())) {
                CTextField NC_TextFieldP = this;
                NC_TextFieldP.setValue(new CosCloneMgr(this.getCosDoc()).clone(coFlat), ASName.k_V);
            }
            this.m_bValuesConsistent = true;
        }
    }

    @Override
    public CosObject getValue(ASName asaKey) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        CosObject coValue;
        if ((this.getFlags() & 0x2000000) == 0x2000000) {
            try {
                this.ensureValueConsistency();
            }
            catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {
                // empty catch block
            }
            coValue = super.getValue(ASName.k_RV);
        } else {
            coValue = super.getValue(ASName.k_V);
        }
        return coValue;
    }

    @Override
    public String getValueAsEStr() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        String esVal = (this.getFlags() & 0x2000000) == 0x2000000 ? AFUtils.EStrNewFromCosObj(this.getValue(ASName.k_V)) : AFUtils.EStrNewFromCosObj(super.getValue(ASName.k_V));
        return esVal;
    }

    @Override
    public ASName getType() {
        return ASName.k_Tx;
    }

    int getMaxLen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        CWidget pCWidget;
        CosObject coMaxLen = this.getPDFFieldNode().getDictionaryCosObjectValue(ASName.k_MaxLen);
        if ((coMaxLen == null || coMaxLen.getType() == 0) && (pCWidget = this.getWidget(0)) != null) {
            PDFAnnotationWidget coAnnot = pCWidget.getPDAnnot();
            coMaxLen = coAnnot.getDictionaryCosObjectValue(ASName.k_MaxLen);
        }
        if (coMaxLen != null && coMaxLen.getType() == 1) {
            return ((CosNumeric)coMaxLen).intValue();
        }
        return 0;
    }

    private CosObject clipThisValueToMaxLen(CosObject coValue, int nLen) throws PDFSecurityException, PDFInvalidDocumentException, PDFIOException {
        if (nLen > 0) {
            String esVal = coValue.stringValue().asString();
            int nBefore = esVal.length();
            if (nLen < esVal.length()) {
                esVal = esVal.substring(0, nLen);
            }
            if (esVal.length() < nBefore) {
                PDFText pdfText = PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), esVal, esVal.length() > 65535, false);
                PDFFilterFlate filter = PDFFilterFlate.newInstance(this.m_pCPDFlds.getPDDoc(), null);
                pdfText.setFilter(filter);
                coValue = pdfText.getCosObject();
            }
        }
        return coValue;
    }

    public void setMaxLen(int maxLen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        int oldLen = this.getMaxLen();
        if (oldLen != maxLen) {
            CosDocument cd = this.getCosDoc();
            PDFFieldNode coFld = this.getPDFFieldNode();
            if (maxLen > 0) {
                coFld.getCosDictionary().put(ASName.k_MaxLen, cd.createCosNumeric(maxLen));
                CosObject coOldVal = super.getValue(ASName.k_V);
                CosObject coNewVal = this.clipThisValueToMaxLen(coOldVal, maxLen);
                if (!this.AFCosObjEquivalent(coOldVal, coNewVal)) {
                    super.setValue(coNewVal, ASName.k_V);
                    this.m_bValuesConsistent = false;
                    this.ensureValueConsistency();
                }
                if (!this.AFCosObjEquivalent(coOldVal = this.getDefaultValue(), coNewVal = this.clipThisValueToMaxLen(coOldVal, maxLen))) {
                    super.setDefaultValue(coNewVal);
                }
            } else if (coFld.dictionaryContains(ASName.k_MaxLen)) {
                coFld.removeValue(ASName.k_MaxLen);
            } else {
                coFld.getCosDictionary().put(ASName.k_MaxLen, cd.createCosNumeric(0));
            }
        }
    }
}

