/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.TextAppearance_t;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CPDField {
    protected CPDFields m_pCPDFlds;
    private int m_coObjNum = -1;
    private PDFFieldType m_fldType;
    protected List<CWidget> m_vectorWidgets;
    protected int numWidgets = 0;
    private String m_esFldName;
    protected Node m_XFANode;
    public static final int Flags_Annot = 0;
    public static final int Flags_Field = 1;
    public static final int SetFlagsAnnot = 2;
    public static final int ClrFlagsAnnot = 3;
    public static final int SetFlagsField = 4;
    public static final int ClrFlagsField = 5;
    public static final ASName k_Button = ASName.create("Button");
    public static final ASName k_CheckBox = ASName.create("CheckBox");
    public static final ASName k_ComboBox = ASName.create("ComboBox");
    public static final ASName k_ListBox = ASName.create("ListBox");
    public static final ASName k_RadioButton = ASName.create("RadioButton");

    CPDField(CPDFields pCPDFlds, PDFFieldNode coFld, String esFldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.m_pCPDFlds = pCPDFlds;
        if (coFld != null) {
            this.m_coObjNum = coFld.getCosObject().getObjNum();
            this.m_fldType = coFld.getFieldType();
        }
        this.m_esFldName = esFldName;
        if (coFld != null && this.m_fldType != null) {
            CosObject coWidget = this.getWidgetCosObjAndNumWidgets(true, 0);
            if (coWidget.getType() == 6) {
                this.m_vectorWidgets = new ArrayList<CWidget>(this.numWidgets);
            } else {
                this.numWidgets = 0;
            }
        }
    }

    private CosObject getWidgetCosObjAndNumWidgets(boolean bInitNumWidgets, int iWidget) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject coWidget;
        int nArrayLen;
        PDFFieldNode coFld = this.getPDFFieldNode();
        CosObject coWidgets = coFld.getDictionaryCosObjectValue(ASName.k_Kids);
        boolean bIsArray = coWidgets != null && coWidgets.getType() == 5;
        int n = nArrayLen = bIsArray ? ((CosArray)coWidgets).size() : 0;
        if (bIsArray && nArrayLen > 0) {
            if (bInitNumWidgets) {
                this.numWidgets = nArrayLen;
            }
            assert (iWidget < nArrayLen);
            coWidget = ((CosArray)coWidgets).get(iWidget);
            if (coWidget.getType() == 6) {
                if (((CosDictionary)coWidget).get(ASName.k_T) != null && ((CosDictionary)coWidget).get(ASName.k_T).getType() == 4) {
                    coWidget = this.getCosDoc().createCosNull();
                } else assert (((CosDictionary)coWidget).getName(ASName.k_Subtype) == ASName.k_Widget);
            }
        } else if (coFld.getDictionaryCosObjectValue(ASName.k_Subtype) == null || coFld.getDictionaryNameValue(ASName.k_Subtype) != ASName.k_Widget) {
            coWidget = this.getCosDoc().createCosNull();
        } else {
            assert (iWidget == 0);
            if (bInitNumWidgets) {
                this.numWidgets = 1;
            }
            coWidget = coFld.getCosObject();
        }
        return coWidget;
    }

    void destroy() {
        XFANodeLinkHelper helper = new XFANodeLinkHelper(this);
        helper.breakLinkWithCurrentXFANode();
    }

    CWidget getWidget(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        CWidget widget;
        if (!this.isTerminal()) {
            return null;
        }
        for (int iWidget = 0; iWidget < this.numWidgets && (widget = this.getWidget(iWidget)) != null; ++iWidget) {
            if (annot != widget.getPDAnnot()) continue;
            return this.m_vectorWidgets.get(iWidget);
        }
        return null;
    }

    public CWidget getWidget(int iWidget) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (iWidget >= this.numWidgets) {
            return null;
        }
        if (iWidget < this.m_vectorWidgets.size()) {
            return this.m_vectorWidgets.get(iWidget);
        }
        for (int i = 0; i < this.numWidgets; ++i) {
            if (this.m_vectorWidgets.size() > i) continue;
            CosObject coWidget = this.getWidgetCosObjAndNumWidgets(false, i);
            this.addWidget(coWidget, i);
        }
        return this.m_vectorWidgets.get(iWidget);
    }

    void addWidget(CosObject annotation, int i) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
    }

    public PDFFieldNode getPDFFieldNode() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coObj = this.getCosObject();
        if (coObj != null) {
            if (this.m_fldType == null) {
                return PDFFieldNode.getInstance(coObj, true);
            }
            return PDFFieldFactory.getInstance(coObj, this.m_fldType.getValue());
        }
        return null;
    }

    Node getXFANode() {
        return this.m_XFANode;
    }

    protected CosDocument getCosDoc() {
        return this.m_pCPDFlds.getPDDoc().getCosDocument();
    }

    public Node getXFAField(boolean bSafe) {
        if (this.m_XFANode != null) {
            if (this.m_XFANode.getModel() == null) {
                this.m_XFANode = null;
            } else {
                return this.m_XFANode;
            }
        }
        if (!bSafe) {
            return this.m_XFANode;
        }
        DocumentContext poContext = DocumentContext.find(this.m_pCPDFlds.getPDDoc(), false, null);
        if (poContext == null) {
            return null;
        }
        return poContext.getFieldXFANode(this);
    }

    public boolean setValueFromEStr(String value) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        boolean retVal = false;
        if (AFUtils.EStrIsNull(value)) {
            retVal = this.setValue(this.getCosDoc().createCosNull(), ASName.k_V);
        } else {
            PDFText pdfText = PDFText.newInstance(this.m_pCPDFlds.getPDDoc(), value, value.length() > 65535, false);
            PDFFilterFlate filter = PDFFilterFlate.newInstance(this.m_pCPDFlds.getPDDoc(), null);
            pdfText.setFilter(filter);
            CosObject cosVal = pdfText.getCosObject();
            if (cosVal != null) {
                retVal = this.setValue(cosVal, ASName.k_V);
            }
        }
        return retVal;
    }

    boolean setValue(CosObject newValue, ASName key) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        PDFFieldNode coFld = this.getPDFFieldNode();
        if (!this.AFCosObjEquivalent(newValue, coFld.getCosDictionary().get(key))) {
            if (newValue.getType() != 0) {
                coFld.getCosDictionary().put(key, newValue);
            } else {
                coFld.removeValue(key);
            }
            return true;
        }
        return false;
    }

    protected boolean AFCosObjEquivalent(CosObject obj1, CosObject obj2) throws PDFCosParseException {
        if (obj1 == obj2) {
            return true;
        }
        int obj1Type = obj1.getType();
        int obj2Type = 0;
        if (obj2 != null) {
            obj2Type = obj2.getType();
        }
        if (obj1Type == obj2Type) {
            if (obj1Type == 7) {
                return obj1.toString().equals(obj2.toString());
            }
            if (obj1Type == 4) {
                try {
                    return obj1.stringValue().asString().equals(obj2.stringValue().asString());
                }
                catch (PDFSecurityException e) {
                }
            } else {
                if (obj1Type == 1) {
                    return ((CosNumeric)obj1).fixedValue() == ((CosNumeric)obj2).fixedValue();
                }
                if (obj1Type == 0) {
                    return true;
                }
                if (obj1Type == 3) {
                    return obj1.nameValue() == obj2.nameValue();
                }
                if (obj1Type == 2) {
                    return obj1.booleanValue() == obj2.booleanValue();
                }
                if (obj1Type == 5) {
                    CosArray obj1Arr = (CosArray)obj1;
                    CosArray obj2Arr = (CosArray)obj2;
                    if (obj1Arr.size() == obj2Arr.size()) {
                        boolean equal = true;
                        Iterator<CosObject> it1 = obj1Arr.iterator();
                        Iterator<CosObject> it2 = obj2Arr.iterator();
                        while (it1.hasNext() && it2.hasNext() && equal) {
                            equal = this.AFCosObjEquivalent(it1.next(), it2.next());
                        }
                        return equal;
                    }
                }
            }
        }
        return false;
    }

    protected CosObject getKids() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode coFld = this.getPDFFieldNode();
        if (coFld == null) {
            assert (this == this.m_pCPDFlds.getRootCPDField());
            return this.m_pCPDFlds.getPDDoc().getInteractiveForm().getDictionaryCosObjectValue(ASName.k_Fields);
        }
        return coFld.getDictionaryCosObjectValue(ASName.k_Kids);
    }

    public void setFlags(int flagType, int nFlags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block10: {
            block9: {
                if (!this.isTerminal()) break block9;
                if (flagType == 0 || flagType == 2 || flagType == 3) {
                    for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                        this.getWidget(iWidget).setFlags(nFlags, flagType);
                    }
                } else {
                    int nOldFlags = this.getFlags();
                    if (flagType == 4) {
                        nFlags |= nOldFlags;
                    } else if (flagType == 5) {
                        nFlags = ~nFlags & nOldFlags;
                    }
                    if (nFlags > 0) {
                        this.getPDFFieldNode().setFlags(nFlags);
                    } else {
                        this.getPDFFieldNode().removeValue(ASName.k_Ff);
                    }
                }
                break block10;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block10;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.setFlags(flagType, nFlags);
            }
        }
    }

    public void setDefaultTextAppearances(TextAppearance_t textAP, int textAPFlags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block3: {
            block2: {
                if (!this.isTerminal()) break block2;
                for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                    this.getWidget(iWidget).setDefaultTextAppearance(textAP, textAPFlags);
                }
                break block3;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block3;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.setDefaultTextAppearances(textAP, textAPFlags);
            }
        }
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFFieldNode().getFlags();
    }

    public ASName getType() {
        return null;
    }

    public String getName() {
        return this.m_esFldName;
    }

    public int getNumWidgets() {
        return this.numWidgets;
    }

    void postConstructionHeavyDutyWork() {
    }

    boolean isTerminal() {
        return this.numWidgets > 0;
    }

    public CosObject getCosObject() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.m_coObjNum < 0) {
            return null;
        }
        return this.getCosDoc().getIndirectObjectByNumber(this.m_coObjNum);
    }

    public void setXFALink(Node oNode) {
        XFANodeLinkHelper helper = new XFANodeLinkHelper(this);
        if (!helper.needToUpdateXFANodeLink(oNode)) {
            return;
        }
        assert (this.getType() == k_RadioButton && oNode instanceof FormExclGroup || this.getType() != k_RadioButton);
        helper.breakLinkWithCurrentXFANode();
        helper.connectWithNewXFANode(oNode);
    }

    public CPDFields getCPDFields() {
        return this.m_pCPDFlds;
    }

    public void setBorders(AFUtils.AFPDWidgetBorderRec pdwb) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block3: {
            block2: {
                if (!this.isTerminal()) break block2;
                for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                    this.getWidget(iWidget).setBorder(pdwb);
                }
                break block3;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block3;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.setBorders(pdwb);
            }
        }
    }

    public void setBackgroundColors(TextAppearance_t.PDColorValueRec pdcvBackground) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block3: {
            block2: {
                if (!this.isTerminal()) break block2;
                for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                    this.getWidget(iWidget).setBackgroundColor(pdcvBackground);
                }
                break block3;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block3;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.setBackgroundColors(pdcvBackground);
            }
        }
    }

    public void setBorderColors(TextAppearance_t.PDColorValueRec pdcvBorder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block3: {
            block2: {
                if (!this.isTerminal()) break block2;
                for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                    this.getWidget(iWidget).setBorderColor(pdcvBorder);
                }
                break block3;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block3;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.setBorderColors(pdcvBorder);
            }
        }
    }

    public void setUserName(String esUserName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (AFUtils.EStrIsNull(esUserName)) {
            this.getPDFFieldNode().removeValue(ASName.k_TU);
        } else {
            this.getPDFFieldNode().setDictionaryStringValue(ASName.k_TU, esUserName);
        }
    }

    protected CosObject getValue(ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        return this.CPDField_getValue(asaKey);
    }

    public final CosObject CPDField_getValue(ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        CosObject retVal = this.getPDFFieldNode().getDictionaryCosObjectValue(asaKey);
        if (retVal == null) {
            retVal = this.getCosDoc().createCosNull();
        }
        return retVal;
    }

    public void generateAppearances(String esVal, boolean bOnlyIfHasNoApp) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        block3: {
            block2: {
                if (!this.isTerminal()) break block2;
                String esDisplayVal = this.getValueForDisplay(esVal);
                for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
                    CWidget pCWidget = this.getWidget(iWidget);
                    pCWidget.generateAppearance(esDisplayVal, bOnlyIfHasNoApp);
                }
                break block3;
            }
            CosObject coKids = this.getKids();
            if (coKids.getType() != 5) break block3;
            int nFlds = ((CosArray)coKids).size();
            for (int i = 0; i < nFlds; ++i) {
                CPDField pChildFld = this.m_pCPDFlds.getCPDField(((CosArray)coKids).getCosDictionary(i), true);
                if (pChildFld == null) continue;
                pChildFld.generateAppearances(esVal, bOnlyIfHasNoApp);
            }
        }
    }

    protected String getValueForDisplay(String esVal) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        return esVal != null ? esVal : this.getValueAsEStr();
    }

    protected String getValueAsEStr() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        String esVal = AFUtils.EStrNewFromCosObj(this.getValue(ASName.k_V));
        return esVal;
    }

    CosObject getDefaultValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFFieldNode().getDictionaryCosObjectValue(ASName.k_DV);
    }

    void setDefaultValue(CosObject coValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (coValue.getType() != 0) {
            this.getPDFFieldNode().getCosDictionary().put(ASName.k_DV, coValue);
        } else {
            this.getPDFFieldNode().removeValue(ASName.k_DV);
        }
    }

    private class XFANodeLinkHelper {
        private CPDField mpCPDField;

        XFANodeLinkHelper(CPDField pinCPDField) {
            this.mpCPDField = pinCPDField;
        }

        boolean needToUpdateXFANodeLink(Node oNode) {
            boolean bUpdateLink = false;
            if (this.mpCPDField.m_XFANode != oNode) {
                if (oNode == null) {
                    bUpdateLink = true;
                } else if (oNode instanceof FormField) {
                    FormField oField = (FormField)oNode;
                    if (oField.getCPDField() != this.mpCPDField) {
                        bUpdateLink = true;
                    }
                } else if (oNode instanceof FormExclGroup) {
                    FormExclGroup oGroup = (FormExclGroup)oNode;
                    if (oGroup.getCPDField() == this.mpCPDField) {
                        NodeList oChildren = oNode.getNodes();
                        int nSize = oChildren.length();
                        for (int i = 0; i < nSize; ++i) {
                            FormField oRB;
                            Node oChild = (Node)oChildren.item(i);
                            if (!(oChild instanceof FormField) || (oRB = (FormField)oChild).getCPDField() == this.mpCPDField) continue;
                            bUpdateLink = true;
                            break;
                        }
                    } else {
                        bUpdateLink = true;
                    }
                }
            }
            return bUpdateLink;
        }

        void breakLinkWithCurrentXFANode() {
            if (this.mpCPDField.m_XFANode != null && this.mpCPDField.m_XFANode.getModel() != null) {
                if (this.mpCPDField.m_XFANode instanceof FormField) {
                    FormField oField = (FormField)this.mpCPDField.m_XFANode;
                    CPDField oldCPDField = (CPDField)oField.getCPDField();
                    if (oldCPDField == this.mpCPDField) {
                        oField.setCPDField(null);
                    } else assert (false);
                } else if (this.mpCPDField.m_XFANode instanceof FormExclGroup) {
                    FormExclGroup oGroup = (FormExclGroup)this.mpCPDField.m_XFANode;
                    CPDField oldCPDGroup = (CPDField)oGroup.getCPDField();
                    if (oldCPDGroup == this.mpCPDField) {
                        oGroup.setCPDField(null);
                    } else assert (false);
                    NodeList oChildren = this.mpCPDField.m_XFANode.getNodes();
                    int nSize = oChildren.length();
                    for (int i = 0; i < nSize; ++i) {
                        Node oChild = (Node)oChildren.item(i);
                        if (!(oChild instanceof FormField)) continue;
                        FormField oRB = (FormField)oChild;
                        CPDField oldCPDRB = (CPDField)oRB.getCPDField();
                        if (oldCPDRB == this.mpCPDField) {
                            oRB.setCPDField(null);
                            continue;
                        }
                        assert (false);
                    }
                }
            }
            this.mpCPDField.m_XFANode = null;
        }

        void connectWithNewXFANode(Node oNode) {
            if (oNode != null) {
                if (oNode instanceof FormField) {
                    FormField oField = (FormField)oNode;
                    CPDField oldCPDField = (CPDField)oField.getCPDField();
                    if (oldCPDField != null && oldCPDField != this.mpCPDField) {
                        XFANodeLinkHelper helper = new XFANodeLinkHelper(oldCPDField);
                        helper.breakLinkWithCurrentXFANode();
                    }
                    oField.setCPDField(this.mpCPDField);
                } else if (oNode instanceof FormExclGroup) {
                    FormExclGroup oGroup = (FormExclGroup)oNode;
                    CPDField oldCPDGroup = (CPDField)oGroup.getCPDField();
                    if (oldCPDGroup != null && oldCPDGroup != this.mpCPDField) {
                        XFANodeLinkHelper helper = new XFANodeLinkHelper(oldCPDGroup);
                        helper.breakLinkWithCurrentXFANode();
                    }
                    oGroup.setCPDField(this.mpCPDField);
                    NodeList oChildren = oNode.getNodes();
                    int nSize = oChildren.length();
                    for (int i = 0; i < nSize; ++i) {
                        Node oChild = (Node)oChildren.item(i);
                        if (!(oChild instanceof FormField)) continue;
                        FormField oRB = (FormField)oChild;
                        oRB.setCPDField(this.mpCPDField);
                    }
                }
            }
            this.mpCPDField.m_XFANode = oNode;
        }
    }
}

