/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxBasedField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CChkBxWidget;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.xfa.template.containers.Field;

class CChkBxField
extends CChkBxBasedField {
    public CChkBxField(CPDFields pCPDFlds, PDFFieldNode coFld, String esFldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pCPDFlds, coFld, esFldName);
    }

    @Override
    public boolean setValueFromEStr(String esVal) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        String ces;
        String sNeutral;
        this.invalidateCurrentState();
        Field oField = (Field)this.getXFAField(true);
        if (oField != null && (sNeutral = oField.getNeutralValue()) != null && (ces = sNeutral).equals(esVal)) {
            CChkBxWidget pCChkBxWidget = (CChkBxWidget)this.getWidget(0);
            pCChkBxWidget.setState(k_Off);
            this.getPDFFieldButton().removeValue();
            return true;
        }
        return super.setValueFromEStr(esVal);
    }

    private void invalidateCurrentState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        for (int iWidget = 0; iWidget < this.m_vectorWidgets.size(); ++iWidget) {
            CChkBxWidget pCChkBxWidget = (CChkBxWidget)this.getWidget(iWidget);
            pCChkBxWidget.invalidateCurrentState();
        }
    }

    @Override
    public void addWidget(CosObject annotation, int i) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        this.m_vectorWidgets.add(i, new CChkBxWidget(this, annotation, i));
    }

    @Override
    public ASName getType() {
        return k_CheckBox;
    }

    @Override
    public CosObject getValue(ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        String sNeutral;
        Field oField;
        CChkBxWidget pCChkBxWidget = (CChkBxWidget)this.getWidget(0);
        if (pCChkBxWidget.getCurrentState() == CChkBxWidget.CurrentState.kNeutral && (oField = (Field)this.getXFAField(true)) != null && (sNeutral = oField.getNeutralValue()) != null) {
            return this.getCosDoc().createCosString(sNeutral);
        }
        return super.getValue(asaKey);
    }
}

