/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedIcon;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToEmbedded;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoToRemote;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionLaunch;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionRendition;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionThread;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFEmbeddedTarget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationScreen;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNamedDestinations;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.handler.RedactedAnnotationInfo;
import com.adobe.internal.pdftoolkit.services.redaction.handler.RedactedFieldInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import java.awt.geom.Area;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class AnnotationRedactor {
    private PDFDocument pdfDoc;
    private RedactionState redactionState;
    private ResourcesState resourcesState;
    private ResourcesState pageResourcesState;
    private int pageNumber;
    private RedactionHandler redactionHandler;
    private OCRedactor ocRedactor;

    void setPageResourcesState(ResourcesState pageResourcesState) {
        this.pageResourcesState = pageResourcesState;
    }

    void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    AnnotationRedactor(RedactionState redactionState, PDFDocument pdfDoc, RedactionHandler redactionHandler, OCRedactor ocRedactor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDoc = pdfDoc;
        PDFResources resources = RedactionUtils.getResources(pdfDoc);
        if (resources != null) {
            this.resourcesState = new ResourcesState(resources, redactionHandler, -1);
        }
        this.redactionState = redactionState;
        this.redactionHandler = redactionHandler;
        this.ocRedactor = ocRedactor;
    }

    PDFAnnotationList redactAnnotations(PDFAnnotationList annotationList, Area area) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFAnnotationList redactionAnnotationList = PDFAnnotationList.newInstance(this.pdfDoc);
        HashSet<String> popupAnnotations = new HashSet<String>();
        if (annotationList != null && !annotationList.isEmpty()) {
            PDFAnnotationIterator annotationListIterator = annotationList.iterator();
            while (annotationListIterator.hasNext()) {
                PDFAnnotation annotation = annotationListIterator.next();
                if (annotation == null) continue;
                if (!(annotation instanceof PDFAnnotationRedaction)) {
                    PDFAnnotationPopup popup;
                    if (annotation instanceof PDFAnnotationPopup && (popup = (PDFAnnotationPopup)annotation).getParent() instanceof PDFAnnotationRedaction) {
                        redactionAnnotationList.add(annotation);
                        continue;
                    }
                    PDFRectangle annotationRectangle = annotation.getRect();
                    String name = annotation.getID();
                    this.namesTreeReferenceUpdation(annotation, false);
                    if (RedactionUtils.intersects(this.pdfDoc, annotationRectangle, area)) {
                        this.redactionState.addAnnotationToRedactionSet(annotation);
                        this.namesTreeReferenceUpdation(annotation, true);
                        if (annotation instanceof PDFAnnotationWidget) {
                            this.removeField((PDFAnnotationWidget)annotation);
                        }
                        popupAnnotations.add(name);
                        annotationListIterator.remove();
                        this.redactionHandler.objectRedacted(new RedactedAnnotationInfo(annotation.getSubtype(), this.pageNumber, annotation.getCosObject().getObjNum()));
                        continue;
                    }
                    if (this.ocRedactor != null) {
                        this.ocRedactor.scanAnnotationForOCG(annotation);
                    }
                    this.parseDefaultAppearance(annotation);
                    this.parseAppearanceContentStream(annotation.getAppearance());
                    if (!PDFStructureUtils.hasStructParent(annotation)) continue;
                    this.redactionState.structParentReferenceUpdation(this.pageNumber, PDFStructureUtils.getStructParent(annotation));
                    continue;
                }
                redactionAnnotationList.add(annotation);
            }
            this.removePopupAnnotations(annotationList, popupAnnotations);
            this.removeCalculationOrder(area);
        }
        return redactionAnnotationList;
    }

    private void parseDefaultAppearance(PDFAnnotation annotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (annotation instanceof PDFAnnotationFreeText) {
            this.parseDefaultAppearanceContentStream(((PDFAnnotationFreeText)annotation).getDefaultAppearance());
        } else if (annotation instanceof PDFAnnotationCaret) {
            this.parseDefaultAppearanceContentStream(((PDFAnnotationCaret)annotation).getDefaultAppearance());
        } else if (annotation instanceof PDFAnnotationRedaction) {
            this.parseDefaultAppearanceContentStream(((PDFAnnotationRedaction)annotation).getDA());
        }
    }

    private void parseDefaultAppearanceContentStream(String value) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFFontException, PDFInvalidParameterException {
        if (value != null) {
            PDFDefaultAppearance defaultAppearance = PDFDefaultAppearance.newInstance(this.pdfDoc, value);
            ModifiableContent content = ModifiableContent.newInstance(defaultAppearance);
            if (this.resourcesState != null) {
                RedactionUtils.parseForResourcesInfo(content, this.resourcesState, this.pageResourcesState, this.redactionState, true, this.pageNumber, this.redactionHandler, this.ocRedactor, false);
            }
        }
    }

    private void parseAppearanceContentStream(PDFAppearance appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (appearance != null) {
            this.parseAPStream(appearance.getNormalAppearance());
            this.parseAPStream(appearance.getDownAppearance());
            this.parseAPStream(appearance.getRolloverAppearance());
        }
    }

    private void parseAPStream(PDFXObjectForm objectForm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (objectForm != null) {
            Content content = Content.newInstance(objectForm);
            ResourcesState resState = null;
            PDFResources formRes = objectForm.getResources();
            if (formRes != null) {
                resState = new ResourcesState(formRes, this.redactionHandler, this.pageNumber);
            }
            if (resState == null) {
                resState = this.resourcesState;
            }
            if (resState != null) {
                RedactionUtils.parseForResourcesInfo(content, resState, this.pageResourcesState, this.redactionState, true, this.pageNumber, this.redactionHandler, this.ocRedactor, false);
            }
        }
    }

    private void removeField(PDFAnnotationWidget annotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFField childNode;
        if (annotation.isField() && (childNode = annotation.getField()) != null) {
            PDFFieldButton fieldButton;
            PDFFieldNode field = childNode.getParent();
            if (childNode instanceof PDFFieldButton && ((fieldButton = (PDFFieldButton)childNode).isRadioButton() || fieldButton.isCheckBox())) {
                this.redactionState.getAcroFormButtonField().add(childNode.getQualifiedName());
            }
            if (field != null) {
                field.removeChild(childNode);
                this.redactionHandler.objectRedacted(new RedactedFieldInfo(childNode.getFieldType().getValue(), childNode.getQualifiedName(), childNode.getCosObject().getObjNum()));
            } else {
                childNode.getQualifiedName();
                this.redactionState.getAcroFormFieldsNameSet().add(childNode.getQualifiedName());
            }
        }
    }

    private void removeAcroFromFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm interactiveForm = this.getInteractiveForm();
        if (interactiveForm != null && !interactiveForm.isEmpty()) {
            Iterator<PDFField> fieldIterator = interactiveForm.iterator();
            while (fieldIterator.hasNext()) {
                PDFField field = fieldIterator.next();
                if (field == null) continue;
                String name = field.getQualifiedName();
                if (!this.redactionState.getAcroFormFieldsNameSet().contains(name)) continue;
                fieldIterator.remove();
                this.redactionHandler.objectRedacted(new RedactedFieldInfo(field.getFieldType().getValue(), field.getQualifiedName(), field.getCosObject().getObjNum()));
            }
        }
    }

    private void namesTreeReferenceUpdation(PDFAnnotation annotation, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAppearance appearance = annotation.getAppearance();
        this.namesAnnotationAppearanceStateReferenceUpdation(appearance, isDecrement);
        if (annotation instanceof PDFAnnotationLink) {
            PDFAnnotationLink annotationLink = (PDFAnnotationLink)annotation;
            PDFAction action = annotationLink.getAction();
            this.namedDestinationReferenceUpdation(annotationLink, isDecrement);
            this.actionReferenceUpdation(action, isDecrement, true);
            this.additionalActionReferenceUpdation(annotationLink.getAdditionalActions(), isDecrement);
        } else if (annotation instanceof PDFAnnotationScreen) {
            PDFAnnotationScreen screenAnnotation = (PDFAnnotationScreen)annotation;
            this.actionReferenceUpdation(screenAnnotation.getAction(), isDecrement, false);
            this.additionalActionReferenceUpdation(screenAnnotation.getAdditionalActions(), isDecrement);
        } else if (annotation instanceof PDFAnnotationWidget) {
            PDFAnnotationWidget widgetAnnotation = (PDFAnnotationWidget)annotation;
            this.actionReferenceUpdation(widgetAnnotation.getAction(), isDecrement, false);
            PDFAdditionalActions additionalActions = widgetAnnotation.getAdditionalActions();
            if (additionalActions != null) {
                this.additionalActionReferenceUpdation(additionalActions, isDecrement);
            }
        }
    }

    private void actionReferenceUpdation(PDFAction action, boolean isDecrement, boolean isLinkAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action != null) {
            if (!isLinkAnnotation) {
                this.destinationReferenceUpdation(this.getActionHasDestination(action), isDecrement);
            }
            this.embeddedFilesReferenceUpdation(action, isDecrement);
            this.javaScriptReferenceUpdation(action, isDecrement);
        }
    }

    private void additionalActionReferenceUpdation(PDFAdditionalActions additionalActions, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set actionSet;
        if (additionalActions != null && !additionalActions.isEmpty() && (actionSet = additionalActions.entrySet()) != null && !actionSet.isEmpty()) {
            Iterator actionIterator = actionSet.iterator();
            while (actionIterator.hasNext()) {
                PDFAction action = (PDFAction)((Map.Entry)actionIterator.next()).getValue();
                if (action == null) continue;
                this.destinationReferenceUpdation(this.getActionHasDestination(action), isDecrement);
                this.embeddedFilesReferenceUpdation(action, isDecrement);
                this.javaScriptReferenceUpdation(action, isDecrement);
            }
        }
    }

    private void namedDestinationReferenceUpdation(PDFAnnotationLink linkAnnotation, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDestination destination = null;
        if (linkAnnotation.hasAction()) {
            PDFAction action = linkAnnotation.getAction();
            if (action != null) {
                destination = this.getActionHasDestination(action);
            }
        } else if (linkAnnotation.hasDestination()) {
            destination = linkAnnotation.getDestination();
        }
        this.destinationReferenceUpdation(destination, isDecrement);
    }

    private void namesAnnotationAppearanceStateReferenceUpdation(PDFAppearance appearance, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (appearance != null) {
            this.apperanceStreamReferenceUpdation(appearance.getNormalAppearance(), isDecrement);
            this.apperanceStreamReferenceUpdation(appearance.getDownAppearance(), isDecrement);
            this.apperanceStreamReferenceUpdation(appearance.getRolloverAppearance(), isDecrement);
        }
    }

    private void apperanceStreamReferenceUpdation(PDFXObjectForm objectForm, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (objectForm != null && this.redactionState != null) {
            this.referenceUpdation(objectForm.getCosObject().getObjNum(), isDecrement, RedactionState.VariableType.AP);
        }
    }

    private void referenceUpdation(Integer key, boolean isDecrement, RedactionState.VariableType type) {
        if (key != 0) {
            RedactionState.ReferencedValue value = this.redactionState.getReferencedValue(key, type);
            if (value != null) {
                if (isDecrement) {
                    value.removeReference();
                } else {
                    value.addReference();
                }
            }
            this.redactionState.setReferenceValue(value, key, type);
        }
    }

    private void removePopupAnnotations(PDFAnnotationList annotationList, Set<String> popupAnnotations) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnsupportedFeatureException {
        if (annotationList != null && !annotationList.isEmpty()) {
            PDFAnnotationIterator annotationListIterator = annotationList.iterator();
            while (annotationListIterator.hasNext()) {
                PDFAnnotation annotation = annotationListIterator.next();
                if (!(annotation instanceof PDFAnnotationPopup) || annotation instanceof PDFAnnotationRedaction || !popupAnnotations.contains(annotation.getID().split("\\.")[0])) continue;
                annotation.removeAppearance();
                annotationListIterator.remove();
                this.redactionHandler.objectRedacted(new RedactedAnnotationInfo(annotation.getSubtype(), this.pageNumber, annotation.getCosObject().getObjNum()));
            }
        }
    }

    private void removeCalculationOrder(Area area) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm interactiveForm = this.getInteractiveForm();
        if (interactiveForm != null) {
            PDFFieldList fieldList = interactiveForm.getCalculationOrder();
            if (fieldList != null && !fieldList.isEmpty()) {
                ListIterator fieldIterator = fieldList.listIterator();
                while (fieldIterator.hasNext()) {
                    PDFFieldNode fieldNode = (PDFFieldNode)fieldIterator.next();
                    if (!(fieldNode instanceof PDFField)) continue;
                    PDFAnnotationIterator annotationIterator = ((PDFField)fieldNode).getAnnotationsIterator();
                    while (annotationIterator.hasNext()) {
                        PDFAnnotation annotation = annotationIterator.next();
                        if (annotation == null || annotation instanceof PDFAnnotationRedaction) continue;
                        PDFRectangle annotationRectangle = annotation.getRect();
                        this.namesTreeReferenceUpdation(annotation, false);
                        if (annotationRectangle == null || !RedactionUtils.intersects(this.pdfDoc, annotationRectangle, area)) continue;
                        this.namesTreeReferenceUpdation(annotation, true);
                        fieldIterator.remove();
                    }
                }
            }
            if (fieldList == null || fieldList.isEmpty()) {
                interactiveForm.setCalculationOrder(null);
            }
        }
    }

    private void acroFromCleanup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<String> acroFormButtonFieldSet;
        PDFFieldList fieldList;
        PDFInteractiveForm interactiveForm = this.getInteractiveForm();
        if (interactiveForm != null && (fieldList = interactiveForm.getChildren()) != null && !fieldList.isEmpty() && !(acroFormButtonFieldSet = this.redactionState.getAcroFormButtonField()).isEmpty()) {
            for (String name : acroFormButtonFieldSet) {
                PDFFieldList list;
                PDFFieldNode fieldNode;
                if (name == null || (fieldNode = fieldList.getFieldFullyNamed(name)) == null || (list = fieldNode.getChildren()) != null && !list.isEmpty()) continue;
                fieldList.remove(fieldNode);
                this.redactionHandler.objectRedacted(new RedactedFieldInfo(fieldNode.getFieldType().getValue(), fieldNode.getQualifiedName(), fieldNode.getCosObject().getObjNum()));
            }
        }
    }

    private void removeNamesAnnotationAppearances() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedIcon namedIcon;
        PDFNameDictionary nameDictionary = this.getNameDictionary();
        if (nameDictionary != null && (namedIcon = nameDictionary.getNamedIcons()) != null) {
            Iterator<PDFTree.Entry> namedIconEntrySet = namedIcon.iterator();
            while (namedIconEntrySet.hasNext()) {
                RedactionState.ReferencedValue referencedValue;
                String key;
                PDFXObject object;
                PDFTree.Entry entry = namedIconEntrySet.next();
                if (entry == null || (object = (PDFXObject)entry.getValue()) == null || (key = String.valueOf(object.getCosObject().getObjNum())) == null || (referencedValue = this.redactionState.getNamedAnnotationAppearanceMap().get(key)) == null || referencedValue.isReferenced()) continue;
                namedIconEntrySet.remove();
            }
        }
    }

    private void javaScriptReferenceUpdation(PDFAction action, boolean isDecrement) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException {
        String name = null;
        if (action instanceof PDFActionRendition) {
            name = ((PDFActionRendition)action).getJavaScriptString();
        } else if (action instanceof PDFActionJavaScript) {
            name = ((PDFActionJavaScript)action).getJavaScriptString();
        }
        if (name != null) {
            this.updateReference(new ASString(name), isDecrement, RedactionState.VariableType.JS);
        }
    }

    private void embeddedFilesReferenceUpdation(PDFAction action, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification fileSpecification;
        PDFEmbeddedTarget embeddedTarget;
        PDFActionGoToEmbedded actionGoToEmbedded;
        if (action instanceof PDFActionGoToEmbedded && (actionGoToEmbedded = (PDFActionGoToEmbedded)action).hasEmbeddedTarget() && (embeddedTarget = actionGoToEmbedded.getEmbeddedTarget()) != null) {
            this.updateReference(embeddedTarget.getName(), isDecrement, RedactionState.VariableType.EMBEDDEDFILES);
        }
        if ((fileSpecification = this.getFileSpecification(action)) != null) {
            this.updateReference(fileSpecification.getFilename(), isDecrement, RedactionState.VariableType.EMBEDDEDFILES);
        }
    }

    private void destinationReferenceUpdation(PDFDestination destination, boolean isDecrement) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (destination instanceof PDFDestinationNamed) {
            PDFDestinationNamed destinationNamed = (PDFDestinationNamed)destination;
            this.updateReference(destinationNamed.getName(), isDecrement, RedactionState.VariableType.DESTS);
        }
    }

    private void updateReference(ASString name, boolean isDecrement, RedactionState.VariableType type) {
        if (name != null) {
            String key = name.asString();
            RedactionState.ReferencedValue value = this.redactionState.getReferencedValue(key, type);
            if (value != null) {
                if (isDecrement) {
                    value.removeReference();
                } else {
                    value.addReference();
                }
            }
            this.redactionState.setReferenceValue(value, key, type);
        }
    }

    private PDFFileSpecification getFileSpecification(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFActionThread actionThread;
        PDFFileSpecification fileSpecification = null;
        if (action instanceof PDFActionGoToRemote) {
            PDFActionGoToRemote goToRemote = (PDFActionGoToRemote)action;
            if (goToRemote.hasFileSpecification()) {
                fileSpecification = goToRemote.getFileSpecification();
            }
        } else if (action instanceof PDFActionLaunch) {
            PDFActionLaunch actionLaunch = (PDFActionLaunch)action;
            if (actionLaunch.hasFileSpecification()) {
                fileSpecification = actionLaunch.getFileSpecification();
            }
        } else if (action instanceof PDFActionThread && (actionThread = (PDFActionThread)action).hasFileSpecification()) {
            fileSpecification = actionThread.getFileSpecification();
        }
        return fileSpecification;
    }

    private PDFDestination getActionHasDestination(PDFAction nextAction) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFDestination destination = null;
        if (nextAction instanceof PDFActionGoTo) {
            destination = ((PDFActionGoTo)nextAction).getDestination();
        } else if (nextAction instanceof PDFActionGoToRemote) {
            destination = ((PDFActionGoToRemote)nextAction).getDestination();
        } else if (nextAction instanceof PDFActionThread) {
            destination = ((PDFActionThread)nextAction).getDestination();
        }
        return destination;
    }

    private PDFInteractiveForm getInteractiveForm() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        if (catalog == null) {
            throw new PDFInvalidDocumentException("Document catalog can not be null.");
        }
        return catalog.getInteractiveForm();
    }

    void cleanAnnotationResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        PDFInteractiveForm interactiveForm = this.getInteractiveForm();
        if (interactiveForm != null) {
            this.parseDefaultAppearanceContentStream(interactiveForm.getDefaultAppearance());
        }
        this.removeNamesAnnotationAppearances();
        this.acroFromCleanup();
        this.removeAcroFromFields();
        this.removeNamesJavaScript();
        this.removeNamedEmbeddedFiles();
        this.removeNamedDestination();
        if (this.resourcesState != null) {
            this.resourcesState.cleanResources(null);
        }
    }

    private void removeNamesJavaScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set javaScriptSet;
        PDFNamedJavaScripts namedJavaScripts;
        PDFNameDictionary nameDictionary = this.getNameDictionary();
        if (nameDictionary != null && (namedJavaScripts = nameDictionary.getNamedJavaScripts()) != null && !namedJavaScripts.isEmpty() && (javaScriptSet = namedJavaScripts.values()) != null && !javaScriptSet.isEmpty()) {
            Iterator jsIterator = javaScriptSet.iterator();
            while (jsIterator.hasNext()) {
                String key;
                RedactionState.ReferencedValue referencedValue;
                PDFActionJavaScript actionJavaScript = (PDFActionJavaScript)jsIterator.next();
                if (actionJavaScript == null || (referencedValue = this.redactionState.getReferencedValue(key = actionJavaScript.getJavaScriptString(), RedactionState.VariableType.JS)) == null || referencedValue.isReferenced()) continue;
                jsIterator.remove();
            }
        }
    }

    private void removeNamedEmbeddedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set fileSpecificationSet;
        PDFNamedEmbeddedFiles namedEmbeddedFiles;
        PDFNameDictionary nameDictionary = this.getNameDictionary();
        if (nameDictionary != null && (namedEmbeddedFiles = nameDictionary.getNamedEmbeddedFiles()) != null && !namedEmbeddedFiles.isEmpty() && (fileSpecificationSet = namedEmbeddedFiles.values()) != null && !fileSpecificationSet.isEmpty()) {
            Iterator fsIterator = fileSpecificationSet.iterator();
            while (fsIterator.hasNext()) {
                RedactionState.ReferencedValue referencedValue;
                ASString name;
                PDFFileSpecification fileSpecification = (PDFFileSpecification)fsIterator.next();
                if (fileSpecification == null || (name = fileSpecification.getFilename()) == null || (referencedValue = this.redactionState.getReferencedValue(name.asString(), RedactionState.VariableType.EMBEDDEDFILES)) == null || referencedValue.isReferenced()) continue;
                fsIterator.remove();
            }
        }
    }

    private void removeNamedDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set destionationSet;
        PDFNamedDestinations namedDestinations;
        PDFNameDictionary nameDictionary = this.getNameDictionary();
        if (nameDictionary != null && (namedDestinations = nameDictionary.getNamedDestinations()) != null && !namedDestinations.isEmpty() && (destionationSet = namedDestinations.values()) != null && !destionationSet.isEmpty()) {
            Iterator destinationIterator = destionationSet.iterator();
            while (destinationIterator.hasNext()) {
                RedactionState.ReferencedValue referencedValue;
                ASString name;
                PDFDestination destination = (PDFDestination)destinationIterator.next();
                if (destination == null || (name = destination.getName()) == null || (referencedValue = this.redactionState.getReferencedValue(name.asString(), RedactionState.VariableType.DESTS)) == null || referencedValue.isReferenced()) continue;
                destinationIterator.remove();
            }
        }
    }

    private PDFNameDictionary getNameDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfDoc.requireCatalog().getNameDictionary();
    }
}

