/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.geom.Area;
import java.util.Iterator;

class RasterXobject
extends XObject<RasterGraphicsState, RasterTextState, RasterContentItem> {
    public RasterXobject(RasterGraphicsState gState, int id) {
        super(gState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        super.writeToDisplayArea(context);
        ContentItemsList ciList = this.getContentItems();
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        GraphicsState.BlendingMode mode = ((RasterGraphicsState)this.getGState()).getBlendingMode();
        if (mode != GraphicsState.BlendingMode.NORMAL) {
            rasterDocumentContext.setBlendingMode(mode);
            rasterDocumentContext.setNonStrokeAlpha(((RasterGraphicsState)this.getGState()).getNonStrokeAlpha());
        }
        if (((RasterGraphicsState)this.getGState()).getNonStrokeAlpha() != 0.0 && (this.getIsIsolatedGroup() || this.getIsKnockoutGroup())) {
            rasterDocumentContext.setNonStrokeAlpha(((RasterGraphicsState)this.getGState()).getNonStrokeAlpha());
        }
        Area backdropArea = ((RasterGraphicsState)this.getGState()).getBackDropArea();
        if (ciList != null) {
            Iterator itr = ciList.iterator();
            while (itr.hasNext()) {
                AbstractContentItem ci = (AbstractContentItem)itr.next();
                if (backdropArea != null) {
                    ((RasterGraphicsState)ci.getGState()).setBackDropArea(backdropArea);
                }
                if (((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask() != null) {
                    ((RasterGraphicsState)ci.getGState()).setGraphicsStateSoftMask(((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask());
                    ((RasterGraphicsState)ci.getGState()).setCachedSoftMask(((RasterGraphicsState)this.getGState()).getCachedSoftMask());
                }
                ContentItem oldSMask = ((RasterGraphicsState)this.getGState()).getGraphicsStateSoftMask();
                ((RasterGraphicsState)this.getGState()).setCachedSoftMask(null);
                ((RasterGraphicsState)this.getGState()).setGraphicsStateSoftMask(null);
                ci.writeToDisplayArea(rasterDocumentContext);
                ((RasterGraphicsState)this.getGState()).setCachedSoftMask(oldSMask);
                ((RasterGraphicsState)this.getGState()).setGraphicsStateSoftMask(oldSMask);
            }
        }
        rasterDocumentContext.setBlendingMode(GraphicsState.BlendingMode.NORMAL);
        rasterDocumentContext.setNonStrokeAlpha(1.0);
    }

    @Override
    public double getDisplayRotation() {
        return 0.0;
    }

    @Override
    public void setDisplayRotation(double rotation) {
    }
}

