/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentPathItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;

class RasterContentTextItem
extends ContentTextItem<RasterTextState, RasterGraphicsState>
implements RasterContentItem {
    public RasterContentTextItem(RasterGraphicsState graphicsState, RasterTextState textState, int id) {
        super(graphicsState, textState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        try {
            RasterizationOptions options = rasterDocumentContext.getOptions();
            if (options != null && options.getCallBackManager() != null && !options.getCallBackManager().processText(rasterDocumentContext.getGraphics2d(), this)) {
                return;
            }
            if (this.isFontType3()) {
                this.writeRasterTextWithFontType3(context);
            } else {
                super.writeToDisplayArea(context);
                Graphics2D graphics2d = rasterDocumentContext.getGraphics2d();
                this.createImageText(rasterDocumentContext, graphics2d);
            }
        }
        catch (Exception e) {
            rasterDocumentContext.handleException(e, "Exception while rasterizing text.");
        }
    }

    private void writeRasterTextWithFontType3(DocumentContext context) {
        List<Glyph> text = this.getText();
        Iterator<Glyph> listItr = text.iterator();
        ContentItemsList contentItemsList = null;
        Iterator contentsListItr = null;
        Type3Glyph glyph = null;
        while (listItr.hasNext()) {
            glyph = (Type3Glyph)listItr.next();
            try {
                contentItemsList = glyph.getOutline();
                contentsListItr = contentItemsList.iterator();
                while (contentsListItr.hasNext()) {
                    ((AbstractContentItem)contentsListItr.next()).writeToDisplayArea(context);
                }
            }
            catch (Exception e) {
                ((RasterDocumentContext)context).handleException(e, "Exception while rasterizing Font type 3 glyph.");
            }
        }
    }

    private void createImageText(RasterDocumentContext rasterDocumentContext, Graphics2D graphics2d) {
        try {
            String fontName = ((RasterTextState)this.getTState()).getFontName();
            if (fontName != null) {
                Font afeFont = ((RasterTextState)this.getTState()).getFontMap().get(fontName);
                this.drawText(rasterDocumentContext, afeFont, rasterDocumentContext.getImage(), rasterDocumentContext.getPageHeight());
            }
        }
        catch (InvalidGlyphException e) {
        }
        catch (FontException e) {
            throw new RuntimeException("Error while converting to the image from glyphs " + e);
        }
    }

    private void drawText(RasterDocumentContext rasterDocumentContext, Font font, BufferedImage image, int height) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        if (font != null) {
            double textScalingFactor = 1.0;
            boolean isTextSpacing = false;
            List<Glyph> text = this.getText();
            if (text != null && !text.isEmpty()) {
                Iterator<Glyph> iterator = text.iterator();
                ASMatrix textMatrix = new ASMatrix(((RasterTextState)this.getTState()).getMatrix());
                double fontSize = ((RasterTextState)this.getTState()).getFontSize();
                double textRise = ((RasterTextState)this.getTState()).getTextRise();
                double absXScalingFactor = Math.abs(textMatrix.geta());
                double absYScalingFactor = Math.abs(textMatrix.getd());
                if (absXScalingFactor <= 0.01 && absYScalingFactor <= 0.01 && (textScalingFactor = this.calculateTextSpacingFactor(font)) > 1.0E-5 && font.getUnitsPerEmY() > 2000.0) {
                    textScalingFactor = 0.001;
                    isTextSpacing = true;
                }
                ASMatrix textSpacingMatrix = null;
                if (isTextSpacing) {
                    ASMatrix mat1 = new ASMatrix(1.0 / textScalingFactor, 0.0, 0.0, 1.0 / textScalingFactor, 0.0, 0.0);
                    textSpacingMatrix = new ASMatrix(absXScalingFactor *= fontSize, textMatrix.getb(), textMatrix.getc(), absYScalingFactor *= fontSize, 0.0, 0.0);
                    textSpacingMatrix = textSpacingMatrix.concat(mat1);
                    textSpacingMatrix = new ASMatrix(textSpacingMatrix.geta() * textScalingFactor / textMatrix.geta(), textScalingFactor * 1.0 * textMatrix.getb() / Math.abs(textMatrix.geta()), textScalingFactor * textMatrix.getc() / Math.abs(textMatrix.geta()), textSpacingMatrix.getd() * textScalingFactor / textMatrix.getd(), 0.0, 0.0);
                }
                while (iterator.hasNext()) {
                    Glyph glyph = iterator.next();
                    try {
                        GeneralPath glyphOutline;
                        int gid = glyph.getGID();
                        if (gid <= 0 || ((RasterTextState)this.getTState()).getTextRenderingMode() == 3) continue;
                        double[] fillCS = ((RasterGraphicsState)this.getGState()).getFillColorValues();
                        if (fillCS != null) {
                            rasterDocumentContext.getGraphics2d().setColor(new Color(GraphicsUtils.toARGB(fillCS, ((RasterGraphicsState)this.getGState()).getNonStrokeAlpha()), true));
                        }
                        if ((glyphOutline = glyph.getGlyphOutline()) == null) {
                            glyphOutline = rasterDocumentContext.getCachedGlyphOutline(gid, ((RasterTextState)this.getTState()).getFontName());
                            if (glyphOutline == null) {
                                glyphOutline = GraphicsUtils.getGlyphsOulines(gid, font);
                                rasterDocumentContext.cacheGlyphOutline(glyphOutline, gid, ((RasterTextState)this.getTState()).getFontName());
                            }
                            AffineTransform text2user = null;
                            ASMatrix transformationMatrix = null;
                            if (isTextSpacing) {
                                transformationMatrix = new ASMatrix(textSpacingMatrix.geta(), textSpacingMatrix.getb(), textSpacingMatrix.getc(), textSpacingMatrix.getd(), glyph.getXPos(), glyph.getYPos() + textRise);
                                text2user = new AffineTransform(transformationMatrix.getValues());
                                if (textMatrix.getc() < 0.0) {
                                    text2user.rotate(1.5707963267948966);
                                }
                            } else {
                                transformationMatrix = new ASMatrix(textMatrix.geta() * fontSize, textMatrix.getb() * fontSize, textMatrix.getc() * fontSize, textMatrix.getd() * fontSize, glyph.getXPos(), glyph.getYPos() + textRise);
                                text2user = new AffineTransform(transformationMatrix.getValues());
                            }
                            if (((RasterTextState)this.getTState()).getIsTextScalingAdjusted() && textMatrix.getc() == -1.0) {
                                text2user = this.applyTextScalingAdjustment(textMatrix, transformationMatrix, fontSize);
                            }
                            glyphOutline = (GeneralPath)glyphOutline.clone();
                            glyphOutline.transform(text2user);
                        }
                        this.renderTextAsCurves(glyphOutline, rasterDocumentContext, glyph.getID());
                    }
                    catch (Exception e) {
                        rasterDocumentContext.handleException(e, "Exception while rasterizing text glyph.");
                    }
                }
            }
        }
    }

    private void renderTextAsCurves(GeneralPath outline, RasterDocumentContext rasterDocumentContext, int id) {
        RasterContentPathItem pathItem = new RasterContentPathItem((RasterGraphicsState)this.getGState(), id, ContentType.Text);
        switch (((RasterTextState)this.getTState()).getTextRenderingMode()) {
            case 0: {
                pathItem.setPath(outline, PathPainting.FILL);
                break;
            }
            case 1: {
                pathItem.setPath(outline, PathPainting.STROKE);
                break;
            }
            case 2: {
                pathItem.setPath(outline, PathPainting.FILLANDSTROKE);
                break;
            }
            case 3: {
                return;
            }
            case 4: {
                pathItem.setPath(outline, PathPainting.FILL);
                break;
            }
            case 5: {
                pathItem.setPath(outline, PathPainting.STROKE);
                break;
            }
            case 6: {
                pathItem.setPath(outline, PathPainting.FILLANDSTROKE);
                break;
            }
            case 7: {
                return;
            }
        }
        pathItem.textWithNoPattern = true;
        pathItem.writeToDisplayArea(rasterDocumentContext);
    }

    private double calculateTextSpacingFactor(Font font) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        ASMatrix textMatrix = new ASMatrix(((RasterTextState)this.getTState()).getMatrix());
        return Math.abs(((RasterTextState)this.getTState()).getFontSize() * textMatrix.geta() * 1024.0 * 20.0 / (65535.0 * font.getUnitsPerEmY()));
    }

    private AffineTransform applyTextScalingAdjustment(ASMatrix textMatrix, ASMatrix transformationMatrix, double fontSize) {
        double a = textMatrix.geta() == 0.01 ? 1.0 : textMatrix.geta();
        double d = textMatrix.getd() == 0.01 ? 1.0 : textMatrix.getd();
        textMatrix = new ASMatrix(a, textMatrix.getb(), textMatrix.getc(), d, textMatrix.getx(), textMatrix.gety());
        transformationMatrix = new ASMatrix(a * fontSize, textMatrix.getb(), textMatrix.getc(), d * fontSize, transformationMatrix.getx(), transformationMatrix.gety());
        AffineTransform text2user = new AffineTransform(transformationMatrix.getValues());
        text2user.rotate(1.5707963267948966);
        return text2user;
    }
}

