/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.io.stream.BitInputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.ShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.image.ImageResamplingMethod;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterAxialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingComposite;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterCoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterFunctionBasedShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterPerformanceObserver;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterRadialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterXobject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class RasterContentImageItem
extends ContentImageItem<RasterGraphicsState>
implements RasterContentItem {
    private static final int imageAreaThreshold = 10;
    private boolean isSoftMaskImage = false;
    private int[] imageMaskStream = null;

    public boolean isSoftMaskImage() {
        return this.isSoftMaskImage;
    }

    public void setIsSoftMaskImage(boolean isSoftMaskImage) {
        this.isSoftMaskImage = isSoftMaskImage;
    }

    public RasterContentImageItem(RasterGraphicsState graphicsState, int id) {
        super(graphicsState, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToDisplayArea(DocumentContext context) {
        rasterDocumentContext = (RasterDocumentContext)context;
        perfObs = null;
        bufferedImage = null;
        g2 = null;
        img2user = null;
        img = null;
        smask = null;
        decodeArray = null;
        blendingComposite = null;
        try {
            try {
                img = this.getImage();
                smask = this.getSoftMask();
                options = rasterDocumentContext.getOptions();
                if (options == null || options.getCallBackManager() == null || this.isSoftMaskImage() || options.getCallBackManager().processImage(rasterDocumentContext.getGraphics2d(), this)) ** GOTO lbl-1000
                ** GOTO lbl19
            }
            catch (Throwable var44_58) {
                block73: {
                    throw var44_58;
lbl19:
                    // 1 sources

                    try {
                        if (smask != null) {
                            smask.close();
                        }
                    }
                    finally {
                        if (img != null) {
                            img.close();
                        }
                    }
                    if (blendingComposite != null) {
                        g2.setComposite(AlphaComposite.Src);
                    }
                    if (perfObs == null) return;
                    perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
                    return;
lbl-1000:
                    // 1 sources

                    {
                        perfObs = new RasterPerformanceObserver();
                        perfObs.start();
                        g2 = rasterDocumentContext.getGraphics2d();
                        pageHeight = rasterDocumentContext.getPageHeight();
                        blendingMode = ((RasterGraphicsState)this.getGState()).getBlendingMode();
                        if (blendingMode.equals((Object)GraphicsState.BlendingMode.OVERPRINTDst)) {
                            blendingComposite = new RasterBlendingComposite(GraphicsState.BlendingMode.OVERPRINTDst, 1.0f);
                        } else if (blendingMode.equals((Object)GraphicsState.BlendingMode.OVERPRINTSrc)) {
                            blendingComposite = new RasterBlendingComposite(GraphicsState.BlendingMode.OVERPRINTSrc, 1.0f);
                        }
                        if (blendingComposite != null) {
                            g2.setComposite(blendingComposite);
                        }
                        scalingFactorW = 1.0;
                        scalingFactorH = 1.0;
                        if (rasterDocumentContext.getIsScaled()) {
                            scalingFactorW = rasterDocumentContext.getWidthScalingFactor();
                            scalingFactorH = rasterDocumentContext.getHeightScalingFactor();
                        }
                        super.writeToDisplayArea(context);
                        width = img.getWidth();
                        height = img.getHeight();
                        transformation = this.getTransformationMatrix();
                        img2user = GraphicsUtils.pdfToRasterTransform(transformation, scalingFactorW, scalingFactorH, width, height, pageHeight, rasterDocumentContext instanceof RasterTilingContext, g2);
                        if (!this.getIsImageMask()) ** GOTO lbl-1000
                        shadingObject = ((RasterGraphicsState)this.getGState()).getLoadedShadingPatterns().get(((RasterGraphicsState)this.getGState()).getFillShadingPatternName());
                        if (shadingObject == null) break block73;
                        x = (int)transformation[4];
                        y = (int)transformation[5];
                        if (shadingObject instanceof RasterCoonsPatchMeshesShading) {
                            ((RasterCoonsPatchMeshesShading)shadingObject).setCTM(new ASMatrix(transformation));
                        }
                        fill = ((RasterGraphicsState)this.getGState()).getFillShadingPatternName() != null;
                        switch (1.$SwitchMap$com$adobe$internal$pdftoolkit$graphicsDOM$ShadingPattern$ShadingType[shadingObject.getShadingType().ordinal()]) {
                            case 1: {
                                axialShading = (RasterAxialShading)shadingObject;
                                colors = axialShading.getColorValues();
                                if (colors == null || colors.length <= 1) break;
                                gradientPaint = new GradientPaint(x, y, colors[0], x, y + height, colors[colors.length - 1], true);
                                g2.setPaint(gradientPaint);
                                this.applyImageMask(rasterDocumentContext, img2user);
                                break;
                            }
                            case 2: {
                                radialShading = (RasterRadialShading)shadingObject;
                                matrix = radialShading.getMatrix();
                                at = null;
                                at = matrix != null ? new AffineTransform(matrix[0], matrix[2], matrix[1], matrix[3], matrix[4], (double)rasterDocumentContext.getPageHeight() - matrix[5]) : new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                                radialShading.postProcessing(height, width, g2, null, at, (int)pageHeight, fill);
                                break;
                            }
                            case 3: {
                                functionBasedShading = (RasterFunctionBasedShading)shadingObject;
                                g2 = functionBasedShading.postProcessing(height, width, g2, fill);
                                break;
                            }
                            case 4: {
                                break;
                            }
                        }
                    }
                    try {
                        if (smask != null) {
                            smask.close();
                        }
                    }
                    finally {
                        if (img != null) {
                            img.close();
                        }
                    }
                    if (blendingComposite != null) {
                        g2.setComposite(AlphaComposite.Src);
                    }
                    if (perfObs == null) return;
                    perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
                    return;
                }
                ** try [egrp 7[TRYBLOCK] [12 : 772->843)] { 
lbl101:
                // 1 sources

                tilingObject = ((RasterGraphicsState)this.getGState()).getLoadedTilingPatterns().get(((RasterGraphicsState)this.getGState()).getFillTilingPatternName());
                if (tilingObject != null && RasterPerformanceObserver.isExceptionMode) {
                    throw new UnsupportedOperationException("Tiling Pattern Unsupported in Image mask.");
                }
                if (((RasterGraphicsState)this.getGState()).getFillTilingPatternName() == null) {
                    this.applyImageMask(rasterDocumentContext, img2user);
                }
                if (blendingComposite != null) {
                    g2.setComposite(AlphaComposite.Src);
                }
                if (perfObs == null) return;
                perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
                return;
lbl-1000:
                // 1 sources

                {
                    itr = img.getBufferedImagesIterator();
                    softMaskItr = smask != null ? smask.getBufferedImagesIterator() : null;
                    isSmallImageWithSMask = false;
                    smaskHeight = 0;
                    smaskWidth = 0;
                    if (smask != null && (smask.getHeight() != img.getHeight() || smask.getWidth() != img.getWidth())) {
                        if (img.getHeight() * img.getWidth() < 10) {
                            isSmallImageWithSMask = true;
                            smaskHeight = (int)((double)img.getHeight() * img2user.getScaleY());
                            smaskWidth = (int)((double)img.getWidth() * img2user.getScaleX());
                        }
                        if (isSmallImageWithSMask) {
                            if (smaskHeight > 0 && smaskWidth > 0) {
                                smask.resample(smaskHeight, smaskWidth, ImageResamplingMethod.kResampleNearestNeighbor);
                            }
                        } else {
                            smask.resample(img.getHeight(), img.getWidth(), ImageResamplingMethod.kResampleNearestNeighbor);
                        }
                    }
                    currentSoftMaskTile = softMaskItr != null && softMaskItr.hasNext() != false ? softMaskItr.next() : null;
                    prevSMaskRow = new IntegerHolder();
                    while (itr.hasNext()) {
                        bufferedImage = itr.next();
                        newImg2User = null;
                        image = null;
                        if (smask != null && isSmallImageWithSMask && smaskWidth > 0 && smaskHeight > 0) {
                            image = new BufferedImage(smaskWidth, smaskHeight, 2);
                            at = new AffineTransform();
                            at.scale(img2user.getScaleX(), img2user.getScaleY());
                            scaleOp = new AffineTransformOp(at, 2);
                            image = scaleOp.filter(bufferedImage, image);
                            newImg2User = new AffineTransform(1.0, img2user.getShearX(), img2user.getShearY(), 1.0, img2user.getTranslateX(), img2user.getTranslateY());
                        }
                        if (isSmallImageWithSMask && image != null) {
                            if (smask != null) {
                                currentSoftMaskTile = this.applySmask(image, currentSoftMaskTile, softMaskItr, prevSMaskRow);
                            }
                            g2.drawRenderedImage(image, newImg2User);
                            this.notifyCallBackManager(newImg2User, image, rasterDocumentContext);
                            img2user.translate(0.0, image.getHeight());
                            continue;
                        }
                        maskApplied = false;
                        if (smask != null) {
                            currentSoftMaskTile = this.applySmask(bufferedImage, currentSoftMaskTile, softMaskItr, prevSMaskRow);
                        } else {
                            curGState = (RasterGraphicsState)this.getGState();
                            if (curGState.getGraphicsStateSoftMask() != null) {
                                xObjectForm = new BufferedImage(rasterDocumentContext.getImage().getWidth(), rasterDocumentContext.getImage().getHeight(), 2);
                                sMask = (RasterXobject)curGState.getGraphicsStateSoftMask();
                                oldImage = rasterDocumentContext.getImage();
                                oldGraphics2d = rasterDocumentContext.getGraphics2d();
                                curGState.setGraphicsStateSoftMask(null);
                                curGState.setCachedSoftMask(null);
                                try {
                                    graphics2d = xObjectForm.createGraphics();
                                    rasterDocumentContext.setGraphics2d(graphics2d);
                                    rasterDocumentContext.setIsGSSoftMask(true);
                                    sMaskCIList = sMask.getContentItems();
                                    ciListIter = sMaskCIList.iterator();
                                    while (ciListIter.hasNext()) {
                                        rasterContentItem = (RasterContentItem)ciListIter.next();
                                        if (!(rasterContentItem instanceof RasterContentImageItem)) continue;
                                        imageItem = (RasterContentImageItem)rasterContentItem;
                                        imageItem.setIsSoftMaskImage(true);
                                    }
                                    sMask.writeToDisplayArea(rasterDocumentContext);
                                }
                                finally {
                                    rasterDocumentContext.setIsGSSoftMask(false);
                                    rasterDocumentContext.setGraphics2d(oldGraphics2d);
                                    rasterDocumentContext.setImage(oldImage);
                                }
                                this.applySoftMask(bufferedImage, xObjectForm, img2user, rasterDocumentContext);
                                curGState.setCachedSoftMask(sMask);
                                curGState.setGraphicsStateSoftMask(sMask);
                                maskApplied = true;
                            }
                        }
                        if (!maskApplied) {
                            g2.drawRenderedImage(bufferedImage, img2user);
                        }
                        this.notifyCallBackManager(img2user, bufferedImage, rasterDocumentContext);
                        img2user.translate(0.0, bufferedImage.getHeight());
                    }
                }
                if (smask != null) {
                    smask.close();
                }
            }
            finally {
                if (img != null) {
                    img.close();
                }
            }
            if (blendingComposite != null) {
                g2.setComposite(AlphaComposite.Src);
            }
            if (perfObs == null) return;
        }
        catch (Exception e) {
            try {
                rasterDocumentContext.handleException(e, "Exception while rasterizing image.");
                if (blendingComposite != null) {
                    g2.setComposite(AlphaComposite.Src);
                }
                if (perfObs == null) return;
            }
            catch (Throwable var46_60) {
                if (blendingComposite != null) {
                    g2.setComposite(AlphaComposite.Src);
                }
                if (perfObs == null) throw var46_60;
                perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
                throw var46_60;
            }
lbl214:
            // 1 sources

            finally {
                try {
                    if (smask != null) {
                        smask.close();
                    }
                }
                finally {
                    if (img != null) {
                        img.close();
                    }
                }
            }
            perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
            return;
        }
        perfObs.stop(this.getImage(), this.getSoftMask() != null, this.getIsImageMask());
        return;
    }

    private void applySoftMask(BufferedImage image, BufferedImage smask, AffineTransform img2user, RasterDocumentContext context) {
        int width = context.getWidth();
        int height = context.getPageHeight();
        Image scaledSMask = smask.getScaledInstance(width, height, 4);
        BufferedImage scaledSMaskImage = new BufferedImage(scaledSMask.getWidth(null), scaledSMask.getHeight(null), 2);
        Graphics2D bGr = scaledSMaskImage.createGraphics();
        bGr.drawImage(scaledSMask, 0, 0, null);
        bGr.dispose();
        BufferedImage scaledImg = new BufferedImage(width, height, 2);
        Graphics2D g2 = scaledImg.createGraphics();
        g2.drawRenderedImage(image, img2user);
        this.notifyCallBackManager(img2user, image, context);
        img2user.translate(0.0, image.getHeight());
        int[] pixels = ((DataBufferInt)scaledImg.getRaster().getDataBuffer()).getData();
        int[] smaskPixels = ((DataBufferInt)scaledSMaskImage.getRaster().getDataBuffer()).getData();
        for (int index = 0; index < height * width; ++index) {
            int red = this.adjustRange(pixels[index] >> 16 & 0xFF);
            int green = this.adjustRange(pixels[index] >> 8 & 0xFF);
            int blue = this.adjustRange(pixels[index] & 0xFF);
            int smaskRed = this.adjustRange(smaskPixels[index] >> 16 & 0xFF);
            int smaskGreen = this.adjustRange(smaskPixels[index] >> 8 & 0xFF);
            int smaskBlue = this.adjustRange(smaskPixels[index] & 0xFF);
            pixels[index] = smaskPixels[index] << 24 | red << 16 | green << 8 | blue;
        }
        context.getGraphics2d().drawImage(scaledImg, null, 0, 0);
    }

    private void notifyCallBackManager(AffineTransform transform, BufferedImage bufferedImage, RasterDocumentContext rasterDocumentContext) {
        if (rasterDocumentContext instanceof RasterTilingContext) {
            return;
        }
        RasterCallBackInterface manager = rasterDocumentContext.getOptions().getCallBackManager();
        if (manager != null) {
            manager.drawnImage(transform, bufferedImage, this);
        }
    }

    private BufferedImage applySmask(BufferedImage image, BufferedImage smask, Iterator<BufferedImage> smaskItr, IntegerHolder prevSMaskRow) {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] smaskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
        int y = 0;
        int sh = prevSMaskRow.val;
        while (y < height) {
            if (smask != null && sh >= smask.getHeight()) {
                sh = 0;
                BufferedImage bufferedImage = smask = smaskItr.hasNext() ? smaskItr.next() : null;
                if (smask != null) {
                    smaskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
                }
            }
            for (int x = 0; x < width; ++x) {
                int index = x + y * width;
                int red = this.adjustRange(pixels[index] >> 16 & 0xFF);
                int green = this.adjustRange(pixels[index] >> 8 & 0xFF);
                int blue = this.adjustRange(pixels[index] & 0xFF);
                if (x + sh * width >= smaskPixels.length) continue;
                pixels[index] = smaskPixels[x + sh * width] << 24 | red << 16 | green << 8 | blue;
            }
            prevSMaskRow.val = sh + 1;
            ++y;
            ++sh;
        }
        return smask;
    }

    private int adjustRange(int color) {
        if (color < 0) {
            color += 255;
        }
        return color;
    }

    private void applyImageMask(RasterDocumentContext docContext, AffineTransform img2usr) throws IOException, NoninvertibleTransformException {
        String fillShadingPatternName = ((RasterGraphicsState)this.getGState()).getFillShadingPatternName();
        if (fillShadingPatternName != null) {
            this.applyImageMaskOnShadingPattern(docContext, img2usr);
            return;
        }
        ARGBImage image = this.getImage();
        ImageMaskDataHandler maskDataHandler = new ImageMaskDataHandler(image);
        int width = image.getWidth();
        int height = image.getHeight();
        double[] decode = image.getDecode();
        boolean defaultMask = true;
        int tilesHeight = 12000000 / width;
        tilesHeight = Math.min(height, tilesHeight);
        BufferedImage bufferedImage = new BufferedImage(width, tilesHeight, 2);
        int[] pixels = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        if (decode != null && decode[0] == 1.0 && decode[1] == 0.0) {
            defaultMask = false;
        }
        int fillRGBValue = GraphicsUtils.toARGB(((RasterGraphicsState)this.getGState()).getFillColorValues(), ((RasterGraphicsState)this.getGState()).getNonStrokeAlpha());
        Graphics2D g2 = docContext.getGraphics2d();
        try {
            int bitsReadInRow = 0;
            int th = 0;
            int y = 0;
            while (y < height) {
                for (th = 0; th < tilesHeight && y < height; ++th, ++y) {
                    bitsReadInRow = 0;
                    for (int x = 0; x < width; ++x) {
                        ++bitsReadInRow;
                        int index = x + th * width;
                        if (defaultMask) {
                            if (maskDataHandler.read(1, x + y * width)) {
                                pixels[index] = fillRGBValue;
                                continue;
                            }
                            pixels[index] = 0;
                            continue;
                        }
                        if (maskDataHandler.read(1, x + y * width)) continue;
                        pixels[index] = fillRGBValue;
                    }
                    if (bitsReadInRow % 8 == 0) continue;
                    maskDataHandler.skip(8 - bitsReadInRow % 8);
                }
                if (th < tilesHeight) {
                    bufferedImage = bufferedImage.getSubimage(0, 0, width, th);
                }
                g2.drawRenderedImage(bufferedImage, img2usr);
                this.notifyCallBackManager(img2usr, bufferedImage, docContext);
                img2usr.translate(0.0, tilesHeight);
            }
        }
        catch (IOException e) {
            throw new PDFRuntimeException("Exception occured while applying image mask.", e);
        }
        finally {
            try {
                if (maskDataHandler != null) {
                    maskDataHandler.done();
                }
            }
            catch (IOException e) {
                throw new PDFRuntimeException("Exception while closing ImageMaskDataHandler", e);
            }
        }
    }

    private void applyImageMaskOnShadingPattern(RasterDocumentContext docContext, AffineTransform img2usr) throws NoninvertibleTransformException, IOException {
        ARGBImage image = this.getImage();
        String fillShadingPatternName = ((RasterGraphicsState)this.getGState()).getFillShadingPatternName();
        int width = image.getWidth();
        int height = image.getHeight();
        double[] decode = image.getDecode();
        boolean defaultMask = true;
        int tilesHeight = 12000000 / width;
        tilesHeight = Math.min(height, tilesHeight);
        if (decode != null && decode[0] == 1.0 && decode[1] == 0.0) {
            defaultMask = false;
        }
        AffineTransform img2usrInverse = img2usr.createInverse();
        BufferedImage blankCanvas = new BufferedImage(docContext.getWidth(), docContext.getPageHeight(), 2);
        ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> fillShadingPattern = ((RasterGraphicsState)this.getGState()).getLoadedShadingPatterns().get(fillShadingPatternName);
        if (fillShadingPattern == null) {
            return;
        }
        double[] matrix = fillShadingPattern.getMatrix();
        AffineTransform matrixAffineTransform = new AffineTransform(matrix);
        matrixAffineTransform.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, docContext.getPageHeight()));
        AffineTransform matrixInverse = matrixAffineTransform.createInverse();
        this.readImageMaskStream(docContext);
        this.updateBlankCanvasPixelColors(blankCanvas, img2usrInverse, width, height, matrixInverse, fillShadingPattern, defaultMask);
        Graphics2D g2 = docContext.getGraphics2d();
        g2.drawRenderedImage(blankCanvas, new AffineTransform());
    }

    private void updateBlankCanvasPixelColors(BufferedImage blankCanvas, AffineTransform img2usrInverse, int width, int height, AffineTransform matrixInverse, ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> fillShadingPattern, boolean defaultMask) {
        int[] blankCanvasPixels = ((DataBufferInt)blankCanvas.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < blankCanvas.getHeight(); ++y) {
            for (int x = 0; x < blankCanvas.getWidth(); ++x) {
                int blankCanvasPixelIndex = x + y * blankCanvas.getWidth();
                double[] imgSpacePixelCoords = new double[2];
                img2usrInverse.transform(new double[]{x, y}, 0, imgSpacePixelCoords, 0, 1);
                if (!(imgSpacePixelCoords[0] >= 0.0) || !(imgSpacePixelCoords[0] < (double)width) || !(imgSpacePixelCoords[1] >= 0.0) || !(imgSpacePixelCoords[1] < (double)height)) continue;
                int imageSpaceX = (int)imgSpacePixelCoords[0];
                int imageSpaceY = (int)imgSpacePixelCoords[1];
                int imageSpacePixelIndex = imageSpaceX + imageSpaceY * width;
                double[] patternSpacePixelCoords = new double[2];
                matrixInverse.transform(new double[]{x, y}, 0, patternSpacePixelCoords, 0, 1);
                double patternSpaceX = patternSpacePixelCoords[0];
                double patternSpaceY = patternSpacePixelCoords[1];
                Color[] colorValues = fillShadingPattern.getColorValues();
                int colorValIndex = this.getColorValueIndex(fillShadingPattern, patternSpaceX, patternSpaceY, colorValues);
                if (colorValIndex == -1) continue;
                int fillColorRGBValue = this.getRGBColorValueFromIndex(colorValues, colorValIndex);
                if (defaultMask) {
                    if (this.imageMaskStream[imageSpacePixelIndex] != 0) continue;
                    blankCanvasPixels[blankCanvasPixelIndex] = fillColorRGBValue;
                    continue;
                }
                if (this.imageMaskStream[imageSpacePixelIndex] != 1) continue;
                blankCanvasPixels[blankCanvasPixelIndex] = fillColorRGBValue;
            }
        }
    }

    private int getRGBColorValueFromIndex(Color[] colorValues, int colorValIndex) {
        double red = 1.0 * (double)colorValues[colorValIndex].getRed() / 255.0;
        double green = 1.0 * (double)colorValues[colorValIndex].getGreen() / 255.0;
        double blue = 1.0 * (double)colorValues[colorValIndex].getBlue() / 255.0;
        return GraphicsUtils.toARGB(new double[]{red, green, blue}, ((RasterGraphicsState)this.getGState()).getNonStrokeAlpha());
    }

    private void readImageMaskStream(RasterDocumentContext docContext) throws IOException {
        ARGBImage image = this.getImage();
        int width = image.getWidth();
        int height = image.getHeight();
        int numSamples = width * height;
        if (docContext.getLoadedImageMaskStreams() == null) {
            HashMap<ARGBImage, int[]> imageMaskStreamMap = new HashMap<ARGBImage, int[]>();
            docContext.setLoadedImageMaskStreams(imageMaskStreamMap);
        }
        if (!docContext.getLoadedImageMaskStreams().containsKey(image)) {
            this.imageMaskStream = new int[numSamples];
            ImageMaskDataHandler maskDataHandler = new ImageMaskDataHandler(image);
            int bitsReadInRow = 0;
            for (int y = 0; y < height; ++y) {
                bitsReadInRow = 0;
                for (int x = 0; x < width; ++x) {
                    int sampleIndex = x + y * width;
                    ++bitsReadInRow;
                    this.imageMaskStream[sampleIndex] = maskDataHandler.read(1, sampleIndex) ? 0 : 1;
                }
                if (bitsReadInRow % 8 == 0) continue;
                maskDataHandler.skip(8 - bitsReadInRow % 8);
            }
            docContext.getLoadedImageMaskStreams().put(image, this.imageMaskStream);
        } else {
            this.imageMaskStream = docContext.getLoadedImageMaskStreams().get(image);
        }
    }

    private int getColorValueIndex(ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> fillShadingPattern, double patternSpaceX, double patternSpaceY, Color[] colorValues) {
        if (fillShadingPattern.getShadingType() == ShadingPattern.ShadingType.Axial) {
            double[] fillShadingCoords = fillShadingPattern.getCoordinates();
            ArrayList<Boolean> extendArray = fillShadingPattern.getExtend();
            return RasterAxialShading.getColorValueIndexForAxialShading(fillShadingCoords, extendArray, patternSpaceX, patternSpaceY, colorValues);
        }
        return -1;
    }

    private static class ImageMaskDataHandler {
        private ARGBImage mask = null;
        private BitInputStream bis = null;
        private boolean[] pixels = null;

        private ImageMaskDataHandler(ARGBImage mask) {
            this.mask = mask;
            this.bis = mask.getImageBitInputStream();
            if (this.bis == null) {
                this.pixels = mask.getMask();
                if (this.pixels == null) {
                    throw new PDFRuntimeException("Image Mask data cann't be retrieved.");
                }
            } else {
                this.pixels = new boolean[mask.getWidth() * mask.getHeight()];
            }
        }

        private boolean read(int nob, int pos) throws IOException {
            if (this.bis != null) {
                boolean val;
                this.pixels[pos] = val = this.bis.read(nob) != 1;
                return val;
            }
            if (this.pixels != null) {
                return this.pixels[pos];
            }
            throw new PDFRuntimeException("Image Mask data cann't be retrieved.");
        }

        private void done() throws IOException {
            if (this.bis != null) {
                this.mask.setMask(this.pixels);
                this.bis.close();
            }
        }

        private void skip(int nob) throws IOException {
            if (this.bis != null) {
                this.bis.skip(nob);
            }
        }
    }

    private static class IntegerHolder {
        int val;

        private IntegerHolder() {
        }
    }
}

